/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.support.umlsupport;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;

public class ETDeviceRect
extends Rectangle
implements IETRect {
    public ETDeviceRect() {
    }

    public ETDeviceRect(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public ETDeviceRect(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public ETDeviceRect(Point point, Point point2) {
        int n = point.x;
        int n2 = point.y;
        int n3 = point2.x;
        int n4 = point2.y;
        this.x = Math.min(n, n3);
        this.y = Math.min(n2, n4);
        this.width = Math.abs(n3 - n);
        this.height = Math.abs(n4 - n2);
    }

    public ETDeviceRect(Rectangle rectangle) {
        super(rectangle);
    }

    protected ETDeviceRect(IETRect iETRect) {
        this.x = iETRect.getLeft();
        this.y = iETRect instanceof ETDeviceRect ? iETRect.getTop() : iETRect.getBottom();
        this.width = iETRect.getIntWidth();
        this.height = iETRect.getIntHeight();
    }

    public int getLeft() {
        return this.x;
    }

    public void setLeft(int n) {
        this.x = n;
    }

    public int getTop() {
        return this.y;
    }

    public void setTop(int n) {
        this.y = n;
    }

    public int getRight() {
        return this.x + this.width;
    }

    public void setRight(int n) {
        this.width = n - this.x;
    }

    public int getBottom() {
        return this.y + this.height;
    }

    public void setBottom(int n) {
        this.height = n - this.y;
    }

    public void setSides(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.setRight(n3);
        this.setBottom(n4);
    }

    public void setCorners(IETPoint iETPoint, IETPoint iETPoint2) {
        this.setSides(iETPoint.getX(), iETPoint.getY(), iETPoint2.getX(), iETPoint2.getY());
    }

    public boolean isContained(IETRect iETRect) {
        return this.contains(iETRect);
    }

    public void normalizeRect() {
        this.normalizeRect(true);
    }

    public void normalizeRect(boolean bl) {
        this.y = bl ? Math.min(this.getTop(), this.getBottom()) : Math.max(this.getTop(), this.getBottom());
        if (this.width < 0) {
            this.x += this.width;
            this.width = -this.width;
        }
        if (this.height < 0) {
            this.y += this.height;
            this.height = -this.height;
        }
    }

    public void unionWith(IETRect iETRect) {
        ETDeviceRect eTDeviceRect = ETDeviceRect.ensureDeviceRect(iETRect);
        this.union(eTDeviceRect);
    }

    public boolean intersectWith(IETRect iETRect) {
        this.unionWith(iETRect);
        return !this.isEmpty();
    }

    public boolean doesIntersect(IETRect iETRect) {
        ETDeviceRect eTDeviceRect = ETDeviceRect.ensureDeviceRect(iETRect);
        return this.intersects(eTDeviceRect);
    }

    public boolean contains(IETPoint iETPoint) {
        return this.contains(iETPoint.asPoint());
    }

    public boolean contains(IETRect iETRect) {
        ETDeviceRect eTDeviceRect = ETDeviceRect.ensureDeviceRect(iETRect);
        return this.contains(eTDeviceRect);
    }

    public int getIntHeight() {
        return this.height;
    }

    public int getIntWidth() {
        return this.width;
    }

    public int getIntX() {
        return this.x;
    }

    public int getIntY() {
        return this.y;
    }

    public void inflate(int n) {
        this.inflate(n, n);
    }

    public void inflate(int n, int n2) {
        this.x -= n;
        this.y -= n2;
        this.width += 2 * n;
        this.height += 2 * n2;
    }

    public Rectangle getRectangle() {
        return this;
    }

    public Point getTopLeft() {
        return new Point(this.getLeft(), this.getTop());
    }

    public Point getBottomRight() {
        return new Point(this.getRight(), this.getBottom());
    }

    public Point getTopRight() {
        return new Point(this.getRight(), this.getTop());
    }

    public Point getBottomLeft() {
        return new Point(this.getLeft(), this.getBottom());
    }

    public Point getCenterPoint() {
        return new Point(this.getLeft() + this.width / 2, this.getTop() + this.height / 2);
    }

    public void deflateRect(int n, int n2, int n3, int n4) {
        this.x += n;
        this.y += n2;
        this.width -= n + n3;
        this.height -= n2 + n4;
    }

    public void deflateRect(int n, int n2) {
        this.deflateRect(n, n2, n, n2);
    }

    public boolean isZero() {
        return 0 == this.x && 0 == this.y && 0 == this.width && 0 == this.height;
    }

    public void offsetRect(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public void offsetRect(Point point) {
        this.offsetRect(point.x, point.y);
    }

    public void setRectEmpty() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public static ETDeviceRect ensureDeviceRect(IETRect iETRect) {
        ETDeviceRect eTDeviceRect = null;
        if (iETRect != null) {
            eTDeviceRect = iETRect instanceof ETDeviceRect ? (ETDeviceRect)iETRect : new ETDeviceRect(iETRect);
        }
        return eTDeviceRect;
    }

    public Object clone() {
        return new ETDeviceRect(this);
    }
}

