/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.workspacemanagement;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.eventframework.EventState;
import org.netbeans.modules.uml.core.eventframework.IEventDispatcher;
import org.netbeans.modules.uml.core.eventframework.IEventPayload;
import org.netbeans.modules.uml.core.support.umlsupport.PathManip;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.InvalidArguments;
import org.netbeans.modules.uml.core.workspacemanagement.ITwoPhaseCommit;
import org.netbeans.modules.uml.core.workspacemanagement.IWSElement;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProjectEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspaceEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.WSElementImpl;
import org.netbeans.modules.uml.core.workspacemanagement.WSProjectEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceManagementException;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceManager;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProjectImpl
extends WSElementImpl
implements IWSProject {
    private IWorkspaceEventDispatcher m_Dispatcher = null;
    private ETList<IWSElement> m_Elements = null;
    private boolean m_IsOpen = false;

    @Override
    public ETList<IWSElement> getElements() throws WorkspaceManagementException {
        return this.getElements(false);
    }

    public ETList<IWSElement> getElements(boolean bl) throws WorkspaceManagementException {
        Element element;
        ETArrayList eTArrayList = null;
        if (!bl) {
            this.verifyOpenState();
        }
        if ((element = this.getElement()) != null) {
            XMLManip.DebugXML(element, false);
            List list = element.elements();
            if (list != null) {
                eTArrayList = new ETArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    IWSElement iWSElement;
                    Element element2 = (Element)list.get(i);
                    String string = element2.getName();
                    if (!element2.getQualifiedName().equals("EMBT:WSElement") || (iWSElement = this.createElement(element2)) == null) continue;
                    eTArrayList.add(iWSElement);
                }
            }
        }
        return eTArrayList;
    }

    @Override
    public IWSElement addElement(String string, String string2, String string3) throws WorkspaceManagementException {
        IWSElement iWSElement = null;
        if (string2.length() > 0) {
            this.verifyOpenState();
            if (string.length() > 0) {
                String string4;
                this.verifyUniqueLocation(string);
                if (this.getElement() != null && (string4 = this.retrievePathRelativeToWorkspace(string)).length() > 0) {
                    iWSElement = this.createElement(string4, string2, string3);
                }
            }
        }
        return iWSElement;
    }

    @Override
    public IWSElement addElementFromDoc(Document document, String string) {
        IWSElement iWSElement = null;
        if (document == null || string.length() > 0) {
            // empty if block
        }
        return iWSElement;
    }

    @Override
    public IWSElement getElementByName(String string) {
        IWSElement iWSElement = null;
        try {
            this.verifyOpenState();
            if (this.m_Elements != null) {
                iWSElement = this.findElementByName(this.m_Elements, string);
            }
            if (iWSElement == null) {
                iWSElement = this.getElementByAttributeQuery("name", string);
            }
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            // empty catch block
        }
        return iWSElement;
    }

    private IWSElement findElementByName(ETList<IWSElement> eTList, String string) {
        IWSElement iWSElement = null;
        try {
            this.verifyOpenState();
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IWSElement iWSElement2 = (IWSElement)eTList.get(i);
                String string2 = iWSElement2.getName();
                if (string2 == null || !string2.equals(string)) continue;
                iWSElement = iWSElement2;
            }
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            // empty catch block
        }
        return iWSElement;
    }

    @Override
    public IWSElement getElementByLocation(String string) throws WorkspaceManagementException {
        return this.getElementByLocation(string, false);
    }

    public IWSElement getElementByLocation(String string, boolean bl) throws WorkspaceManagementException {
        String string2;
        IWSElement iWSElement = null;
        if (!bl) {
            this.verifyOpenState();
        }
        if (this.getElements() != null) {
            iWSElement = this.findElementByLocation(this.getElements(), string);
        }
        if (iWSElement == null && (string2 = this.retrievePathRelativeToWorkspace(string)).length() > 0) {
            String string3 = StringUtilities.splice(string2, "\\", "/");
            iWSElement = this.getElementByAttributeQuery("href", string3);
        }
        return iWSElement;
    }

    @Override
    public void open() throws WorkspaceManagementException {
        if (!this.isOpen() && this.validateWorkspace()) {
            IWorkspace iWorkspace = this.getWorkspace();
            IWorkspaceEventDispatcher iWorkspaceEventDispatcher = iWorkspace.getEventDispatcher();
            try {
                boolean bl = true;
                IWSProjectEventDispatcher iWSProjectEventDispatcher = null;
                EventState eventState = null;
                if (iWorkspaceEventDispatcher != null) {
                    eventState = new EventState((IEventDispatcher)iWorkspaceEventDispatcher, "WorkspaceProjectEvents");
                    iWSProjectEventDispatcher = new WSProjectEventDispatcher(iWorkspaceEventDispatcher);
                    bl = iWSProjectEventDispatcher.dispatchWSProjectPreOpen(iWorkspace, this.getName());
                }
                if (bl) {
                    this.setOpen(true);
                    if (iWSProjectEventDispatcher != null) {
                        iWSProjectEventDispatcher.dispatchWSProjectOpened(this);
                    }
                }
                if (eventState != null) {
                    eventState.existState();
                }
            }
            catch (InvalidArguments invalidArguments) {
                throw new WorkspaceManagementException(invalidArguments);
            }
        }
    }

    @Override
    public void close(boolean bl) throws WorkspaceManagementException {
        if (this.isOpen() && this.validateWorkspace()) {
            if (bl) {
                this.save("");
            }
            try {
                IWorkspace iWorkspace = this.getWorkspace();
                IWorkspaceEventDispatcher iWorkspaceEventDispatcher = iWorkspace.getEventDispatcher();
                EventState eventState = new EventState((IEventDispatcher)iWorkspaceEventDispatcher, "WorkspaceProjectEvents");
                WSProjectEventDispatcher wSProjectEventDispatcher = new WSProjectEventDispatcher(iWorkspaceEventDispatcher);
                try {
                    if (wSProjectEventDispatcher.dispatchWSProjectPreClose(this)) {
                        IWSElement iWSElement;
                        wSProjectEventDispatcher.dispatchWSProjectClosed(this);
                        this.setTwoPhaseCommit(null);
                        IWSElement iWSElement2 = this.getElementByName("_MetaData__");
                        if (iWSElement2 != null) {
                            iWSElement2.setTwoPhaseCommit(null);
                        }
                        if ((iWSElement = this.getElementByName("_VBAProject__")) != null) {
                            iWSElement.setTwoPhaseCommit(null);
                        }
                        this.setOpen(false);
                    }
                }
                catch (InvalidArguments invalidArguments) {
                    throw new WorkspaceManagementException(invalidArguments);
                }
                eventState.existState();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.m_IsOpen;
    }

    @Override
    public boolean isDirty() {
        boolean bl = false;
        if (!this.m_IsDirty) {
            if (this.m_Elements != null) {
                int n = this.m_Elements.size();
                for (int i = 0; i < n; ++i) {
                    IWSElement iWSElement = (IWSElement)this.m_Elements.get(i);
                    bl = iWSElement.isDirty();
                    if (!bl) continue;
                    this.m_IsDirty = true;
                    break;
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void setOpen(boolean bl) {
        this.m_IsOpen = bl;
    }

    @Override
    public String getBaseDirectory() {
        String string = "";
        Element element = this.getElement();
        if (element != null) {
            String string2 = XMLManip.getAttributeValue((Node)element, "baseDirectory");
            string = this.retrieveAbsolutePath(this.getWorkspaceDir(), string2);
        }
        return string;
    }

    @Override
    public void setBaseDirectory(String string) throws WorkspaceManagementException {
        this.verifyOpenState();
        String string2 = this.validateDirectory(string);
        String string3 = this.getWorkspaceDir();
        String string4 = this.retrieveRelativePath(string2, string3);
        if (string4.length() > 0) {
            this.setAttributeValue("baseDirectory", string4);
        }
        this.m_IsDirty = true;
    }

    @Override
    public void setName(String string) {
        try {
            if (this.m_Element != null) {
                WorkspaceManager.validateName(string);
                String string2 = this.getName();
                if (string2 == null || string2.length() == 0) {
                    string2 = "";
                }
                IWSProjectEventDispatcher iWSProjectEventDispatcher = this.prepareWSProjectEventDispatcher();
                boolean bl = true;
                if (iWSProjectEventDispatcher != null) {
                    bl = iWSProjectEventDispatcher.dispatchWSProjectPreRename(this, string);
                }
                if (bl) {
                    this.setAttributeValue("name", string);
                    this.m_IsDirty = true;
                    if (iWSProjectEventDispatcher != null) {
                        iWSProjectEventDispatcher.dispatchWSProjectRenamed(this, string2);
                    }
                }
            }
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            workspaceManagementException.printStackTrace();
        }
        catch (InvalidArguments invalidArguments) {
            invalidArguments.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyUniqueLocation(String string) throws WorkspaceManagementException {
        boolean bl;
        if (string == null) {
            return false;
        }
        boolean bl2 = bl = string.length() > 0;
        if (bl) {
            boolean bl3 = this.isOpen();
            try {
                this.setOpen(true);
                ETList<IWSElement> eTList = this.getElements(true);
                if (eTList != null) {
                    File file = new File(string);
                    for (int i = 0; i < eTList.size() && bl; ++i) {
                        File file2;
                        String string2 = ((IWSElement)eTList.get(i)).getLocation();
                        if (string2 == null || !(file2 = new File(string2)).equals(file)) continue;
                        bl = false;
                    }
                }
            }
            finally {
                this.setOpen(bl3);
            }
        }
        return bl;
    }

    @Override
    public void removeElement(IWSElement iWSElement) throws InvalidArguments {
        if (iWSElement != null && this.getElement() != null) {
            IEventPayload iEventPayload;
            IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
            boolean bl = false;
            if (iWorkspaceEventDispatcher != null) {
                iEventPayload = iWorkspaceEventDispatcher.createPayload("WSElementPreRemove");
                bl = iWorkspaceEventDispatcher.fireWSElementPreRemove(iWSElement, iEventPayload);
            }
            if (bl && (iEventPayload = iWSElement.getElement()) != null) {
                Element element = iEventPayload.getParent();
                if (element instanceof Branch) {
                    ((Branch)element).remove((Element)iEventPayload);
                }
                this.removeProjectElement(iWSElement);
                this.setIsDirty(true);
                if (iWorkspaceEventDispatcher != null) {
                    IEventPayload iEventPayload2 = iWorkspaceEventDispatcher.createPayload("WSElementRemoved");
                    iWorkspaceEventDispatcher.fireWSElementRemoved(iWSElement, iEventPayload2);
                }
            }
        } else {
            throw new InvalidArguments();
        }
    }

    @Override
    public boolean removeElementByLocation(String string) throws WorkspaceManagementException {
        boolean bl = false;
        if (string.length() > 0) {
            String string2 = this.getWorkspaceDir();
            String string3 = this.retrieveRelativePath(string, string2);
            IWSElement iWSElement = this.getElementByLocation(string3 = StringUtilities.splice(string3, "\\", "/"));
            if (iWSElement != null) {
                try {
                    this.removeElement(iWSElement);
                    bl = true;
                }
                catch (InvalidArguments invalidArguments) {
                    throw new WorkspaceManagementException(invalidArguments);
                }
            }
        }
        return bl;
    }

    @Override
    public IWorkspaceEventDispatcher getEventDispatcher() {
        IWorkspaceEventDispatcher iWorkspaceEventDispatcher = null;
        IWorkspace iWorkspace = this.getWorkspace();
        if (iWorkspace != null && !this.isWorkspace()) {
            iWorkspaceEventDispatcher = iWorkspace.getEventDispatcher();
        } else if (this.m_Dispatcher != null) {
            iWorkspaceEventDispatcher = this.m_Dispatcher;
        }
        return iWorkspaceEventDispatcher;
    }

    @Override
    public void setEventDispatcher(IWorkspaceEventDispatcher iWorkspaceEventDispatcher) {
        this.m_Dispatcher = iWorkspaceEventDispatcher;
    }

    @Override
    public ETList<IWSElement> getElementsByDataValue(String string) {
        ETArrayList eTArrayList = null;
        if (this.m_Element != null) {
            String string2 = ".//*[@data=\"";
            string2 = string2 + string;
            List list = this.m_Element.selectNodes(string2 = string2 + "\"]");
            if (list != null) {
                ETArrayList eTArrayList2 = new ETArrayList();
                for (Node node : list) {
                    Element element;
                    IWSElement iWSElement;
                    if (node == null || (iWSElement = this.createElement(element = (Element)node)) == null) continue;
                    eTArrayList2.add(iWSElement);
                }
                eTArrayList = eTArrayList2;
            }
        }
        return eTArrayList;
    }

    @Override
    public String getSourceControlID() {
        String string = "";
        string = XMLManip.getAttributeValue((Node)this.m_Element, "scmID");
        return string;
    }

    @Override
    public void setSourceControlID(String string) {
        this.setAttributeValue("scmID", string);
        this.m_IsDirty = true;
    }

    @Override
    public void save(String string) throws WorkspaceManagementException {
        if (this.m_Elements != null && this.isDirty() && this.validateWorkspace()) {
            this.markWorkspaceDirty();
            IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
            if (iWorkspaceEventDispatcher != null) {
                EventState eventState = new EventState((IEventDispatcher)iWorkspaceEventDispatcher, "WorkspaceProjectEvents");
                IWSProjectEventDispatcher iWSProjectEventDispatcher = this.prepareWSProjectEventDispatcher();
                try {
                    boolean bl = iWSProjectEventDispatcher.dispatchWSProjectPreSave(this);
                    if (bl) {
                        ETList<IWSElement> eTList = new ETArrayList<IWSElement>();
                        eTList = this.preCommitElements(eTList);
                        this.verifyPreCommit(eTList);
                        this.commitElements(eTList);
                        this.setIsDirty(false);
                        iWSProjectEventDispatcher.dispatchWSProjectSaved(this);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void markWorkspaceDirty() {
        IWorkspace iWorkspace = this.getWorkspace();
        if (iWorkspace != null) {
            iWorkspace.setIsDirty(true);
        }
    }

    protected final void verifyOpenState() throws WorkspaceManagementException {
        if (!this.isOpen()) {
            throw new WorkspaceManagementException(WorkspaceMessages.getString("WSPROJECT_NOT_OPEN"));
        }
    }

    protected IWSElement createElement(Element element) throws WorkspaceManagementException {
        return this.createElement(element, "");
    }

    protected IWSElement createElement(Element element, String string) throws WorkspaceManagementException {
        IWSElement iWSElement = null;
        if (element != null) {
            if (this.m_Elements == null) {
                this.m_Elements = new ETArrayList<IWSElement>();
            }
            if ((iWSElement = this.findElementByLocation(this.m_Elements, string)) == null) {
                iWSElement = new WSElementImpl();
                iWSElement.setElement(element);
                iWSElement.setOwner(this);
                if (string.length() > 0) {
                    iWSElement.setLocation(string);
                }
                try {
                    this.addElement(iWSElement, this.m_Elements);
                }
                catch (InvalidArguments invalidArguments) {
                    throw new WorkspaceManagementException(invalidArguments);
                }
                iWSElement.setIsDirty(false);
            }
        }
        return iWSElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IWSElement createElement(String string, String string2, String string3) throws WorkspaceManagementException {
        IWSElement iWSElement = null;
        this.verifyOpenState();
        if (string2.length() > 0 && this.getElement() != null) {
            IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
            boolean bl = iWorkspaceEventDispatcher.getPreventAllEvents();
            try {
                EventState eventState = new EventState((IEventDispatcher)iWorkspaceEventDispatcher, "WorkspaceProjectEvents");
                if (this.dispatchWSProjectElementPreCreate(string, string2, string3)) {
                    iWorkspaceEventDispatcher.setPreventAllEvents(true);
                    Document document = this.getElement().getDocument();
                    Element element = XMLManip.createElement(this.getElement(), "EMBT:WSElement");
                    iWSElement = this.createElement(element, string);
                    if (iWSElement != null) {
                        iWSElement.setName(string2);
                        iWSElement.setData(string3);
                        iWorkspaceEventDispatcher.setPreventAllEvents(bl);
                        this.dispatchWSProjectElementCreated(iWSElement);
                        this.m_IsDirty = true;
                    }
                }
                eventState.existState();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InvalidArguments invalidArguments) {
            }
            finally {
                iWorkspaceEventDispatcher.setPreventAllEvents(bl);
            }
        }
        return iWSElement;
    }

    private void dispatchWSProjectElementCreated(IWSElement iWSElement) throws InvalidArguments {
        if (iWSElement != null) {
            IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
            if (iWorkspaceEventDispatcher != null) {
                IEventPayload iEventPayload = iWorkspaceEventDispatcher.createPayload("WorkspaceProjectElementCreated");
                iWorkspaceEventDispatcher.fireWSElementCreated(iWSElement, iEventPayload);
            }
        } else {
            throw new InvalidArguments();
        }
    }

    private boolean dispatchWSProjectElementPreCreate(String string, String string2, String string3) {
        boolean bl = true;
        IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
        if (iWorkspaceEventDispatcher != null) {
            IEventPayload iEventPayload = iWorkspaceEventDispatcher.createPayload("WorkspaceProjectElementPreCreate");
            bl = iWorkspaceEventDispatcher.fireWSElementPreCreate(this, string, string2, string3, iEventPayload);
        }
        return bl;
    }

    private void commitElements(ETList<IWSElement> eTList) throws WorkspaceManagementException, InvalidArguments {
        this.verifyOpenState();
        if (eTList != null) {
            for (IWSElement iWSElement : eTList) {
                ITwoPhaseCommit iTwoPhaseCommit;
                if (iWSElement == null || (iTwoPhaseCommit = iWSElement.getTwoPhaseCommit()) == null) continue;
                iTwoPhaseCommit.commit();
            }
        } else {
            throw new InvalidArguments();
        }
    }

    private void verifyPreCommit(ETList<IWSElement> eTList) throws WorkspaceManagementException, InvalidArguments {
        boolean bl = false;
        int n = 0;
        do {
            for (IWSElement iWSElement : eTList) {
                if (iWSElement == null || !iWSElement.isDirty()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            this.preCommitElements(eTList);
        } while (bl && ++n < 10);
    }

    private ETList<IWSElement> preCommitElements(ETList<IWSElement> eTList) throws WorkspaceManagementException, InvalidArguments {
        this.verifyOpenState();
        if (this.m_Elements != null) {
            int n = this.m_Elements.size();
            for (int i = n - 1; i >= 0; --i) {
                IWSElement iWSElement = (IWSElement)this.m_Elements.get(i);
                if (iWSElement == null || !iWSElement.isDirty()) continue;
                ITwoPhaseCommit iTwoPhaseCommit = iWSElement.getTwoPhaseCommit();
                if (iTwoPhaseCommit != null) {
                    iTwoPhaseCommit.preCommit();
                }
                iWSElement.save("");
                eTList = this.addElement(iWSElement, eTList);
            }
        } else {
            throw new InvalidArguments();
        }
        return eTList;
    }

    private ETList<IWSElement> addElement(IWSElement iWSElement, ETList<IWSElement> eTList) throws WorkspaceManagementException, InvalidArguments {
        this.verifyOpenState();
        if (iWSElement != null && eTList != null) {
            boolean bl = true;
            String string = iWSElement.getLocation();
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IWSElement iWSElement2 = (IWSElement)eTList.get(i);
                if (iWSElement2 == null) continue;
                String string2 = iWSElement2.getLocation();
                String string3 = this.getWorkspaceFileName();
                String string4 = this.retrieveAbsolutePath(string3, string2);
                if (string == null || !string.equals(string4)) continue;
                bl = false;
                break;
            }
            if (bl) {
                eTList.add(iWSElement);
            }
        } else {
            throw new InvalidArguments();
        }
        return eTList;
    }

    private String retrieveAbsolutePath(String string, String string2) {
        String string3 = string2;
        File file = new File(string3);
        if (!file.isAbsolute()) {
            File file2 = new File(string, string2).getAbsoluteFile();
            try {
                string3 = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                string3 = file2.toString();
            }
        }
        return string3;
    }

    private String getWorkspaceFileName() throws WorkspaceManagementException {
        String string = "";
        IWorkspace iWorkspace = this.getWorkspace();
        string = iWorkspace != null ? iWorkspace.getLocation() : this.getLocation();
        return string;
    }

    private IWorkspace getWorkspace() {
        IWorkspace iWorkspace = null;
        IWSProject iWSProject = this.getOwner();
        if (iWSProject instanceof IWorkspace) {
            iWorkspace = (IWorkspace)iWSProject;
        } else if (this instanceof IWorkspace) {
            iWorkspace = (IWorkspace)((Object)this);
        }
        return iWorkspace;
    }

    protected IWSProjectEventDispatcher prepareWSProjectEventDispatcher() {
        WSProjectEventDispatcher wSProjectEventDispatcher = null;
        IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
        if (iWorkspaceEventDispatcher != null) {
            wSProjectEventDispatcher = new WSProjectEventDispatcher(iWorkspaceEventDispatcher);
        }
        return wSProjectEventDispatcher;
    }

    private IWSElement findElementByLocation(ETList<IWSElement> eTList, String string) throws WorkspaceManagementException {
        IWSElement iWSElement = null;
        this.verifyOpenState();
        Iterator iterator = eTList.iterator();
        while (iterator.hasNext() && iWSElement == null) {
            IWSElement iWSElement2 = (IWSElement)iterator.next();
            try {
                String string2 = iWSElement2.getLocation();
                if (!string2.equalsIgnoreCase(string)) continue;
                iWSElement = iWSElement2;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return iWSElement;
    }

    protected String retrievePathRelativeToWorkspace(String string) throws WorkspaceManagementException {
        String string2 = "";
        String string3 = this.getWorkspaceFileName();
        string2 = this.retrieveRelativePath(string, string3);
        return string2;
    }

    private String retrieveRelativePath(String string, String string2) {
        return PathManip.retrieveRelativePath(string, string2);
    }

    private String getWorkspaceDir() {
        String string = "";
        IWorkspace iWorkspace = this.getWorkspace();
        if (iWorkspace != null && iWorkspace != this) {
            string = iWorkspace.getBaseDirectory();
        }
        return string;
    }

    protected String validateDirectory(String string) throws WorkspaceManagementException {
        String string2 = string;
        File file = new File(string);
        if (!file.isDirectory()) {
            File file2 = file.getParentFile();
            if (!file2.isDirectory()) {
                throw new WorkspaceManagementException(WorkspaceMessages.getString("BAD_LOCATION"));
            }
            string2 = file2.getAbsolutePath();
        }
        return string2;
    }

    protected boolean validateWorkspace() throws WorkspaceManagementException {
        boolean bl = false;
        if (this.getOwner() != null) {
            bl = true;
        } else if (this.isWorkspace()) {
            bl = true;
        } else {
            throw new WorkspaceManagementException(WorkspaceMessages.getString("NO_WORKSPACE"));
        }
        return bl;
    }

    protected void AddElement(IWSElement iWSElement, ArrayList<IWSElement> arrayList) throws WorkspaceManagementException {
        if (arrayList.size() > 0) {
            boolean bl = true;
            String string = iWSElement.getLocation();
            for (int i = 0; i < arrayList.size() && bl; ++i) {
                String string2 = arrayList.get(i).getLocation();
                String string3 = this.getWorkspaceFileName();
                String string4 = this.retrieveAbsolutePath(string3, string2);
                if (!string.equals(string4)) continue;
                bl = false;
            }
            if (bl) {
                arrayList.add(iWSElement);
            }
        }
    }

    protected IWSElement getElementByAttributeQuery(String string, String string2) throws WorkspaceManagementException {
        IWSElement iWSElement = null;
        if (this.getElement() != null) {
            StringBuffer stringBuffer = new StringBuffer("./EMBT:WSElement[@");
            stringBuffer.append(string);
            stringBuffer.append("=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"]");
            Node node = XMLManip.selectSingleNode((Node)this.getElement(), stringBuffer.toString());
            if (node instanceof Element) {
                iWSElement = this.createElement((Element)node);
            }
        }
        return iWSElement;
    }

    protected IWSElement findElementByLocation(ETList<IWSElement> eTList, String string, boolean bl) throws WorkspaceManagementException {
        IWSElement iWSElement = null;
        if (!bl) {
            this.verifyOpenState();
        }
        File file = new File(string);
        for (int i = 0; i < eTList.size() && iWSElement == null; ++i) {
            File file2;
            String string2 = ((IWSElement)eTList.get(i)).getLocation();
            if (string2.length() <= 0 || !file.equals(file2 = new File(string2))) continue;
            iWSElement = (IWSElement)eTList.get(i);
        }
        return iWSElement;
    }

    protected void removeProjectElement(IWSElement iWSElement) throws InvalidArguments {
        if (iWSElement == null || this.m_Elements == null) {
            throw new InvalidArguments();
        }
        this.m_Elements.remove(iWSElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocation() throws WorkspaceManagementException {
        String string = null;
        boolean bl = this.isOpen();
        try {
            this.setOpen(true);
            IWSElement iWSElement = this.getElementByName("_MetaData__");
            if (iWSElement != null) {
                string = iWSElement.getLocation();
            }
        }
        finally {
            this.setOpen(bl);
        }
        return string;
    }
}

