/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.addins.diagramcreator;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.structure.IComponent;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.addins.diagramcreator.ComponentParentFinder;
import org.netbeans.modules.uml.ui.addins.diagramcreator.IGenealogyTree;
import org.netbeans.modules.uml.ui.products.ad.drawengines.IComponentDrawEngine;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

public class GenealogyTree
implements IGenealogyTree {
    private static final int SPACING = 80;
    private ETList<IPresentationElement> m_UndeterminedNodes = null;
    private ETList<IPresentationElement> m_AllNodes = null;
    private ArrayList<GenealogyNode> m_RootElements = new ArrayList();
    private IDrawingAreaControl m_Diagram = null;
    private ComponentParentFinder.ParentChildCollection m_ParentChildPairs;

    public void addUndeterminedNode(INodePresentation iNodePresentation) {
        if (null == this.m_UndeterminedNodes) {
            this.m_UndeterminedNodes = new ETArrayList<IPresentationElement>();
            this.m_AllNodes = new ETArrayList<IPresentationElement>();
        }
        if (this.m_UndeterminedNodes != null && this.m_AllNodes != null) {
            this.m_UndeterminedNodes.add(iNodePresentation);
            this.m_AllNodes.add(iNodePresentation);
        }
    }

    public void buildGenealogy(IDrawingAreaControl iDrawingAreaControl) {
        this.m_Diagram = iDrawingAreaControl;
        if (this.m_Diagram != null) {
            int n;
            this.determineParentChildRelationships();
            this.populateRootElementsFromUndeterminedNodes();
            int n2 = n = this.m_UndeterminedNodes != null ? this.m_UndeterminedNodes.getCount() : 0;
            if (n > 0) {
                boolean bl = true;
                while (bl) {
                    bl = false;
                    n = this.m_UndeterminedNodes.getCount();
                    if (n <= 0) continue;
                    for (int i = 0; i < n; ++i) {
                        IPresentationElement iPresentationElement = this.m_UndeterminedNodes.item(i);
                        if (iPresentationElement == null || !this.addToParent(iPresentationElement)) continue;
                        bl = true;
                        this.m_UndeterminedNodes.removeItem(iPresentationElement);
                        n = this.m_UndeterminedNodes.getCount();
                        --i;
                    }
                    if (!bl) assert (false);
                }
            }
        }
    }

    public void determineParentChildRelationships() {
        long l = this.m_UndeterminedNodes != null ? (long)this.m_UndeterminedNodes.getCount() : 0L;
        ETArrayList<IComponent> eTArrayList = new ETArrayList<IComponent>();
        ETArrayList<IClassifier> eTArrayList2 = new ETArrayList<IClassifier>();
        int n = 0;
        while ((long)n < l) {
            IPresentationElement iPresentationElement = this.m_UndeterminedNodes.item(n);
            IElement iElement = TypeConversions.getElement(iPresentationElement);
            assert (iElement != null);
            if (iElement instanceof IComponent) {
                eTArrayList.add((IComponent)iElement);
                if (iElement instanceof IClassifier) {
                    eTArrayList2.add((IClassifier)iElement);
                }
            } else if (iElement instanceof IClassifier) {
                eTArrayList2.add((IClassifier)iElement);
            }
            ++n;
        }
        this.m_ParentChildPairs = ComponentParentFinder.resolveParents(eTArrayList, eTArrayList2);
    }

    public void calculateRectangles(IETRect iETRect) {
        for (GenealogyNode genealogyNode : this.m_RootElements) {
            if (genealogyNode.m_Children.size() <= 0) continue;
            IETRect iETRect2 = genealogyNode.getDesiredRect();
            iETRect2.inflate(iETRect.getIntWidth(), 0);
            genealogyNode.setDesiredRect(iETRect2);
            genealogyNode.computeRectangleSizes();
            genealogyNode.setRectToContainChildren(genealogyNode.getDesiredRect().getTopLeft());
            iETRect.setRight(genealogyNode.getDesiredRect().getRight() + 80);
        }
    }

    public void placeNodes() {
        if (this.m_Diagram != null) {
            for (GenealogyNode genealogyNode : this.m_RootElements) {
                genealogyNode.placeNode(this.m_Diagram);
            }
        }
    }

    public void onGraphEvent(int n, String string) {
        int n2 = this.m_AllNodes != null ? this.m_AllNodes.getCount() : 0;
        for (int i = 0; i < n2; ++i) {
            IPresentationElement iPresentationElement = this.m_AllNodes.item(i);
            if (iPresentationElement == null) continue;
            IETGraphObject iETGraphObject = TypeConversions.getETGraphObject(iPresentationElement);
            IDrawEngine iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement);
            IComponentDrawEngine iComponentDrawEngine = null;
            if (iDrawEngine instanceof IComponentDrawEngine) {
                iComponentDrawEngine = (IComponentDrawEngine)iDrawEngine;
                iComponentDrawEngine.setAllowAutoRouteEdges(false);
            }
            if (iETGraphObject != null) {
                iETGraphObject.onGraphEvent(n);
            }
            if (iComponentDrawEngine == null) continue;
            iComponentDrawEngine.setAllowAutoRouteEdges(true);
        }
    }

    public void setStackingOrder() {
        if (this.m_Diagram != null) {
            for (GenealogyNode genealogyNode : this.m_RootElements) {
                genealogyNode.setStackingOrder(this.m_Diagram);
            }
        }
    }

    public void printTree() {
        if (this.m_Diagram != null) {
            for (GenealogyNode genealogyNode : this.m_RootElements) {
                genealogyNode.printTree(0);
            }
        }
    }

    public void distributeAllComponentPorts() {
        int n = this.m_AllNodes != null ? this.m_AllNodes.getCount() : 0;
        for (int i = 0; i < n; ++i) {
            IPresentationElement iPresentationElement = this.m_AllNodes.item(i);
            if (iPresentationElement == null) continue;
            IETGraphObject iETGraphObject = TypeConversions.getETGraphObject(iPresentationElement);
            IDrawEngine iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement);
            if (!(iDrawEngine instanceof IComponentDrawEngine)) continue;
            IComponentDrawEngine iComponentDrawEngine = (IComponentDrawEngine)iDrawEngine;
            iComponentDrawEngine.setAllowAutoRouteEdges(false);
            iComponentDrawEngine.distributeInterfacesOnAllPorts(false);
            iComponentDrawEngine.setAllowAutoRouteEdges(true);
        }
    }

    protected GenealogyNode buildGenealogyNode(IPresentationElement iPresentationElement) {
        return this.buildGenealogyNode(iPresentationElement, null);
    }

    protected GenealogyNode buildGenealogyNode(IPresentationElement iPresentationElement, GenealogyNode genealogyNode) {
        GenealogyNode genealogyNode2 = null;
        if (iPresentationElement != null) {
            genealogyNode2 = new GenealogyNode();
            genealogyNode2.m_PE = iPresentationElement;
            genealogyNode2.m_Parent = genealogyNode;
            IDrawEngine iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement);
            if (iDrawEngine != null) {
                IETRect iETRect = iDrawEngine.getLogicalBoundingRect(false);
                genealogyNode2.setDesiredRect(iETRect);
            }
        }
        return genealogyNode2;
    }

    protected IElement getParentElement(IPresentationElement iPresentationElement) {
        if (null == iPresentationElement) {
            throw new IllegalArgumentException();
        }
        IElement iElement = null;
        IElement iElement2 = iPresentationElement.getFirstSubject();
        assert (iElement2 != null);
        if (iElement2 != null) {
            for (ComponentParentFinder.ParentChildPair parentChildPair : this.m_ParentChildPairs) {
                boolean bl;
                IClassifier iClassifier = (IClassifier)parentChildPair.getParamTwo();
                if (iClassifier == null || !(bl = iClassifier.isSame(iElement2))) continue;
                iElement = (IElement)parentChildPair.getParamOne();
                break;
            }
        }
        return iElement;
    }

    protected boolean getIsInternalClassifier(IComponent iComponent, IElement iElement) {
        if (null == iComponent) {
            throw new IllegalArgumentException();
        }
        if (null == iElement) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        if (iElement instanceof IClassifier) {
            bl = iComponent.getIsInternalClassifier((IClassifier)iElement);
        }
        return bl;
    }

    protected void populateRootElementsFromUndeterminedNodes() {
        if (this.m_Diagram != null) {
            int n;
            int n2 = n = this.m_UndeterminedNodes != null ? this.m_UndeterminedNodes.getCount() : 0;
            if (n > 0) {
                IElement iElement;
                int n3;
                ETArrayList eTArrayList = new ETArrayList();
                for (n3 = 0; n3 < n; ++n3) {
                    IPresentationElement iPresentationElement = this.m_UndeterminedNodes.item(n3);
                    if (iPresentationElement == null || null != (iElement = this.getParentElement(iPresentationElement))) continue;
                    eTArrayList.add(iPresentationElement);
                }
                this.m_UndeterminedNodes.removeThese(eTArrayList);
                n3 = eTArrayList.getCount();
                for (int i = 0; i < n3; ++i) {
                    iElement = (IPresentationElement)eTArrayList.item(i);
                    if (iElement == null) continue;
                    this.m_RootElements.add(this.buildGenealogyNode((IPresentationElement)iElement));
                }
            }
        }
    }

    protected boolean addToParent(IPresentationElement iPresentationElement) {
        boolean bl;
        block3: {
            bl = false;
            if (iPresentationElement == null) break block3;
            IElement iElement = this.getParentElement(iPresentationElement);
            assert (iElement != null);
            if (iElement != null) {
                GenealogyNode genealogyNode;
                Iterator<GenealogyNode> iterator = this.m_RootElements.iterator();
                while (iterator.hasNext() && !(bl = (genealogyNode = iterator.next()).addToParent(iPresentationElement, iElement))) {
                }
            }
        }
        return bl;
    }

    protected class GenealogyNode {
        private IPresentationElement m_PE = null;
        private GenealogyNode m_Parent = null;
        private ArrayList<GenealogyNode> m_Children = new ArrayList();
        private String m_sName = "";
        private IETRect m_DesiredRect = new ETRect();

        boolean addToParent(IPresentationElement iPresentationElement, IElement iElement) {
            boolean bl;
            block3: {
                bl = false;
                if (this.m_PE == null || iPresentationElement == null || iElement == null) break block3;
                boolean bl2 = this.m_PE.isSubject(iElement);
                if (bl2) {
                    GenealogyNode genealogyNode = GenealogyTree.this.buildGenealogyNode(iPresentationElement);
                    this.m_Children.add(genealogyNode);
                    bl = true;
                } else {
                    GenealogyNode genealogyNode;
                    Iterator<GenealogyNode> iterator = this.m_Children.iterator();
                    while (iterator.hasNext() && !(bl = (genealogyNode = iterator.next()).addToParent(iPresentationElement, iElement))) {
                    }
                }
            }
            return bl;
        }

        void computeRectangleSizes() {
            for (GenealogyNode genealogyNode : this.m_Children) {
                genealogyNode.computeRectangleSizes();
            }
            int n = this.m_Children.size();
            if (n > 0) {
                int n2 = 0;
                int n3 = 0;
                n3 = 160;
                n2 = 160;
                if (n > 0) {
                    n2 += (n - 1) * 80;
                }
                int n4 = 0;
                int n5 = 0;
                for (GenealogyNode genealogyNode : this.m_Children) {
                    IETRect iETRect = genealogyNode.getRectWithChildren();
                    n4 += iETRect.getIntWidth();
                    if (n5 >= Math.abs(iETRect.getIntHeight())) continue;
                    n5 = Math.abs(iETRect.getIntHeight());
                }
                n3 = Math.max(n3, n5 + 160);
                IETRect iETRect = this.getDesiredRect();
                iETRect.setRight(Math.max(iETRect.getRight(), iETRect.getLeft() + (n2 += n4)));
                iETRect.setBottom(Math.min(iETRect.getBottom(), iETRect.getTop() - n3));
                this.setDesiredRect(iETRect);
            }
        }

        void setRectToContainChildren(Point point) {
            point.x += 80;
            point.y -= 80;
            Point point2 = (Point)point.clone();
            for (GenealogyNode genealogyNode : this.m_Children) {
                IETRect iETRect = genealogyNode.getDesiredRect();
                ETRect eTRect = new ETRect();
                eTRect.setLeft(point2.x);
                eTRect.setRight(eTRect.getLeft() + Math.abs(iETRect.getIntWidth()));
                eTRect.setTop(point2.y);
                eTRect.setBottom(eTRect.getTop() - Math.abs(iETRect.getIntHeight()));
                genealogyNode.setDesiredRect(eTRect);
                point2.x = eTRect.getRight() + 80;
            }
            for (GenealogyNode genealogyNode : this.m_Children) {
                genealogyNode.setRectToContainChildren(genealogyNode.getDesiredRect().getTopLeft());
            }
        }

        void placeNode(IDrawingAreaControl iDrawingAreaControl) {
            if (null == iDrawingAreaControl) {
                throw new IllegalArgumentException();
            }
            for (GenealogyNode genealogyNode : this.m_Children) {
                genealogyNode.placeNode(iDrawingAreaControl);
            }
            if (this.m_PE instanceof INodePresentation) {
                INodePresentation iNodePresentation = (INodePresentation)this.m_PE;
                iNodePresentation.moveTo(this.m_DesiredRect.getCenterPoint().x, this.m_DesiredRect.getCenterPoint().y, 11);
                iNodePresentation.resize(Math.abs(this.m_DesiredRect.getIntWidth()), Math.abs(this.m_DesiredRect.getIntHeight()), false);
            }
        }

        void printTree(int n) {
            String string = "";
            for (long i = 0L; i < (long)n; ++i) {
                string = string + " ";
            }
            string = string + " name=" + this.m_sName + ", ";
            string = string + " top=" + this.m_DesiredRect.getTop() + ", ";
            string = string + " bottom=" + this.m_DesiredRect.getBottom() + ", ";
            string = string + " left=" + this.m_DesiredRect.getLeft() + ", ";
            string = string + " right=" + this.m_DesiredRect.getRight() + "\n";
            ETSystem.out.println(string);
            for (GenealogyNode genealogyNode : this.m_Children) {
                genealogyNode.printTree(n + 1);
            }
        }

        void setDesiredRectAndMoveChildren(IETRect iETRect) {
            int n = iETRect.getLeft() - this.m_DesiredRect.getLeft();
            int n2 = iETRect.getTop() - this.m_DesiredRect.getTop();
            this.m_DesiredRect = (IETRect)iETRect.clone();
            for (GenealogyNode genealogyNode : this.m_Children) {
                IETRect iETRect2 = (IETRect)genealogyNode.m_DesiredRect.clone();
                iETRect2.offsetRect(n, n2);
                genealogyNode.setDesiredRectAndMoveChildren(iETRect2);
            }
        }

        void setStackingOrder(IDrawingAreaControl iDrawingAreaControl) {
            if (null == iDrawingAreaControl) {
                throw new IllegalArgumentException();
            }
            iDrawingAreaControl.executeStackingCommand(this.m_PE, 1, false);
            for (GenealogyNode genealogyNode : this.m_Children) {
                genealogyNode.setStackingOrder(iDrawingAreaControl);
            }
        }

        void setDesiredRect(IETRect iETRect) {
            this.m_DesiredRect = iETRect;
        }

        IETRect getDesiredRect() {
            return this.m_DesiredRect;
        }

        IETRect getRectWithChildren() {
            IComponentDrawEngine iComponentDrawEngine;
            ETPairT<IETRect, IETRect> eTPairT;
            IETRect iETRect;
            IDrawEngine iDrawEngine;
            IETRect iETRect2 = (IETRect)this.m_DesiredRect.clone();
            if (this.m_PE != null && (iDrawEngine = TypeConversions.getDrawEngine(this.m_PE)) instanceof IComponentDrawEngine && (iETRect = (eTPairT = (iComponentDrawEngine = (IComponentDrawEngine)iDrawEngine).getBoundingRectWithLollypops()).getParamTwo()) != null) {
                iETRect2.setRight(Math.max(this.m_DesiredRect.getRight(), this.m_DesiredRect.getLeft() + iETRect.getIntWidth()));
                iETRect2.setBottom(Math.min(this.m_DesiredRect.getBottom(), this.m_DesiredRect.getTop() - Math.abs(iETRect.getIntHeight())));
            }
            return iETRect2;
        }
    }
}

