/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.addins.diagramcreator;

import com.tomsawyer.editor.TSENode;
import com.tomsawyer.graph.TSGraphObject;
import java.awt.Point;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.eventframework.EventBlocker;
import org.netbeans.modules.uml.core.metamodel.basic.basicactions.IAction;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.ICoreRelationshipDiscovery;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.dynamics.IActionOccurrence;
import org.netbeans.modules.uml.core.metamodel.dynamics.ICombinedFragment;
import org.netbeans.modules.uml.core.metamodel.dynamics.IEventOccurrence;
import org.netbeans.modules.uml.core.metamodel.dynamics.IExecutionOccurrence;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteraction;
import org.netbeans.modules.uml.core.metamodel.dynamics.ILifeline;
import org.netbeans.modules.uml.core.metamodel.dynamics.IMessage;
import org.netbeans.modules.uml.core.metamodel.structure.IComment;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.ElementLocator;
import org.netbeans.modules.uml.ui.addins.diagramcreator.DiagCreatorAddIn;
import org.netbeans.modules.uml.ui.addins.diagramcreator.ISequenceDiagramGenerator;
import org.netbeans.modules.uml.ui.addins.diagramcreator.MessageHelper;
import org.netbeans.modules.uml.ui.controls.drawingarea.IUIDiagram;
import org.netbeans.modules.uml.ui.controls.drawingarea.SimpleAction;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.IADLifelineCompartment;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.IADSequenceDiagEngine;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.sequencediagram.ICombinedFragmentDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.sequencediagram.ILifelineDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.sequencediagram.IMessageEdgeDrawEngine;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.ThermProgress;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductDiagramManager;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ILabelManager;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.PointConversions;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

public class SequenceDiagramGenerator
implements ISequenceDiagramGenerator {
    private Hashtable<ILifeline, ILifelineDrawEngine> m_MapLifelineToEngine = new Hashtable();
    private INamespace m_Namespace = null;
    private IInteraction m_Interaction = null;
    private IDiagram m_Diagram = null;
    private int m_InitialMessageY = 0;

    public boolean generate(IInteraction iInteraction, IDiagram iDiagram) {
        Object object;
        String string;
        boolean bl = false;
        this.m_Interaction = iInteraction;
        if (iInteraction instanceof INamespace) {
            this.m_Namespace = iInteraction;
        }
        if (iDiagram != null) {
            int n = 1;
            n = iDiagram.getDiagramKind();
            if (n == 64) {
                this.m_Diagram = iDiagram;
                bl = true;
            }
        } else {
            this.createSequenceDiagram();
        }
        if (this.m_Diagram != null) {
            this.m_Diagram.setAllowRedraw(true);
        }
        if (this.m_Interaction != null && ((string = this.m_Interaction.getName()) == null || string.length() == 0)) {
            object = this.m_Diagram.getName();
            this.m_Interaction.setName((String)object);
        }
        if (this.m_Diagram != null) {
            this.generateSequenceDiagramFromInteraction();
            this.m_Interaction.setDirty(true);
            boolean bl2 = this.m_Interaction.isDirty();
            if (!bl2 && (object = this.m_Interaction.getProject()) != null) {
                object.setDirty(true);
            }
        }
        return bl;
    }

    private void createSequenceDiagram() {
        IProductDiagramManager iProductDiagramManager;
        if (this.m_Interaction != null && (iProductDiagramManager = ProductHelper.getProductDiagramManager()) != null) {
            String string = this.m_Interaction.getName();
            this.m_Diagram = iProductDiagramManager.newDiagramDialog(this.m_Namespace, 64, 72, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSequenceDiagramFromInteraction() {
        boolean bl = EventBlocker.startBlocking();
        try {
            ThermProgress thermProgress = new ThermProgress();
            boolean bl2 = this.m_Diagram != null && this.showInteractionBoundary();
            int n = 8 + (this.inDescribeIDE() ? 0 : 1) + (bl2 ? 1 : 0);
            int n2 = 0;
            thermProgress.updateProgressControl(this.loadString("IDS_SQD_VALIDATE_INTERACTION"), n2, n);
            MessageHelper messageHelper = new MessageHelper(this.m_Interaction);
            messageHelper.validateInteraction();
            thermProgress.updateProgressControl(this.loadString("IDS_SQD_CREATE_LIFELINES"), ++n2, n);
            if (this.createLifelines() > 0) {
                this.pumpMessages();
                SwingUtilities.invokeLater(new SQDGenerateRunnable(messageHelper, thermProgress, n, n2, bl2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            EventBlocker.stopBlocking(bl);
        }
    }

    private boolean inDescribeIDE() {
        return false;
    }

    private boolean showInteractionBoundary() {
        return false;
    }

    private int createLifelines() {
        int n;
        ETList<ILifeline> eTList;
        int n2 = 0;
        if (this.m_Interaction != null && this.m_Diagram != null && (eTList = this.m_Interaction.getLifelines()) != null && (n = eTList.size()) > 0) {
            Object object;
            ICoreRelationshipDiscovery iCoreRelationshipDiscovery = TypeConversions.getRelationshipDiscovery(this.m_Diagram);
            if (iCoreRelationshipDiscovery != null && (object = PointConversions.newETPoint(new Point(0, 0))) != null) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < n) {
                    object.setX(n3);
                    ILifeline iLifeline = (ILifeline)eTList.get(n4);
                    IPresentationElement iPresentationElement = iCoreRelationshipDiscovery.createNodePresentationElement(iLifeline, (IETPoint)object);
                    ILifelineDrawEngine iLifelineDrawEngine = this.saveDrawEngineIntoMap(iLifeline, iPresentationElement);
                    if (iLifelineDrawEngine != null) {
                        iLifelineDrawEngine.sizeToContents();
                        IETRect iETRect = TypeConversions.getLogicalBoundingRect(iLifelineDrawEngine);
                        n3 = iETRect.getRight();
                    }
                    ++n2;
                    ++n4;
                    n3 += 20;
                }
            }
            this.layoutSequenceDiagram();
            object = (ILifeline)eTList.get(0);
            ILifelineDrawEngine iLifelineDrawEngine = this.m_MapLifelineToEngine.get(object);
            if (iLifelineDrawEngine != null) {
                IETRect iETRect = TypeConversions.getLogicalBoundingRect(iLifelineDrawEngine);
                this.m_InitialMessageY = iETRect.getIntY() - 50;
            }
        }
        return n2;
    }

    private ILifelineDrawEngine saveDrawEngineIntoMap(ILifeline iLifeline, IPresentationElement iPresentationElement) {
        IDrawEngine iDrawEngine;
        ILifelineDrawEngine iLifelineDrawEngine = null;
        if (iLifeline != null && iPresentationElement != null && (iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement)) != null && iDrawEngine instanceof ILifelineDrawEngine) {
            iLifelineDrawEngine = (ILifelineDrawEngine)iDrawEngine;
            this.m_MapLifelineToEngine.put(iLifeline, iLifelineDrawEngine);
        }
        return iLifelineDrawEngine;
    }

    private int createMessages(MessageHelper messageHelper) {
        ETList<IMessage> eTList;
        int n = -100;
        if (this.m_Interaction != null && this.m_MapLifelineToEngine.size() > 0 && (eTList = this.m_Interaction.getMessages()) != null) {
            int n2 = -1;
            int n3 = messageHelper.getMessageCnt();
            this.updateLifelineLengths((n3 + 1) * 60);
            this.m_Diagram.fitInWindow();
            double d = this.m_Diagram.getCurrentZoom();
            if (d < 0.05) {
                this.m_Diagram.zoom(0.05);
            }
            n = this.m_InitialMessageY;
            for (int i = 0; i < n3; ++i) {
                IMessage iMessage = (IMessage)messageHelper.getMessages().get(i);
                ILifeline iLifeline = iMessage.getSendingLifeline();
                ILifeline iLifeline2 = iMessage.getReceivingLifeline();
                if (iLifeline == null || iLifeline2 == null) continue;
                int n4 = iMessage.getKind();
                ILifelineDrawEngine iLifelineDrawEngine = this.m_MapLifelineToEngine.get(iLifeline);
                ILifelineDrawEngine iLifelineDrawEngine2 = this.m_MapLifelineToEngine.get(iLifeline2);
                if (iLifelineDrawEngine != null && iLifelineDrawEngine2 != null) {
                    switch (n2) {
                        case 0: {
                            n -= 40;
                            break;
                        }
                        case 3: {
                            if (n4 == 3) {
                                n -= 15;
                                break;
                            }
                            n -= !iLifelineDrawEngine.equals(iLifelineDrawEngine2) ? 60 : 35;
                            break;
                        }
                        case 1: {
                            n -= 5;
                            break;
                        }
                        case 2: {
                            n -= 2 == n4 ? 50 : 20;
                            break;
                        }
                        default: {
                            n -= 20;
                        }
                    }
                    ETPairT<IMessageEdgeDrawEngine, Integer> eTPairT = iLifelineDrawEngine.createMessage(iMessage, iLifelineDrawEngine2, n);
                    IMessageEdgeDrawEngine iMessageEdgeDrawEngine = eTPairT.getParamOne();
                    n = eTPairT.getParamTwo();
                }
                this.pumpMessages();
                n2 = n4;
            }
        }
        return n;
    }

    private void updateLifelineLengths(int n) {
        ETList<IPresentationElement> eTList;
        if (this.m_Diagram != null && (eTList = this.m_Diagram.getAllByType("Lifeline")) != null) {
            int n2 = eTList.size();
            for (int i = 0; i < n2; ++i) {
                IADLifelineCompartment iADLifelineCompartment;
                IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(i);
                IETRect iETRect = (IETRect)TypeConversions.getLogicalBoundingRect(iPresentationElement).clone();
                if (n == iETRect.getBottom()) continue;
                iETRect.setBottom(n);
                if (!(iPresentationElement instanceof INodePresentation)) continue;
                INodePresentation iNodePresentation = (INodePresentation)iPresentationElement;
                iNodePresentation.resize(iETRect.getIntWidth(), iETRect.getIntHeight(), true);
                TSENode tSENode = iNodePresentation.getTSNode();
                if (tSENode == null || (iADLifelineCompartment = (IADLifelineCompartment)TypeConversions.getCompartment((TSGraphObject)tSENode, IADLifelineCompartment.class)) == null) continue;
                iADLifelineCompartment.cleanUpActivationBars();
                iADLifelineCompartment.updateReflexiveBends();
            }
        }
    }

    private void createDestroyActions() {
        ETList<ILifeline> eTList;
        if (this.m_Interaction != null && this.m_Diagram != null && (eTList = this.m_Interaction.getLifelines()) != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                ILifeline iLifeline = (ILifeline)eTList.get(i);
                this.createDestroyAction(iLifeline);
            }
        }
    }

    private void createDestroyAction(ILifeline iLifeline) {
        ETList<IEventOccurrence> eTList;
        if (iLifeline != null && (eTList = iLifeline.getEvents()) != null) {
            int n = eTList.size();
            IMessage iMessage = null;
            for (int i = 0; i < n; ++i) {
                IEventOccurrence iEventOccurrence = (IEventOccurrence)eTList.get(i);
                if (this.containsDestroyAction(iEventOccurrence)) {
                    int n2 = this.destroyLifelineAfterMessage(iLifeline, iMessage);
                    IMessageEdgeDrawEngine iMessageEdgeDrawEngine = this.findFirstMessageBelow(n2);
                    if (iMessageEdgeDrawEngine == null) break;
                    iMessageEdgeDrawEngine.move(n2 - 30, true);
                    break;
                }
                IMessage iMessage2 = this.determineEventsMessage(iEventOccurrence);
                if (iMessage2 == null) continue;
                iMessage = iMessage2;
            }
        }
    }

    private void createComments() {
        int n;
        ElementLocator elementLocator;
        ETList<IElement> eTList;
        if (this.m_Interaction != null && (eTList = (elementLocator = new ElementLocator()).findElementsByQuery(this.m_Interaction, ".//UML:Comment")) != null && (n = eTList.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                IElement iElement = (IElement)eTList.get(i);
                if (!(iElement instanceof IComment)) continue;
                this.createComment((IComment)iElement);
            }
            this.layoutSequenceDiagram();
        }
    }

    private void layoutSequenceDiagram() {
        if (this.m_Diagram != null) {
            this.m_Diagram.selectAll(false);
            this.m_Diagram.setLayoutStyleSilently(6);
            this.pumpMessages();
            this.m_Diagram.fitInWindow();
        }
    }

    private IPresentationElement createComment(IComment iComment) {
        IETPoint iETPoint;
        ICoreRelationshipDiscovery iCoreRelationshipDiscovery;
        IPresentationElement iPresentationElement = null;
        if (this.m_Diagram != null && iComment != null && (iCoreRelationshipDiscovery = TypeConversions.getRelationshipDiscovery(this.m_Diagram)) != null && (iETPoint = PointConversions.newETPoint(new Point(0, 0))) != null) {
            iPresentationElement = iCoreRelationshipDiscovery.createNodePresentationElement(iComment, iETPoint);
        }
        return iPresentationElement;
    }

    private boolean containsDestroyAction(IEventOccurrence iEventOccurrence) {
        boolean bl = false;
        if (iEventOccurrence != null) {
            String string;
            IActionOccurrence iActionOccurrence;
            IAction iAction;
            IExecutionOccurrence iExecutionOccurrence = iEventOccurrence.getStartExec();
            if (iExecutionOccurrence == null) {
                iExecutionOccurrence = iEventOccurrence.getFinishExec();
            }
            if (iExecutionOccurrence != null && iExecutionOccurrence instanceof IActionOccurrence && (iAction = (iActionOccurrence = (IActionOccurrence)iExecutionOccurrence).getAction()) != null && (string = iAction.getElementType()) != null && string.equals("DestroyAction")) {
                bl = true;
            }
        }
        return bl;
    }

    private IMessage determineEventsMessage(IEventOccurrence iEventOccurrence) {
        IMessage iMessage = null;
        if (iEventOccurrence != null && (iMessage = iEventOccurrence.getSendMessage()) == null) {
            iMessage = iEventOccurrence.getReceiveMessage();
        }
        return iMessage;
    }

    private int destroyLifelineAfterMessage(ILifeline iLifeline, IMessage iMessage) {
        ILifelineDrawEngine iLifelineDrawEngine;
        int n = 0;
        if (this.m_Diagram != null && iLifeline != null && (iLifelineDrawEngine = this.m_MapLifelineToEngine.get(iLifeline)) != null) {
            IETRect iETRect = null;
            iETRect = iMessage != null ? this.getElementBoundingRectangle(iMessage) : TypeConversions.getLogicalBoundingRect(iLifelineDrawEngine);
            n = iETRect.getIntY() + iETRect.getIntHeight() - 300;
            IETPoint iETPoint = PointConversions.newETPoint(new Point((int)iETRect.getCenterX(), n));
            iLifelineDrawEngine.addDecoration("destroy", iETPoint);
            n -= 20;
        }
        return n;
    }

    private IMessageEdgeDrawEngine findFirstMessageBelow(int n) {
        ETList<IPresentationElement> eTList;
        IMessageEdgeDrawEngine iMessageEdgeDrawEngine = null;
        if (this.m_Diagram != null && (eTList = this.m_Diagram.getAllByType("Message")) != null) {
            int n2 = eTList.size();
            int n3 = Integer.MAX_VALUE;
            IDrawEngine iDrawEngine = null;
            for (int i = 0; i < n2; ++i) {
                IETRect iETRect;
                int n4;
                IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(i);
                IDrawEngine iDrawEngine2 = TypeConversions.getDrawEngine(iPresentationElement);
                if (iDrawEngine2 == null || (n4 = n - (iETRect = TypeConversions.getLogicalBoundingRect(iDrawEngine2)).getTop()) <= 0 || n4 >= n3) continue;
                n3 = n4;
                iDrawEngine = iDrawEngine2;
            }
            if (iDrawEngine != null && iDrawEngine instanceof IMessageEdgeDrawEngine) {
                iMessageEdgeDrawEngine = (IMessageEdgeDrawEngine)iDrawEngine;
            }
        }
        return iMessageEdgeDrawEngine;
    }

    private IDrawEngine getDrawEngine(IElement iElement) {
        int n;
        ETList<IPresentationElement> eTList;
        IDrawEngine iDrawEngine = null;
        if (iElement != null && this.m_Diagram != null && (eTList = this.m_Diagram.getAllItems2(iElement)) != null && (n = eTList.size()) > 0) {
            IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(n - 1);
            iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement);
        }
        return iDrawEngine;
    }

    private IETRect getElementBoundingRectangle(IElement iElement) {
        IDrawEngine iDrawEngine;
        IETRect iETRect = null;
        if (iElement != null && (iDrawEngine = this.getDrawEngine(iElement)) != null) {
            iETRect = TypeConversions.getLogicalBoundingRect(iDrawEngine);
        }
        return iETRect;
    }

    private void createCombinedFragments() {
        ElementLocator elementLocator;
        ETList<IElement> eTList;
        if (this.m_Interaction != null && (eTList = (elementLocator = new ElementLocator()).findElementsByQuery(this.m_Interaction, ".//UML:CombinedFragment")) != null) {
            int n = eTList.size();
            for (int i = n - 1; i >= 0; --i) {
                IElement iElement = (IElement)eTList.get(i);
                if (!(iElement instanceof ICombinedFragment)) continue;
                this.createCombinedFragment((ICombinedFragment)iElement);
            }
            IDrawingAreaControl iDrawingAreaControl = this.getDrawingAreaControl();
            if (iDrawingAreaControl != null) {
                for (int i = 0; i < n; ++i) {
                    int n2;
                    IElement iElement = (IElement)eTList.get(i);
                    ETList<IPresentationElement> eTList2 = iDrawingAreaControl.getAllItems2(iElement);
                    if (eTList2 == null || (n2 = eTList2.size()) <= 0) continue;
                    IPresentationElement iPresentationElement = (IPresentationElement)eTList2.get(0);
                    iDrawingAreaControl.executeStackingCommand(iPresentationElement, 1, false);
                }
            }
        }
    }

    private void createCombinedFragment(ICombinedFragment iCombinedFragment) {
        if (this.m_Diagram != null && iCombinedFragment != null) {
            ICoreRelationshipDiscovery iCoreRelationshipDiscovery = TypeConversions.getRelationshipDiscovery(this.m_Diagram);
            IPresentationElement iPresentationElement = null;
            if (iCoreRelationshipDiscovery != null) {
                iPresentationElement = iCoreRelationshipDiscovery.createPresentationElement(iCombinedFragment);
            }
            if (iPresentationElement != null) {
                IDrawEngine iDrawEngine;
                if (iPresentationElement instanceof INodePresentation) {
                    ((INodePresentation)iPresentationElement).setSelected(false);
                }
                if ((iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement)) != null) {
                    if (iDrawEngine instanceof ICombinedFragmentDrawEngine) {
                        ((ICombinedFragmentDrawEngine)iDrawEngine).expandToIncludeInteractionOperands(true);
                    }
                    this.pumpMessages();
                    ILabelManager iLabelManager = iDrawEngine.getLabelManager();
                    if (iLabelManager != null) {
                        iLabelManager.createInitialLabels();
                    }
                }
            }
        }
    }

    private IDrawingAreaControl getDrawingAreaControl() {
        IDrawingAreaControl iDrawingAreaControl = null;
        if (this.m_Diagram != null && this.m_Diagram instanceof IUIDiagram) {
            iDrawingAreaControl = ((IUIDiagram)this.m_Diagram).getDrawingArea();
        }
        return iDrawingAreaControl;
    }

    private String loadString(String string) {
        return DiagCreatorAddIn.loadString(string);
    }

    private void pumpMessages() {
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingAreaControl();
        if (iDrawingAreaControl != null) {
            iDrawingAreaControl.pumpMessages(false);
        }
    }

    private void postSimpleAction(int n) {
        if (this.m_Diagram != null) {
            SimpleAction simpleAction = new SimpleAction();
            simpleAction.setKind(n);
            this.m_Diagram.postDelayedAction(simpleAction);
        }
    }

    private class SQDGenerateRunnable
    implements Runnable {
        private MessageHelper m_msgHelper = null;
        private ThermProgress m_progress = null;
        private int m_count = 0;
        private int m_index = 0;
        private int m_verticalOffset = 0;
        private boolean m_showInteractionBoundary = false;

        public SQDGenerateRunnable(MessageHelper messageHelper, ThermProgress thermProgress, int n, int n2, boolean bl) {
            this.m_msgHelper = messageHelper;
            this.m_progress = thermProgress;
            this.m_count = n;
            this.m_index = n2;
            this.m_showInteractionBoundary = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = EventBlocker.startBlocking();
            try {
                Object object;
                this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_SQD_CREATE_MESSAGES"), ++this.m_index, this.m_count);
                this.m_verticalOffset = SequenceDiagramGenerator.this.createMessages(this.m_msgHelper);
                SequenceDiagramGenerator.this.pumpMessages();
                this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_SQD_UPDATE_LIFELINES"), ++this.m_index, this.m_count);
                SequenceDiagramGenerator.this.updateLifelineLengths(this.m_verticalOffset - 80);
                SequenceDiagramGenerator.this.pumpMessages();
                if (!SequenceDiagramGenerator.this.inDescribeIDE()) {
                    this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_PERFORMING_LAYOUT"), ++this.m_index, this.m_count);
                    SequenceDiagramGenerator.this.layoutSequenceDiagram();
                }
                this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_SQD_DESTROY_ACTIONS"), ++this.m_index, this.m_count);
                SequenceDiagramGenerator.this.createDestroyActions();
                this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_SQD_COMMENTS"), ++this.m_index, this.m_count);
                SequenceDiagramGenerator.this.createComments();
                if (this.m_showInteractionBoundary) {
                    this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_SQD_SHOW_BOUNDARY"), ++this.m_index, this.m_count);
                    object = TypeConversions.getDiagramEngine(SequenceDiagramGenerator.this.m_Diagram);
                    if (object != null && object instanceof IADSequenceDiagEngine) {
                        ((IADSequenceDiagEngine)object).showInteractionBoundary(true);
                    }
                }
                this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_PERFORMING_LAYOUT"), ++this.m_index, this.m_count);
                SequenceDiagramGenerator.this.layoutSequenceDiagram();
                SequenceDiagramGenerator.this.pumpMessages();
                this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_SQD_COMBINED_FRAGMENTS"), ++this.m_index, this.m_count);
                SequenceDiagramGenerator.this.createCombinedFragments();
                this.m_progress.updateProgressControl(SequenceDiagramGenerator.this.loadString("IDS_SQD_RELATIONSHIPS"), ++this.m_index, this.m_count);
                object = TypeConversions.getRelationshipDiscovery(SequenceDiagramGenerator.this.m_Diagram);
                if (object != null) {
                    ETList<IElement> eTList = SequenceDiagramGenerator.this.m_Diagram.getAllItems3();
                    object.discoverCommonRelations(false, eTList);
                }
                SequenceDiagramGenerator.this.pumpMessages();
            }
            finally {
                EventBlocker.stopBlocking(bl);
            }
        }
    }
}

