/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.controls.drawingarea;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.diagrams.DiagramDetails;
import org.netbeans.modules.uml.core.support.umlsupport.FileExtensions;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.ui.controls.drawingarea.ModelElementXMIIDPair;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchive;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveDefinitions;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.archivesupport.ProductArchiveImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedDiagrams
implements FileExtensions,
IProductArchiveDefinitions {
    private static final Logger logger = Logger.getLogger("uml.ui.controls.drawingarea.CachedDiagrams");
    private static CachedDiagrams m_Instance = null;
    private HashMap<String, DiagramDetails> m_CachedInfo = new HashMap();

    private CachedDiagrams() {
    }

    public static CachedDiagrams instance() {
        if (m_Instance == null) {
            m_Instance = new CachedDiagrams();
        }
        return m_Instance;
    }

    public void destroy() {
        m_Instance = null;
    }

    public DiagramDetails getInfo(String string) {
        DiagramDetails diagramDetails = null;
        if (string.length() > 0 && (diagramDetails = this.getInfoFromCache(string)) == null) {
            IProductArchiveElement iProductArchiveElement;
            String string2 = StringUtilities.ensureExtension(string, ".etlp");
            ProductArchiveImpl productArchiveImpl = new ProductArchiveImpl(string2);
            if (productArchiveImpl.isLoaded() && (iProductArchiveElement = productArchiveImpl.getElement("diagramInfo")) != null) {
                diagramDetails = new DiagramDetails();
                diagramDetails.setName(iProductArchiveElement.getAttributeString("name"));
                diagramDetails.setDiagramAlias(iProductArchiveElement.getAttributeString("alias"));
                diagramDetails.setDiagramTypeName(iProductArchiveElement.getAttributeString("diagramKind"));
                diagramDetails.setDiagramXMIID(iProductArchiveElement.getAttributeString("diagramXMIID"));
                diagramDetails.setToplevelXMIID(iProductArchiveElement.getAttributeString("namespaceToplevelID"));
                diagramDetails.setNamespaceXMIID(iProductArchiveElement.getAttributeString("namespaceMEID"));
                File file = new File(string2);
                diagramDetails.setDateModified(file.lastModified());
                if (diagramDetails.getDiagramTypeName().length() <= 0) {
                    diagramDetails.setDiagramTypeName(iProductArchiveElement.getAttributeString("kind"));
                }
                diagramDetails.setAssociatedDiagrams(this.loadAssociatedDiagrams(productArchiveImpl));
                diagramDetails.setAssociatedElements(this.loadAssociatedElements(productArchiveImpl));
                this.addToCache(string, diagramDetails);
            }
            if (diagramDetails != null) {
                logger.fine("** getInfo: load diagram detail from file. Diagram alias|name= " + diagramDetails.getDiagramAlias() + "|" + diagramDetails.getName());
            }
        }
        return diagramDetails;
    }

    public DiagramDetails getInfoFromCache(String string) {
        DiagramDetails diagramDetails = null;
        if (string.length() > 0) {
            File file;
            String string2 = StringUtilities.ensureExtension(string, ".etld");
            String string3 = StringUtilities.ensureExtension(string, ".etlp");
            diagramDetails = this.m_CachedInfo.get(string3);
            if (diagramDetails != null && (file = new File(string3)).lastModified() != diagramDetails.getDateModified()) {
                diagramDetails = null;
            }
        }
        return diagramDetails;
    }

    public void addToCache(String string, DiagramDetails diagramDetails) {
        if (string != null && string.length() > 0 && diagramDetails != null) {
            String string2 = StringUtilities.ensureExtension(string, ".etlp");
            if (this.m_CachedInfo.containsKey(string2)) {
                this.m_CachedInfo.remove(string2);
            }
            this.m_CachedInfo.put(string2, diagramDetails);
        }
    }

    public ArrayList<String> loadAssociatedDiagrams(IProductArchive iProductArchive) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iProductArchive != null) {
            int n = 1;
            IProductArchiveElement iProductArchiveElement = iProductArchive.getTableEntry("AssociatedDiagrams", n);
            while (iProductArchiveElement != null) {
                String string;
                if (!iProductArchiveElement.isDeleted() && (string = iProductArchiveElement.getID()).length() > 0) {
                    arrayList.add(string);
                }
                iProductArchiveElement = null;
                iProductArchiveElement = iProductArchive.getTableEntry("AssociatedDiagrams", ++n);
            }
        }
        return arrayList;
    }

    public ArrayList<ModelElementXMIIDPair> loadAssociatedElements(IProductArchive iProductArchive) {
        ArrayList<ModelElementXMIIDPair> arrayList = new ArrayList<ModelElementXMIIDPair>();
        if (iProductArchive != null) {
            int n = 1;
            IProductArchiveElement iProductArchiveElement = null;
            iProductArchiveElement = iProductArchive.getTableEntry("AssociatedElements", n);
            while (iProductArchiveElement != null) {
                if (!iProductArchiveElement.isDeleted()) {
                    String string = iProductArchiveElement.getID();
                    String string2 = iProductArchiveElement.getAttributeString("toplevelMEID");
                    if (string.length() > 0 && string2.length() > 0) {
                        arrayList.add(new ModelElementXMIIDPair(string2, string));
                    }
                }
                iProductArchiveElement = null;
                iProductArchiveElement = iProductArchive.getTableEntry("AssociatedElements", ++n);
            }
        }
        return arrayList;
    }

    public static String getNewDiagramType(int n) {
        String string = "";
        if (n == 2) {
            string = "Class Diagram";
        } else if (n == 6) {
            string = "Sequence Diagram";
        }
        return string;
    }
}

