/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.controls.drawingarea;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.controls.drawingarea.GetHelper;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETGraph;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductGraphPresentation;
import org.netbeans.modules.uml.ui.support.umltsconversions.RectConversions;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEHelper {
    TSEGraphWindow m_graphWindow;
    IDrawingAreaControl m_drawingArea;
    boolean m_bCalculateBoundingRect;
    IETRect m_rectBounding = new ETRect();
    HashSet<Long> m_setPEIDs = new HashSet();
    ETList<IPresentationElement> m_presentationElements;

    public PEHelper(TSEGraphWindow tSEGraphWindow, IDrawingAreaControl iDrawingAreaControl, boolean bl) {
        this.m_graphWindow = tSEGraphWindow;
        this.m_bCalculateBoundingRect = bl;
        this.m_drawingArea = iDrawingAreaControl;
    }

    public void add(IPresentationElement iPresentationElement) {
        if (iPresentationElement != null) {
            Object object;
            if (this.m_bCalculateBoundingRect && iPresentationElement instanceof IProductGraphPresentation && (object = (IProductGraphPresentation)iPresentationElement) != null) {
                IETRect iETRect = TypeConversions.getLogicalBoundingRect((IProductGraphPresentation)object);
                this.m_rectBounding.unionWith(iETRect);
            }
            object = (TSGraphObject)TypeConversions.getTSObject(iPresentationElement);
            this.add((TSGraphObject)object);
            if (null == this.m_presentationElements) {
                this.m_presentationElements = new ETArrayList<IPresentationElement>();
            }
            if (this.m_presentationElements != null) {
                this.m_presentationElements.add(iPresentationElement);
            }
        }
    }

    public void add(ETList<IPresentationElement> eTList) {
        if (eTList != null) {
            for (IPresentationElement iPresentationElement : eTList) {
                this.add(iPresentationElement);
            }
        }
    }

    public void addSelected() {
        if (null == this.m_graphWindow) {
            throw new IllegalArgumentException();
        }
        ETGraph eTGraph = (ETGraph)GetHelper.getCurrentGraph(this.m_graphWindow);
        ETList<IPresentationElement> eTList = GetHelper.getSelected(eTGraph);
        this.add(eTList);
    }

    public IETRect getBoundingRect() {
        return (IETRect)this.m_rectBounding.clone();
    }

    void executeStackingCommand(int n, boolean bl) {
        if (null == this.m_graphWindow) {
            throw new IllegalArgumentException();
        }
        if (n == 1) {
            TSDGraph tSDGraph = GetHelper.getCurrentGraph(this.m_graphWindow);
            long l = 0L;
            if (null == this.m_presentationElements) {
                this.m_presentationElements = this.m_drawingArea.getSelected();
            }
            if (this.m_presentationElements != null && tSDGraph != null) {
                l = this.m_presentationElements.getCount();
            }
            for (IPresentationElement iPresentationElement : this.m_presentationElements) {
                TSENode tSENode = TypeConversions.getOwnerNode(iPresentationElement);
                if (tSENode == null) continue;
                boolean bl2 = tSENode.isSelected();
                tSDGraph.remove((TSNode)tSENode);
                tSDGraph.insert((TSNode)tSENode);
                if (!bl2) continue;
                tSENode.setSelected(bl2);
            }
            if (bl) {
                this.m_drawingArea.refresh(false);
            }
            return;
        }
        TSDGraph tSDGraph = GetHelper.getCurrentGraph(this.m_graphWindow);
        TSRect tSRect = new TSRect();
        if (tSDGraph != null && this.m_graphWindow != null) {
            ETPairT<TSRect, List> eTPairT = this.buildListTouchingRect();
            if (null == eTPairT) {
                return;
            }
            tSRect = eTPairT.getParamOne();
            List list = eTPairT.getParamTwo();
            ArrayList<TSENode> arrayList = new ArrayList<TSENode>();
            for (TSENode object : list) {
                if (!object.isSelected()) continue;
                arrayList.add(object);
            }
            if (n == 1 || n == 3) {
                for (TSGraphObject tSGraphObject : arrayList) {
                    TSENode tSENode;
                    long l = tSGraphObject.getID();
                    boolean bl2 = this.m_setPEIDs.contains(new Long(l));
                    if ((n != 1 || !bl2) && (n != 3 || bl2) || (tSENode = (TSENode)tSGraphObject) == null) continue;
                    tSDGraph.remove((TSNode)tSENode);
                    tSDGraph.insert((TSNode)tSENode);
                }
            } else if (n == 2 || n == 0) {
                ArrayList arrayList2 = new ArrayList();
                if (n == 2) {
                    GetHelper.reverseList(this.m_graphWindow, list);
                }
                ArrayList<TSGraphObject> arrayList3 = new ArrayList<TSGraphObject>();
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                for (TSGraphObject tSGraphObject : list) {
                    long l = tSGraphObject.getID();
                    boolean bl6 = false;
                    boolean bl7 = this.m_setPEIDs.contains(new Long(l));
                    if (bl7) {
                        bl3 = true;
                    }
                    if (bl3) {
                        int n2;
                        if (bl7) {
                            arrayList3.add(tSGraphObject);
                            bl6 = true;
                        } else if (!bl4 && !bl7 && (n2 = arrayList2.size()) > 0) {
                            arrayList2.addAll(arrayList3);
                            arrayList3.clear();
                        }
                    }
                    if (!bl6) {
                        arrayList2.add(tSGraphObject);
                    }
                    bl4 = bl7;
                }
                arrayList2.addAll(arrayList3);
                arrayList3.clear();
                if (n == 2) {
                    GetHelper.reverseList(this.m_graphWindow, arrayList2);
                }
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    TSGraphObject tSGraphObject;
                    tSGraphObject = (TSENode)iterator.next();
                    tSDGraph.remove((TSNode)tSGraphObject);
                    tSDGraph.insert((TSNode)tSGraphObject);
                }
            }
            this.selectByID(arrayList);
            if (bl) {
                this.m_graphWindow.addInvalidRegion((TSConstRect)tSRect);
            }
        }
    }

    protected void selectByID(List list) {
        if (list != null && this.m_drawingArea != null) {
            for (TSGraphObject tSGraphObject : list) {
                IPresentationElement iPresentationElement;
                long l = tSGraphObject.getID();
                if (!this.m_setPEIDs.contains(new Long(l)) || (iPresentationElement = TypeConversions.getPresentationElement((TSObject)tSGraphObject)) == null) continue;
                this.m_drawingArea.postSimplePresentationDelayedAction(iPresentationElement, 13);
            }
        }
    }

    protected void addToIDList(List list) {
        if (list != null) {
            for (TSGraphObject tSGraphObject : list) {
                this.add(tSGraphObject);
            }
        }
    }

    protected void add(TSGraphObject tSGraphObject) {
        if (tSGraphObject != null) {
            long l = tSGraphObject.getID();
            this.m_setPEIDs.add(new Long(l));
        }
    }

    protected ETPairT<TSRect, List> buildListTouchingRect() {
        List list;
        ETPairT<TSRect, List> eTPairT = null;
        ETArrayList<TSGraphObject> eTArrayList = new ETArrayList<TSGraphObject>();
        TSRect tSRect = RectConversions.etRectToTSRect(this.m_rectBounding);
        TSDGraph tSDGraph = GetHelper.getCurrentGraph(this.m_graphWindow);
        if (tSRect != null && tSDGraph != null && (list = tSDGraph.getNodesTouchingBounds((TSConstRect)tSRect, null)) != null) {
            long l = list.size();
            long l2 = 0L;
            while (l != l2) {
                ArrayList arrayList = new ArrayList();
                for (TSGraphObject tSGraphObject : list) {
                    if (!(tSGraphObject instanceof TSENode)) continue;
                    eTArrayList.add(tSGraphObject);
                }
                l = list.size();
                tSRect = GetHelper.calculateTSGraphObjectsRect(eTArrayList);
                list = tSDGraph.getNodesTouchingBounds((TSConstRect)tSRect, null);
                l2 = list.size();
            }
            eTPairT = new ETPairT<TSRect, List>(tSRect, list);
        }
        return eTPairT;
    }
}

