/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.controls.projecttree;

import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.coreapplication.CoreProductInitEventsAdapter;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.metamodel.structure.ProjectEventsAdapter;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.InvalidArguments;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.core.workspacemanagement.WSProjectEventsAdapter;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceEventsAdapter;
import org.netbeans.modules.uml.ui.controls.projecttree.DefaultNodeFactory;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeEngine;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeModel;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeModelListener;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeItemImpl;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeModelEvent;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeNode;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeNodeFactory;
import org.netbeans.modules.uml.ui.controls.projecttree.TreeElementNode;
import org.netbeans.modules.uml.ui.products.ad.projecttreedefaultengine.ADProjectTreeEngine;
import org.netbeans.modules.uml.ui.support.DispatchHelper;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeElement;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeItem;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ProjectTreeComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProductProjectTreeModel
implements IProjectTreeModel {
    private ICoreProduct m_Product = null;
    private ProjectTreeNode m_TreeRoot = null;
    private ArrayList<IProjectTreeEngine> m_TreeEngines = new ArrayList();
    private ArrayList<IProjectTreeModelListener> m_Listeners = new ArrayList();
    private DispatchHelper m_DispatcherHelper = new DispatchHelper();
    private WorkspaceEventHandler m_WorkspaceHandler = new WorkspaceEventHandler();
    private WSProjectEventsHandler m_WSProjectHandler = new WSProjectEventsHandler();
    private ProjectEventHandler m_ProjectHandler = new ProjectEventHandler();
    private ProjectTreeNodeFactory m_Factory = new DefaultNodeFactory();

    public ProductProjectTreeModel() {
    }

    public ProductProjectTreeModel(ICoreProduct iCoreProduct) {
        this.setProduct(iCoreProduct);
        this.initialize();
    }

    @Override
    public String getModelName() {
        return "ProjectTree";
    }

    @Override
    public ProjectTreeNodeFactory getNodeFactory() {
        return this.m_Factory;
    }

    public IProjectTreeEngine getFirstEngine() {
        return this.m_TreeEngines.get(0);
    }

    public void initialize() {
        try {
            this.attachSinks();
            this.attachEngines();
        }
        catch (InvalidArguments invalidArguments) {
            // empty catch block
        }
    }

    @Override
    public ITreeItem getChildItem(Object object, int n) {
        ITreeItem iTreeItem;
        ITreeItem iTreeItem2 = null;
        if (object instanceof ITreeItem && (iTreeItem = (ITreeItem)object).getChildCount() > 0) {
            iTreeItem2 = ((ITreeItem)object).getChild(n);
        }
        return iTreeItem2;
    }

    @Override
    public int getChildCount(Object object) {
        ITreeItem iTreeItem;
        int n = 0;
        if (object instanceof ITreeItem && (n = (iTreeItem = (ITreeItem)object).getChildCount()) <= 0 && !iTreeItem.isInitalized()) {
            n = 1;
        }
        return n;
    }

    @Override
    public ITreeItem getRootItem() {
        return this.m_TreeRoot;
    }

    @Override
    public boolean isLeaf(Object object) {
        int n = this.getChildCount(object);
        return n == 0;
    }

    @Override
    public boolean canDelete(IProjectTreeItem iProjectTreeItem) {
        boolean bl = true;
        for (IProjectTreeEngine iProjectTreeEngine : this.m_TreeEngines) {
            if (iProjectTreeEngine.canDelete(iProjectTreeItem)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public boolean canEdit(IProjectTreeItem iProjectTreeItem) {
        boolean bl = true;
        for (IProjectTreeEngine iProjectTreeEngine : this.m_TreeEngines) {
            if (iProjectTreeEngine.canEdit(iProjectTreeItem)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    public void clear(boolean bl) {
        if (this.m_TreeRoot != null) {
            this.m_TreeRoot.removeAllChildren();
            this.m_TreeRoot = null;
        }
        if (bl) {
            this.setWorkspace(this.getWorkspace());
        }
    }

    public ICoreProduct getProduct() {
        return this.m_Product;
    }

    public void setProduct(ICoreProduct iCoreProduct) {
        this.m_Product = iCoreProduct;
        if (this.getWorkspace() != null) {
            this.setWorkspace(this.getWorkspace());
        }
    }

    @Override
    public IWorkspace getWorkspace() {
        IWorkspace iWorkspace = null;
        if (this.getProduct() != null) {
            iWorkspace = this.getProduct().getCurrentWorkspace();
        }
        return iWorkspace;
    }

    public void setWorkspace(IWorkspace iWorkspace) {
        if (iWorkspace != null) {
            ProjectTreeItemImpl projectTreeItemImpl = new ProjectTreeItemImpl();
            projectTreeItemImpl.setData(iWorkspace);
            projectTreeItemImpl.setDescription("Workspace");
            projectTreeItemImpl.setItemText(iWorkspace.getName());
            this.m_TreeRoot = new ProjectTreeNode(projectTreeItemImpl);
            this.addProjects(iWorkspace);
        }
    }

    private void addProjects(IWorkspace iWorkspace) {
        try {
            if (this.isProjectTree()) {
                IApplication iApplication = ProductHelper.getApplication();
                ETArrayList<String> eTArrayList = this.getUnfilteredProjects();
                ETList<IWSProject> eTList = iWorkspace.getWSProjects();
                for (int i = 0; i < eTList.size(); ++i) {
                    IWSProject iWSProject = (IWSProject)eTList.get(i);
                    String string = iWSProject.getNameWithAlias();
                    if (string.length() <= 0) continue;
                    if (eTArrayList == null) {
                        this.addProject(string, this.getRootItem(), iWorkspace, iApplication);
                        continue;
                    }
                    if (!eTArrayList.contains(string)) continue;
                    this.addProject(string, this.getRootItem(), iWorkspace, iApplication);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ITreeElement addProject(String string, ITreeItem iTreeItem, IWorkspace iWorkspace, IApplication iApplication) {
        IProject iProject = iApplication.getProjectByName(iWorkspace, string);
        ITreeElement iTreeElement = this.addProject(string, iTreeItem, iProject);
        return iTreeElement;
    }

    protected ITreeElement addProject(String string, ITreeItem iTreeItem, IProject iProject) {
        TreeElementNode treeElementNode = new TreeElementNode();
        treeElementNode.setName(string);
        treeElementNode.setElement(iProject);
        treeElementNode.setDisplayedName(string);
        if (treeElementNode.getData() != null) {
            treeElementNode.getData().setSortPriority(1L);
            treeElementNode.getData().setDescription("Workspace Project");
        }
        this.addItem(iTreeItem, treeElementNode);
        return treeElementNode;
    }

    @Override
    public IProjectTreeItem addItem(IProjectTreeItem iProjectTreeItem, String string, String string2, long l, IElement iElement, Object object, String string3) {
        ITreeItem iTreeItem = null;
        if (iProjectTreeItem.getPath() != null) {
            ITreeItem[] iTreeItemArray = iProjectTreeItem.getPath();
            iTreeItem = iTreeItemArray[iTreeItemArray.length - 1];
        }
        return this.addItem(iTreeItem, string, string2, l, iElement, object, string3);
    }

    @Override
    public IProjectTreeItem addItem(ITreeItem iTreeItem, String string, String string2, long l, IElement iElement, Object object, String string3) {
        ProjectTreeItemImpl projectTreeItemImpl = new ProjectTreeItemImpl();
        projectTreeItemImpl.setItemText(string2);
        projectTreeItemImpl.setModelElement(iElement);
        projectTreeItemImpl.setDescription(string3);
        projectTreeItemImpl.setSortPriority((int)l);
        if (object instanceof ITreeItem) {
            projectTreeItemImpl.setProjectTreeSupportTreeItem((ITreeItem)object);
        }
        ProjectTreeNode projectTreeNode = new ProjectTreeNode(projectTreeItemImpl);
        iTreeItem.insertAt(projectTreeNode, this.findLocation(iTreeItem, projectTreeNode));
        projectTreeNode.setName(string);
        TreeNode[] treeNodeArray = projectTreeNode.getPath();
        if (treeNodeArray != null) {
            ITreeItem[] iTreeItemArray = new ITreeItem[treeNodeArray.length];
            for (int i = 0; i < treeNodeArray.length; ++i) {
                if (!(treeNodeArray[i] instanceof ITreeItem)) continue;
                iTreeItemArray[i] = (ITreeItem)((Object)treeNodeArray[i]);
            }
            projectTreeItemImpl.setPath(iTreeItemArray);
        }
        return projectTreeItemImpl;
    }

    @Override
    public void addItem(ITreeItem iTreeItem, ITreeItem iTreeItem2) {
        if (iTreeItem != null && iTreeItem2 != null) {
            Object object;
            int n;
            iTreeItem2.setParentItem(null);
            int n2 = iTreeItem.getChildCount();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                object = iTreeItem.getChild(n);
                if (!object.equals(iTreeItem2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                n = this.findLocation(iTreeItem, iTreeItem2);
                iTreeItem.insertAt(iTreeItem2, n);
                iTreeItem2.setParentItem(iTreeItem);
                object = new int[]{n};
                this.notifyOfAddedChildren(iTreeItem, (int[])object);
            }
        }
    }

    protected int findLocation(ITreeItem iTreeItem, ITreeItem iTreeItem2) {
        int n;
        int n2 = 0;
        n2 = n = iTreeItem.getChildCount();
        for (int i = 0; i < n; ++i) {
            ITreeItem iTreeItem3 = iTreeItem.getChild(i);
            if (iTreeItem3 == null || ProjectTreeComparable.compareTo(iTreeItem3, iTreeItem2) != 1) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public void insertItem(ITreeItem iTreeItem, ITreeItem iTreeItem2, int n) {
        iTreeItem.insertAt(iTreeItem2, n);
        int[] nArray = new int[]{n};
        this.notifyOfAddedChildren(iTreeItem, nArray);
    }

    @Override
    public void removeAll(IElement iElement) {
        ETList<ITreeItem> eTList = this.findNodes(iElement);
        if (eTList != null && eTList.size() > 0) {
            for (ITreeItem iTreeItem : eTList) {
                this.removeNodeFromParent(iTreeItem);
            }
        }
    }

    @Override
    public ITreeItem projectOpened(IProject iProject) {
        ITreeElement iTreeElement = null;
        if (iProject != null && (iTreeElement = this.getProjectNode(iProject.getNameWithAlias())) != null) {
            iTreeElement.setElement(iProject);
        }
        return iTreeElement;
    }

    public ETArrayList<String> getUnfilteredProjects() {
        return null;
    }

    public boolean isProjectTree() {
        return false;
    }

    public void addEngine(IProjectTreeEngine iProjectTreeEngine) {
        this.m_TreeEngines.add(iProjectTreeEngine);
    }

    public void removeEngine(IProjectTreeEngine iProjectTreeEngine) {
        this.m_TreeEngines.remove(iProjectTreeEngine);
    }

    @Override
    public void removeNodeFromParent(ITreeItem iTreeItem) {
        ITreeItem iTreeItem2 = iTreeItem.getParentItem();
        if (iTreeItem2 == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] nArray = new int[]{this.getIndexOfChild(iTreeItem2, iTreeItem)};
        ITreeItem[] iTreeItemArray = new ITreeItem[]{iTreeItem};
        iTreeItem2.removeChild(iTreeItem);
        this.notifyOfRemovedChildren(iTreeItem2, nArray, iTreeItemArray);
    }

    @Override
    public int getIndexOfChild(ITreeItem iTreeItem, ITreeItem iTreeItem2) {
        int n = -1;
        if (iTreeItem != null && iTreeItem2 != null) {
            for (int i = 0; i < iTreeItem.getChildCount() && n < 0; ++i) {
                if (!iTreeItem2.equals(iTreeItem.getChild(i))) continue;
                n = i;
            }
        }
        return n;
    }

    @Override
    public void sortChildren(ITreeItem iTreeItem) {
        this.sortChildren(iTreeItem, new ProjectTreeComparable());
    }

    @Override
    public void sortChildren(ITreeItem iTreeItem, Comparator comparator) {
    }

    @Override
    public ETList<ITreeItem> findNodes(final IElement iElement) {
        return this.findNodes(new Comparator<ITreeItem>(){

            @Override
            public int compare(ITreeItem iTreeItem, ITreeItem iTreeItem2) {
                return 0;
            }

            @Override
            public boolean equals(Object object) {
                return object.equals(iElement);
            }
        });
    }

    @Override
    public ETList<ITreeItem> findNodes(Comparator<ITreeItem> comparator) {
        ETArrayList<ITreeItem> eTArrayList = new ETArrayList<ITreeItem>();
        this.findNodes(this.getRootItem(), comparator, eTArrayList);
        return eTArrayList;
    }

    protected void findNodes(ITreeItem iTreeItem, Comparator<ITreeItem> comparator, ETList<ITreeItem> eTList) {
        if (iTreeItem != null && eTList != null) {
            if (((Object)comparator).equals(iTreeItem)) {
                eTList.add(iTreeItem);
            }
            int n = iTreeItem.getChildCount();
            for (int i = 0; i < n; ++i) {
                ITreeItem iTreeItem2 = iTreeItem.getChild(i);
                this.findNodes(iTreeItem2, comparator, eTList);
            }
        }
    }

    @Override
    public ETList<ITreeItem> findDiagramNodes(final String string) {
        return this.findNodes(new Comparator<ITreeItem>(){

            @Override
            public int compare(ITreeItem iTreeItem, ITreeItem iTreeItem2) {
                return 0;
            }

            @Override
            public boolean equals(Object object) {
                return object.equals(string);
            }
        });
    }

    @Override
    public void addProjectTreeModelListener(IProjectTreeModelListener iProjectTreeModelListener) {
        this.m_Listeners.add(iProjectTreeModelListener);
    }

    @Override
    public void removeProjectTreeModelListener(IProjectTreeModelListener iProjectTreeModelListener) {
        this.m_Listeners.remove(iProjectTreeModelListener);
    }

    public void fireProjectClosed(ITreeElement iTreeElement, IProject iProject) {
        ProjectTreeModelEvent projectTreeModelEvent = new ProjectTreeModelEvent(this, iTreeElement, iProject, true);
        for (IProjectTreeModelListener iProjectTreeModelListener : this.m_Listeners) {
            iProjectTreeModelListener.projectClosed(projectTreeModelEvent);
        }
    }

    public void fireProjectOpened(ITreeElement iTreeElement, IProject iProject) {
        ProjectTreeModelEvent projectTreeModelEvent = new ProjectTreeModelEvent(this, iTreeElement, iProject, false);
        for (IProjectTreeModelListener iProjectTreeModelListener : this.m_Listeners) {
            iProjectTreeModelListener.projectOpened(projectTreeModelEvent);
        }
    }

    protected ITreeElement getProjectNode(String string) {
        ITreeElement iTreeElement = null;
        ITreeItem iTreeItem = this.getRootItem();
        if (iTreeItem != null) {
            int n = iTreeItem.getChildCount();
            for (int i = 0; i < n && iTreeElement == null; ++i) {
                ITreeItem iTreeItem2 = iTreeItem.getChild(i);
                IProjectTreeItem iProjectTreeItem = iTreeItem2.getData();
                if (!iProjectTreeItem.isProject() || !iProjectTreeItem.getItemText().equals(string) || !(iTreeItem2 instanceof ITreeElement)) continue;
                iTreeElement = (ITreeElement)iTreeItem2;
            }
        }
        return iTreeElement;
    }

    protected ITreeElement getProjectNode(IProject iProject) {
        ITreeElement iTreeElement = null;
        if (iProject != null) {
            Object object;
            IWorkspace iWorkspace = this.getWorkspace();
            String string = iProject.getNameWithAlias();
            boolean bl = false;
            if (iWorkspace != null && (object = iWorkspace.getWSProjectByName(iProject.getName())) != null) {
                bl = object.isOpen();
            }
            if (bl) {
                object = ProductHelper.getDataFormatter();
                iTreeElement = this.getProjectNode(object.formatElement(iProject));
            }
        }
        return iTreeElement;
    }

    protected void attachEngines() {
        ADProjectTreeEngine aDProjectTreeEngine = new ADProjectTreeEngine();
        aDProjectTreeEngine.initialize(this);
        this.addEngine(aDProjectTreeEngine);
    }

    protected void attachSinks() throws InvalidArguments {
        this.m_DispatcherHelper.registerForWorkspaceEvents(this.m_WorkspaceHandler);
        this.m_DispatcherHelper.registerForWSProjectEvents(this.m_WSProjectHandler);
        this.m_DispatcherHelper.registerForProjectEvents(this.m_ProjectHandler);
    }

    protected void detachSinks() throws InvalidArguments {
        this.m_DispatcherHelper.revokeWorkspaceSink(this.m_WorkspaceHandler);
        this.m_DispatcherHelper.revokeWSProjectSink(this.m_WSProjectHandler);
        this.m_DispatcherHelper.revokeProjectSink(this.m_ProjectHandler);
    }

    public void handleWSProjectRemoved(IWSProject iWSProject, IResultCell iResultCell) {
    }

    public void handleWSProjectInserted(IWSProject iWSProject, IResultCell iResultCell) {
    }

    public void handleProjectCreated(IProject iProject, IResultCell iResultCell) {
    }

    public void handleProjectOpened(IProject iProject, IResultCell iResultCell) {
    }

    public void handleProjectClosed(IProject iProject, IResultCell iResultCell) {
    }

    public void handleProjectRenamed(IProject iProject, String string, IResultCell iResultCell) {
    }

    protected class ProjectEventHandler
    extends ProjectEventsAdapter {
        protected ProjectEventHandler() {
        }

        public void onModeModified(IProject iProject, IResultCell iResultCell) {
        }

        public void onDefaultLanguageModified(IProject iProject, IResultCell iResultCell) {
        }

        public void onProjectCreated(IProject iProject, IResultCell iResultCell) {
            ProductProjectTreeModel.this.handleProjectCreated(iProject, iResultCell);
        }

        public void onProjectOpened(IProject iProject, IResultCell iResultCell) {
            ProductProjectTreeModel.this.handleProjectOpened(iProject, iResultCell);
        }

        public void onProjectRenamed(IProject iProject, String string, IResultCell iResultCell) {
            ProductProjectTreeModel.this.handleProjectRenamed(iProject, string, iResultCell);
        }

        public void onProjectClosed(IProject iProject, IResultCell iResultCell) {
            ProductProjectTreeModel.this.handleProjectClosed(iProject, iResultCell);
        }

        public void onProjectSaved(IProject iProject, IResultCell iResultCell) {
        }
    }

    protected class WSProjectEventsHandler
    extends WSProjectEventsAdapter {
        protected WSProjectEventsHandler() {
        }

        public void onWSProjectRemoved(IWSProject iWSProject, IResultCell iResultCell) {
            ProductProjectTreeModel.this.handleWSProjectRemoved(iWSProject, iResultCell);
        }

        public void onWSProjectInserted(IWSProject iWSProject, IResultCell iResultCell) {
            ProductProjectTreeModel.this.handleWSProjectInserted(iWSProject, iResultCell);
        }
    }

    protected class WorkspaceEventHandler
    extends WorkspaceEventsAdapter {
        protected WorkspaceEventHandler() {
        }

        public void onWorkspaceOpened(IWorkspace iWorkspace, IResultCell iResultCell) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProductProjectTreeModel.this.clear();
                }
            });
        }

        public void onWorkspaceClosed(IWorkspace iWorkspace, IResultCell iResultCell) {
            ProductProjectTreeModel.this.clear(false);
        }
    }

    protected class CoreProductInitHandler
    extends CoreProductInitEventsAdapter {
        protected CoreProductInitHandler() {
        }

        public void onCoreProductPreQuit(ICoreProduct iCoreProduct, IResultCell iResultCell) {
            try {
                ProductProjectTreeModel.this.detachSinks();
                ProductProjectTreeModel.this.clear(false);
            }
            catch (InvalidArguments invalidArguments) {
                // empty catch block
            }
        }
    }
}

