/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments;

import com.tomsawyer.editor.TSEWindowTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETTransform;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETTransformOwner;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IMouseEvent;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ISetCursorEvent;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.DragManager;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.IDragManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompartmentDividers {
    private static final long DIVIDERHEIGHT = 2L;
    protected ETList<DividerInfo> m_dividers;
    private ETTransformOwner m_transformOwner;
    private int m_nPenStyle;

    public CompartmentDividers(ETTransformOwner eTTransformOwner, int n) {
        this.m_transformOwner = eTTransformOwner;
        this.m_nPenStyle = n;
    }

    public void finalize() {
        this.clear();
    }

    public void addDivider(double d, ETRect eTRect, ICompartment iCompartment, ICompartment iCompartment2) {
        Debug.assertTrue(iCompartment != iCompartment2);
        if (iCompartment != null && iCompartment2 != null) {
            boolean bl = false;
            if (iCompartment != null) {
                bl = iCompartment.isResizeable();
            }
            boolean bl2 = false;
            if (iCompartment2 != null) {
                bl2 = iCompartment2.isCollapsible();
            }
            int n = (int)(d * 2.0);
            eTRect.inflate(0, n);
            this.m_dividers.add(new DividerInfo(eTRect, bl, bl2, iCompartment, iCompartment2));
        }
    }

    public void clear() {
        this.m_dividers.clear();
    }

    public void draw(Graphics2D graphics2D, Color color) {
        BasicStroke basicStroke = new BasicStroke();
        for (DividerInfo dividerInfo : this.m_dividers) {
            boolean bl = false;
            if (dividerInfo.m_bCollapsible) {
                ICompartment iCompartment = dividerInfo.m_nextCompartment;
                bl = iCompartment.getCollapsed();
            }
            this.drawDividerBar(graphics2D, dividerInfo.m_rcDivider, bl, basicStroke);
        }
    }

    public boolean isMouseOnDivider(IMouseEvent iMouseEvent) {
        boolean bl = false;
        if (this.m_transformOwner != null) {
            IETPoint iETPoint = this.getTransform().getWinClientMouseLocation(iMouseEvent);
            bl = this.determineMouseEventDivider(iETPoint) != null;
        }
        return bl;
    }

    public boolean handleLeftMouseBeginDrag(IETPoint iETPoint) {
        IDragManager iDragManager;
        boolean bl = false;
        IETPoint iETPoint2 = this.getTransform().getTSAbsoluteToWinScaledOwner(iETPoint);
        DividerInfo dividerInfo = this.determineMouseEventDivider(iETPoint2);
        if (dividerInfo != null) {
            if (!dividerInfo.m_bResizeable) {
                dividerInfo = null;
            }
            bl = true;
        }
        if (dividerInfo != null && (iDragManager = this.createDragManagerTool()) != null) {
            IETRect iETRect = this.getTransform().getWinClientRect();
            ICompartment iCompartment = dividerInfo.m_prevCompartment;
            Debug.assertTrue(iCompartment != null);
            if (iCompartment != null) {
                IETRect iETRect2 = TypeConversions.getLogicalBoundingRect(iCompartment);
                iDragManager.setTop(iETRect2.getTop());
                ICompartment iCompartment2 = dividerInfo.m_nextCompartment;
                Debug.assertTrue(iCompartment2 != null);
                if (iCompartment2 != null) {
                    IETRect iETRect3 = TypeConversions.getLogicalBoundingRect(iCompartment2);
                    iDragManager.setBottom(iETRect3.getBottom());
                }
                iDragManager.setStretchCompartment(iCompartment);
            }
        }
        return bl;
    }

    public ETTransform getTransform() {
        if (null == this.m_transformOwner) {
            throw new IllegalStateException();
        }
        return this.m_transformOwner;
    }

    protected void drawDividerBar(Graphics2D graphics2D, ETRect eTRect, boolean bl, Stroke stroke) {
        int n = eTRect.getCenterPoint().y;
        Point point = new Point(eTRect.getLeft(), n);
        Point point2 = new Point(eTRect.getRight(), n);
        GDISupport.drawLine(graphics2D, point, point2, stroke);
        if (bl) {
            Color color = Color.BLACK;
            ETRect eTRect2 = new ETRect(point, point2);
            double d = this.getTransform().getZoomLevel();
            eTRect.setBottom((int)((double)eTRect.getTop() + d * 2.0));
            eTRect.inflate((int)(-5.0 * d), 0);
            GDISupport.drawRectangle(graphics2D, eTRect, color, color);
        }
    }

    protected boolean handleSetCursor(IETPoint iETPoint, ISetCursorEvent iSetCursorEvent) {
        DividerInfo dividerInfo = this.determineMouseEventDivider(iETPoint);
        if (dividerInfo != null) {
            boolean bl;
            ICompartment iCompartment;
            boolean bl2 = false;
            if (dividerInfo.m_bResizeable || !dividerInfo.m_bCollapsible || (iCompartment = dividerInfo.m_nextCompartment) == null || !(bl = iCompartment.getCollapsed())) {
                // empty if block
            }
            if (bl2) {
                // empty if block
            }
        }
        return dividerInfo != null;
    }

    protected DividerInfo determineMouseEventDivider(IETPoint iETPoint) {
        DividerInfo dividerInfo = null;
        for (DividerInfo dividerInfo2 : this.m_dividers) {
            Debug.assertTrue(dividerInfo2 != null);
            if (!dividerInfo2.m_rcDivider.contains(iETPoint)) continue;
            dividerInfo = dividerInfo2;
            break;
        }
        return dividerInfo;
    }

    protected IDragManager createDragManagerTool() {
        DragManager dragManager = new DragManager(this.getTransform().getGraphWindow());
        if (dragManager != null) {
            this.getTransform().getGraphWindow().switchTool((TSEWindowTool)dragManager);
        }
        return dragManager;
    }

    public ETList<DividerInfo> getDividers() {
        return this.m_dividers;
    }

    protected class DividerInfo {
        public ETRect m_rcDivider;
        public boolean m_bResizeable;
        public boolean m_bCollapsible;
        public ICompartment m_prevCompartment;
        public ICompartment m_nextCompartment;

        public DividerInfo() {
            this.m_rcDivider = new ETRect(0, 0, 0, 0);
            this.m_bResizeable = false;
            this.m_bCollapsible = false;
            this.m_prevCompartment = null;
            this.m_nextCompartment = null;
        }

        public DividerInfo(ETRect eTRect, boolean bl, boolean bl2, ICompartment iCompartment, ICompartment iCompartment2) {
            this.m_rcDivider = eTRect;
            this.m_bResizeable = bl;
            this.m_bCollapsible = bl2;
            this.m_prevCompartment = iCompartment;
            this.m_nextCompartment = iCompartment2;
        }
    }
}

