/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.common.generics.IteratorT;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ITaggedValue;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.application.IMenuManager;
import org.netbeans.modules.uml.ui.products.ad.application.action.ContextMenuActionClass;
import org.netbeans.modules.uml.ui.products.ad.compartments.INameListCompartment;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.INodeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.Padlock;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETEdge;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETNode;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.ETGenericNodeUI;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.IETGraphObjectUI;
import org.netbeans.modules.uml.ui.support.PresentationReferenceHelper;
import org.netbeans.modules.uml.ui.support.accessibility.UMLAccessibleRole;
import org.netbeans.modules.uml.ui.support.applicationmanager.ILabelPresentation;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductGraphPresentation;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchive;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveAttribute;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETEdge;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNode;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNodeUI;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ILabelManager;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IListCompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.INotificationTargets;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ISimpleListCompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IStretchContext;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ITSGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ETNodeDrawEngine
extends ETDrawEngine
implements INodeDrawEngine {
    private Properties m_properties = new Properties();
    private int m_lastDrawPointY;
    private double m_lastDrawPointWorldY;
    private ETHiddenNodeList m_HiddenQualifiers = null;
    int m_nBorderThickness = 2;
    public static final String PARENT_WIDTH = "PARENT_WIDTH";
    public static final String PARENT_HEIGHT = "PARENT_HEIGHT";
    public static final String FILL_COLOR = "FILL_COLOR";
    public static final String FONT = "FONT";
    public static final String PSK_SHOWSTEREOTYPEICONS = "PSK_SHOWSTEREOTYPEICONS";
    public static final String PSK_SHOWEMPTYLISTS = "PSK_SHOWEMPTYLISTS";
    public static final String PSK_DISPLAYCOMPARTMENTTITLE = "PSK_DISPLAYCOMPARTMENTTITLE";
    public static final String PSK_AUTORESIZE = "PSK_AUTORESIZE";
    public static final String PSK_SHOWEDITTOOLTIP = "PSK_SHOWEDITTOOLTIP";
    public static final String PSK_RESIZE_ASNEEDED = "PSK_RESIZE_ASNEEDED";
    public static final String PSK_RESIZE_EXPANDONLY = "PSK_RESIZE_EXPANDONLY";
    public static final String PSK_RESIZE_UNLESSMANUAL = "PSK_RESIZE_UNLESSMANUAL";
    public static final String PSK_RESIZE_NEVER = "PSK_RESIZE_NEVER";
    public static final String PSK_ASK = "PSK_RESIZE_NEVER";
    public static final String PSK_ALWAYS = "PSK_ALWAYS";
    public static final String PSK_NEVER = "PSK_NEVER";
    public static final String PSK_SELECTED = "PSK_SELECTED";
    public static final String PSK_YES = "PSK_YES";
    public static final String PSK_NO = "PSK_NO";
    public static final int MIN_NODE_WIDTH = 40;
    public static final int MIN_NODE_HEIGHT = 40;
    protected int m_borderThickness;
    protected boolean m_lockEditing = false;
    private int m_nFillStringID = -1;
    private int m_nLightFillStringID = -1;
    private int m_nBorderStringID = -1;
    AccessibleContext accessibleContext;

    @Override
    public TSGraphObject getOwnerGraphObject() {
        ITSGraphObject iTSGraphObject = this.getParentETElement();
        return iTSGraphObject instanceof TSGraphObject ? (TSGraphObject)iTSGraphObject : null;
    }

    private void getPreferences() {
        Preferences preferences = NbPreferences.forModule(ETNodeDrawEngine.class);
        Properties properties = this.getProperties();
        if (preferences.getBoolean("UML_Show_Stereotype_Icons", true)) {
            properties.setProperty(PSK_SHOWSTEREOTYPEICONS, PSK_YES);
        } else {
            properties.setProperty(PSK_SHOWSTEREOTYPEICONS, PSK_NO);
        }
        if (preferences.getBoolean("UML_Display_Empty_Lists", true)) {
            properties.setProperty(PSK_SHOWEMPTYLISTS, PSK_YES);
        } else {
            properties.setProperty(PSK_SHOWEMPTYLISTS, PSK_NO);
        }
        properties.setProperty(PSK_DISPLAYCOMPARTMENTTITLE, preferences.get("UML_Display_Compartment_Titles", PSK_ALWAYS));
        properties.setProperty(PSK_AUTORESIZE, preferences.get("UML_Automatically_Size_Elements", PSK_RESIZE_ASNEEDED));
        properties.setProperty(PSK_SHOWEDITTOOLTIP, PSK_YES);
    }

    @Override
    public void resizeToFitCompartment(ICompartment iCompartment, boolean bl, boolean bl2) {
        if (this.getOwnerNode() != null) {
            String string;
            String string2 = string = bl2 ? PSK_RESIZE_ASNEEDED : this.getResizeBehavior();
            if (string != null && !string.equals("PSK_RESIZE_NEVER")) {
                IETSize iETSize = this.calculateOptimumSize(null, false);
                IETRect iETRect = this.getDeviceBoundingRect();
                ETSize eTSize = new ETSize(iETRect.getIntWidth(), iETRect.getIntHeight());
                if (string.equals(PSK_RESIZE_EXPANDONLY)) {
                    iETSize.setWidth(Math.max(iETSize.getWidth(), eTSize.getWidth()));
                    iETSize.setHeight(Math.max(iETSize.getHeight(), eTSize.getHeight()));
                } else {
                    iETSize.setWidth(iETSize.getWidth() + 2 * this.m_nBorderThickness);
                    iETSize.setHeight(iETSize.getHeight() + 2 * this.m_nBorderThickness);
                }
                if (iETSize.getWidth() != eTSize.getWidth() || iETSize.getHeight() != eTSize.getHeight()) {
                    INodePresentation iNodePresentation;
                    INodePresentation iNodePresentation2 = TypeConversions.getGraphicalContainer(this);
                    this.resize(iETSize.getWidth(), iETSize.getHeight(), bl);
                    if (iNodePresentation2 != null && (iNodePresentation = TypeConversions.getNodePresentation(this)) != null) {
                        iNodePresentation2.resizeToContain(iNodePresentation);
                    }
                    this.relocateQualifiers(false);
                }
            }
        }
    }

    private String getResizeBehavior() {
        String string = NbPreferences.forModule(ETNodeDrawEngine.class).get("UML_Automatically_Size_Elements", PSK_RESIZE_ASNEEDED);
        if (string != null && string.equals(PSK_RESIZE_UNLESSMANUAL)) {
            string = this.m_LastResizeOriginator == TSE_NODE_RESIZE_ORIG_INTERACTIVE ? "PSK_RESIZE_NEVER" : PSK_RESIZE_ASNEEDED;
        }
        return string;
    }

    @Override
    public int getLastDrawPointY() {
        return this.m_lastDrawPointY;
    }

    @Override
    public void setLastDrawPointY(int n) {
        this.m_lastDrawPointY = n;
    }

    @Override
    public void updateLastDrawPointY(double d) {
        this.m_lastDrawPointY = (int)((double)this.m_lastDrawPointY + d);
    }

    @Override
    public double getLastDrawPointWorldY() {
        return this.m_lastDrawPointWorldY;
    }

    @Override
    public void setLastDrawPointWorldY(double d) {
        this.m_lastDrawPointWorldY = d;
    }

    @Override
    public void updateLastDrawPointWorldY(double d) {
        this.m_lastDrawPointWorldY -= d;
    }

    public String getProperty(String string) {
        return this.m_properties.getProperty(string);
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public void setProperties(Properties properties) {
        this.m_properties = properties;
    }

    @Override
    public boolean handleLeftMouseButton(MouseEvent mouseEvent) {
        boolean bl = false;
        Iterator iterator = this.getCompartments().iterator();
        while (iterator.hasNext() && !bl) {
            bl = ((ICompartment)iterator.next()).handleLeftMouseButton(mouseEvent);
        }
        if (!bl && this.hasSelectedCompartments()) {
            this.selectAllCompartments(false);
        }
        return bl;
    }

    @Override
    public boolean handleLeftMouseBeginDrag(IETPoint iETPoint, IETPoint iETPoint2) {
        boolean bl = false;
        Iterator iterator = this.getCompartments().iterator();
        while (iterator.hasNext() && !bl) {
            ICompartment iCompartment = (ICompartment)iterator.next();
            if (!(iCompartment instanceof ISimpleListCompartment)) continue;
            ISimpleListCompartment iSimpleListCompartment = (ISimpleListCompartment)iCompartment;
            bl = iSimpleListCompartment.handleLeftMouseBeginDrag(iETPoint, iETPoint2, false);
        }
        return bl;
    }

    @Override
    public boolean handleLeftMouseButtonDoubleClick(MouseEvent mouseEvent) {
        boolean bl = false;
        if (!this.m_lockEditing) {
            Iterator iterator = this.getCompartments().iterator();
            while (iterator.hasNext() && !bl) {
                bl = ((ICompartment)iterator.next()).handleLeftMouseButtonDoubleClick(mouseEvent);
            }
        }
        if (!bl) {
            this.displayNavigationDialog();
        }
        return bl;
    }

    @Override
    public boolean handleLeftMouseDrag(IETPoint iETPoint, IETPoint iETPoint2) {
        boolean bl = false;
        Iterator iterator = this.getCompartments().iterator();
        while (iterator.hasNext() && !bl) {
            ICompartment iCompartment = (ICompartment)iterator.next();
            bl = iCompartment.handleLeftMouseDrag(iETPoint, iETPoint2);
        }
        return bl;
    }

    @Override
    public boolean handleLeftMouseDrop(IETPoint iETPoint, List list, boolean bl) {
        boolean bl2 = false;
        ETArrayList eTArrayList = new ETArrayList();
        eTArrayList.addAll(this.getCompartments());
        for (ICompartment iCompartment : eTArrayList) {
            if (!(iCompartment instanceof IListCompartment)) continue;
            IListCompartment iListCompartment = (IListCompartment)iCompartment;
            bl2 = iListCompartment.handleLeftMouseDrop(iETPoint, list, bl);
        }
        return bl2;
    }

    @Override
    public boolean handleRightMouseButton(MouseEvent mouseEvent) {
        boolean bl = this.handleLeftMouseButton(mouseEvent);
        boolean bl2 = false;
        Iterator iterator = this.getCompartments().iterator();
        while (iterator.hasNext() && !bl2) {
            bl2 = ((ICompartment)iterator.next()).handleRightMouseButton(mouseEvent);
        }
        return bl || bl2;
    }

    @Override
    public boolean handleLeftMouseButtonPressed(MouseEvent mouseEvent) {
        boolean bl = false;
        Iterator iterator = this.getCompartments().iterator();
        while (iterator.hasNext() && !bl) {
            bl = ((ICompartment)iterator.next()).handleLeftMouseButtonPressed(mouseEvent);
        }
        return bl;
    }

    @Override
    public TSEConnector addConnector() {
        TSEConnector tSEConnector = null;
        TSENode tSENode = this.getOwnerNode();
        if (tSENode != null && (tSEConnector = (TSEConnector)tSENode.addConnector()) != null) {
            tSEConnector.setVisible(false);
        }
        return tSEConnector;
    }

    @Override
    public void addDecoration(String string, IETPoint iETPoint) {
    }

    @Override
    public ETList<IPresentationElement> getAttachedQualifiers() {
        ETArrayList eTArrayList = null;
        try {
            IPresentationElement iPresentationElement = this.getPresentationElement();
            if (iPresentationElement != null) {
                ETList<IPresentationElement> eTList = PresentationReferenceHelper.getAllReferredElements(iPresentationElement);
                long l = eTList != null ? (long)eTList.getCount() : 0L;
                eTArrayList = new ETArrayList();
                int n = 0;
                while ((long)n < l) {
                    String string;
                    IPresentationElement iPresentationElement2 = (IPresentationElement)eTList.get(n);
                    IDrawEngine iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement2);
                    if (iDrawEngine != null && (string = iDrawEngine.getDrawEngineID()) != null && string.equals("QualifierDrawEngine")) {
                        eTArrayList.add(iPresentationElement2);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return eTArrayList;
    }

    @Override
    public boolean getLockEdit() {
        return this.m_lockEditing;
    }

    @Override
    public TSENode getNode() {
        TSEObject tSEObject = null;
        IETGraphObjectUI iETGraphObjectUI = this.getParent();
        if (iETGraphObjectUI != null) {
            tSEObject = iETGraphObjectUI.getOwner();
        }
        return tSEObject instanceof TSENode ? (TSENode)tSEObject : null;
    }

    @Override
    public IClassifier getParentClassifier() {
        IETGraphObjectUI iETGraphObjectUI = this.getParent();
        IElement iElement = iETGraphObjectUI != null ? iETGraphObjectUI.getModelElement() : null;
        return iElement instanceof IClassifier ? (IClassifier)iElement : null;
    }

    @Override
    public int getReconnectConnector(IPresentationElement iPresentationElement) {
        return 0;
    }

    @Override
    public void hideAllAttachedQualifiers(boolean bl) {
        if (bl) {
            ETList<IPresentationElement> eTList = this.getAttachedQualifiers();
            if (eTList != null) {
                this.m_HiddenQualifiers = new ETQualifierHiddenNodeList(eTList);
                this.m_HiddenQualifiers.hide();
            }
        } else if (this.m_HiddenQualifiers != null) {
            this.m_HiddenQualifiers.unHide();
            this.m_HiddenQualifiers = null;
            this.relocateQualifiers(false);
        }
    }

    public void relocateQualifiers() {
        this.relocateQualifiers(true);
    }

    @Override
    public void relocateQualifiers(boolean bl) {
        try {
            ETList<IPresentationElement> eTList = this.getAttachedQualifiers();
            long l = eTList != null ? (long)eTList.getCount() : 0L;
            TSENode tSENode = this.getOwnerNode();
            if (l > 0L && tSENode != null) {
                TSRect tSRect = new TSRect(tSENode.getBounds());
                int n = 0;
                while ((long)n < l) {
                    IPresentationElement iPresentationElement = eTList.item(n);
                    ETNode eTNode = (ETNode)TypeConversions.getOwnerNode(iPresentationElement);
                    if (eTNode != null) {
                        TSConstRect tSConstRect = eTNode.getBounds();
                        TSRect tSRect2 = new TSRect(tSConstRect);
                        tSRect2.merge(tSConstRect.getLeft() + 2.5, tSConstRect.getTop() + 2.5, tSConstRect.getRight() + 2.5, tSConstRect.getBottom() + 2.5);
                        TSConstRect tSConstRect2 = tSRect2.intersection((TSConstRect)tSRect);
                        if (tSConstRect2 == null) {
                            IProductGraphPresentation iProductGraphPresentation;
                            IProductGraphPresentation iProductGraphPresentation2 = iProductGraphPresentation = iPresentationElement instanceof IProductGraphPresentation ? (IProductGraphPresentation)iPresentationElement : null;
                            if (iProductGraphPresentation != null) {
                                iProductGraphPresentation.invalidate();
                                this.invalidate();
                            }
                            TSConstPoint tSConstPoint = null;
                            int n2 = tSRect.outcode(tSConstRect.getCenterX(), tSConstRect.getCenterY());
                            tSConstPoint = n2 == 4 || n2 == 12 || n2 == 5 ? new TSConstPoint(tSRect.getCenterX(), tSRect.getTop() + tSConstRect.getHeight() / 2.0) : (n2 == 2 || n2 == 3 || n2 == 10 ? new TSConstPoint(tSRect.getCenterX(), tSRect.getBottom() - tSConstRect.getHeight() / 2.0) : (n2 == 8 ? new TSConstPoint(tSRect.getLeft() - tSConstRect.getWidth() / 2.0, tSRect.getCenterY()) : (n2 == 1 ? new TSConstPoint(tSRect.getRight() + tSConstRect.getWidth() / 2.0, tSRect.getCenterY()) : new TSConstPoint(tSRect.getCenter()))));
                            eTNode.moveTo(tSConstPoint);
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public long readFromArchive(IProductArchive iProductArchive, IProductArchiveElement iProductArchiveElement) {
        super.readFromArchive(iProductArchive, iProductArchiveElement);
        IProductArchiveElement iProductArchiveElement2 = iProductArchiveElement.getElement("engine");
        if (iProductArchiveElement2 != null) {
            boolean bl = iProductArchiveElement2.getAttributeBool("editLocked");
            IProductArchiveAttribute iProductArchiveAttribute = iProductArchiveElement2.getAttribute("editLocked");
            if (iProductArchiveAttribute != null) {
                this.m_lockEditing = bl;
            }
        }
        return 0L;
    }

    @Override
    public void resize(int n, int n2, boolean bl) {
        INodePresentation iNodePresentation = this.getNodePresentation();
        if (iNodePresentation != null) {
            this.invalidate();
            TSTransform tSTransform = this.getTransform();
            if (tSTransform == null) {
                IDrawInfo iDrawInfo;
                IDrawInfo iDrawInfo2 = iDrawInfo = this.getParent() != null ? this.getParent().getDrawInfo() : null;
                if (iDrawInfo == null && this.getDrawingArea() != null && this.getDrawingArea().getGraphWindow() != null) {
                    tSTransform = this.getDrawingArea().getGraphWindow().getTransform();
                } else if (iDrawInfo != null) {
                    tSTransform = iDrawInfo.getTSTransform();
                }
                if (tSTransform == null) {
                    return;
                }
            }
            iNodePresentation.resize(tSTransform.widthToWorld(n), tSTransform.heightToWorld(n2), bl);
            this.invalidate();
        }
    }

    @Override
    public void resize(IETSize iETSize, boolean bl) {
        if (iETSize != null) {
            this.resize(iETSize.getWidth(), iETSize.getHeight(), bl);
        }
    }

    @Override
    public void resizeTo(IETSize iETSize) {
        this.resize(iETSize, true);
    }

    @Override
    public void selectAllAttachedQualifiers(boolean bl) {
        try {
            ETList<IPresentationElement> eTList = this.getAttachedQualifiers();
            if (eTList == null) {
                return;
            }
            Iterator iterator = eTList.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                IPresentationElement iPresentationElement = (IPresentationElement)iterator.next();
                IETNode iETNode = TypeConversions.getETNode(iPresentationElement);
                if (iETNode == null || iETNode.isSelected() == bl) continue;
                iETNode.getEngine().invalidate();
                iETNode.setSelected(bl);
                bl2 = true;
            }
            if (bl2 && this.getDrawingArea() != null) {
                this.getDrawingArea().refresh(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setLockEdit(boolean bl) {
        this.m_lockEditing = bl;
        this.invalidate();
    }

    @Override
    public void setNodeShape(IDrawInfo iDrawInfo) {
    }

    @Override
    public void stretch(IStretchContext iStretchContext) {
        if (null == iStretchContext) {
            throw new IllegalArgumentException();
        }
        ICompartment iCompartment = iStretchContext.getCompartment();
        if (iCompartment != null) {
            iCompartment.stretch(iStretchContext);
        } else {
            ETList<ICompartment> eTList = this.getCompartments();
            for (ICompartment iCompartment2 : eTList) {
                iCompartment2.stretch(iStretchContext);
            }
        }
    }

    @Override
    public void doDraw(IDrawInfo iDrawInfo) {
        IETGraphObjectUI iETGraphObjectUI = this.getParent();
        this.getPreferences();
        if (!iDrawInfo.isTransparent()) {
            this.drawBackground(iDrawInfo);
        }
        if (iDrawInfo.isBorderDrawn()) {
            this.drawBorder(iDrawInfo);
        }
        this.drawContents(iDrawInfo);
        if (this.isPadlockAllawed() && this.getLockEdit()) {
            this.drawPadlock(iDrawInfo);
        }
    }

    protected void drawContents(IDrawInfo iDrawInfo) {
    }

    protected void drawBorder(IDrawInfo iDrawInfo) {
    }

    protected void drawBackground(IDrawInfo iDrawInfo) {
    }

    @Override
    public void sizeToContents() {
        if (this.getOwnerNode() != null) {
            IDrawInfo iDrawInfo = this.getParent().getDrawInfo();
            ETList<ICompartment> eTList = this.getCompartments();
            for (ICompartment iCompartment : eTList) {
                iCompartment.clearStretch(iDrawInfo);
            }
            if (iDrawInfo != null && iDrawInfo.getTSEGraphics() != null) {
                ICompartment iCompartment;
                IETSize iETSize = this.calculateOptimumSize(iDrawInfo, true);
                iCompartment = iDrawInfo.getTSTransform();
                IETSize iETSize2 = this.scaleSize(iETSize, (TSTransform)iCompartment);
                this.resize(iETSize2, true);
            }
        }
    }

    @Override
    public String getPresentationType() {
        return "NodePresentation";
    }

    public INodePresentation getNodePresentation() {
        return this.getPresentation() instanceof INodePresentation ? (INodePresentation)this.getPresentation() : null;
    }

    @Override
    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        IETSize iETSize = super.calculateOptimumSize(iDrawInfo, bl);
        iETSize.setWidth(iETSize.getWidth() + 2 * this.m_nBorderThickness);
        iETSize.setHeight(iETSize.getHeight() + 2 * this.m_nBorderThickness);
        return iETSize;
    }

    protected TSENode getOwnerNode() {
        IETGraphObjectUI iETGraphObjectUI = this.getParent();
        return iETGraphObjectUI != null ? (TSENode)iETGraphObjectUI.getOwner() : null;
    }

    @Override
    public void onContextMenu(IMenuManager iMenuManager) {
        int n = this.getNumCompartments();
        for (int i = 0; i < n; ++i) {
            ICompartment iCompartment = this.getCompartment(i);
            if (iCompartment == null) continue;
            iCompartment.onContextMenu(iMenuManager);
        }
    }

    protected boolean handleStandardLabelSensitivityAndCheck(String string, ContextMenuActionClass contextMenuActionClass) {
        boolean bl = false;
        ILabelManager iLabelManager = this.getLabelManager();
        boolean bl2 = this.isParentDiagramReadOnly();
        if (string.equals("MBK_SHOW_STEREOTYPE")) {
            boolean bl3 = iLabelManager.isDisplayed(6);
            contextMenuActionClass.setChecked(bl3);
            bl = !bl2;
        } else if (string.equals("MBK_SHOW_NAME_LABEL")) {
            boolean bl4 = iLabelManager.isDisplayed(12);
            contextMenuActionClass.setChecked(bl4);
            bl = !bl2;
        }
        return bl;
    }

    public void addStandardLabelsToPullright(int n, IMenuManager iMenuManager) {
        IElement iElement;
        if (n == 1 || n == 2) {
            this.addStereotypeLabelPullright(this, iMenuManager);
        }
        if ((n == 0 || n == 2) && (iElement = this.getFirstModelElement()) != null && iElement instanceof INamedElement) {
            this.addNameLabelPullright(this, iMenuManager);
        }
    }

    protected boolean handleStandardLabelSelection(ActionEvent actionEvent, String string) {
        boolean bl = false;
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        ILabelManager iLabelManager = this.getLabelManager();
        if (iDrawingAreaControl != null) {
            if (string.equals("MBK_SHOW_STEREOTYPE")) {
                if (iLabelManager != null) {
                    boolean bl2 = iLabelManager.isDisplayed(6);
                    iLabelManager.showLabel(6, !bl2);
                }
                iDrawingAreaControl.refresh(false);
                bl = true;
            } else if (string.equals("MBK_SHOW_NAME_LABEL")) {
                if (iLabelManager != null) {
                    IPresentationElement iPresentationElement;
                    boolean bl3 = iLabelManager.isDisplayed(12);
                    iLabelManager.showLabel(12, !bl3);
                    if (!bl3 && (iPresentationElement = iLabelManager.getLabel(12)) != null && iPresentationElement instanceof ILabelPresentation) {
                        iDrawingAreaControl.postEditLabel((ILabelPresentation)iPresentationElement);
                    }
                }
                iDrawingAreaControl.refresh(false);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public long writeToArchive(IProductArchive iProductArchive, IProductArchiveElement iProductArchiveElement) {
        super.writeToArchive(iProductArchive, iProductArchiveElement);
        IProductArchiveElement iProductArchiveElement2 = iProductArchiveElement.getElement("engine");
        if (iProductArchiveElement2 != null) {
            iProductArchiveElement2.addAttributeBool("editLocked", this.m_lockEditing);
        }
        return 0L;
    }

    @Override
    public String getDrawEngineID() {
        return "NodeDrawEngine";
    }

    @Override
    public void onGraphEvent(int n) {
        super.onGraphEvent(n);
        switch (n) {
            case 17: {
                this.handlePostSelect();
                break;
            }
            case 3: {
                this.selectAllAttachedQualifiers(false);
                break;
            }
            case 2: {
                this.selectAllAttachedQualifiers(true);
                break;
            }
            case 4: {
                this.selectAllAttachedQualifiers(false);
                this.relocateQualifiers();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.relocateQualifiers();
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.relocateQualifiers(true);
                break;
            }
            case 9: {
                this.selectAllAttachedQualifiers(true);
            }
        }
    }

    private void handlePostSelect() {
        if (this.getOwnerNode() != null && !this.getOwnerNode().isSelected() && this.hasSelectedCompartments()) {
            this.selectAllCompartments(false);
        }
    }

    @Override
    public Color getFillColor() {
        return new Color(this.m_ResourceUser.getCOLORREFForStringID(this.m_nFillStringID));
    }

    public Color getLightGradientFillColor() {
        if (!NbPreferences.forModule(ETNodeDrawEngine.class).getBoolean("UML_Gradient_Background", true)) {
            return this.getFillColor();
        }
        return new Color(this.m_ResourceUser.getCOLORREFForStringID(this.m_nLightFillStringID));
    }

    public Color getBkColor() {
        return this.getFillColor();
    }

    @Override
    public Color getBorderColor() {
        return new Color(this.m_ResourceUser.getCOLORREFForStringID(this.m_nBorderStringID));
    }

    public Color getBorderBoundsColor() {
        return this.getBorderColor();
    }

    public TSEColor getTextColor() {
        ETGenericNodeUI eTGenericNodeUI = (ETGenericNodeUI)this.getParent();
        return eTGenericNodeUI != null ? eTGenericNodeUI.getTextColor() : null;
    }

    public int getBorderThickness() {
        return this.m_nBorderThickness;
    }

    public void setBorderThickness(int n) {
        this.m_nBorderThickness = n;
    }

    @Override
    public long handleNameListModelElementHasChanged(INotificationTargets iNotificationTargets) {
        try {
            if (iNotificationTargets != null) {
                INameListCompartment iNameListCompartment;
                ITaggedValue iTaggedValue;
                IElement iElement = iNotificationTargets.getChangedModelElement();
                int n = iNotificationTargets.getKind();
                ITaggedValue iTaggedValue2 = iTaggedValue = iElement instanceof ITaggedValue ? (ITaggedValue)iElement : null;
                if (n == 21 || n == 20 || n == 22 || iTaggedValue != null) {
                    boolean bl;
                    INameListCompartment iNameListCompartment2 = (INameListCompartment)this.getCompartmentByKind(INameListCompartment.class);
                    if (iNameListCompartment2 != null && (bl = iNameListCompartment2.updateAllOptionalCompartments(null))) {
                        this.setIsDirty();
                    }
                } else if (n == 0 && (iNameListCompartment = (INameListCompartment)this.getCompartmentByKind(INameListCompartment.class)) != null) {
                    iNameListCompartment.modelElementHasChanged(iNotificationTargets);
                }
                this.postInvalidate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0L;
    }

    protected IteratorT<ICompartment> getCompartmentIterator() {
        try {
            return new IteratorT<ICompartment>(this.getCompartments());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected long handleNameListModelElementDeleted(INotificationTargets iNotificationTargets) {
        try {
            IClassifier iClassifier;
            IElement iElement = iNotificationTargets.getChangedModelElement();
            IClassifier iClassifier2 = iClassifier = iElement instanceof IClassifier ? (IClassifier)iElement : null;
            if (iClassifier != null) {
                IteratorT<ICompartment> iteratorT = this.getCompartmentIterator();
                while (iteratorT.hasNext()) {
                    ICompartment iCompartment = iteratorT.next();
                    iCompartment.modelElementDeleted(iNotificationTargets);
                    IListCompartment iListCompartment = iCompartment instanceof IListCompartment ? (IListCompartment)iCompartment : null;
                    if (iListCompartment == null || iListCompartment.getNumCompartments() != 0 || !iListCompartment.getDeleteIfEmpty()) continue;
                    this.removeCompartment(iCompartment);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0L;
    }

    protected boolean drawInvalidRectangle(IDrawInfo iDrawInfo) {
        boolean bl = false;
        try {
            if (this.m_checkSyncStateDuringDraw && iDrawInfo != null) {
                int n;
                IElement iElement = TypeConversions.getElement(this);
                IProductGraphPresentation iProductGraphPresentation = this.getPresentationElement() instanceof IProductGraphPresentation ? (IProductGraphPresentation)this.getPresentationElement() : null;
                int n2 = n = iProductGraphPresentation != null ? iProductGraphPresentation.getSynchState() : 2;
                if (iElement == null || n == 2) {
                    IETRect iETRect = iDrawInfo.getDeviceBounds();
                    GDISupport.drawHatchedRectangle(iDrawInfo.getTSEGraphics().getGraphics(), iETRect.getRectangle(), Color.RED, Color.WHITE);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    @Override
    public IETNodeUI getNodeUI() {
        return this.getParent() instanceof IETNodeUI ? (IETNodeUI)this.getParent() : null;
    }

    public void sizeToContentsWithMin(long l, long l2) {
        this.sizeToContentsWithMin(l, l2, false, false);
    }

    public void sizeToContentsWithMin(long l, long l2, boolean bl, boolean bl2) {
        try {
            if (this.getOwnerNode() != null && this.getNodeUI() != null) {
                Object object;
                IETSize iETSize = this.calculateOptimumSize(this.getNodeUI().getDrawInfo(), false);
                if (iETSize == null) {
                    return;
                }
                TSTransform tSTransform = this.getTransform();
                ETSize eTSize = new ETSize(Math.max(iETSize.getWidth(), tSTransform.widthToDevice((double)l)), Math.max(iETSize.getHeight(), tSTransform.heightToDevice((double)l2)));
                if (bl2) {
                    object = this.getDeviceBoundingRect();
                    eTSize.setSize((int)Math.max((double)eTSize.getWidth(), object.getWidth()), (int)Math.max((double)eTSize.getHeight(), object.getHeight()));
                }
                this.resize(eTSize.getWidth(), eTSize.getHeight(), bl);
                object = this.getDiagram();
                if (object != null) {
                    object.refresh(true);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public long modelElementDeleted(INotificationTargets iNotificationTargets) {
        this.dispatchModelElementDeletedToCompartments(iNotificationTargets);
        return 0L;
    }

    @Override
    public long modelElementHasChanged(INotificationTargets iNotificationTargets) {
        INameListCompartment iNameListCompartment = (INameListCompartment)this.getCompartmentByKind(INameListCompartment.class);
        if (iNameListCompartment != null) {
            this.handleNameListModelElementHasChanged(iNotificationTargets);
        }
        return super.modelElementHasChanged(iNotificationTargets);
    }

    private void dispatchModelElementDeletedToCompartments(INotificationTargets iNotificationTargets) {
        IElement iElement = iNotificationTargets.getChangedModelElement();
        if (iElement != null) {
            int n = this.getNumCompartments();
            for (int i = 0; i < n; ++i) {
                int n2;
                ICompartment iCompartment = this.getCompartment(i);
                if (iCompartment == null) continue;
                iCompartment.modelElementDeleted(iNotificationTargets);
                IListCompartment iListCompartment = null;
                if (iCompartment instanceof IListCompartment) {
                    iListCompartment = (IListCompartment)iCompartment;
                }
                if (iListCompartment == null || (n2 = iListCompartment.getNumCompartments()) != 0) continue;
                boolean bl = false;
                bl = iListCompartment.getDeleteIfEmpty();
                if (!bl) continue;
                this.removeCompartment(iCompartment);
            }
        }
    }

    public int setFillColor(String string, int n, int n2, int n3) {
        return this.setFillColor(string, new Color(n, n2, n3));
    }

    public int setLightGradientFillColor(String string, int n, int n2, int n3) {
        return this.setLightGradientFillColor(string, new Color(n, n2, n3));
    }

    public int setFillColor(String string, Color color) {
        if (color != null) {
            this.m_nFillStringID = this.m_ResourceUser.setResourceStringID(this.m_nFillStringID, string, color.getRGB());
        }
        return this.m_nFillStringID;
    }

    public int setLightGradientFillColor(String string, Color color) {
        if (color != null) {
            this.m_nLightFillStringID = this.m_ResourceUser.setResourceStringID(this.m_nLightFillStringID, string, color.getRGB());
        }
        return this.m_nLightFillStringID;
    }

    public int setBorderColor(String string, int n, int n2, int n3) {
        return this.setBorderColor(string, new Color(n, n2, n3));
    }

    public int setBorderColor(String string, Color color) {
        this.m_nBorderStringID = this.m_ResourceUser.setResourceStringID(this.m_nBorderStringID, string, color != null ? color.getRGB() : Color.BLACK.getRGB());
        return this.m_nBorderStringID;
    }

    public Color getColor(int n) {
        return new Color(this.m_ResourceUser.getCOLORREFForStringID(n));
    }

    @Override
    public boolean validateNode() {
        boolean bl = false;
        IPresentationElement iPresentationElement = this.getPresentationElement();
        if (iPresentationElement != null) {
            IClassifier iClassifier;
            bl = true;
            IElement iElement = iPresentationElement.getFirstSubject();
            IClassifier iClassifier2 = iClassifier = iElement instanceof IClassifier ? (IClassifier)iElement : null;
            if (iClassifier != null) {
                int n = this.getNumCompartments();
                for (int i = 0; i < n && bl; ++i) {
                    ICompartment iCompartment = this.getCompartment(i);
                    if (iCompartment == null) continue;
                    bl &= iCompartment.validate(iElement);
                }
            }
        }
        return bl;
    }

    protected ETHiddenNodeList createHiddenList(ETList<IPresentationElement> eTList) {
        return new ETHiddenNodeList(eTList);
    }

    public boolean isSelected() {
        IETGraphObject iETGraphObject = this.getObject();
        return iETGraphObject != null && iETGraphObject.isSelected();
    }

    public IETRect getLogicalGrappleBounds() {
        IETRect iETRect = this.getLogicalBoundingRect(true);
        if (iETRect != null) {
            int n = 0;
            IETNodeUI iETNodeUI = this.getNodeUI();
            if (iETNodeUI != null) {
                n = iETNodeUI.getGrappleSize();
            }
            iETRect.inflate(n + 10);
        }
        return iETRect;
    }

    @Override
    public long invalidate() {
        if (!this.isSelected()) {
            return super.invalidate();
        }
        IETRect iETRect = this.getLogicalGrappleBounds();
        if (iETRect == null) {
            return super.invalidate();
        }
        this.invalidateRect(iETRect);
        return 0L;
    }

    @Override
    public long postLoad() {
        super.postLoad();
        return 0L;
    }

    @Override
    public long invalidateRect(IETRect iETRect) {
        IETNode iETNode;
        long l = super.invalidateRect(iETRect);
        IETNode iETNode2 = iETNode = (IETNode)this.getNode() instanceof IETNode ? (IETNode)this.getNode() : null;
        if (iETNode != null) {
            iETNode.invalidateEdges();
        }
        return l;
    }

    @Override
    public boolean collapseCompartment(ICompartment iCompartment, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = iCompartment.getCollapsed();
        if (bl3 != bl) {
            IETSize iETSize;
            iCompartment.setCollapsed(bl);
            String string = this.getResizeBehavior();
            if (string.equals(PSK_RESIZE_ASNEEDED) && (iETSize = this.calculateOptimumSize(null, true)) != null) {
                this.resize(iETSize, true);
            }
            bl2 = true;
        }
        return bl2;
    }

    protected boolean isOwnerOnDrawingArea() {
        if (this.getDrawingArea() instanceof ADDrawingAreaControl) {
            ADDrawingAreaControl aDDrawingAreaControl = (ADDrawingAreaControl)this.getDrawingArea();
            return aDDrawingAreaControl.getIsOnDiagram(this.getParentETElement());
        }
        return false;
    }

    protected boolean isPadlockAllawed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPadlock(IDrawInfo iDrawInfo) {
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        TSTransform tSTransform = iDrawInfo.getTSTransform();
        Padlock padlock = new Padlock();
        this.setPadlockLocation(iDrawInfo, padlock);
        AffineTransform affineTransform = tSEGraphics.getTransform();
        AffineTransform affineTransform2 = ETNodeDrawEngine.convertTransform(tSTransform);
        try {
            tSEGraphics.transform(affineTransform2);
            padlock.paint((Graphics2D)tSEGraphics);
        }
        finally {
            tSEGraphics.setTransform(affineTransform);
        }
    }

    protected void setPadlockLocation(IDrawInfo iDrawInfo, Padlock padlock) {
        TSTransform tSTransform = iDrawInfo.getTSTransform();
        IETRect iETRect = iDrawInfo.getDeviceBounds();
        TSConstRect tSConstRect = tSTransform.boundsToWorld(iETRect.getRectangle());
        padlock.setOriginalPoint(2);
        padlock.setLocation(tSConstRect.getRight() - 2.0, tSConstRect.getTop() - 2.0);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleETNodeDrawEngine();
        }
        return this.accessibleContext;
    }

    public class AccessibleETNodeDrawEngine
    extends ETDrawEngine.AccessibleETDrawEngine {
        public Color getBackground() {
            return ETNodeDrawEngine.this.getFillColor();
        }

        public void setBackground(Color color) {
        }

        public AccessibleRole getAccessibleRole() {
            return UMLAccessibleRole.UML_NODE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ETQualifierHiddenNodeList
    extends ETHiddenNodeList {
        protected ETList<ETEdge> m_qualifierEdges;

        public ETQualifierHiddenNodeList(ETList<IPresentationElement> eTList) {
            super(eTList);
            this.m_qualifierEdges = new ETArrayList<ETEdge>();
        }

        @Override
        protected boolean hideNode(IETNode iETNode) {
            List list;
            if (this.canHideNode(iETNode) && (list = iETNode.getInEdges()) != null && list.size() == 1) {
                ETEdge eTEdge = (ETEdge)list.get(0);
                this.m_qualifierEdges.add(eTEdge);
                eTEdge.setTargetNode((TSNode)ETNodeDrawEngine.this.getOwnerNode());
            }
            return super.hideNode(iETNode);
        }

        @Override
        protected boolean unHideNode(IETNode iETNode) {
            ETEdge eTEdge;
            int n = this.m_hddenNodes.indexOf(iETNode);
            ETEdge eTEdge2 = eTEdge = n >= 0 ? (ETEdge)this.m_qualifierEdges.get(n) : null;
            if (super.unHideNode(iETNode)) {
                this.m_qualifierEdges.removeItem(eTEdge);
                if (eTEdge != null) {
                    iETNode.moveTo(eTEdge.getTargetPoint());
                    if (eTEdge != null) {
                        eTEdge.setTargetNode((TSNode)((TSENode)iETNode.getObject()));
                    }
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ETHiddenNodesAndEdges
    extends ETHiddenNodeList {
        protected ETList<IETEdge> m_hiddenEdges;
        ETList<ConnectionData> m_connectionData;
        boolean m_moveNodesOnRestore;
        TSConstPoint m_ptCenterPreLayout;

        public ETHiddenNodesAndEdges(ETList<IPresentationElement> eTList) {
            this(eTList, true);
        }

        public ETHiddenNodesAndEdges(ETList<IPresentationElement> eTList, boolean bl) {
            super(eTList);
            this.m_hiddenEdges = new ETArrayList<IETEdge>();
            this.m_connectionData = new ETArrayList<ConnectionData>();
            this.m_moveNodesOnRestore = true;
            this.m_ptCenterPreLayout = null;
            this.m_moveNodesOnRestore = bl;
        }

        @Override
        public void hide() {
            this.m_ptCenterPreLayout = ETNodeDrawEngine.this.getOwnerNode().getCenter();
            this.hideEdges();
            super.hide();
        }

        @Override
        public void unHide() {
            super.unHide();
            this.unHideEdges();
        }

        protected boolean canHideEdge(IETEdge iETEdge) {
            return iETEdge != null && !this.m_hiddenEdges.find(iETEdge);
        }

        protected boolean hideEdge(IETEdge iETEdge) {
            if (this.canHideEdge(iETEdge)) {
                iETEdge.invalidate();
                iETEdge.getGraphObject().getOwnerGraph().remove((TSEdge)((TSEEdge)iETEdge.getGraphObject()));
                this.m_hiddenEdges.add(iETEdge);
                return true;
            }
            return false;
        }

        protected void hideEdges(ConnectionData connectionData) {
            IteratorT iteratorT = new IteratorT(connectionData.getInEdges());
            while (iteratorT.hasNext()) {
                this.hideEdge((IETEdge)iteratorT.next());
            }
            iteratorT.reset(connectionData.getOutEdges());
            while (iteratorT.hasNext()) {
                this.hideEdge((IETEdge)iteratorT.next());
            }
        }

        protected void buildConnectionData() {
            Iterator iterator = this.m_pPES.iterator();
            while (iterator.hasNext()) {
                IETNode iETNode = TypeConversions.getETNode((IPresentationElement)iterator.next());
                if (iETNode == null) continue;
                this.m_connectionData.add(new ConnectionData(iETNode));
            }
        }

        protected void hideEdges() {
            this.buildConnectionData();
            Iterator iterator = this.m_connectionData.iterator();
            while (iterator.hasNext()) {
                this.hideEdges((ConnectionData)iterator.next());
            }
        }

        @Override
        protected boolean unHideNode(IETNode iETNode) {
            boolean bl = super.unHideNode(iETNode);
            return bl;
        }

        protected boolean unHideEdge(IETEdge iETEdge) {
            if (iETEdge != null) {
                this.m_hiddenEdges.removeItem(iETEdge);
                this.m_ownerGraph.insert((TSEdge)((TSEEdge)iETEdge));
                return true;
            }
            return false;
        }

        protected ETPairT<Double, Double> updateNodePosition(ConnectionData connectionData) {
            if (this.m_moveNodesOnRestore) {
                TSENode tSENode = (TSENode)connectionData.getNode();
                TSConstPoint tSConstPoint = ETNodeDrawEngine.this.getOwnerNode().getCenter();
                double d = tSConstPoint.getX() - this.m_ptCenterPreLayout.getX();
                double d2 = tSConstPoint.getY() - this.m_ptCenterPreLayout.getY();
                tSENode.moveBy(d, d2);
                return new ETPairT<Double, Double>(new Double(d), new Double(d2));
            }
            return null;
        }

        protected void restore(ConnectionData connectionData) {
            ETPairT<Double, Double> eTPairT = this.updateNodePosition(connectionData);
            if (eTPairT != null) {
                IteratorT iteratorT = new IteratorT(connectionData.getOutEdges());
                double d = eTPairT.getParamOne();
                double d2 = eTPairT.getParamTwo();
                while (iteratorT.hasNext()) {
                    IteratorT iteratorT2 = new IteratorT(((ETEdge)iteratorT.next()).pathNodes());
                    while (iteratorT2.hasNext()) {
                        ((TSPNode)iteratorT2.next()).moveBy(d, d2);
                    }
                }
            }
        }

        protected void unHideEdges() {
            Iterator iterator = this.m_connectionData.iterator();
            while (iterator.hasNext()) {
                this.restore((ConnectionData)iterator.next());
                iterator.remove();
            }
            IteratorT iteratorT = new IteratorT(this.m_hiddenEdges);
            while (iteratorT.hasNext()) {
                if (!this.unHideEdge((IETEdge)iteratorT.next())) continue;
                iteratorT.reset(this.m_hiddenEdges);
            }
        }

        protected ConnectionData getConnectionData(IETNode iETNode) {
            for (ConnectionData connectionData : this.m_connectionData) {
                if (connectionData.getNode() != iETNode) continue;
                return connectionData;
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ConnectionData {
            ETList<IETEdge> inEdges;
            ETList<IETEdge> outEdges;
            IETNode m_node;
            private TSConstPoint m_ptCenterPreLayout;

            ConnectionData(IETNode iETNode) {
                this.m_node = iETNode;
                this.inEdges = new ETArrayList<IETEdge>();
                this.outEdges = new ETArrayList<IETEdge>();
                this.appendThese(this.inEdges, iETNode.getInEdges());
                this.appendThese(this.outEdges, iETNode.getOutEdges());
                this.m_ptCenterPreLayout = iETNode.getBounds().getCenter();
            }

            protected void appendThese(ETList<IETEdge> eTList, List list) {
                IteratorT iteratorT = new IteratorT(list);
                while (iteratorT.hasNext()) {
                    eTList.add(iteratorT.next());
                }
            }

            public IETNode getNode() {
                return this.m_node;
            }

            public ETList<IETEdge> getInEdges() {
                return this.inEdges;
            }

            public ETList<IETEdge> getOutEdges() {
                return this.outEdges;
            }

            public TSConstPoint getPreviousCenter() {
                return this.m_ptCenterPreLayout;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ETHiddenNodeList {
        protected TSGraph m_ownerGraph;
        protected ETList<IPresentationElement> m_pPES;
        protected ETList<IETNode> m_hddenNodes;

        public ETHiddenNodeList(ETList<IPresentationElement> eTList) {
            this.m_ownerGraph = ETNodeDrawEngine.this.getOwnerNode().getOwnerGraph();
            this.m_hddenNodes = new ETArrayList<IETNode>();
            this.m_pPES = eTList;
        }

        public void hide() {
            if (this.m_pPES != null) {
                Iterator iterator = this.m_pPES.iterator();
                while (iterator.hasNext()) {
                    IETNode iETNode = TypeConversions.getETNode((IPresentationElement)iterator.next());
                    if (iETNode == null) continue;
                    this.hideNode(iETNode);
                }
                if (ETNodeDrawEngine.this.getDrawingArea() != null) {
                    ETNodeDrawEngine.this.getDrawingArea().refresh(true);
                }
            }
        }

        public void unHide() {
            IteratorT iteratorT = new IteratorT(this.m_hddenNodes);
            while (iteratorT.hasNext()) {
                try {
                    IETNode iETNode = (IETNode)iteratorT.next();
                    if (iETNode == null) continue;
                    this.unHideNode(iETNode);
                    iteratorT.reset(this.m_hddenNodes);
                }
                catch (Exception exception) {}
            }
            if (ETNodeDrawEngine.this.getDrawingArea() != null) {
                ETNodeDrawEngine.this.getDrawingArea().refresh(true);
            }
        }

        protected boolean hideNode(IETNode iETNode) {
            if (this.canHideNode(iETNode)) {
                try {
                    iETNode.getEngine().invalidate();
                    iETNode.invalidateEdges();
                    iETNode.getGraphObject().getOwnerGraph().remove((TSNode)((TSENode)iETNode.getGraphObject()));
                    this.m_hddenNodes.add(iETNode);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }

        protected boolean canHideNode(IETNode iETNode) {
            boolean bl;
            if (iETNode != null && !this.m_hddenNodes.find(iETNode)) {
                ETNodeDrawEngine eTNodeDrawEngine;
                ETNodeDrawEngine eTNodeDrawEngine2 = eTNodeDrawEngine = iETNode.getEngine() instanceof ETNodeDrawEngine ? (ETNodeDrawEngine)iETNode.getEngine() : null;
                bl = eTNodeDrawEngine != null ? eTNodeDrawEngine.isOwnerOnDrawingArea() : true;
            } else {
                bl = false;
            }
            return bl;
        }

        protected boolean unHideNode(IETNode iETNode) {
            if (iETNode != null) {
                this.m_hddenNodes.removeItem(iETNode);
                this.m_ownerGraph.insert((TSNode)((TSENode)iETNode));
                return true;
            }
            return false;
        }
    }
}

