/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.viewfactory;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETArrowHead;

public abstract class ETArrowHead
implements IETArrowHead {
    protected int m_width = 0;
    protected int m_height = 0;
    protected int kind;

    protected ETArrowHead(int n) {
        this.kind = n;
    }

    public boolean draw(IDrawInfo iDrawInfo, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2, TSEColor tSEColor) {
        boolean bl;
        AffineTransform affineTransform;
        Shape shape = this.getShape(iDrawInfo, tSConstPoint, tSConstPoint2);
        if (shape == null) {
            return false;
        }
        AffineTransform affineTransform2 = this.getRotationTransform(iDrawInfo, tSConstPoint, tSConstPoint2);
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        if (affineTransform2 != null) {
            affineTransform = tSEGraphics.getTransform();
            tSEGraphics.setTransform(affineTransform2);
        } else {
            affineTransform = null;
        }
        if (shape != null) {
            if (this.isFilled() || !this.isOpenRegion()) {
                Color color = tSEGraphics.getColor();
                tSEGraphics.setColor(tSEColor);
                tSEGraphics.fill(shape);
                tSEGraphics.setColor(color);
            }
            tSEGraphics.draw(shape);
            bl = true;
        } else {
            bl = false;
        }
        if (affineTransform2 != null) {
            tSEGraphics.setTransform(affineTransform);
        }
        return bl;
    }

    public int getKind() {
        return this.kind;
    }

    public void setHeight(int n) {
        this.m_height = n;
    }

    public void setWidth(int n) {
        this.m_width = n;
    }

    public int getHeight() {
        return this.m_height == 0 ? this.getDefaultHeight() : this.m_height;
    }

    public int getWidth() {
        return this.m_width == 0 ? this.getDefaultWidth() : this.m_width;
    }

    public int getDefaultHeight() {
        return 10;
    }

    public int getDefaultWidth() {
        return 8;
    }

    protected boolean isFilled() {
        return !this.isOpenRegion();
    }

    protected abstract boolean isOpenRegion();

    public abstract Shape getShape(IDrawInfo var1, TSConstPoint var2, TSConstPoint var3);

    protected boolean requiresRotation() {
        return false;
    }

    protected AffineTransform getRotationTransform(IDrawInfo iDrawInfo, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        if (this.requiresRotation()) {
            TSTransform tSTransform = iDrawInfo.getTSTransform();
            double d = tSTransform.xToDevice(tSConstPoint2.getX());
            double d2 = tSTransform.yToDevice(tSConstPoint2.getY());
            iDrawInfo.getTSEGraphics().getTransform();
            return AffineTransform.getRotateInstance(this.getTheta(tSConstPoint, tSConstPoint2), d, d2);
        }
        return null;
    }

    public static double getTheta(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        double d6 = Math.PI;
        if (d2 == d) {
            if (d4 > d3) {
                d5 = d6 / 2.0;
            }
            if (d4 < d3) {
                d5 = 3.0 * d6 / 2.0;
            }
        } else {
            double d7 = (d4 - d3) / (d2 - d);
            d5 = (float)Math.atan(d7);
            if (d2 < d) {
                d5 += d6;
            }
        }
        return d5;
    }

    protected double getTheta(TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        return ETArrowHead.getTheta(tSConstPoint.getX(), tSConstPoint2.getX(), tSConstPoint.getY(), tSConstPoint2.getY());
    }
}

