/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.drawingproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.uml.ui.support.drawingproperties.DrawingPropertyResource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class FontChooser
extends JPanel
implements ItemListener {
    protected static JPanel UIPanel = null;
    protected static JPanel stylePanel = null;
    protected static JPanel optionPanel = null;
    protected static JPanel samplePanel = null;
    protected static JList m_NameList = null;
    protected static JList m_SizeList = null;
    protected static JLabel fontLabel = null;
    protected static JLabel fontSizeLabel = null;
    protected static JLabel m_sampleField = null;
    protected JLabel m_selectedFontName = null;
    protected JLabel m_selectedFontSize = null;
    protected static JButton m_ok = null;
    protected static JButton m_cancel = null;
    protected static JScrollPane fontScrollPane = null;
    protected static JScrollPane fontSizePane = null;
    protected static JCheckBox m_boldCheck = null;
    protected static JCheckBox m_italicCheck = null;
    private Font m_DefaultFont = null;
    protected static Font m_font = null;
    protected static String m_fontName = "";
    protected static int m_size = 0;
    protected static boolean m_bBold = false;
    protected static boolean m_bItalic = false;
    protected static String m_sampleStr = DrawingPropertyResource.getString("IDS_SAMPLESTRING");
    GridBagConstraints gridBagConstraints;

    protected void init() {
        this.setLayout(new GridBagLayout());
        UIPanel = new JPanel();
        UIPanel.setLayout(new GridBagLayout());
        stylePanel = new JPanel();
        stylePanel.setLayout(new GridBagLayout());
        String string = DrawingPropertyResource.getString("IDS_FONT");
        fontLabel = new JLabel(DrawingPropertyResource.determineText(string));
        DrawingPropertyResource.setMnemonic(fontLabel, string);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 0.7;
        this.gridBagConstraints.weighty = 0.1;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        UIPanel.add((Component)fontLabel, this.gridBagConstraints);
        this.m_selectedFontName = new JLabel();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        m_NameList = new JList<String>(stringArray);
        fontLabel.setLabelFor(m_NameList);
        String string2 = NbBundle.getMessage(FontChooser.class, (String)"ADDS_FONT");
        m_NameList.getAccessibleContext().setAccessibleDescription(string2);
        m_NameList.setSelectionMode(0);
        m_NameList.setVisibleRowCount(6);
        m_NameList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                FontChooser.this.m_selectedFontName.setText((String)jList.getSelectedValue());
                m_fontName = FontChooser.this.m_selectedFontName.getText();
                FontChooser.fontChanged();
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 0.7;
        this.gridBagConstraints.weighty = 0.1;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        UIPanel.add((Component)this.m_selectedFontName, this.gridBagConstraints);
        fontScrollPane = new JScrollPane(m_NameList);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 0.7;
        this.gridBagConstraints.weighty = 0.8;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        UIPanel.add((Component)fontScrollPane, this.gridBagConstraints);
        String string3 = DrawingPropertyResource.getString("IDS_SIZE");
        fontSizeLabel = new JLabel(DrawingPropertyResource.determineText(string3));
        DrawingPropertyResource.setMnemonic(fontSizeLabel, string3);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 0.3;
        this.gridBagConstraints.weighty = 0.1;
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        UIPanel.add((Component)fontSizeLabel, this.gridBagConstraints);
        this.m_selectedFontSize = new JLabel();
        Object[] objectArray = new Object[]{"8", "10", "12", "14", "18", "24", "36"};
        m_SizeList = new JList<Object>(objectArray);
        m_SizeList.setSelectionMode(0);
        m_SizeList.setVisibleRowCount(6);
        fontSizeLabel.setLabelFor(m_SizeList);
        String string4 = NbBundle.getMessage(FontChooser.class, (String)"ADDS_SIZE");
        m_SizeList.getAccessibleContext().setAccessibleDescription(string4);
        FontMetrics fontMetrics = null;
        fontMetrics = this.m_DefaultFont != null ? this.getFontMetrics(this.m_DefaultFont) : this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth("36");
        Dimension dimension = m_SizeList.getPreferredSize();
        dimension.width = n * 2;
        m_SizeList.setPreferredSize(dimension);
        m_SizeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                if (jList.getSelectedValue() != null) {
                    FontChooser.this.m_selectedFontSize.setText((String)jList.getSelectedValue());
                    m_size = Integer.parseInt(FontChooser.this.m_selectedFontSize.getText());
                    FontChooser.fontChanged();
                }
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 0.3;
        this.gridBagConstraints.weighty = 0.1;
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        UIPanel.add((Component)this.m_selectedFontSize, this.gridBagConstraints);
        fontSizePane = new JScrollPane(m_SizeList);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 0.3;
        this.gridBagConstraints.weighty = 0.9;
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 2;
        this.gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        UIPanel.add((Component)fontSizePane, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 0.7;
        this.gridBagConstraints.anchor = 10;
        this.gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.add((Component)UIPanel, this.gridBagConstraints);
        optionPanel = new JPanel();
        optionPanel.setLayout(new GridBagLayout());
        m_boldCheck = new JCheckBox(DrawingPropertyResource.determineText(DrawingPropertyResource.getString("IDS_BOLD")));
        DrawingPropertyResource.setMnemonic(m_boldCheck, DrawingPropertyResource.getString("IDS_BOLD"));
        m_boldCheck.getAccessibleContext().setAccessibleDescription(DrawingPropertyResource.getString("ADDS_BOLD"));
        m_boldCheck.setSelected(false);
        m_boldCheck.addItemListener(this);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.anchor = 18;
        this.gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        optionPanel.add((Component)m_boldCheck, this.gridBagConstraints);
        m_italicCheck = new JCheckBox(DrawingPropertyResource.determineText(DrawingPropertyResource.getString("IDS_ITALIC")));
        DrawingPropertyResource.setMnemonic(m_italicCheck, DrawingPropertyResource.getString("IDS_ITALIC"));
        m_italicCheck.getAccessibleContext().setAccessibleDescription(DrawingPropertyResource.getString("ADDS_ITALIC"));
        m_italicCheck.setSelected(false);
        m_italicCheck.addItemListener(this);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.anchor = 18;
        this.gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        optionPanel.add((Component)m_italicCheck, this.gridBagConstraints);
        optionPanel.setBorder(new TitledBorder(DrawingPropertyResource.getString("IDS_STYLES")));
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 0.3;
        this.gridBagConstraints.weighty = 1.0;
        this.gridBagConstraints.anchor = 17;
        stylePanel.add((Component)optionPanel, this.gridBagConstraints);
        samplePanel = new JPanel();
        samplePanel.setBorder(BorderFactory.createTitledBorder(DrawingPropertyResource.getString("IDS_SAMPLE")));
        samplePanel.setLayout(new BorderLayout());
        m_sampleField = new JLabel();
        m_sampleField.setText(m_sampleStr);
        samplePanel.add(m_sampleField);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 0.7;
        this.gridBagConstraints.weighty = 1.0;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        stylePanel.add((Component)samplePanel, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 0.3;
        this.gridBagConstraints.anchor = 10;
        this.add((Component)stylePanel, this.gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(DrawingPropertyResource.getString("ADDS_DIALOGTITLE"));
        this.setPreferredSize(new Dimension(500, 350));
    }

    public FontChooser() {
        this.init();
    }

    public FontChooser(Font font) {
        this.m_DefaultFont = font;
        this.init();
    }

    protected static int getFontStyle() {
        int n = 0;
        if (m_bItalic) {
            n |= 2;
        }
        if (m_bBold) {
            n |= 1;
        }
        return n;
    }

    protected static void fontChanged() {
        int n = FontChooser.getFontStyle();
        m_font = new Font(m_fontName, n, m_size);
        m_sampleField.setFont(m_font);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == m_boldCheck) {
            m_bBold = m_boldCheck.isSelected();
        } else if (itemSelectable == m_italicCheck) {
            m_bItalic = m_italicCheck.isSelected();
        }
        FontChooser.fontChanged();
    }

    public static Font selectFont() {
        return FontChooser.selectFont(null);
    }

    private static Font selectFont2(Font font) {
        Font font2 = null;
        FontChooser fontChooser = null;
        if (font != null) {
            fontChooser = new FontChooser(font);
            m_font = font;
            FontChooser.setDefaultFontValues(font);
        } else {
            fontChooser = new FontChooser();
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)fontChooser, DrawingPropertyResource.getString("IDS_DIALOGTITLE"));
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            font2 = m_font;
        }
        return font2;
    }

    public static Font selectFont(Font font) {
        Font font2 = null;
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Font.class);
        if (propertyEditor != null) {
            if (font != null) {
                propertyEditor.setValue(font);
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyEditor.getCustomEditor(), DrawingPropertyResource.getString("IDS_DIALOGTITLE"));
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                font2 = (Font)propertyEditor.getValue();
            }
        } else {
            font2 = FontChooser.selectFont2(font);
        }
        return font2;
    }

    private static void setDefaultFontValues(Font font) {
        m_fontName = font.getName();
        m_bItalic = font.isItalic();
        m_bBold = font.isBold();
        m_size = font.getSize();
        FontChooser.setCurrentFontName(m_fontName);
        FontChooser.setCurrentFontSize(m_size);
        FontChooser.setCurrentFontBold(m_bBold);
        FontChooser.setCurrentFontItalic(m_bItalic);
        FontChooser.fontChanged();
    }

    private static void setCurrentFontName(String string) {
        if (string != null && string.length() > 0) {
            m_NameList.setSelectedValue(string, true);
        } else {
            m_NameList.setSelectedIndex(0);
        }
    }

    private static void setCurrentFontSize(int n) {
        Integer n2 = new Integer(n);
        if (n2 > 0) {
            m_SizeList.setSelectedValue(n2.toString(), true);
        } else {
            m_SizeList.setSelectedIndex(0);
        }
    }

    private static void setCurrentFontBold(boolean bl) {
        m_boldCheck.setSelected(bl);
    }

    private static void setCurrentFontItalic(boolean bl) {
        m_italicCheck.setSelected(bl);
    }
}

