/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.helpers;

public class UserInputBlocker {
    private static long m_numKeyboardInstances = 0L;
    private static long m_numSelectionInstances = 0L;
    private static long m_numMovementInstances = 0L;
    private static long m_numResizeInstances = 0L;
    private static long m_numDeletionInstances = 0L;
    private static long m_numContainmentInstances = 0L;
    private static long m_numTrackCarsInstances = 0L;
    private static long m_numStackingCommandInstances = 0L;
    private static long m_numLabelLayoutInstances = 0L;
    private static long m_numInvalidateInstances = 0L;
    private int m_thisKind = 0;

    UserInputBlocker(int n) {
        switch (n) {
            case 16: {
                ++m_numKeyboardInstances;
                break;
            }
            case 32: {
                ++m_numSelectionInstances;
                break;
            }
            case 64: {
                ++m_numMovementInstances;
                break;
            }
            case 128: {
                ++m_numResizeInstances;
                break;
            }
            case 256: {
                ++m_numDeletionInstances;
                break;
            }
            case 2: {
                ++m_numContainmentInstances;
                break;
            }
            case 512: {
                ++m_numTrackCarsInstances;
                break;
            }
            case 1024: {
                ++m_numStackingCommandInstances;
                break;
            }
            case 2048: {
                ++m_numLabelLayoutInstances;
                break;
            }
            case 4096: {
                ++m_numInvalidateInstances;
            }
        }
        this.m_thisKind = n;
    }

    void stopBlocking() {
        if (this.m_thisKind != 0) {
            switch (this.m_thisKind) {
                case 16: {
                    --m_numKeyboardInstances;
                    break;
                }
                case 32: {
                    --m_numSelectionInstances;
                    break;
                }
                case 64: {
                    --m_numMovementInstances;
                    break;
                }
                case 128: {
                    --m_numResizeInstances;
                    break;
                }
                case 256: {
                    --m_numDeletionInstances;
                    break;
                }
                case 2: {
                    --m_numContainmentInstances;
                    break;
                }
                case 512: {
                    --m_numTrackCarsInstances;
                    break;
                }
                case 1024: {
                    --m_numStackingCommandInstances;
                    break;
                }
                case 2048: {
                    --m_numLabelLayoutInstances;
                    break;
                }
                case 4096: {
                    --m_numInvalidateInstances;
                }
            }
            this.m_thisKind = 0;
        }
    }

    public static boolean getIsDisabled(int n) {
        boolean bl = false;
        switch (n) {
            case 16: {
                bl = m_numKeyboardInstances > 0L;
                break;
            }
            case 32: {
                bl = m_numSelectionInstances > 0L;
                break;
            }
            case 64: {
                bl = m_numMovementInstances > 0L;
                break;
            }
            case 128: {
                bl = m_numResizeInstances > 0L;
                break;
            }
            case 256: {
                bl = m_numDeletionInstances > 0L;
                break;
            }
            case 2: {
                bl = m_numContainmentInstances > 0L;
                break;
            }
            case 512: {
                bl = m_numTrackCarsInstances > 0L;
                break;
            }
            case 1024: {
                bl = m_numStackingCommandInstances > 0L;
                break;
            }
            case 2048: {
                bl = m_numLabelLayoutInstances > 0L;
                break;
            }
            case 4096: {
                bl = m_numInvalidateInstances > 0L;
            }
        }
        return bl;
    }

    public static boolean getOneIsDisabled(int n) {
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = UserInputBlocker.getIsDisabled(1);
        }
        if (!bl && (n & 2) == 2) {
            bl = UserInputBlocker.getIsDisabled(2);
        }
        if (!bl && (n & 4) == 4) {
            bl = UserInputBlocker.getIsDisabled(4);
        }
        if (!bl && (n & 8) == 8) {
            bl = UserInputBlocker.getIsDisabled(8);
        }
        if (!bl && (n & 0x10) == 16) {
            bl = UserInputBlocker.getIsDisabled(16);
        }
        if (!bl && (n & 0x20) == 32) {
            bl = UserInputBlocker.getIsDisabled(32);
        }
        if (!bl && (n & 0x40) == 64) {
            bl = UserInputBlocker.getIsDisabled(64);
        }
        if (!bl && (n & 0x80) == 128) {
            bl = UserInputBlocker.getIsDisabled(128);
        }
        if (!bl && (n & 0x100) == 256) {
            bl = UserInputBlocker.getIsDisabled(256);
        }
        if (!bl && (n & 0x200) == 512) {
            bl = UserInputBlocker.getIsDisabled(512);
        }
        if (!bl && (n & 0x400) == 1024) {
            bl = UserInputBlocker.getIsDisabled(1024);
        }
        return bl;
    }
}

