/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.messaging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.ui.support.helpers.IGUIBlocker;
import org.netbeans.modules.uml.ui.support.messaging.IProgressController;
import org.netbeans.modules.uml.ui.support.messaging.IProgressDialog;
import org.netbeans.modules.uml.ui.support.messaging.IProgressExecutor;
import org.netbeans.modules.uml.ui.support.messaging.MessagingResources;
import org.netbeans.modules.uml.ui.support.messaging.TreeSaver;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProgressDialogImp
extends JCenterDialog
implements IProgressExecutor {
    private Dimension COLLAPSED_SIZE = new Dimension(600, 220);
    private Dimension EXPANDED_SIZE = new Dimension(600, 415);
    private static final int SMALL_INFO = 0;
    private static final int SMALL_ERROR = 1;
    private static final int SMALL_MESSAGE = 2;
    private static final int LARGE_MESSAGE = 3;
    private static final int LARGE_ERROR = 4;
    private static final int LARGE_INFO = 5;
    private static final int ATTRIBUTE = 6;
    private static final int OPERATION = 7;
    private static int m_NextCookie;
    private String m_Title = " ";
    private int m_Lower = 0;
    private int m_Upper = 100;
    private int m_Increment = 1;
    private int m_CurMode = 0;
    private IProgressController m_Controller = null;
    private List m_ImageList = null;
    private DefaultMutableTreeNode m_RootNode = null;
    private DefaultMutableTreeNode m_CurGroup = null;
    private DefaultMutableTreeNode m_CurFirst = null;
    private DefaultMutableTreeNode m_CurSecond = null;
    private JTree m_MessageTree = null;
    private DefaultTreeModel m_TreeModel = null;
    private boolean m_Cancelled = true;
    private String m_LogFile = "GDResults.txt";
    private String m_DefExt = "*.txt";
    private boolean m_Collapsed = true;
    private boolean m_SavingMessages = false;
    private IProgressExecutor m_Executor = null;
    private long m_RevokeNum = 0L;
    private IGUIBlocker m_cpDiagramBlocker = null;
    private boolean m_CloseWhenDone = false;
    private int lastButtonPressed;
    private JLabel m_FirstField = new JLabel();
    private JLabel m_SecondField = new JLabel();
    private JLabel m_ThirdField = new JLabel();
    private JButton m_CancelButton = new JButton();
    private JButton m_SaveMessageButton = new JButton();
    private JCheckBox cbCloseWhenDone = new JCheckBox();
    private JProgressBar m_ProgressIndicator = new JProgressBar();
    private JLabel m_GroupTitle = new JLabel();
    private JPanel pnlContents = new JPanel();
    private JPanel pnlTop = new JPanel();
    private JPanel pnlProgressMsgs = new JPanel();
    private JPanel pnlCenter = new JPanel();
    private JPanel pnlBottom = new JPanel();
    private JPanel pnlMessageCenter = new JPanel();
    private JLabel lblMessageCenter = new JLabel();
    private JPanel pnlCheckBox = new JPanel();
    private JPanel pnlButtons = new JPanel();
    private JLabel lblDummy = new JLabel();
    private JPanel pnlCancel = new JPanel();
    private JPanel pnlSaveMessage = new JPanel();
    private Frame m_ParentFrame = null;

    public ProgressDialogImp(Frame frame, int n, IProgressController iProgressController, int n2, int n3, int n4, DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, DefaultMutableTreeNode defaultMutableTreeNode3, boolean bl, String string, String string2, boolean bl2, int n5) {
        this(frame, MessagingResources.getString("IDS_PROGRESS"), false);
        this.m_CurMode = n;
        this.m_Controller = iProgressController;
        this.m_Lower = n2;
        this.m_Upper = n3;
        this.m_Increment = n4;
        this.m_CurGroup = defaultMutableTreeNode;
        this.m_CurFirst = defaultMutableTreeNode2;
        this.m_CurSecond = defaultMutableTreeNode3;
        this.m_Cancelled = bl;
        this.m_LogFile = this.m_LogFile != null ? this.m_LogFile : "GDResults.txt";
        this.m_DefExt = this.m_LogFile != null ? this.m_LogFile : "*.txt";
        this.m_Collapsed = bl2;
        this.m_RevokeNum = n5;
        this.m_FirstField.setText(" ");
        this.m_SecondField.setText(" ");
        this.m_ThirdField.setText(" ");
        this.m_CloseWhenDone = false;
    }

    public ProgressDialogImp(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.m_ParentFrame = frame;
        try {
            this.createUI();
            this.pack();
            this.setSize(this.COLLAPSED_SIZE);
            this.setCollapsedPanelSize();
            this.setExpandedPanelSize();
            this.setCollapse(true);
            this.setResizable(true);
            if (this.m_ParentFrame != null) {
                this.center(this.m_ParentFrame);
            } else {
                Dimension dimension = this.getToolkit().getScreenSize();
                Dimension dimension2 = this.getSize();
                this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            }
            this.updateData(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ProgressDialogImp() {
        this((Frame)null, MessagingResources.getString("IDS_PROGRESS"), false);
    }

    private void initMessageTree() {
        this.m_RootNode = new DefaultMutableTreeNode(MessagingResources.getString("IDS_PROGRESSINFORMATION"));
        this.m_TreeModel = new DefaultTreeModel(this.m_RootNode);
        this.m_MessageTree.setModel(this.m_TreeModel);
    }

    private void createUI() throws Exception {
        this.getAccessibleContext().setAccessibleDescription(MessagingResources.getString("ACSD_ProgressDialog"));
        this.m_RootNode = new DefaultMutableTreeNode(MessagingResources.getString("IDS_PROGRESSINFORMATION"));
        this.m_TreeModel = new DefaultTreeModel(this.m_RootNode);
        this.m_MessageTree = new JTree(this.m_TreeModel);
        this.m_MessageTree.getAccessibleContext().setAccessibleName(MessagingResources.getString("ACSN_MessageTree"));
        this.m_MessageTree.getAccessibleContext().setAccessibleDescription(MessagingResources.getString("ACSD_MessageTree"));
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        this.m_MessageTree.setCellRenderer(defaultTreeCellRenderer);
        this.m_MessageTree.setEditable(false);
        this.m_MessageTree.getSelectionModel().setSelectionMode(1);
        this.m_MessageTree.setShowsRootHandles(true);
        this.pnlContents.setLayout(new BorderLayout());
        this.pnlContents.setMaximumSize(new Dimension(-1, -1));
        this.pnlContents.setMinimumSize(new Dimension(-1, -1));
        this.pnlContents.setPreferredSize(new Dimension(-1, -1));
        this.pnlTop.setLayout(new GridBagLayout());
        this.pnlTop.setMinimumSize(new Dimension(591, 150));
        this.pnlTop.setPreferredSize(new Dimension(591, 150));
        this.pnlProgressMsgs.setLayout(new GridBagLayout());
        this.pnlProgressMsgs.setBorder(BorderFactory.createEtchedBorder());
        this.pnlProgressMsgs.setMinimumSize(new Dimension(50, 50));
        this.pnlProgressMsgs.setPreferredSize(new Dimension(50, 50));
        this.m_FirstField.setFont(new Font("SansSerif", 0, 10));
        this.m_FirstField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_FirstField.setMaximumSize(new Dimension(495, 18));
        this.m_FirstField.setMinimumSize(new Dimension(495, 18));
        this.m_FirstField.setPreferredSize(new Dimension(495, 18));
        this.m_SecondField.setFont(new Font("SansSerif", 0, 10));
        this.m_SecondField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_SecondField.setMaximumSize(new Dimension(495, 18));
        this.m_SecondField.setMinimumSize(new Dimension(495, 18));
        this.m_SecondField.setPreferredSize(new Dimension(495, 18));
        this.m_ThirdField.setFont(new Font("Dialog", 0, 10));
        this.m_ThirdField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_ThirdField.setMaximumSize(new Dimension(495, 18));
        this.m_ThirdField.setMinimumSize(new Dimension(495, 18));
        this.m_ThirdField.setPreferredSize(new Dimension(495, 18));
        this.m_GroupTitle.setOpaque(true);
        this.m_GroupTitle.setText("");
        this.m_SaveMessageButton.setText(MessagingResources.determineText(MessagingResources.getString("IDS_SAVEMESSAGE")));
        MessagingResources.setMnemonic(this.m_SaveMessageButton, MessagingResources.getString("IDS_SAVEMESSAGE"));
        this.m_SaveMessageButton.getAccessibleContext().setAccessibleDescription(MessagingResources.getString("ACSD_SaveMessage"));
        this.m_CancelButton.setText(MessagingResources.determineText(MessagingResources.getString("IDS_CANCEL")));
        MessagingResources.setMnemonic(this.m_CancelButton, MessagingResources.getString("IDS_CANCEL"));
        this.m_CancelButton.getAccessibleContext().setAccessibleDescription(MessagingResources.getString("ACSD_Cancel"));
        this.pnlBottom.setLayout(new BorderLayout());
        this.pnlBottom.setMinimumSize(new Dimension(591, 45));
        this.pnlBottom.setPreferredSize(new Dimension(591, 45));
        this.cbCloseWhenDone.setText(MessagingResources.getString("IDS_CLOSEWHENDONE"));
        this.cbCloseWhenDone.setVisible(false);
        this.pnlMessageCenter.setBorder(BorderFactory.createEtchedBorder());
        this.pnlMessageCenter.setLayout(new GridBagLayout());
        this.pnlCenter.setLayout(new GridBagLayout());
        this.lblMessageCenter.setText(MessagingResources.determineText(MessagingResources.getString("IDS_MESSAGECENTER")));
        MessagingResources.setMnemonic(this.lblMessageCenter, MessagingResources.getString("IDS_MESSAGECENTER"));
        this.lblMessageCenter.setOpaque(true);
        this.lblMessageCenter.setLabelFor(this.m_MessageTree);
        this.m_MessageTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_ProgressIndicator.setToolTipText("");
        this.pnlCenter.setMinimumSize(new Dimension(-1, -1));
        this.pnlCenter.setPreferredSize(new Dimension(-1, -1));
        this.pnlButtons.setLayout(new GridBagLayout());
        this.lblDummy.setText("     ");
        this.pnlCancel.setLayout(new FlowLayout());
        this.pnlSaveMessage.setLayout(new FlowLayout());
        this.pnlCheckBox.add((Component)this.lblDummy, null);
        this.getContentPane().add((Component)this.pnlContents, "Center");
        this.pnlContents.add((Component)this.pnlTop, "North");
        this.pnlProgressMsgs.add((Component)this.m_FirstField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(18, 30, 0, 24), 100, 0));
        this.pnlProgressMsgs.add((Component)this.m_SecondField, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 30, 0, 24), 100, 0));
        this.pnlProgressMsgs.add((Component)this.m_ThirdField, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 30, 15, 24), 100, 0));
        this.pnlTop.add((Component)this.m_GroupTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(16, 30, 85, 252), 0, 0));
        this.pnlTop.add((Component)this.m_ProgressIndicator, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(7, 20, 9, 18), 403, 0));
        this.pnlTop.add((Component)this.pnlProgressMsgs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(23, 20, 0, 18), 503, 45));
        this.pnlContents.add((Component)this.pnlCenter, "Center");
        this.pnlCenter.add((Component)this.lblMessageCenter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 173, 352), 0, 0));
        this.pnlCenter.add((Component)this.pnlMessageCenter, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(7, 20, 3, 18), 0, 0));
        this.pnlMessageCenter.add((Component)new JScrollPane(this.m_MessageTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(17, 9, 8, 10), 448, 83));
        this.pnlContents.add((Component)this.pnlBottom, "South");
        this.pnlBottom.add((Component)this.pnlCheckBox, "West");
        this.pnlCheckBox.add((Component)this.cbCloseWhenDone, null);
        this.pnlBottom.add((Component)this.pnlButtons, "East");
        this.pnlButtons.add((Component)this.pnlSaveMessage, new GridBagConstraints(0, 0, 1, 1, 5.0, 0.0, 10, 0, new Insets(25, 338, 25, 0), 0, 0));
        this.pnlSaveMessage.add((Component)this.m_SaveMessageButton, null);
        this.pnlButtons.add((Component)this.pnlCancel, new GridBagConstraints(1, 0, 1, 1, 5.0, 0.0, 10, 0, new Insets(25, 5, 25, 12), 0, 0));
        this.pnlCancel.add((Component)this.m_CancelButton, null);
        this.addActionListeners();
        this.m_FirstField.setText("  ");
        this.m_SecondField.setText("  ");
        this.m_ThirdField.setText("  ");
    }

    private void addActionListeners() {
        this.m_SaveMessageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialogImp.this.m_SaveMessageButton_actionPerformed(actionEvent);
            }
        });
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialogImp.this.m_CancelButton_actionPerformed(actionEvent);
            }
        });
        this.cbCloseWhenDone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialogImp.this.cbCloseWhenDone_actionPerformed(actionEvent);
            }
        });
    }

    void m_CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.lastButtonPressed = 1;
        if (this.m_CancelButton.getText().equals(MessagingResources.determineText(MessagingResources.getString("IDS_DONE")))) {
            this.onCancel();
        } else if (this.m_CancelButton.getText().equals(MessagingResources.determineText(MessagingResources.getString("IDS_CANCEL")))) {
            this.onCancel();
        }
    }

    void m_SaveMessageButton_actionPerformed(ActionEvent actionEvent) {
        this.onSaveMessages();
    }

    void cbCloseWhenDone_actionPerformed(ActionEvent actionEvent) {
        this.m_CloseWhenDone = this.cbCloseWhenDone.isSelected();
    }

    public void advise(IProgressController iProgressController, long l) {
        this.m_Controller = iProgressController;
        this.m_RevokeNum = l;
    }

    public void broadCastCancel() {
        try {
            if (this.m_Controller != null) {
                this.m_Controller.onProgressEnd();
            }
            this.flushEventQueue();
        }
        catch (Exception exception) {
            Log.stackTrace(exception);
        }
    }

    private void flushEventQueue() {
        try {
            if (!this.m_Cancelled && !this.m_SavingMessages) {
                this.repaint();
                this.updateData(true);
            }
        }
        catch (Exception exception) {
            Log.stackTrace(exception);
        }
    }

    private void setCollapsedPanelSize() {
        int n = this.getFont().getSize();
        int n2 = 600;
        int n3 = 220;
        int n4 = 1;
        if (n > 17) {
            n4 = 3;
        }
        n2 += Math.round((float)n2 * ((float)(n4 * n) / 100.0f));
        n3 += Math.round((float)n3 * ((float)(n4 * n) / 100.0f));
        this.COLLAPSED_SIZE = new Dimension(n2, n3);
    }

    private void setExpandedPanelSize() {
        int n = this.getFont().getSize();
        int n2 = 600;
        int n3 = 415;
        int n4 = 1;
        if (n > 17) {
            n4 = 3;
        }
        n2 += Math.round((float)n2 * ((float)(n4 * n) / 100.0f));
        n3 += Math.round((float)n3 * ((float)(n4 * n) / 100.0f));
        this.EXPANDED_SIZE = new Dimension(n2, n3);
    }

    private void collapseDialog(boolean bl) {
        if (bl) {
            this.pnlContents.remove(this.pnlCenter);
            this.setSize(this.COLLAPSED_SIZE);
            this.m_SaveMessageButton.setVisible(false);
            this.m_CancelButton.setText(MessagingResources.determineText(MessagingResources.getString("IDS_CANCEL")));
            MessagingResources.setMnemonic(this.m_CancelButton, MessagingResources.getString("IDS_CANCEL"));
        } else {
            this.pnlContents.add((Component)this.pnlCenter, "Center");
            this.setSize(this.EXPANDED_SIZE);
            this.m_SaveMessageButton.setVisible(true);
            this.m_CancelButton.setText(MessagingResources.determineText(MessagingResources.getString("IDS_DONE")));
            MessagingResources.setMnemonic(this.m_CancelButton, MessagingResources.getString("IDS_DONE"));
            this.m_TreeModel.reload(this.m_RootNode);
        }
        this.validate();
        this.repaint();
    }

    private int doModal() {
        super.show();
        return this.lastButtonPressed;
    }

    private boolean isProgressIndicatorAtMaximumPosition() {
        boolean bl = false;
        int n = this.m_ProgressIndicator.getValue();
        if (n >= this.m_Upper) {
            bl = true;
        }
        return bl;
    }

    private void setProgressIndicatorToMaximum() {
        this.m_ProgressIndicator.setValue(this.m_Upper);
    }

    private int retrieveImage(int n, boolean bl) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = bl ? 2 : 3;
                break;
            }
            case 2: {
                n2 = bl ? 0 : 5;
                break;
            }
            case 3: {
                n2 = bl ? 1 : 4;
                break;
            }
            case 4: {
                n2 = 6;
                break;
            }
            case 5: {
                n2 = 7;
            }
        }
        return n2;
    }

    private DefaultMutableTreeNode establishFirstNode(int n, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.m_CurGroup != null) {
            defaultMutableTreeNode = this.establishNode(n, string, this.retrieveImage(n, true), this.m_CurFirst, this.m_CurGroup);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode establishSecondNode(int n, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (this.m_CurFirst != null) {
            defaultMutableTreeNode = this.establishNode(n, string, this.retrieveImage(n, true), this.m_CurSecond, this.m_CurFirst);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode establishGroupNode(int n, String string) {
        try {
            if (this.m_RootNode.getChildCount() == 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.establishNode(n, string, this.retrieveImage(n, false), this.m_CurGroup, this.m_RootNode);
        if (string.length() > 0) {
            this.m_CurFirst = null;
            this.m_CurSecond = null;
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode establishNode(int n, String string, int n2, DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        if (defaultMutableTreeNode == null) {
            if (string.length() > 0) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                if (defaultMutableTreeNode2 != null) {
                    this.m_TreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                    defaultMutableTreeNode3 = defaultMutableTreeNode;
                }
            }
        } else if (string != null && string.length() > 0) {
            if (!defaultMutableTreeNode.toString().equals(string)) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(string);
                if (defaultMutableTreeNode2 != null) {
                    this.m_TreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                }
                defaultMutableTreeNode3 = defaultMutableTreeNode;
            }
        } else {
            defaultMutableTreeNode3 = defaultMutableTreeNode;
        }
        return defaultMutableTreeNode3;
    }

    public void onCancel() {
        try {
            this.m_Cancelled = true;
            this.broadCastCancel();
            this.cleanUp();
            this.m_GroupTitle.setText("");
            this.m_Controller = null;
            if (this.m_CurMode == 1) {
                this.dispose();
            } else {
                this.dispose();
            }
        }
        catch (Exception exception) {
            Log.stackTrace(exception);
        }
    }

    private void onSaveMessages() {
        try {
            TreeSaver treeSaver = new TreeSaver(this.m_MessageTree);
            this.m_SavingMessages = true;
            treeSaver.save();
            this.m_SavingMessages = false;
        }
        catch (Exception exception) {
            Log.stackTrace(exception);
        }
    }

    private void onCloseWhenDone() {
        this.dispose();
    }

    private void cleanUp() {
        this.m_CurMode = 0;
        this.m_CurGroup = null;
        this.m_CurFirst = null;
        this.m_CurSecond = null;
        this.m_ProgressIndicator.setIndeterminate(false);
        this.m_ProgressIndicator.setMinimum(0);
        this.m_ProgressIndicator.setMaximum(100);
        this.m_ProgressIndicator.setValue(0);
        if (this.m_Controller != null) {
            // empty if block
        }
        this.m_cpDiagramBlocker = null;
    }

    private void expandTree(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (n >= 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            while (defaultMutableTreeNode2 != null) {
                int n2 = n - 1;
                if (n2 < 0) continue;
                this.expandTree(defaultMutableTreeNode2, n2);
            }
        }
    }

    private void updateData(boolean bl) {
        if (bl) {
            this.update(this.getGraphics());
        }
    }

    protected long clearFields() {
        this.m_FirstField.setText("  ");
        this.m_SecondField.setText("  ");
        this.m_ThirdField.setText("  ");
        this.updateData(false);
        return 0L;
    }

    protected long close() {
        this.dispose();
        return 0L;
    }

    protected boolean display(int n) {
        boolean bl = true;
        this.m_Cancelled = false;
        if (n == 1) {
            this.m_CurMode = 1;
            this.doModal();
        } else if (n == 2) {
            this.m_CurMode = 2;
            this.setModal(false);
            this.show();
            this.updateData(true);
        }
        this.initMessageTree();
        return bl;
    }

    protected boolean getCloseWhenDone() {
        return this.cbCloseWhenDone.isSelected();
    }

    protected boolean getCollapse() {
        return this.m_Collapsed;
    }

    protected String getDefaultExtension() {
        return this.m_DefExt;
    }

    protected String getFieldOne() {
        return this.m_FirstField.getText();
    }

    protected String getFieldThree() {
        return this.m_SecondField.getText();
    }

    protected String getFieldTwo() {
        return this.m_ThirdField.getText();
    }

    protected String getGroupingTitle() {
        return this.m_GroupTitle.getText();
    }

    protected int getIncrementAmount() {
        return this.m_Increment;
    }

    protected boolean getIsCancelled() {
        return this.m_Cancelled;
    }

    protected ETPairT<Integer, Integer> getLimits() {
        return new ETPairT<Integer, Integer>(new Integer(this.m_Lower), new Integer(this.m_Upper));
    }

    protected String getLogFileName() {
        return this.m_LogFile;
    }

    protected int getPosition() {
        return this.m_ProgressIndicator.getValue();
    }

    protected IProgressExecutor getProgressExecutor() {
        return this.m_Executor;
    }

    protected int increment() {
        int n;
        if (!this.isProgressIndicatorAtMaximumPosition()) {
            this.m_ProgressIndicator.setValue(this.m_ProgressIndicator.getValue() + 1);
            n = this.m_ProgressIndicator.getValue();
        } else {
            n = this.m_Upper;
        }
        this.flushEventQueue();
        return n;
    }

    protected int increment(int n) {
        int n2;
        if (!this.isProgressIndicatorAtMaximumPosition()) {
            int n3 = n > 0 ? n : 1;
            int n4 = this.m_ProgressIndicator.getValue() + n3;
            this.m_ProgressIndicator.setValue(n4);
            n2 = this.m_ProgressIndicator.getValue();
        } else {
            n2 = this.m_Upper;
        }
        this.flushEventQueue();
        return n2;
    }

    protected void lockMessageCenterUpdate() {
    }

    protected void log(int n, String string, String string2, String string3, String string4) {
        this.m_CurGroup = this.establishGroupNode(n, string);
        this.m_CurFirst = this.establishFirstNode(n, string2);
        this.m_CurSecond = this.establishSecondNode(n, string3);
        if (string4.length() > 0 && this.m_CurSecond != null) {
            int n2 = this.retrieveImage(n, true);
            this.m_TreeModel.insertNodeInto(new DefaultMutableTreeNode(string4), this.m_CurSecond, this.m_CurSecond.getChildCount());
        }
    }

    protected void promptForClosure(String string, boolean bl) {
        try {
            this.setProgressIndicatorToMaximum();
            this.updateData(true);
            if (this.m_CloseWhenDone) {
                this.onCancel();
            } else if (string.length() > 0) {
                this.unlockMessageCenterUpdate();
                this.showLastTreeItem();
                Thread thread = new Thread(){

                    public void run() {
                        while (!ProgressDialogImp.this.m_Cancelled) {
                            try {
                                if (!ProgressDialogImp.this.m_SavingMessages) {
                                    ProgressDialogImp.this.flushEventQueue();
                                }
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        Runnable runnable = new Runnable(){

                            public void run() {
                                ProgressDialogImp.this.flushEventQueue();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                };
            }
        }
        catch (Exception exception) {
            Log.stackTrace(exception);
        }
    }

    private void showLastTreeItem() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.m_MessageTree.getModel().getRoot();
        if (defaultMutableTreeNode2 != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_MessageTree.getModel().getChild(defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount() - 1);
        }
        if (defaultMutableTreeNode != null) {
            this.m_MessageTree.makeVisible(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    protected void setCloseWhenDone(boolean bl) {
        this.m_CloseWhenDone = bl;
        this.updateData(false);
    }

    protected void setCollapse(boolean bl) {
        this.m_Collapsed = bl;
        this.collapseDialog(bl);
        if (bl) {
            this.lockMessageCenterUpdate();
        } else {
            this.unlockMessageCenterUpdate();
        }
    }

    protected void setDefaultExtension(String string) {
        this.m_DefExt = string;
    }

    protected void setFieldOne(String string) {
        this.setFieldOne(string, 0);
    }

    protected void setFieldOne(String string, int n) {
        this.m_FirstField.setText(string != null ? string : "  ");
        this.updateData(false);
        this.log(n, "", string, "", "");
        this.flushEventQueue();
    }

    protected void setFieldTwo(String string) {
        this.setFieldTwo(string, 0);
    }

    protected void setFieldTwo(String string, int n) {
        this.m_SecondField.setText(string != null ? string : "  ");
        this.updateData(false);
        this.log(n, "", "", string, "");
        this.flushEventQueue();
    }

    protected void setFieldThree(String string) {
        this.setFieldThree(string, 0);
    }

    protected void setFieldThree(String string, int n) {
        this.m_ThirdField.setText(string != null ? string : "  ");
        this.updateData(false);
        this.log(n, "", "", "", string);
        this.flushEventQueue();
    }

    protected void setGroupingTitle(String string) {
        this.setGroupingTitle(string, 0);
    }

    protected void setGroupingTitle(String string, int n) {
        this.m_GroupTitle.setText(string != null ? string : "  ");
        this.log(n, string, "", "", "");
        this.flushEventQueue();
    }

    protected void setIncrementAmount(int n) {
        this.m_Increment = n;
        this.flushEventQueue();
    }

    protected void setLimits(ETPairT<Integer, Integer> eTPairT) {
        if (this.m_ParentFrame != null) {
            this.center(this.m_ParentFrame);
            this.updateData(false);
        }
        if (eTPairT != null) {
            this.m_Lower = eTPairT.getParamOne();
            this.m_Upper = eTPairT.getParamTwo();
            this.m_ProgressIndicator.setMinimum(this.m_Lower);
            this.m_ProgressIndicator.setMaximum(this.m_Upper);
            this.flushEventQueue();
        }
    }

    protected void setLogFileName(String string) {
        this.m_LogFile = string;
    }

    protected void setPosition(int n) {
        this.m_ProgressIndicator.setValue(n);
        this.flushEventQueue();
    }

    protected void setProgressExecutor(IProgressExecutor iProgressExecutor) {
        this.m_Executor = iProgressExecutor;
    }

    protected void setIndeterminate(boolean bl) {
        this.m_ProgressIndicator.setIndeterminate(bl);
    }

    protected void unlockMessageCenterUpdate() {
    }

    @Override
    public long execute(IProgressDialog iProgressDialog) {
        return 0L;
    }

    protected void setProgressController(IProgressController iProgressController) {
        this.m_Controller = iProgressController;
    }

    protected IProgressController getProgressController() {
        return this.m_Controller;
    }
}

