/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.messaging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.uml.common.Util;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.ui.support.messaging.IZoomDialog;
import org.netbeans.modules.uml.ui.support.messaging.MessagingResources;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomDialog
extends JCenterDialog
implements IZoomDialog {
    private int lastButtonPressed;
    private long m_CurrentZoom = 100L;
    private boolean m_FitToWindow = false;
    private JPanel panel1 = new JPanel();
    private JPanel spacePanel = new JPanel();
    private JButton jbOK = new JButton();
    private JButton jbCancel = new JButton();
    private JComboBox cbZoom = new JComboBox();
    private JCheckBox cbFitToWindow = new JCheckBox();
    private JLabel lblPercent = new JLabel();
    private JPanel topPanel = new JPanel();
    private JPanel midPanel = new JPanel();
    private JPanel bottomPanel = new JPanel();

    public ZoomDialog(Frame frame) {
        this(frame, MessagingResources.getString("IDS_ZOOM"), false);
    }

    public ZoomDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.createUI();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ZoomDialog() {
        this((Frame)null, MessagingResources.getString("IDS_ZOOM"), false);
    }

    private void createUI() throws Exception {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panel1.setLayout(new GridBagLayout());
        this.jbOK.setToolTipText("");
        Mnemonics.setLocalizedText((AbstractButton)this.jbOK, (String)NbBundle.getMessage(ZoomDialog.class, (String)"IDS_OK"));
        this.getRootPane().setDefaultButton(this.jbOK);
        Mnemonics.setLocalizedText((AbstractButton)this.jbCancel, (String)NbBundle.getMessage(ZoomDialog.class, (String)"IDS_CANCEL"));
        this.cbFitToWindow.setText(MessagingResources.determineText(MessagingResources.getString("IDS_FITTOWINDOW")));
        MessagingResources.setMnemonic(this.cbFitToWindow, MessagingResources.getString("IDS_FITTOWINDOW"));
        this.lblPercent.setOpaque(true);
        this.lblPercent.setToolTipText("");
        this.lblPercent.setText(MessagingResources.determineText(MessagingResources.getString("IDS_PERCENT")));
        this.lblPercent.setBorder(new EmptyBorder(new Insets(0, 0, 2, 0)));
        MessagingResources.setMnemonic(this.lblPercent, MessagingResources.getString("IDS_PERCENT"));
        MessagingResources.setFocusAccelerator(this.cbZoom, MessagingResources.getString("IDS_PERCENT"));
        this.getContentPane().add(this.panel1);
        this.topPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(7, 7, 5, 2);
        this.topPanel.add((Component)this.lblPercent, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(6, 2, 5, 5);
        gridBagConstraints.ipadx = -20;
        gridBagConstraints.fill = 1;
        this.topPanel.add((Component)this.cbZoom, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panel1.add((Component)this.topPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 2);
        this.panel1.add((Component)this.cbFitToWindow, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        this.bottomPanel.add((Component)this.jbOK, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 5, 4);
        this.bottomPanel.add((Component)this.jbCancel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.panel1.add((Component)this.bottomPanel, gridBagConstraints);
        Dimension dimension = this.getMaxButtonWidth();
        this.jbOK.setMaximumSize(dimension);
        this.jbOK.setPreferredSize(dimension);
        this.jbCancel.setMaximumSize(dimension);
        this.jbCancel.setPreferredSize(dimension);
        this.addActionListeners();
        this.onInitDialog();
    }

    private Dimension getMaxButtonWidth() {
        Dimension dimension = null;
        Dimension dimension2 = this.jbCancel.getPreferredSize();
        double d = dimension2.width;
        dimension2 = this.jbOK.getPreferredSize();
        if ((double)dimension2.width < d) {
            d = dimension2.width;
            dimension = dimension2;
        }
        return dimension;
    }

    private void addActionListeners() {
        this.jbOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomDialog.this.jbOK_actionPerformed(actionEvent);
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomDialog.this.jbCancel_actionPerformed(actionEvent);
            }
        });
        this.cbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomDialog.this.cbZoom_actionPerformed(actionEvent);
            }
        });
        this.cbFitToWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomDialog.this.cbFitToWindow_actionPerformed(actionEvent);
            }
        });
    }

    void cbZoom_actionPerformed(ActionEvent actionEvent) {
        try {
            this.m_CurrentZoom = Util.toLong(this.cbZoom.getSelectedItem());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void cbFitToWindow_actionPerformed(ActionEvent actionEvent) {
        if (this.cbFitToWindow.isSelected()) {
            this.m_FitToWindow = true;
            this.cbZoom.setEnabled(false);
        } else {
            this.m_FitToWindow = false;
            this.cbZoom.setEnabled(true);
        }
    }

    void jbOK_actionPerformed(ActionEvent actionEvent) {
        this.lastButtonPressed = 1;
        try {
            this.m_CurrentZoom = Util.toLong(this.cbZoom.getSelectedItem());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.m_FitToWindow = this.cbFitToWindow.isSelected();
        this.dispose();
    }

    void jbCancel_actionPerformed(ActionEvent actionEvent) {
        this.lastButtonPressed = 0;
        this.dispose();
    }

    protected boolean onInitDialog() {
        this.cbFitToWindow.setSelected(this.m_FitToWindow);
        this.cbZoom.addItem(new String("400"));
        this.cbZoom.addItem(new String("200"));
        this.cbZoom.addItem(new String("100"));
        this.cbZoom.addItem(new String("50"));
        this.cbZoom.addItem(new String("25"));
        this.cbZoom.setSelectedItem("100");
        this.cbZoom.setEditable(true);
        return true;
    }

    @Override
    public double getCurrentZoom() {
        try {
            return (double)this.m_CurrentZoom / 100.0;
        }
        catch (RuntimeException runtimeException) {
            return 0.0;
        }
    }

    @Override
    public void setCurrentZoom(double d) {
        try {
            this.cbZoom.setSelectedItem(Util.toString(new Long(Math.round(d * 100.0))));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public boolean getFitToWindow() {
        return this.m_FitToWindow;
    }

    @Override
    public ETPairT<Double, Boolean> display(double d) {
        double d2 = d;
        boolean bl = false;
        this.setCurrentZoom(d);
        this.setModal(true);
        super.show();
        if (this.lastButtonPressed == 1) {
            d2 = this.getCurrentZoom();
            bl = this.getFitToWindow();
        } else if (this.lastButtonPressed == 0) {
            return null;
        }
        return new ETPairT<Double, Boolean>(new Double(d2), new Boolean(bl));
    }
}

