/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.presentationnavigation;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.ui.support.DiagramBuilder;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.netbeans.modules.uml.ui.support.diagramsupport.IPresentationTarget;
import org.netbeans.modules.uml.ui.swing.commondialogs.SwingNavigationDialog;
import org.netbeans.modules.uml.ui.swing.treetable.JTreeTable;
import org.netbeans.modules.uml.ui.swing.treetable.PropertyValueCellRenderer;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableModel;

public class JNavigationTreeTable
extends JTreeTable {
    private TreePath m_Selected = null;
    private CommonResourceManager m_Manager = CommonResourceManager.instance();
    private SwingNavigationDialog m_Parent = null;

    public JNavigationTreeTable(TreeTableModel treeTableModel) {
        this(treeTableModel, (JTreeTable.TreeTableCellRenderer)null);
    }

    public JNavigationTreeTable(TreeTableModel treeTableModel, SwingNavigationDialog swingNavigationDialog) {
        this(treeTableModel, (JTreeTable.TreeTableCellRenderer)null);
        this.m_Parent = swingNavigationDialog;
    }

    public JNavigationTreeTable(TreeTableModel treeTableModel, JTreeTable.TreeTableCellRenderer treeTableCellRenderer) {
        super(treeTableModel, treeTableCellRenderer);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        TableColumnModel tableColumnModel = this.getColumnModel();
        PropertyValueCellRenderer propertyValueCellRenderer = new PropertyValueCellRenderer();
        tableColumnModel.getColumn(0).setCellRenderer(this.tree);
        tableColumnModel.getColumn(1).setCellRenderer(propertyValueCellRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(propertyValueCellRenderer);
        tableColumnModel.getColumn(3).setCellRenderer(propertyValueCellRenderer);
        this.addMouseListener(new TreeMouseHandler());
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        return false;
    }

    public TreePath getSelectedPath() {
        return this.m_Selected;
    }

    public void expandFirstLevelNodes() {
        TreeModel treeModel = this.getTree().getModel();
        Object object = treeModel.getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = n - 1; i >= 0; --i) {
                this.tree.expandNode(i, true);
            }
        }
    }

    public void handleNavigation(TreePath treePath) {
        Object object;
        Object object2;
        if (treePath != null && (object2 = treePath.getLastPathComponent()) != null && object2 instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)object2).getUserObject()) != null) {
            DiagramBuilder diagramBuilder = new DiagramBuilder();
            if (object instanceof IProxyDiagram) {
                IProxyDiagram iProxyDiagram = (IProxyDiagram)object;
                String string = iProxyDiagram.getFilename();
                String string2 = iProxyDiagram.getXMIID();
                if (this.m_Parent != null) {
                    this.m_Parent.setTargetXMIID(string2);
                }
                if (string != null && string.length() > 0) {
                    diagramBuilder.navigateToDiagram(string, string2, "", "");
                }
            } else if (object instanceof IPresentationTarget) {
                IPresentationTarget iPresentationTarget = (IPresentationTarget)object;
                String string = iPresentationTarget.getPresentationID();
                if (this.m_Parent != null) {
                    this.m_Parent.setTargetXMIID(string);
                }
                diagramBuilder.navigateToTarget(iPresentationTarget);
            } else if (object instanceof IElement) {
                IElement iElement = (IElement)object;
                String string = iElement.getXMIID();
                if (this.m_Parent != null) {
                    this.m_Parent.setTargetXMIID(string);
                }
                diagramBuilder.navigateToElementInTree(iElement);
            }
        }
    }

    public class NavigationTreeCellRenderer
    extends JTreeTable.TreeTableCellRenderer {
        public NavigationTreeCellRenderer(JTreeTable.TreeTableCellRenderer treeTableCellRenderer) {
            super(JNavigationTreeTable.this);
            JNavigationTreeTable.this.tree = treeTableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2;
            TreePath treePath;
            Object object3;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 0 && (object3 = (treePath = JNavigationTreeTable.this.tree.getPathForRow(n)).getLastPathComponent()) != null && object3 instanceof DefaultMutableTreeNode && (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)object3).getUserObject()) != null) {
                if (object2 instanceof IPresentationTarget) {
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(JNavigationTreeTable.this.m_Manager.getIconForDisp(object2));
                    return jLabel;
                }
                if (object2 instanceof IProxyDiagram) {
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(JNavigationTreeTable.this.m_Manager.getIconForDisp(object2));
                    return jLabel;
                }
                if (object2 instanceof IElement) {
                    JLabel jLabel = new JLabel();
                    jLabel.setIcon(JNavigationTreeTable.this.m_Manager.getIconForDisp(object2));
                    return jLabel;
                }
            }
            return component;
        }
    }

    public class TreeMouseHandler
    extends MouseInputAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = JNavigationTreeTable.this.rowAtPoint(mouseEvent.getPoint());
            TreePath treePath = JNavigationTreeTable.this.getTree().getPathForRow(n);
            if (n != -1) {
                if (mouseEvent.getClickCount() == 1) {
                    Object object;
                    Object object2;
                    JNavigationTreeTable.this.m_Selected = treePath;
                    if (JNavigationTreeTable.this.m_Parent != null && (object2 = treePath.getLastPathComponent()) != null && object2 instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)object2).getUserObject()) != null) {
                        if (object instanceof IProxyDiagram) {
                            JNavigationTreeTable.this.m_Parent.setIsDiagram(true);
                        } else {
                            JNavigationTreeTable.this.m_Parent.setIsDiagram(false);
                        }
                    }
                    if (!JNavigationTreeTable.this.tree.isExpanded(treePath)) {
                        JNavigationTreeTable.this.getTree().expandPath(treePath);
                    } else {
                        JNavigationTreeTable.this.getTree().collapsePath(treePath);
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    JNavigationTreeTable.this.handleNavigation(treePath);
                }
            }
        }
    }
}

