/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.viewfactorysupport;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETCompartment;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETNodeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.INodeDrawEngine;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchive;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IEllipseCompartment;

public class ETEllipseCompartment
extends ETCompartment
implements IEllipseCompartment {
    protected int m_ellipseKind = -1;

    public ETEllipseCompartment() {
    }

    public ETEllipseCompartment(IDrawEngine iDrawEngine) {
        super(iDrawEngine);
    }

    public int getEllipseKind() {
        return this.m_ellipseKind;
    }

    public void setEllipseKind(int n) {
        this.m_ellipseKind = n;
    }

    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        try {
            ETSize eTSize = new ETSize(7, 7);
            this.internalSetOptimumSize(eTSize);
            return iDrawInfo == null ? this.getOptimumSize(bl) : this.scaleSize(eTSize, iDrawInfo.getTSTransform());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Color getBorderColor() {
        INodeDrawEngine iNodeDrawEngine = this.getEngine() instanceof INodeDrawEngine ? (INodeDrawEngine)this.getEngine() : null;
        return iNodeDrawEngine != null ? iNodeDrawEngine.getBorderColor() : Color.BLACK;
    }

    public Color getBkColor() {
        INodeDrawEngine iNodeDrawEngine = this.getEngine() instanceof INodeDrawEngine ? (INodeDrawEngine)this.getEngine() : null;
        return iNodeDrawEngine != null ? iNodeDrawEngine.getFillColor() : Color.DARK_GRAY;
    }

    public Color getLightGradientBkColor() {
        ETNodeDrawEngine eTNodeDrawEngine = this.getEngine() instanceof ETNodeDrawEngine ? (ETNodeDrawEngine)this.getEngine() : null;
        return eTNodeDrawEngine != null ? eTNodeDrawEngine.getLightGradientFillColor() : this.getBkColor();
    }

    public void draw(IDrawInfo iDrawInfo, IETRect iETRect) {
        try {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = iETRect != null ? iETRect.getRectangle() : null;
            if (iDrawInfo != null && rectangle != null) {
                super.draw(iDrawInfo, iETRect);
                Color color = this.getBorderColor();
                Color color2 = this.getBkColor();
                Color color3 = this.getLightGradientBkColor();
                float f = (float)iETRect.getCenterX();
                GradientPaint gradientPaint = new GradientPaint(f, iETRect.getBottom(), color2, f, iETRect.getTop(), color3);
                switch (this.getEllipseKind()) {
                    case -1: {
                        GDISupport.drawEllipse((Graphics2D)iDrawInfo.getTSEGraphics(), rectangle, color, gradientPaint);
                        break;
                    }
                    case 0: {
                        GDISupport.drawEllipse((Graphics2D)iDrawInfo.getTSEGraphics(), rectangle, color, Color.WHITE);
                        ETRect eTRect = new ETRect(rectangle);
                        eTRect.deflateRect((int)rectangle.getWidth() / 4, (int)rectangle.getHeight() / 4);
                        GDISupport.drawEllipse((Graphics2D)iDrawInfo.getTSEGraphics(), eTRect, color, gradientPaint);
                        break;
                    }
                    case 1: {
                        GDISupport.drawEllipse((Graphics2D)iDrawInfo.getTSEGraphics(), rectangle, color, gradientPaint);
                        Point point = iETRect.getTopLeft();
                        Point point2 = iETRect.getBottomLeft();
                        Point point3 = iETRect.getTopRight();
                        Point point4 = iETRect.getBottomRight();
                        GDISupport.drawLine((Graphics2D)iDrawInfo.getTSEGraphics(), point, point4, color, 1);
                        GDISupport.drawLine((Graphics2D)iDrawInfo.getTSEGraphics(), point3, point2, color, 1);
                        break;
                    }
                    case 2: {
                        GDISupport.drawEllipse((Graphics2D)iDrawInfo.getTSEGraphics(), rectangle, color, gradientPaint);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getCompartmentID() {
        return "EllipseCompartment";
    }

    public void readFromArchive(IProductArchive iProductArchive, IProductArchiveElement iProductArchiveElement) {
        try {
            super.readFromArchive(iProductArchive, iProductArchiveElement);
            this.setEllipseKind((int)iProductArchiveElement.getAttributeLong("EllipseKind"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public IProductArchiveElement writeToArchive(IProductArchive iProductArchive, IProductArchiveElement iProductArchiveElement) {
        try {
            IProductArchiveElement iProductArchiveElement2 = super.writeToArchive(iProductArchive, iProductArchiveElement);
            if (iProductArchiveElement2 != null) {
                iProductArchiveElement2.addAttributeLong("EllipseKind", this.getEllipseKind());
            }
            return iProductArchiveElement2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void initResources() {
        super.initResources();
    }
}

