/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.viewfactorysupport;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETStrokeCache;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.ETArrowHeadFactory;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETArrowHead;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETEdge;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETEdgeUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDISupport {
    private static final int SMALLEST_TEXT = 3;
    protected static ETStrokeCache m_stokeCache = new ETStrokeCache();

    public static void fillRectangle(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void fillRectangle(Graphics2D graphics2D, IETRect iETRect, Color color) {
        Color color2 = graphics2D.getColor();
        graphics2D.setColor(color);
        GDISupport.fillRectangle(graphics2D, iETRect);
        graphics2D.setColor(color2);
    }

    public static void fillRectangle(Graphics2D graphics2D, IETRect iETRect) {
        graphics2D.fillRect(iETRect.getLeft(), iETRect.getTop(), (int)iETRect.getWidth(), (int)iETRect.getHeight());
    }

    public static void frameRectangle(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void frameRectangle(Graphics2D graphics2D, IETRect iETRect) {
        graphics2D.draw(iETRect.getRectangle());
    }

    public static void frameRectangle(Graphics2D graphics2D, IETRect iETRect, int n, int n2, Color color) {
        Color color2 = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(color);
        graphics2D.setStroke(GDISupport.getLineStroke(n, n2));
        GDISupport.frameRectangle(graphics2D, iETRect);
        graphics2D.setColor(color2);
        graphics2D.setStroke(stroke);
    }

    public static void drawRectangle(Graphics2D graphics2D, Rectangle rectangle) {
        GDISupport.fillRectangle(graphics2D, rectangle);
        GDISupport.frameRectangle(graphics2D, rectangle);
    }

    public static void drawRectangle(Graphics2D graphics2D, Rectangle rectangle, Paint paint, Paint paint2) {
        GDISupport.drawRectangle(graphics2D, rectangle, paint, paint2, GDISupport.getLineStroke(0, 1.0f));
    }

    public static void drawDashedRectangle(Graphics2D graphics2D, Rectangle rectangle, Paint paint, Paint paint2) {
        GDISupport.drawRectangle(graphics2D, rectangle, paint, paint2, GDISupport.getLineStroke(1, 1.0f));
    }

    public static void drawHatchedRectangle(Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2) {
        GDISupport.drawRectangle(graphics2D, rectangle, color, color2, GDISupport.getLineStroke(4, 1.0f));
    }

    public static void drawRectangle(Graphics2D graphics2D, Rectangle rectangle, Paint paint, Paint paint2, Stroke stroke) {
        Paint paint3 = graphics2D.getPaint();
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setStroke(stroke);
        if (paint2 != null) {
            graphics2D.setPaint(paint2);
            graphics2D.fill(rectangle);
        }
        graphics2D.setPaint(paint);
        graphics2D.draw(rectangle);
        graphics2D.setPaint(paint3);
        graphics2D.setStroke(stroke2);
    }

    public static void frameEllipse(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void fillEllipse(Graphics2D graphics2D, Rectangle rectangle) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.fill(float_);
    }

    public static void drawEllipse(Graphics2D graphics2D, Rectangle rectangle) {
        GDISupport.fillEllipse(graphics2D, rectangle);
        Color color = graphics2D.getColor();
        graphics2D.setColor(TSEColor.black.getColor());
        GDISupport.frameEllipse(graphics2D, rectangle);
        graphics2D.setColor(color);
    }

    public static void drawEllipse(Graphics2D graphics2D, Rectangle rectangle, Paint paint, Paint paint2) {
        GDISupport.drawEllipse(graphics2D, rectangle, paint, paint2, GDISupport.getLineStroke(0, 1.0f));
    }

    public static void drawEllipse(Graphics2D graphics2D, Rectangle rectangle, Paint paint, Paint paint2, Stroke stroke) {
        Paint paint3 = graphics2D.getPaint();
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setPaint(paint2);
        GDISupport.fillEllipse(graphics2D, rectangle);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        GDISupport.frameEllipse(graphics2D, rectangle);
        graphics2D.setPaint(paint3);
        graphics2D.setStroke(stroke2);
    }

    public static void drawDashedEllipse(Graphics2D graphics2D, Rectangle rectangle, Paint paint, Paint paint2) {
        GDISupport.drawEllipse(graphics2D, rectangle, paint, paint2, GDISupport.getLineStroke(1, 1.0f));
    }

    public static void drawRoundRect(Graphics2D graphics2D, Rectangle rectangle, double d, Paint paint, Paint paint2) {
        GDISupport.drawRoundRect(graphics2D, rectangle, d, paint, paint2, GDISupport.getLineStroke(0, 1.0f));
    }

    public static void drawRoundRect(Graphics2D graphics2D, Rectangle rectangle, double d, Paint paint, Paint paint2, Stroke stroke) {
        Paint paint3 = graphics2D.getPaint();
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setPaint(paint2);
        GDISupport.fillRoundRect(graphics2D, rectangle, d);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        GDISupport.frameRoundRect(graphics2D, rectangle, d);
        graphics2D.setPaint(paint3);
        graphics2D.setStroke(stroke2);
    }

    public static void frameRoundRect(Graphics2D graphics2D, Rectangle rectangle, double d) {
        graphics2D.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 15, 15);
    }

    public static void fillRoundRect(Graphics2D graphics2D, Rectangle rectangle, double d) {
        graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 15, 15);
    }

    public static void drawRoundRect(Graphics2D graphics2D, Rectangle rectangle, double d, Color color, Color color2, Stroke stroke) {
        Color color3 = graphics2D.getColor();
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setColor(color2);
        GDISupport.fillRoundRect(graphics2D, rectangle, d);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        GDISupport.frameRoundRect(graphics2D, rectangle, d);
        graphics2D.setColor(color3);
        graphics2D.setStroke(stroke2);
    }

    public static void drawDashedRoundRect(Graphics2D graphics2D, Rectangle rectangle, double d, Color color, Paint paint) {
        GDISupport.drawRoundRect(graphics2D, rectangle, d, (Paint)color, paint, GDISupport.getLineStroke(1, 1.0f));
    }

    public static void drawRoundRect(Graphics2D graphics2D, Rectangle rectangle, double d, Color color, Paint paint) {
        GDISupport.drawRoundRect(graphics2D, rectangle, d, (Paint)color, paint, GDISupport.getLineStroke(0, 1.0f));
    }

    public static void drawRoundRect(Graphics2D graphics2D, Rectangle rectangle, double d) {
        GDISupport.drawRoundRect(graphics2D, rectangle, d, TSEColor.black.getColor(), (Paint)graphics2D.getColor());
    }

    public static void drawRoundOnTopRect(Graphics2D graphics2D, Rectangle rectangle, double d, Color color, Color color2) {
    }

    public static void drawRoundOnTopRect(Graphics2D graphics2D, Rectangle rectangle, double d) {
    }

    public static void drawLine(Graphics2D graphics2D, Point point, Point point2, Stroke stroke) {
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setStroke(stroke);
        graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        graphics2D.setStroke(stroke2);
    }

    public static void drawLine(Graphics2D graphics2D, Point point, Point point2, Color color, Stroke stroke) {
        Color color2 = graphics2D.getColor();
        graphics2D.setColor(color);
        GDISupport.drawLine(graphics2D, point, point2, stroke);
        graphics2D.setColor(color2);
    }

    public static void drawLine(Graphics2D graphics2D, Point point, Point point2, Color color, int n, int n2) {
        GDISupport.drawLine(graphics2D, point, point2, color, GDISupport.getLineStroke(n2, n));
    }

    public static void drawLine(Graphics2D graphics2D, Point point, Point point2, Color color, int n) {
        GDISupport.drawLine(graphics2D, point, point2, color, GDISupport.getLineStroke(0, n));
    }

    public static void drawLine(Graphics2D graphics2D, Point point, Point point2) {
        graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public static void drawDashedLine(Graphics2D graphics2D, Point point, Point point2, Color color) {
        GDISupport.drawLine(graphics2D, point, point2, color, GDISupport.getLineStroke(1, 1.0f));
    }

    public static void drawDottedLine(Graphics2D graphics2D, Point point, Point point2, Color color) {
        GDISupport.drawLine(graphics2D, point, point2, color, GDISupport.getLineStroke(2, 1.0f));
    }

    public static void drawPolyLine(Graphics2D graphics2D, ETList<IETPoint> eTList, Color color, int n) {
        Color color2 = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(GDISupport.getLineStroke(0, n));
        graphics2D.setColor(color);
        GDISupport.drawPolyLine(graphics2D, eTList, color);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color2);
    }

    public static void drawPolyLine(Graphics2D graphics2D, ETList<IETPoint> eTList, Color color) {
        if (eTList == null || eTList.size() < 2) {
            return;
        }
        Color color2 = graphics2D.getColor();
        graphics2D.setColor(color);
        GeneralPath generalPath = GDISupport.getPolyline(eTList);
        if (generalPath != null) {
            graphics2D.draw(generalPath);
        }
        graphics2D.setColor(color2);
    }

    public static void drawPolyLine(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        Color color2 = graphics2D.getColor();
        GDISupport.fillRectangle(graphics2D, rectangle);
        graphics2D.setColor(color2);
    }

    public static GeneralPath getPolyline(ETList<IETPoint> eTList) {
        if (eTList == null || eTList.size() < 2) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(0);
        Iterator iterator = eTList.iterator();
        IETPoint iETPoint = (IETPoint)iterator.next();
        generalPath.moveTo(iETPoint.getX(), iETPoint.getY());
        while (iterator.hasNext()) {
            iETPoint = (IETPoint)iterator.next();
            generalPath.lineTo(iETPoint.getX(), iETPoint.getY());
        }
        return generalPath;
    }

    public static GeneralPath getPolygon(ETList<IETPoint> eTList) {
        GeneralPath generalPath = GDISupport.getPolyline(eTList);
        if (generalPath != null) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public static void framePolygon(Graphics2D graphics2D, ETList<IETPoint> eTList) {
        GDISupport.framePolygon(graphics2D, GDISupport.getPolygon(eTList));
    }

    public static void framePolygon(Graphics2D graphics2D, GeneralPath generalPath) {
        if (generalPath != null) {
            graphics2D.draw(generalPath);
        }
    }

    public static void fillPolygon(Graphics2D graphics2D, ETList<IETPoint> eTList) {
        GDISupport.fillPolygon(graphics2D, GDISupport.getPolygon(eTList));
    }

    public static void fillPolygon(Graphics2D graphics2D, GeneralPath generalPath) {
        if (generalPath != null) {
            graphics2D.fill(generalPath);
        }
    }

    public static void drawPolygon(Graphics2D graphics2D, ETList<IETPoint> eTList, Color color, Color color2, Stroke stroke) {
        GDISupport.drawPolygon(graphics2D, GDISupport.getPolygon(eTList), color, color2, stroke);
    }

    public static void drawPolygon(Graphics2D graphics2D, ETList<IETPoint> eTList, Color color, int n, Color color2) {
        GDISupport.drawPolygon(graphics2D, eTList, color, color2, GDISupport.getLineStroke(0, n));
    }

    public static void drawPolygon(Graphics2D graphics2D, ETList<IETPoint> eTList, Color color, Color color2) {
        Stroke stroke = graphics2D.getStroke() != null ? graphics2D.getStroke() : GDISupport.getLineStroke(0, 1.0f);
        GDISupport.drawPolygon(graphics2D, eTList, color, color2, stroke);
    }

    public static void drawPolygon(Graphics2D graphics2D, GeneralPath generalPath, Color color, Color color2) {
        Stroke stroke = graphics2D.getStroke() != null ? graphics2D.getStroke() : GDISupport.getLineStroke(0, 1.0f);
        GDISupport.drawPolygon(graphics2D, generalPath, color, color2, stroke);
    }

    public static void drawPolygon(Graphics2D graphics2D, ETList<IETPoint> eTList, Paint paint, int n, Paint paint2) {
        GDISupport.drawPolygon(graphics2D, GDISupport.getPolygon(eTList), paint, paint2, GDISupport.getLineStroke(0, n));
    }

    public static void drawPolygon(Graphics2D graphics2D, ETList<IETPoint> eTList, Paint paint, Paint paint2) {
        GDISupport.drawPolygon(graphics2D, GDISupport.getPolygon(eTList), paint, paint2, GDISupport.getLineStroke(0, 1.0f));
    }

    public static void drawPolygon(Graphics2D graphics2D, GeneralPath generalPath, Paint paint, Paint paint2, Stroke stroke) {
        Paint paint3 = graphics2D.getPaint();
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setPaint(paint2);
        GDISupport.fillPolygon(graphics2D, generalPath);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        GDISupport.framePolygon(graphics2D, generalPath);
        graphics2D.setPaint(paint3);
        graphics2D.setStroke(stroke2);
    }

    public static void drawPolygon(Graphics2D graphics2D, GeneralPath generalPath, Color color, Color color2, Stroke stroke) {
        Color color3 = graphics2D.getColor();
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setColor(color2);
        GDISupport.fillPolygon(graphics2D, generalPath);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        GDISupport.framePolygon(graphics2D, generalPath);
        graphics2D.setColor(color3);
        graphics2D.setStroke(stroke2);
    }

    public static IETSize getTextExtent(Graphics2D graphics2D, Font font, String string) {
        return graphics2D != null && font != null ? GDISupport.getTextExtent(graphics2D.getFontMetrics(font), string) : null;
    }

    public static IETSize getTextExtent(Graphics2D graphics2D, String string) {
        return graphics2D != null ? GDISupport.getTextExtent(graphics2D.getFontMetrics(), string) : null;
    }

    public static IETSize getTextExtent(FontMetrics fontMetrics, String string) {
        if (fontMetrics != null && string != null) {
            int n = fontMetrics.getMaxAdvance() / 2;
            return new ETSize(fontMetrics.stringWidth(string) + n, fontMetrics.getHeight());
        }
        return null;
    }

    public static void drawText(Graphics2D graphics2D, Font font, String string, IETRect iETRect) {
        if (graphics2D != null) {
            Font font2 = graphics2D.getFont();
            graphics2D.setFont(font);
            GDISupport.drawText(graphics2D, string, iETRect);
            graphics2D.setFont(font2);
        }
    }

    public static void drawText(Graphics2D graphics2D, String string, IETRect iETRect) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (fontMetrics != null && iETRect.getHeight() > 3.0) {
            Color color = graphics2D.getColor();
            int n = iETRect.getLeft() + fontMetrics.getMaxAdvance() / 4;
            int n2 = (int)((double)iETRect.getTop() + iETRect.getHeight()) - fontMetrics.getMaxDescent();
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, n, n2);
            graphics2D.setColor(color);
        }
    }

    public static ETList<IETPoint> getDiamondPolygonPoints(Graphics2D graphics2D, Rectangle rectangle) {
        ETRect eTRect = new ETRect(rectangle);
        int n = Math.max(eTRect.getTop(), eTRect.getBottom());
        int n2 = Math.min(eTRect.getTop(), eTRect.getBottom());
        int n3 = Math.max(eTRect.getLeft(), eTRect.getRight());
        int n4 = Math.min(eTRect.getLeft(), eTRect.getRight());
        ETPoint eTPoint = new ETPoint(n4 + (int)(eTRect.getWidth() / 2.0), n2 + (int)eTRect.getHeight());
        ETPoint eTPoint2 = new ETPoint(n4 + (int)(eTRect.getWidth() / 2.0), n + (int)eTRect.getHeight());
        ETPoint eTPoint3 = new ETPoint(n4, n + (int)(eTRect.getHeight() / 2.0));
        ETPoint eTPoint4 = new ETPoint(n3, eTPoint3.getY());
        ETArrayList<IETPoint> eTArrayList = new ETArrayList<IETPoint>();
        eTArrayList.add(eTPoint);
        eTArrayList.add(eTPoint3);
        eTArrayList.add(eTPoint2);
        eTArrayList.add(eTPoint4);
        eTArrayList.add(eTPoint);
        return eTArrayList;
    }

    public static GeneralPath getDiamondPolygon(Graphics2D graphics2D, Rectangle rectangle) {
        return GDISupport.getPolygon(GDISupport.getDiamondPolygonPoints(graphics2D, rectangle));
    }

    public static Stroke getLineStroke(int n, float f) {
        return m_stokeCache.getStroke(n, f);
    }

    public static void drawArrowHead(IDrawInfo iDrawInfo, IETEdge iETEdge, IETEdgeUI iETEdgeUI, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2, int n, Color color, Color color2) {
        boolean bl = iETEdge != null ? iETEdge.isSelected() : false;
        IETArrowHead iETArrowHead = ETArrowHeadFactory.create(n);
        TSEColor tSEColor = new TSEColor(bl ? color2 : color);
        if (iETArrowHead != null) {
            iETArrowHead.draw(iDrawInfo, tSConstPoint, tSConstPoint2, tSEColor);
        }
    }
}

