/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.wizard;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProxyUserInterface;

public abstract class ETModalWizardThread {
    protected Thread m_pThread = null;
    protected Runnable m_pRunnable = null;
    protected boolean m_bLockFrameInput = true;

    public ETModalWizardThread(Runnable runnable) {
        this.m_pRunnable = runnable;
    }

    protected ETModalWizardThread() {
    }

    protected Thread getThread() {
        return this.m_pThread;
    }

    protected Frame getOwnerFrame() {
        IProxyUserInterface iProxyUserInterface = ProductHelper.getProxyUserInterface();
        return iProxyUserInterface != null ? iProxyUserInterface.getWindowHandle() : null;
    }

    public void start() {
        this.start(this.m_bLockFrameInput);
    }

    public void start(boolean bl) {
        this.m_bLockFrameInput = bl;
        if (this.getRunnable() != null) {
            Thread thread = new Thread(this.getRunnable());
            thread.setPriority(this.getDefaultPrioity());
            if (this.m_bLockFrameInput && this.getOwnerFrame() != null) {
                this.getOwnerFrame().setEnabled(false);
            }
            thread.start();
            Component component = this.getComponent();
            if (component != null) {
                component.addComponentListener(new ProgreessMoveListener());
            } else if (this.getOwnerFrame() != null) {
                this.getOwnerFrame().setEnabled(true);
                this.getOwnerFrame().setVisible(true);
            }
        }
    }

    protected int getDefaultPrioity() {
        return 5;
    }

    protected abstract Component getComponent();

    protected Runnable getRunnable() {
        return this.m_pRunnable;
    }

    public class ProgreessMoveListener
    implements ComponentListener {
        public void componentResized(ComponentEvent componentEvent) {
            ETSystem.out.println("ETModalWizardThread componentResized");
            this.repaintFrame();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            ETSystem.out.println("ETModalWizardThread componentMoved");
            this.repaintFrame();
        }

        public void componentShown(ComponentEvent componentEvent) {
            ETSystem.out.println("ETModalWizardThread componentShown");
            this.repaintFrame();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            ETSystem.out.println("ETModalWizardThread componentHidden");
            if (ETModalWizardThread.this.m_bLockFrameInput && ETModalWizardThread.this.getOwnerFrame() != null) {
                ETModalWizardThread.this.getOwnerFrame().setEnabled(true);
                ETModalWizardThread.this.getOwnerFrame().setVisible(true);
                ETModalWizardThread.this.getOwnerFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
            if (componentEvent != null) {
                componentEvent.getComponent().removeComponentListener(this);
            }
        }

        protected void repaintFrame() {
            Frame frame = ETModalWizardThread.this.getOwnerFrame();
            if (frame != null) {
                frame.invalidate();
                Thread thread = Thread.currentThread();
                if (thread == ETModalWizardThread.this.getThread()) {
                    thread.yield();
                }
            }
        }
    }
}

