/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.commondialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.support.UserSettings;
import org.netbeans.modules.uml.ui.support.diagramsupport.IPresentationTarget;
import org.netbeans.modules.uml.ui.support.presentationnavigation.JNavigationTreeTable;
import org.netbeans.modules.uml.ui.support.presentationnavigation.NavigationTreeTableModel;
import org.netbeans.modules.uml.ui.swing.commondialogs.SwingNavigationDialog;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingNavigationView
extends JPanel {
    private IElement element;
    private JNavigationTreeTable treeTableView;
    private SwingNavigationDialog parent;
    private UserSettings settings = new UserSettings();
    private JLabel bottomLabel;
    private JPanel bottomPanel;
    private JLabel instructionLabel;
    private JScrollPane scrollPane;
    private JCheckBox shiftCheckBox;

    public SwingNavigationView(SwingNavigationDialog swingNavigationDialog) {
        this.parent = swingNavigationDialog;
        this.element = swingNavigationDialog.getElement();
        this.initComponents();
        this.setComponentValues();
    }

    public void setComponentValues() {
        String string = "";
        String string2 = "";
        if (this.parent.getIsProject()) {
            string2 = NbBundle.getMessage(SwingNavigationView.class, (String)"DS_PACKAGE_TITLE");
        } else {
            this.shiftCheckBox.setSelected(this.settings.isOnlyShowNavigateWhenShift(this.element));
            if (this.element instanceof INamedElement) {
                string = ((INamedElement)this.element).getName();
            }
            string2 = NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_TITLE");
            string2 = StringUtilities.replaceSubString(string2, "%s", string);
        }
        this.instructionLabel.setText(string2);
        this.instructionLabel.setLabelFor(this.treeTableView);
        this.instructionLabel.getAccessibleContext().setAccessibleName(string2);
        this.instructionLabel.getAccessibleContext().setAccessibleDescription(string2);
    }

    public void setOptions(int n) {
        this.shiftCheckBox.setEnabled(n == UserSettings.OPEN_OPTION);
    }

    public void buildList(ETList<IProxyDiagram> eTList, ETList<IPresentationTarget> eTList2, ETList<IProxyDiagram> eTList3, ETList<IElement> eTList4) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        int n;
        int n2;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        String string;
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Root");
        NavigationTreeTableModel navigationTreeTableModel = new NavigationTreeTableModel(defaultMutableTreeNode3, null);
        this.treeTableView = new JNavigationTreeTable((TreeTableModel)navigationTreeTableModel, this.parent);
        if (eTList != null && eTList.size() > 0) {
            string = "";
            string = this.element instanceof IProject ? NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_DIAGRAMS") : NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_SCOPEDDIAGRAMS");
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            n2 = eTList.size();
            for (n = 0; n < n2; ++n) {
                object = (IProxyDiagram)eTList.get(n);
                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
            }
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        }
        if (eTList2 != null && eTList2.size() > 0) {
            string = NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_TARGETS");
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            n2 = eTList2.size();
            for (n = 0; n < n2; ++n) {
                object = (IPresentationTarget)eTList2.get(n);
                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
            }
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        }
        if (eTList3 != null && eTList3.size() > 0) {
            string = NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_ASSOCIATEDDIAGRAMS");
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            n2 = eTList3.size();
            for (n = 0; n < n2; ++n) {
                object = (IProxyDiagram)eTList3.get(n);
                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
            }
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        }
        if (eTList4 != null) {
            string = NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_ASSOCIATEDELEMENTS");
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            n2 = eTList4.size();
            for (n = 0; n < n2; ++n) {
                object = (IElement)eTList4.get(n);
                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
            }
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        }
        this.treeTableView.updateUI();
        this.treeTableView.expandFirstLevelNodes();
        this.treeTableView.updateUI();
        this.treeTableView.addFocusListener(new TreeFocusHandler());
        this.treeTableView.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "LArrowKeysHandler");
        this.treeTableView.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "RArrowKeysHandler");
        this.treeTableView.getActionMap().put("LArrowKeysHandler", new KeyActionPerformer(37));
        this.treeTableView.getActionMap().put("RArrowKeysHandler", new KeyActionPerformer(39));
        this.treeTableView.getAccessibleContext().setAccessibleName("");
        this.treeTableView.getAccessibleContext().setAccessibleDescription("");
        this.scrollPane.setViewportView(this.treeTableView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOKAction() {
        try {
            TreePath treePath;
            this.setCursor(new Cursor(3));
            if (this.treeTableView != null && (treePath = this.treeTableView.getTree().getSelectionPath()) != null) {
                this.treeTableView.handleNavigation(treePath);
            }
            if (!this.parent.getIsProject()) {
                this.savePreferenceDefaults();
            }
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    public void savePreferenceDefaults() {
        UserSettings userSettings = new UserSettings();
        if (this.shiftCheckBox.isSelected()) {
            userSettings.setIsOnlyShowNavigateWhenShift(this.element, true);
            if (this.parent.getIsDiagram()) {
                userSettings.setDefaultDiagram(this.element, this.parent.getTargetXMIID());
            } else {
                userSettings.setDefaultPE(this.element, this.parent.getTargetXMIID());
            }
        } else {
            userSettings.setIsOnlyShowNavigateWhenShift(this.element, false);
            userSettings.clearDefaultTarget(this.element);
        }
    }

    private void initComponents() {
        this.instructionLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bottomPanel = new JPanel();
        this.bottomLabel = new JLabel();
        this.shiftCheckBox = new JCheckBox();
        this.instructionLabel.setText(NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_TITLE"));
        this.instructionLabel.setFocusable(false);
        this.scrollPane.setFocusable(false);
        this.bottomLabel.setText(NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_CHECKBOXTEXT"));
        this.bottomLabel.setFocusable(false);
        this.bottomLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_CHECKBOXTEXT"));
        this.bottomLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_CHECKBOXTEXT"));
        Mnemonics.setLocalizedText((AbstractButton)this.shiftCheckBox, (String)NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_CHECKBOX"));
        this.shiftCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.shiftCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.shiftCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_CHECKBOX"));
        this.shiftCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwingNavigationView.class, (String)"IDS_CHECKBOX"));
        GroupLayout groupLayout = new GroupLayout((Container)this.bottomPanel);
        this.bottomPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.bottomLabel, -1, 519, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.shiftCheckBox, -1, 507, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.bottomLabel).addPreferredGap(0).add((Component)this.shiftCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.bottomPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.scrollPane, -1, 519, Short.MAX_VALUE).add(1, (Component)this.instructionLabel, -1, 519, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.instructionLabel).addPreferredGap(0).add((Component)this.scrollPane, -2, 159, -2).addPreferredGap(0).add((Component)this.bottomPanel, -2, -1, -2).addContainerGap(60, Short.MAX_VALUE)));
    }

    class KeyActionPerformer
    extends AbstractAction {
        private int keyCode;

        public KeyActionPerformer(int n) {
            this.keyCode = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SwingNavigationView.this.treeTableView.getSelectedRow();
            if (n >= 0) {
                switch (this.keyCode) {
                    case 37: {
                        if (!SwingNavigationView.this.treeTableView.getTree().isExpanded(n)) break;
                        SwingNavigationView.this.treeTableView.getTree().collapseRow(n);
                        break;
                    }
                    case 39: {
                        if (SwingNavigationView.this.treeTableView.getTree().isExpanded(n)) break;
                        SwingNavigationView.this.treeTableView.getTree().expandRow(n);
                        break;
                    }
                }
                SwingNavigationView.this.treeTableView.updateUI();
                SwingNavigationView.this.treeTableView.getTree().setSelectionRow(n);
            }
        }
    }

    class TreeFocusHandler
    implements FocusListener {
        private TreePath selectedPath;

        TreeFocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component != null && component instanceof JNavigationTreeTable) {
                JNavigationTreeTable jNavigationTreeTable = (JNavigationTreeTable)component;
                if (this.selectedPath == null) {
                    this.selectedPath = jNavigationTreeTable.getTree().getPathForRow(0);
                }
                jNavigationTreeTable.getTree().setSelectionPath(this.selectedPath);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component != null && component instanceof JNavigationTreeTable) {
                JNavigationTreeTable jNavigationTreeTable = (JNavigationTreeTable)component;
                this.selectedPath = jNavigationTreeTable.getTree().getSelectionPath();
            }
        }
    }
}

