/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools;

import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.tool.TSEMoveSelectedTool;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSObject;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteractionOperand;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.controls.drawingarea.GetHelper;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.IADInteractionOperandCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.IADLifelineCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.LifelinePiece;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.IADSequenceDiagEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.INodeDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETPointEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETEdge;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IStretchContext;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.StretchContext;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDiagramEngine;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETHorzDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETHorzNoDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETVertDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETVertNoDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.ConnectorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartDragTool
extends TSEMoveSelectedTool {
    private static final boolean PREFERENCE_JUST_DRAG_MESSAGE = false;
    private boolean mDeep = false;
    private IDrawingAreaControl mDrawingAreaControl = null;
    private IStretchContext mStretchContext = null;
    private IETRect mRectRestrictedArea = null;
    private TSConstPoint m_LastXYPos = null;
    private TSEdge mDraggingEdge = null;
    private ETList<TSGraphObject> mResizeTSGraphObjects = new ETArrayList<TSGraphObject>();
    private ETList<ConnectorInfo> mDraggingConnectors = new ETArrayList<ConnectorInfo>();
    private ETList<TSGraphObject> mDraggingTSGraphObjects = new ETArrayList<TSGraphObject>();
    private LifelinePiece mPiece = null;
    private boolean mDragPieceTop = false;
    private TSEGraph mGraph = null;
    private IADInteractionOperandCompartment m_OperandCompartment = null;
    private int m_DragRestriction = 0;
    private TSConstPoint mPreviousMouseMove = null;
    private boolean mDragAffectsSiblings = true;

    public SmartDragTool(TSConstPoint tSConstPoint, IDrawingAreaControl iDrawingAreaControl, boolean bl) {
        super(iDrawingAreaControl != null ? iDrawingAreaControl.getGraphWindow().getCurrentTool() : null, tSConstPoint, false);
        this.mDrawingAreaControl = iDrawingAreaControl;
        this.setDeep(bl);
    }

    public void setResizeGraphObjects(ETList<TSGraphObject> eTList) {
        throw new RuntimeException("Method Not Implemented Yet.  Waiting for the AccordionTool.");
    }

    public void addDraggingConnector(TSConnector tSConnector, boolean bl, long l) {
        if (tSConnector != null) {
            ConnectorInfo connectorInfo = new ConnectorInfo(tSConnector, l);
            this.mDraggingConnectors.add(connectorInfo);
            TSGraphObject tSGraphObject = tSConnector.getOwner();
            this.addDraggingTSGraphObject(tSGraphObject);
        }
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        TSPoint tSPoint = new TSPoint(this.getAlignedWorldPoint(mouseEvent));
        this.setLastXYPos((TSConstPoint)tSPoint);
        StretchContext stretchContext = new StretchContext();
        this.setStretchContext(stretchContext);
        ETPointEx eTPointEx = new ETPointEx(this.getStartPoint());
        stretchContext.setStartPoint(eTPointEx);
        stretchContext.setFinishPoint(eTPointEx);
        ETRect eTRect = new ETRect(-9.223372036854776E18, 9.223372036854776E18, 9.223372036854776E18, -9.223372036854776E18);
        stretchContext.setRestrictedArea(eTRect);
        this.informResizeDrawEnginesAboutStretch();
        IETRect iETRect = stretchContext.getRestrictedArea();
        ETRect eTRect2 = new ETRect(-9.223372036854776E18, 9.223372036854776E18, 9.223372036854776E18, -9.223372036854776E18);
        if (!eTRect.equals(eTRect2)) {
            this.setRestrictedArea(eTRect);
        }
        this.setDragAffectsSiblings(mouseEvent.isControlDown());
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingAreaControl();
        if (iDrawingAreaControl != null) {
            TSPoint tSPoint = this.restrictPoint(this.getLastXYPos());
            IETPoint iETPoint = iDrawingAreaControl.logicalToDevicePoint(new ETPointEx((TSConstPoint)tSPoint));
            MouseEvent mouseEvent2 = mouseEvent;
            if (!tSPoint.equals((Object)this.getLastXYPos())) {
                mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), iETPoint.getX(), iETPoint.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            super.onMouseReleased(mouseEvent2);
            ETList<IETGraphObject> eTList = iDrawingAreaControl.getSelected3();
            long l = 0L;
            if (eTList != null) {
                for (IETGraphObject iETGraphObject : eTList) {
                    if (iETGraphObject == null) continue;
                    iETGraphObject.onGraphEvent(4);
                }
            }
            this.updateResizeNodes(3, (TSConstPoint)tSPoint);
            this.sendDraggingGraphObjectsMoveEvent();
            this.updateAssociatedCombinedFragment();
            this.getGraphWindow().invalidate();
            this.endCurrentOperation();
            if (eTList != null) {
                iDrawingAreaControl.onGraphEvent(3, new ETPointEx(this.getStartPoint()), iETPoint, eTList);
            }
        }
    }

    protected void init() {
        super.init();
        this.setLastXYPos(this.getStartPoint());
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint = this.getAlignedWorldPoint(mouseEvent);
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingAreaControl();
        if (iDrawingAreaControl != null) {
            TSPoint tSPoint = this.restrictPoint(tSConstPoint);
            boolean bl = tSPoint.equals((Object)this.mPreviousMouseMove);
            this.mPreviousMouseMove = tSPoint;
            if (!bl) {
                IETPoint iETPoint = iDrawingAreaControl.logicalToDevicePoint(new ETPointEx((TSConstPoint)tSPoint));
                MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), iETPoint.getX(), iETPoint.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                this.updateDraggingGraphObjects((TSConstPoint)tSPoint);
                this.updateResizeNodes(1, (TSConstPoint)tSPoint);
                super.onMouseDragged(mouseEvent2);
                iDrawingAreaControl.refresh(true);
                this.setLastXYPos(tSConstPoint);
            }
        }
    }

    public void cancelAction() {
        super.cancelAction();
        this.endCurrentOperation();
    }

    protected TSPoint restrictPoint(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = tSConstPoint != null ? new TSPoint(tSConstPoint) : new TSPoint(0.0, 0.0);
        TSConstPoint tSConstPoint2 = this.getStartPoint();
        Cursor cursor = null;
        Cursor cursor2 = null;
        switch (this.getDragRestrictionType()) {
            case 0: {
                break;
            }
            case 1: {
                tSPoint.setX(tSConstPoint2.getX());
                cursor = ETHorzDragCursor.getCursor();
                cursor2 = ETHorzNoDragCursor.getCursor();
                break;
            }
            case 2: {
                tSPoint.setY(tSConstPoint2.getY());
                cursor = ETVertDragCursor.getCursor();
                cursor2 = ETVertNoDragCursor.getCursor();
                break;
            }
            default: {
                Debug.assertFalse(false, "did we add another restriction");
            }
        }
        IETRect iETRect = this.getRestrictedArea();
        if (iETRect != null && !iETRect.contains((int)tSPoint.getX(), (int)tSPoint.getY())) {
            if (tSPoint.getX() < (double)iETRect.getLeft()) {
                tSPoint.setX((double)iETRect.getLeft());
                cursor = cursor2;
            }
            if (tSPoint.getX() > (double)iETRect.getRight()) {
                tSPoint.setX((double)iETRect.getRight());
                cursor = cursor2;
            }
            if (tSPoint.getY() > (double)iETRect.getTop()) {
                tSPoint.setY((double)iETRect.getTop());
                cursor = cursor2;
            }
            if (tSPoint.getY() < (double)iETRect.getBottom()) {
                tSPoint.setY((double)iETRect.getBottom());
                cursor = cursor2;
            }
        }
        if (this.getDraggingEdge() != null && cursor != null) {
            this.setCursor(cursor);
        }
        return tSPoint;
    }

    protected void endCurrentOperation() {
        this.setRestrictedArea(new ETRect(0, 0, 0, 0));
        this.setDraggingEdge(null);
        this.mResizeTSGraphObjects.clear();
        this.mDraggingConnectors.clear();
        this.mDraggingTSGraphObjects.clear();
        this.setPiece(null);
        this.setDragPieceTop(true);
    }

    protected void updateResizeNodes(int n, TSConstPoint tSConstPoint) {
        IStretchContext iStretchContext = this.getStretchContext();
        if (iStretchContext != null) {
            iStretchContext.setType(n);
            iStretchContext.setFinishPoint(new ETPointEx(tSConstPoint));
        }
        this.informResizeDrawEnginesAboutStretch();
    }

    protected void informResizeDrawEnginesAboutStretch() {
        IStretchContext iStretchContext = this.getStretchContext();
        for (TSGraphObject tSGraphObject : this.mResizeTSGraphObjects) {
            IDrawEngine iDrawEngine;
            if (tSGraphObject == null || !((iDrawEngine = TypeConversions.getDrawEngine((TSObject)tSGraphObject)) instanceof INodeDrawEngine)) continue;
            INodeDrawEngine iNodeDrawEngine = (INodeDrawEngine)iDrawEngine;
            iNodeDrawEngine.stretch(iStretchContext);
        }
    }

    protected void sendDraggingGraphObjectsMoveEvent() {
        for (TSGraphObject tSGraphObject : this.mDraggingTSGraphObjects) {
            IDrawEngine iDrawEngine;
            if (tSGraphObject == null || (iDrawEngine = TypeConversions.getDrawEngine((TSObject)tSGraphObject)) == null) continue;
            iDrawEngine.onGraphEvent(4);
        }
    }

    protected void updateDraggingGraphObjects(TSConstPoint tSConstPoint) {
        double d = tSConstPoint.getY();
        this.updateConnectors((long)d);
        this.updatePiece((int)d);
        if (this.getGraphWindow() != null) {
            this.getGraphWindow().invalidate();
        }
    }

    protected void updateConnectors(long l) {
        try {
            for (ConnectorInfo connectorInfo : this.mDraggingConnectors) {
                connectorInfo.moveConnector(l);
            }
        }
        catch (Throwable throwable) {
            this.mDraggingConnectors.clear();
        }
    }

    protected void updatePiece(int n) {
        LifelinePiece lifelinePiece = this.getPiece();
        if (lifelinePiece != null) {
            if (this.isDragPieceTop()) {
                lifelinePiece.setLogicalTop(n);
            } else {
                lifelinePiece.setLogicalBottom(n);
            }
        }
    }

    protected void showAllTSGraphObjects() {
        this.showAllTSGraphObjects(true);
    }

    protected void showAllTSGraphObjects(boolean bl) {
        this.showAllTSGraphObjects(this.mResizeTSGraphObjects, bl);
        this.showAllTSGraphObjects(this.mDraggingTSGraphObjects, bl);
    }

    protected void showAllTSGraphObjects(ETList<TSGraphObject> eTList, boolean bl) {
        boolean bl2 = bl;
        for (TSGraphObject tSGraphObject : eTList) {
            TSNode tSNode;
            if (tSGraphObject instanceof TSNode) {
                tSNode = (TSNode)tSGraphObject;
                tSNode.setVisible(bl2);
                continue;
            }
            if (!(tSGraphObject instanceof TSEdge)) continue;
            tSNode = (TSEdge)tSGraphObject;
            tSNode.setVisible(bl2);
        }
    }

    protected void invalidateAllTSGraphObjects() {
        this.invalidateAllTSGraphObjects(this.mResizeTSGraphObjects);
        this.invalidateAllTSGraphObjects(this.mDraggingTSGraphObjects);
    }

    protected void invalidateAllTSGraphObjects(ETList<TSGraphObject> eTList) {
        Iterator iterator = eTList.iterator();
        while (iterator.hasNext()) {
            IDrawEngine iDrawEngine = TypeConversions.getDrawEngine((TSObject)iterator.next());
            if (iDrawEngine == null) continue;
            iDrawEngine.invalidate();
        }
    }

    protected TSRect calculateTSGraphObjectsRect() {
        TSRect tSRect = new TSRect(0.0, 0.0, 0.0, 0.0);
        tSRect.merge((TSConstRect)GetHelper.calculateTSGraphObjectsRect(this.mResizeTSGraphObjects));
        tSRect.merge((TSConstRect)GetHelper.calculateTSGraphObjectsRect(this.mDraggingTSGraphObjects));
        return tSRect;
    }

    protected void addGraphObjectsToDraggingList(ETList<TSGraphObject> eTList, Class clazz) {
        if (eTList != null) {
            for (TSGraphObject tSGraphObject : eTList) {
                if (!clazz.isInstance(tSGraphObject)) continue;
                this.addDraggingTSGraphObject(tSGraphObject);
            }
        }
    }

    public void addDraggingTSGraphObject(TSGraphObject tSGraphObject) {
        this.addDraggingTSGraphObject(tSGraphObject, false);
    }

    public void addDraggingTSGraphObject(TSGraphObject tSGraphObject, boolean bl) {
        if (tSGraphObject != null && this.mDraggingEdge != null) {
            boolean bl2 = true;
            TSNode tSNode = this.mDraggingTSGraphObjects.iterator();
            while (tSNode.hasNext()) {
                TSGraphObject tSGraphObject2 = (TSGraphObject)tSNode.next();
                if (!tSGraphObject.equals(tSGraphObject2)) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                this.mDraggingTSGraphObjects.add(tSGraphObject);
                if (bl) {
                    if (tSGraphObject instanceof TSNode) {
                        tSNode = (TSNode)tSGraphObject;
                        tSNode.setVisible(false);
                    } else if (tSGraphObject instanceof TSEdge && (tSNode = (TSEdge)tSGraphObject) != null) {
                        tSNode.setVisible(false);
                    }
                }
            }
        }
    }

    protected void updateAssociatedCombinedFragment() {
        IADInteractionOperandCompartment iADInteractionOperandCompartment = this.getOperandCompartment();
        if (iADInteractionOperandCompartment != null) {
            iADInteractionOperandCompartment.expandToIncludeCoveredItems();
            this.setOperandCompartment(null);
        }
    }

    public void setDraggingEdge(TSEEdge tSEEdge, long l) {
        Object object;
        IDiagramEngine iDiagramEngine;
        if (tSEEdge == null) {
            throw new NullPointerException("The specified edge is null");
        }
        this.setDragAffectsSiblings(false);
        boolean bl = this.isDragAffectsSiblings();
        Debug.assertNull(this.mDraggingEdge);
        this.mDraggingEdge = tSEEdge;
        this.mDraggingConnectors.clear();
        this.mDraggingTSGraphObjects.clear();
        TSConnector tSConnector = tSEEdge.getSourceConnector();
        this.addDraggingConnector(tSConnector, bl, l);
        if (this.getDrawingAreaControl() != null && (iDiagramEngine = this.getDrawingAreaControl().getDiagramEngine()) instanceof IADSequenceDiagEngine) {
            object = (IADSequenceDiagEngine)iDiagramEngine;
            ETPairT<IInteractionOperand, ICompartment> eTPairT = object.getEdgesInteractionOperand((IETEdge)tSEEdge);
            IInteractionOperand iInteractionOperand = eTPairT.getParamOne();
            ICompartment iCompartment = eTPairT.getParamTwo();
            if (iCompartment != null) {
                this.setOperandCompartment(null);
                if (iCompartment instanceof IADInteractionOperandCompartment) {
                    this.setOperandCompartment((IADInteractionOperandCompartment)iCompartment);
                }
            }
        }
        if (bl) {
            this.addDraggingTSGraphObject((TSGraphObject)tSEEdge);
        } else {
            iDiagramEngine = tSEEdge.getSourceNode();
            object = tSEEdge.getTargetNode();
            this.addDraggingTSGraphObject((TSGraphObject)tSEEdge);
            this.addDraggingTSGraphObject((TSGraphObject)iDiagramEngine);
            this.addDraggingTSGraphObject((TSGraphObject)object);
        }
    }

    public void setDraggingPiece(LifelinePiece lifelinePiece, boolean bl) {
        if (lifelinePiece != null) {
            TSObject tSObject;
            this.setPiece(null);
            this.setPiece(lifelinePiece);
            this.setDragPieceTop(bl);
            IADLifelineCompartment iADLifelineCompartment = this.mPiece.getParentCompartment();
            if (iADLifelineCompartment != null && (tSObject = TypeConversions.getTSObject(iADLifelineCompartment)) instanceof TSGraphObject) {
                this.addDraggingTSGraphObject((TSGraphObject)tSObject);
            }
            for (int i = 0; i <= 3; ++i) {
                TSEdge tSEdge = lifelinePiece.getAttachedEdge(i);
                if (tSEdge == null) continue;
                this.addDraggingTSGraphObject((TSGraphObject)tSEdge);
            }
        }
    }

    public boolean isDeep() {
        return this.mDeep;
    }

    public void setDeep(boolean bl) {
        this.mDeep = bl;
    }

    public IDrawingAreaControl getDrawingAreaControl() {
        return this.mDrawingAreaControl;
    }

    public void setDrawingAreaControl(IDrawingAreaControl iDrawingAreaControl) {
        this.mDrawingAreaControl = iDrawingAreaControl;
    }

    public IStretchContext getStretchContext() {
        return this.mStretchContext;
    }

    public void setStretchContext(IStretchContext iStretchContext) {
        this.mStretchContext = iStretchContext;
    }

    public IETRect getRestrictedArea() {
        return this.mRectRestrictedArea;
    }

    public void setRestrictedArea(IETRect iETRect) {
        this.mRectRestrictedArea = iETRect;
    }

    public TSConstPoint getLastXYPos() {
        return this.m_LastXYPos;
    }

    public void setLastXYPos(TSConstPoint tSConstPoint) {
        this.m_LastXYPos = tSConstPoint;
    }

    public TSEdge getDraggingEdge() {
        return this.mDraggingEdge;
    }

    public void setDraggingEdge(TSEdge tSEdge) {
        this.mDraggingEdge = tSEdge;
    }

    public LifelinePiece getPiece() {
        return this.mPiece;
    }

    public void setPiece(LifelinePiece lifelinePiece) {
        this.mPiece = lifelinePiece;
    }

    public boolean isDragPieceTop() {
        return this.mDragPieceTop;
    }

    public void setDragPieceTop(boolean bl) {
        this.mDragPieceTop = bl;
    }

    public TSEGraph getGraph() {
        return this.mGraph;
    }

    public void setGraph(TSEGraph tSEGraph) {
        this.mGraph = tSEGraph;
    }

    public IADInteractionOperandCompartment getOperandCompartment() {
        return this.m_OperandCompartment;
    }

    public void setOperandCompartment(IADInteractionOperandCompartment iADInteractionOperandCompartment) {
        this.m_OperandCompartment = iADInteractionOperandCompartment;
    }

    public int getDragRestrictionType() {
        return this.m_DragRestriction;
    }

    public void setDragRestrictionType(int n) {
        this.m_DragRestriction = n;
    }

    public boolean isDragAffectsSiblings() {
        return this.mDragAffectsSiblings;
    }

    public void setDragAffectsSiblings(boolean bl) {
        this.mDragAffectsSiblings = bl;
    }

    public static class DR {
        public static final int NONE = 0;
        public static final int VERTICAL_MOVE_ONLY = 1;
        public static final int HORIZONTAL_MOVE_ONLY = 2;
    }
}

