/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.projecttree;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.VolatileImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.uml.core.scm.ISCMIntegrator;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeNode;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeDiagram;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeFolder;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeItem;
import org.netbeans.modules.uml.ui.swing.projecttree.ProjectTreeResources;

public class ProjectTreeRender
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private ImageIcon m_WarningIcon = null;

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof ITreeItem) {
            this.formatElementForObject(object);
            this.setIcon(this.getImage((ITreeItem)object, bl2));
        }
        this.selected = bl;
        if (bl) {
            this.setBackground(this.getBackgroundSelectionColor());
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setBackground(this.getBackgroundNonSelectionColor());
            this.setForeground(this.getTextNonSelectionColor());
        }
        return this;
    }

    protected Icon getImage(ITreeItem iTreeItem, boolean bl) {
        Icon icon = null;
        IProjectTreeItem iProjectTreeItem = iTreeItem.getData();
        if (iTreeItem instanceof ITreeFolder) {
            CommonResourceManager commonResourceManager = CommonResourceManager.instance();
            icon = commonResourceManager.getIconForElementType(iTreeItem.getName());
        } else if (iTreeItem instanceof ITreeDiagram) {
            ITreeDiagram iTreeDiagram = (ITreeDiagram)iTreeItem;
            CommonResourceManager commonResourceManager = CommonResourceManager.instance();
            icon = commonResourceManager.getIconForElementType(iTreeDiagram.getDiagramType());
        } else if (iProjectTreeItem.getModelElement() != null) {
            CommonResourceManager commonResourceManager = CommonResourceManager.instance();
            icon = commonResourceManager.getIconForDisp(iProjectTreeItem.getModelElement());
        } else if (iProjectTreeItem.isProject()) {
            CommonResourceManager commonResourceManager = CommonResourceManager.instance();
            icon = commonResourceManager.getIconForElementType("WSProject");
        } else if (iProjectTreeItem.isWorkspace()) {
            CommonResourceManager commonResourceManager = CommonResourceManager.instance();
            icon = iProjectTreeItem.getItemText().equals("DesignPatternCatalog") ? commonResourceManager.getIconForElementType("DesignPatternCatalog") : commonResourceManager.getIconForElementType("Workspace");
        } else {
            CommonResourceManager commonResourceManager = CommonResourceManager.instance();
            icon = commonResourceManager.getIconForElementType(iTreeItem.getName());
        }
        if (icon == null) {
            icon = this.createImage(this.m_WarningIcon, ProjectTreeResources.getString("ProjectTreeRender.Warning_Image_Path"));
        }
        return this.getIconWithOverlay(icon, iTreeItem);
    }

    private ImageIcon createImage(ImageIcon imageIcon, String string) {
        if (imageIcon == null) {
            imageIcon = new ImageIcon(string);
        }
        return imageIcon;
    }

    private void formatElementForObject(Object object) {
        String string = "";
        if (object instanceof ProjectTreeNode) {
            ProjectTreeNode projectTreeNode = (ProjectTreeNode)object;
            string = projectTreeNode.getDisplayedName();
        }
        if (string != null && string.length() > 0) {
            this.setText(string);
        }
    }

    protected Icon getOverlayIcon(IProjectTreeItem iProjectTreeItem) {
        Icon icon = null;
        ISCMIntegrator iSCMIntegrator = ProductHelper.getSCMIntegrator();
        if (iSCMIntegrator != null) {
            if (iProjectTreeItem.getItemText().equals("C")) {
                Debug.out.println("Here");
            }
            int n = iSCMIntegrator.getSCMMaskKind(iProjectTreeItem);
            icon = iSCMIntegrator.getSCMMask(n);
        }
        return icon;
    }

    protected Icon getIconWithOverlay(Icon icon, ITreeItem iTreeItem) {
        Icon icon2 = icon;
        if (!(iTreeItem instanceof ITreeFolder)) {
            Icon icon3 = this.getOverlayIcon(iTreeItem.getData());
            if (icon != null && icon3 != null) {
                GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[0].getConfigurations();
                VolatileImage volatileImage = graphicsConfigurationArray[0].createCompatibleVolatileImage(icon.getIconWidth(), icon.getIconHeight());
                Graphics graphics = ((Image)volatileImage).getGraphics();
                icon.paintIcon(this, graphics, 0, 0);
                int n = icon.getIconHeight() - icon3.getIconHeight();
                icon3.paintIcon(this, graphics, 0, n);
                icon2 = new ImageIcon(volatileImage);
            }
        }
        return icon2;
    }
}

