/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.testbed.addin.menu;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.netbeans.modules.uml.ui.products.ad.application.IMenuManager;
import org.netbeans.modules.uml.ui.products.ad.application.action.BaseAction;
import org.netbeans.modules.uml.ui.swing.testbed.addin.menu.Separator;
import org.netbeans.modules.uml.ui.swing.testbed.addin.menu.SubMenuManager;

public class TestBedMenuManager
implements IMenuManager {
    private JMenuBar m_MenuBar = null;
    private Hashtable<String, IMenuManager> m_SubMenus = new Hashtable();
    private Point m_Point = null;
    private Object m_ObjectClickedOn = null;
    private List m_Contributions = new ArrayList();
    private boolean isDirty = true;
    private char m_Mnemonic = '\u0000';
    private String m_Id = "";
    JMenu m_MenuItem = null;
    private String m_MenuText = "";
    private boolean m_RemoveAllWhenShown = false;
    private IMenuManager m_Parent;
    private boolean m_Visible = true;
    private HashMap itemMap = new HashMap();
    private boolean visible = true;
    private String m_Label = null;
    private IMenuManager parent;
    private BaseAction m_Action;

    public TestBedMenuManager() {
        this(true);
    }

    public TestBedMenuManager(IMenuManager iMenuManager) {
        this();
        this.m_Parent = iMenuManager;
        this.setVisible(iMenuManager.isVisible());
    }

    public TestBedMenuManager(String string, String string2) {
        this.setId(string2);
        this.setMenuText(string);
    }

    public TestBedMenuManager(IMenuManager iMenuManager, String string, String string2) {
        this.setId(string2);
        this.setMenuText(string);
        this.m_Parent = iMenuManager;
    }

    protected TestBedMenuManager(boolean bl) {
    }

    public JMenuBar createMenuBar() {
        if (!this.menuExist()) {
            this.setMenuBar(new JMenuBar());
        }
        this.update(false);
        return this.getMenuBar();
    }

    public JMenuBar getMenuBar() {
        return this.m_MenuBar;
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.m_MenuBar = jMenuBar;
    }

    public void setMenuItem(JMenu jMenu) {
        this.m_MenuItem = jMenu;
    }

    public JMenu getMenuItem() {
        return this.m_MenuItem;
    }

    public IMenuManager findMenuUsingPath(String string) {
        IMenuManager iMenuManager = null;
        Object object = this.findUsingPath(string);
        if (object instanceof IMenuManager) {
            iMenuManager = (IMenuManager)object;
        }
        return iMenuManager;
    }

    public Object findUsingPath(String string) {
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(47);
        if (n == -1) {
            return this.find(string);
        }
        string2 = string.substring(0, n);
        string3 = string.substring(n + 1);
        Object object = this.find(string2);
        if (object instanceof IMenuManager) {
            IMenuManager iMenuManager = (IMenuManager)object;
            return iMenuManager.findUsingPath(string3);
        }
        return null;
    }

    public boolean getRemoveAllWhenShown() {
        return this.m_RemoveAllWhenShown;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setRemoveAllWhenShown(boolean bl) {
        this.m_RemoveAllWhenShown = bl;
    }

    public void updateAll(boolean bl) {
        this.update(bl, true);
    }

    public void update(boolean bl) {
        this.update(bl, false);
    }

    public void update() {
        this.updateMenuItem();
    }

    public void fill(JMenu jMenu, int n) {
        if (this.isSeparator()) {
            jMenu.add(new JSeparator());
            return;
        }
        if (n >= 0) {
            this.m_MenuItem = new JMenu(this.getMenuText());
            if (this.getMnemonic() > '\u0000') {
                this.m_MenuItem.setMnemonic(this.getMnemonic());
            }
            jMenu.add(this.m_MenuItem);
        } else {
            this.m_MenuItem = new JMenu(this.getMenuText());
            jMenu.add(this.m_MenuItem);
        }
        this.initializeMenu();
        this.update(true);
    }

    public void fill(JMenuBar jMenuBar, int n) {
        if (this.m_MenuItem == null) {
            if (n >= 0) {
                this.m_MenuItem = new JMenu(this.getMenuText());
                if (this.getMnemonic() > '\u0000') {
                    this.m_MenuItem.setMnemonic(this.getMnemonic());
                }
                jMenuBar.add(this.m_MenuItem);
            } else {
                this.m_MenuItem = new JMenu(this.getMenuText());
                jMenuBar.add(this.m_MenuItem);
            }
            this.initializeMenu();
            this.update(true);
        }
    }

    public String getId() {
        return this.m_Id;
    }

    public void setId(String string) {
        this.m_Id = string;
    }

    public String getMenuText() {
        String string = this.m_MenuText;
        if (string == null || string.length() <= 0) {
            string = ((TestBedMenuManager)this.getParent()).getMenuText();
        }
        return string;
    }

    public void setMenuText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&' && i + 1 < string.length()) {
                c = string.charAt(++i);
                this.setMnemonic(c);
            }
            stringBuffer.append(c);
        }
        this.m_MenuText = stringBuffer.toString();
    }

    public void setMnemonic(char c) {
        this.m_Mnemonic = c;
    }

    public char getMnemonic() {
        char c = this.m_Mnemonic;
        if (c > '\u0000') {
            c = ((TestBedMenuManager)this.getParent()).getMnemonic();
        }
        return c;
    }

    public boolean isSeparator() {
        return false;
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    public void setParent(IMenuManager iMenuManager) {
        this.m_Parent = iMenuManager;
    }

    public void setVisible(boolean bl) {
        this.m_Visible = bl;
    }

    public IMenuManager createSubMenu(String string, String string2) {
        TestBedMenuManager testBedMenuManager = new TestBedMenuManager(string, string2);
        testBedMenuManager.setVisible(true);
        testBedMenuManager.setParent(this);
        SubMenuManager subMenuManager = new SubMenuManager(testBedMenuManager);
        subMenuManager.setLabel(string);
        subMenuManager.setVisible(true);
        this.m_SubMenus.put(string, subMenuManager);
        return subMenuManager;
    }

    public IMenuManager createOrGetSubMenu(String string, String string2) {
        IMenuManager iMenuManager = null;
        IMenuManager iMenuManager2 = this.m_SubMenus.get(string);
        if (iMenuManager2 == null) {
            iMenuManager = this.createSubMenu(string, string2);
            this.add(iMenuManager);
        } else {
            iMenuManager = iMenuManager2;
        }
        return iMenuManager;
    }

    protected void update(boolean bl, boolean bl2) {
        if (this.isDirty() || bl) {
            if (this.menuExist()) {
                Object[] objectArray = this.getItems();
                ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
                IMenuManager iMenuManager = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (object instanceof IMenuManager) {
                        IMenuManager iMenuManager2 = (IMenuManager)object;
                        if (!iMenuManager2.isVisible()) continue;
                        if (iMenuManager2.isSeparator()) {
                            iMenuManager = iMenuManager2;
                            continue;
                        }
                        if (iMenuManager != null) {
                            if (arrayList.size() > 0) {
                                arrayList.add(iMenuManager);
                            }
                            iMenuManager = null;
                        }
                        arrayList.add(object);
                        continue;
                    }
                    if (!(object instanceof BaseAction)) continue;
                    if (iMenuManager != null) {
                        if (arrayList.size() > 0) {
                            arrayList.add(iMenuManager);
                        }
                        iMenuManager = null;
                    }
                    arrayList.add(object);
                }
                this.updateMenu(bl, bl2, arrayList);
            }
        } else if (bl2) {
            Object[] objectArray = this.getItems();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof IMenuManager) {
                    IMenuManager iMenuManager = (IMenuManager)object;
                    if (!iMenuManager.isVisible()) continue;
                    iMenuManager.updateAll(bl);
                    continue;
                }
                if (!(object instanceof BaseAction)) continue;
                this.updateAll(bl);
            }
        }
        this.updateMenuItem();
    }

    protected void updateMenu(boolean bl, boolean bl2, List list) {
        int n = 0;
        for (Object e : list) {
            if (e instanceof IMenuManager) {
                IMenuManager iMenuManager = (IMenuManager)e;
                if (this.m_MenuBar != null) {
                    iMenuManager.fill(this.m_MenuBar, n);
                } else if (this.m_MenuItem != null) {
                    iMenuManager.fill(this.m_MenuItem, n);
                }
            } else if (e instanceof BaseAction && this.m_MenuBar == null && this.m_MenuItem != null) {
                this.m_MenuItem.add(((BaseAction)e).getActionComponent());
            }
            ++n;
        }
    }

    protected void updateMenuItem() {
    }

    private boolean menuExist() {
        boolean bl = false;
        if (this.m_MenuBar != null) {
            bl = true;
        } else if (this.m_MenuItem != null) {
            bl = true;
        }
        return bl;
    }

    private void initializeMenu() {
        this.markDirty();
    }

    public void setLocation(Point point) {
        this.m_Point = point;
    }

    public Point getLocation() {
        if (null == this.m_Point && this.m_Parent instanceof IMenuManager) {
            IMenuManager iMenuManager = this.m_Parent;
            this.m_Point = iMenuManager.getLocation();
        }
        return this.m_Point;
    }

    public void setContextObject(Object object) {
        this.m_ObjectClickedOn = object;
    }

    public Object getContextObject() {
        return this.m_ObjectClickedOn;
    }

    public void removeAll() {
        this.m_Contributions.clear();
        this.markDirty();
        this.m_SubMenus.clear();
    }

    public String getLabel() {
        return this.m_Label;
    }

    public void setLabel(String string) {
        this.m_Label = string;
        this.setMenuText(string);
    }

    public Object remove(String string) {
        Object object = this.find(string);
        if (object == null) {
            throw new IllegalArgumentException("can't find ID");
        }
        return this.remove(object);
    }

    public Object remove(Object object) {
        if (this.m_Contributions.remove(object)) {
            this.itemRemoved(object);
            return object;
        }
        return null;
    }

    public Object find(String string) {
        Object object = this.itemMap.get(string);
        if (object == null) {
            for (Object e : this.m_Contributions) {
                String string2;
                Object object2;
                if (e instanceof IMenuManager) {
                    object2 = (IMenuManager)e;
                    string2 = object2.getId();
                    if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                    object = object2;
                    break;
                }
                if (!(e instanceof BaseAction) || (string2 = ((BaseAction)(object2 = (BaseAction)e)).getId()) == null || !string2.equalsIgnoreCase(string)) continue;
                object = object2;
                break;
            }
        }
        return object;
    }

    public Object[] getItems() {
        Object[] objectArray = new Object[this.m_Contributions.size()];
        this.m_Contributions.toArray(objectArray);
        return objectArray;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isEmpty() {
        return this.m_Contributions.isEmpty();
    }

    public void markDirty() {
        this.setDirty(true);
    }

    protected void itemRemoved(Object object) {
        this.markDirty();
    }

    protected void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public void add(IMenuManager iMenuManager) {
        this.m_Contributions.add(iMenuManager);
        iMenuManager.setVisible(this.visible);
        this.itemAdded(iMenuManager);
        iMenuManager.setParent(this);
    }

    protected void itemAdded(IMenuManager iMenuManager) {
        this.markDirty();
    }

    public void fill(JToolBar jToolBar, int n) {
    }

    public IMenuManager getParent() {
        return this.m_Parent;
    }

    public void add(BaseAction baseAction) {
        this.m_Contributions.add(baseAction);
        baseAction.setMenuManager(this);
    }

    public void add(Separator separator, String string) {
        this.add(separator);
        this.itemMap.put(string, separator);
    }
}

