/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.trackbar;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputAdapter;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.dynamics.ILifeline;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.ui.controls.trackbar.TrackBarResource;
import org.netbeans.modules.uml.ui.support.ProjectTreeHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.trackbar.JTrackBar;
import org.netbeans.modules.uml.ui.swing.trackbar.TrackCoupling;
import org.netbeans.modules.uml.ui.swing.trackbar.TrackItem;

public class TrackCar
extends TrackItem
implements ActionListener {
    public static final String NAVIGATE_TO_CLASSIFIER = "NAVIGATE_TO_CLASSIFIER";
    public static final String NAVIGATE_TO_INSTANCE = "NAVIGATE_TO_INSTANCE";
    private IPresentationElement m_PresentationElement = null;
    private boolean m_IsOverrideMode = false;

    public TrackCar(JTrackBar jTrackBar, IPresentationElement iPresentationElement) {
        super(jTrackBar);
        this.setPresentationElement(iPresentationElement);
        this.setBackground(Color.WHITE);
        this.setBorder(new LineBorder(Color.BLACK));
        TrackItemMouseListener trackItemMouseListener = new TrackItemMouseListener();
        this.addMouseMotionListener(trackItemMouseListener);
        this.addMouseListener(trackItemMouseListener);
    }

    public String getXMIID(IPresentationElement iPresentationElement) {
        String string = "";
        if (iPresentationElement != null) {
            string = iPresentationElement.getXMIID();
        }
        return string;
    }

    public String getXMIID() {
        return this.getXMIID(this.getPresentationElement());
    }

    public IPresentationElement getPresentationElement() {
        return this.m_PresentationElement;
    }

    public void setPresentationElement(IPresentationElement iPresentationElement) {
        this.m_PresentationElement = iPresentationElement;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TrackCar) {
            TrackCar trackCar = (TrackCar)object;
            String string = this.getXMIID();
            if (string.equals(trackCar.getXMIID())) {
                bl = true;
            }
        }
        return bl;
    }

    public void resizeBasedOnPresentationElement(boolean bl) {
        Rectangle rectangle = this.determineBoundingRect();
        this.setBounds(rectangle);
        if (bl) {
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        if (this.hasFocus()) {
            graphics.setColor(SystemColor.textHighlight);
        } else {
            graphics.setColor(this.getBackground());
        }
        Rectangle rectangle = this.getBounds();
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        String string = this.getName();
        if (string != null && string.length() > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = rectangle.width / 2;
            int n2 = fontMetrics.stringWidth(string);
            int n3 = n - n2 / 2;
            if (this.hasFocus()) {
                graphics.setColor(SystemColor.textHighlightText);
            } else {
                graphics.setColor(SystemColor.textText);
            }
            graphics.drawString(string, n3, rectangle.height - 3 - fontMetrics.getDescent());
        }
        this.paintBorder(graphics);
        graphics.setColor(color);
    }

    protected void limitBoundingRect(Rectangle rectangle) {
        IETRect iETRect;
        if (rectangle != null && (iETRect = this.determinePresentationElementBoundingRect()) != null) {
            rectangle.x = iETRect.getIntX();
            rectangle.width = iETRect.getIntWidth();
        }
    }

    protected IETRect determinePresentationElementBoundingRect() {
        IDiagram iDiagram;
        IETRect iETRect;
        IETRect iETRect2 = null;
        IPresentationElement iPresentationElement = this.getPresentationElement();
        if (iPresentationElement != null && (iETRect = TypeConversions.getLogicalBoundingRect(iPresentationElement, false)) != null && (iDiagram = this.getTrackBar().getDiagram()) != null) {
            iETRect2 = iDiagram.logicalToDeviceRect(iETRect);
        }
        return iETRect2;
    }

    public void push(int n) {
        if (!this.IsOverrideConstraintsMode()) {
            super.push(n);
        } else {
            this.setLocation(this.getX() + n, this.getY());
        }
        this.movePresentation(n);
    }

    protected void movePresentation(int n) {
        INodePresentation iNodePresentation;
        IETRect iETRect;
        IPresentationElement iPresentationElement = this.getPresentationElement();
        if (iPresentationElement instanceof INodePresentation && (iETRect = (iNodePresentation = (INodePresentation)iPresentationElement).getBoundingRect()) != null) {
            int n2 = 21;
            int n3 = this.getX() + this.getWidth() / 2;
            iNodePresentation.moveTo(n3 + n - 2, this.getY(), n2);
        }
    }

    protected void fixConstraints() {
        TrackItem trackItem = this.getPreviousItem();
        TrackItem trackItem2 = this.getNextItem();
        trackItem2 = this.readjustNieghbors(trackItem, trackItem2);
        this.updateContraints(0);
        this.setPreviousItem(null);
        this.setNextItem(null);
        this.printPreviousItems(trackItem);
        this.printNextItems(trackItem2);
        this.getTrackBar().addCar(this, false);
        this.printPreviousItems(this.getPreviousItem());
        this.printNextItems(this.getNextItem());
    }

    protected void printNextItems(TrackItem trackItem) {
        for (TrackItem trackItem2 = trackItem; trackItem2 != null; trackItem2 = trackItem2.getNextItem()) {
            ETSystem.out.println(trackItem);
        }
    }

    protected void printPreviousItems(TrackItem trackItem) {
        for (TrackItem trackItem2 = trackItem; trackItem2 != null; trackItem2 = trackItem2.getPreviousItem()) {
            ETSystem.out.println(trackItem2);
        }
    }

    protected TrackItem readjustNieghbors(TrackItem trackItem, TrackItem trackItem2) {
        if (trackItem != null) {
            if (trackItem2 instanceof TrackCoupling) {
                TrackItem trackItem3 = trackItem2;
                if ((trackItem2 = trackItem2.getNextItem()) != null) {
                    trackItem2.setPreviousItem(this);
                }
                trackItem.setNextItem(this);
                trackItem3.setNextItem(null);
                trackItem3.setPreviousItem(null);
                this.getTrackBar().remove(trackItem3);
            }
            if (trackItem2 != null) {
                trackItem.setNextItem(trackItem2);
                trackItem2.setPreviousItem(trackItem);
            } else {
                trackItem.setNextItem(null);
                trackItem.setPreviousItem(null);
                this.getTrackBar().remove(trackItem);
            }
        } else if (trackItem2 != null) {
            TrackItem trackItem4 = trackItem2.getNextItem();
            if (trackItem4 != null) {
                trackItem4.setPreviousItem(null);
            }
            trackItem2.setNextItem(null);
            trackItem2.setPreviousItem(null);
            this.getTrackBar().remove(trackItem2);
        }
        if (trackItem != null) {
            trackItem.setBounds(trackItem.determineBoundingRect());
        }
        if (trackItem2 != null) {
            trackItem2.setBounds(trackItem2.determineBoundingRect());
        }
        return trackItem2;
    }

    public boolean IsOverrideConstraintsMode() {
        return this.m_IsOverrideMode;
    }

    public void setIsOverrideConstraintsMode(boolean bl) {
        this.m_IsOverrideMode = bl;
    }

    public void buildContextMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(this.getNavigateToInstance());
        jPopupMenu.add(this.getNavigateToClassifier());
    }

    protected JMenuItem getNavigateToClassifier() {
        JMenuItem jMenuItem = new JMenuItem(TrackBarResource.getString("TrackCar.Navigate_to_Classifier"), 67);
        jMenuItem.setActionCommand(NAVIGATE_TO_CLASSIFIER);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    protected JMenuItem getNavigateToInstance() {
        JMenuItem jMenuItem = new JMenuItem(TrackBarResource.getString("TrackCar.Navigate_to_Instance"), 73);
        jMenuItem.setActionCommand(NAVIGATE_TO_INSTANCE);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ILifeline iLifeline;
        IClassifier iClassifier;
        IElement iElement;
        String string = actionEvent.getActionCommand();
        if (string.equals(NAVIGATE_TO_INSTANCE)) {
            IDiagram iDiagram;
            JTrackBar jTrackBar = this.getTrackBar();
            if (jTrackBar != null && (iDiagram = jTrackBar.getDiagram()) != null) {
                iDiagram.centerPresentationElement(this.getPresentationElement(), true, true);
            }
        } else if (string.equals(NAVIGATE_TO_CLASSIFIER) && (iElement = TypeConversions.getElement(this.m_PresentationElement)) != null && iElement instanceof ILifeline && (iClassifier = (iLifeline = (ILifeline)iElement).getRepresentingClassifier()) != null) {
            ProjectTreeHelper.findElementInProjectTree(iClassifier);
        }
    }

    public class TrackItemMouseListener
    extends MouseInputAdapter {
        private static final int UNINIAILIZED = -1;
        private int xOffset = -1;

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.xOffset > -1) {
                int n = TrackCar.this.getX();
                int n2 = mouseEvent.getX() - this.xOffset;
                TrackCar.this.push(n2);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.xOffset = mouseEvent.getX();
            if ((mouseEvent.getModifiersEx() & 0x80) == 128) {
                TrackCar.this.setIsOverrideConstraintsMode(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.xOffset = -1;
            if (TrackCar.this.IsOverrideConstraintsMode()) {
                TrackCar.this.fixConstraints();
                TrackCar.this.setIsOverrideConstraintsMode(false);
            }
        }
    }
}

