/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.trackbar;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import org.netbeans.modules.uml.ui.controls.trackbar.TrackBarResource;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.swing.trackbar.JTrackBar;

public abstract class TrackItem
extends JComponent
implements Accessible {
    public static final int INSET_V = 3;
    private TrackItem m_PreviousItem = null;
    private TrackItem m_NextItem = null;
    private JTrackBar m_Bar = null;
    AccessibleContext accessibleContext;

    public TrackItem(JTrackBar jTrackBar) {
        this.setTrackBar(jTrackBar);
        this.addMouseListener(new MenuManagerMouseListener());
        this.addFocusListener(new TrackItemFocusListener());
        this.getInputMap(0).put(KeyStroke.getKeyStroke("shift F10"), "SHOW_CONTEXT_MENU");
        this.getActionMap().put("SHOW_CONTEXT_MENU", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackItem.this.showContextMenu(null);
            }
        });
    }

    public boolean isCoupling() {
        return false;
    }

    public Rectangle determineBoundingRect() {
        Border border;
        Rectangle rectangle = new Rectangle();
        JTrackBar jTrackBar = this.getTrackBar();
        this.limitBoundingRect(rectangle);
        if (jTrackBar != null) {
            rectangle.height = jTrackBar.getHeight() - 6;
            rectangle.y = 3;
        }
        if ((border = this.getBorder()) != null) {
            Insets insets = border.getBorderInsets(this);
            rectangle.x += insets.left + 1;
            rectangle.width += insets.right + 1;
        }
        return rectangle;
    }

    public JTrackBar getTrackBar() {
        return this.m_Bar;
    }

    public void setTrackBar(JTrackBar jTrackBar) {
        this.m_Bar = jTrackBar;
    }

    public void load(IProductArchiveElement iProductArchiveElement) {
    }

    public void save(IProductArchiveElement iProductArchiveElement) {
    }

    public TrackItem getNextItem() {
        return this.m_NextItem;
    }

    public void setNextItem(TrackItem trackItem) {
        this.m_NextItem = trackItem;
    }

    public TrackItem getPreviousItem() {
        return this.m_PreviousItem;
    }

    public void setPreviousItem(TrackItem trackItem) {
        this.m_PreviousItem = trackItem;
    }

    public void push(int n) {
        if (n != 0) {
            this.setLocation(this.getX() + n, this.getY());
            this.notifyNeighborsOfMove(n);
        }
    }

    public void updateContraints(int n) {
    }

    protected abstract void limitBoundingRect(Rectangle var1);

    protected void notifyNeighborsOfMove(int n) {
        TrackItem trackItem = this.getPreviousItem();
        TrackItem trackItem2 = this.getNextItem();
        if (trackItem != null) {
            if (n < 0) {
                trackItem.push(n);
            } else {
                trackItem.updateContraints(n);
            }
        }
        if (trackItem2 != null) {
            if (n > 0) {
                trackItem2.push(n);
            } else {
                trackItem2.updateContraints(n);
            }
        }
    }

    public String toString() {
        String string = "Track Item [";
        string = this.isCoupling() ? string + "Coupling" : string + "Car";
        string = string + "] " + this.getName();
        return string;
    }

    public boolean isBetweenSameNeighbors(TrackItem trackItem) {
        boolean bl = false;
        if (this.getPreviousItem() == trackItem.getPreviousItem() && this.getNextItem() == trackItem.getNextItem()) {
            bl = true;
        }
        return bl;
    }

    public void copyAttributes(TrackItem trackItem) {
    }

    public void showContextMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.buildContextMenu(jPopupMenu);
        int n = 0;
        int n2 = 0;
        if (mouseEvent != null) {
            n = mouseEvent.getX();
            n2 = mouseEvent.getY();
        }
        jPopupMenu.show(this, n, n2);
    }

    public void buildContextMenu(JPopupMenu jPopupMenu) {
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTrackItem();
        }
        return this.accessibleContext;
    }

    public class AccessibleTrackItem
    extends JComponent.AccessibleJComponent {
        public AccessibleTrackItem() {
            super(TrackItem.this);
        }

        public String getAccessibleName() {
            if (TrackItem.this.isCoupling()) {
                return TrackBarResource.getString("ACSN_TrackCoupling");
            }
            String string = TrackItem.this.getName();
            if (string == null || string.equals("")) {
                return TrackBarResource.getString("ACSN_TrackCarNoName");
            }
            return MessageFormat.format(TrackBarResource.getString("ACSN_TrackCar"), string);
        }

        public String getAccessibleDescription() {
            if (!TrackItem.this.isCoupling()) {
                return MessageFormat.format(TrackBarResource.getString("ACSD_TrackCar"), TrackItem.this.getName());
            }
            return this.getAccessibleName();
        }
    }

    public class TrackItemFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            TrackItem.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            TrackItem.this.repaint();
        }
    }

    public class MenuManagerKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
                TrackItem.this.showContextMenu(null);
                keyEvent.consume();
            }
        }
    }

    public class MenuManagerMouseListener
    extends MouseInputAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TrackItem.this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TrackItem.this.showContextMenu(mouseEvent);
            }
        }
    }
}

