/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.ui.swing.propertyeditor.PropertyEditorResources;
import org.netbeans.modules.uml.ui.swing.treetable.JDefaultMutableTreeNode;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableCellEditor;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableModel;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableModelAdapter;

public class JTreeTable
extends JTable
implements ActionListener {
    protected TreeTableCellRenderer tree;

    public JTreeTable(TreeTableModel treeTableModel) {
        this(treeTableModel, null);
    }

    public JTreeTable(TreeTableModel treeTableModel, TreeTableCellRenderer treeTableCellRenderer) {
        this.tree = treeTableCellRenderer != null ? treeTableCellRenderer : new TreeTableCellRenderer(treeTableModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(this.tree));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(this.getFont().getSize() + 5);
        this.setShowVerticalLines(true);
        this.doLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        if (string.equals(PropertyEditorResources.getString("PropertyEditor.Create_Menu"))) {
            // empty if block
        }
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.getColumnClass(n2) == TreeTableModel.class) {
            this.repaint(this.getCellRect(n, n2, false));
        }
        if (n2 == 1) {
            bl = false;
        }
        return bl;
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(this.tree));
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void sizeColumnsToFit(int n) {
        super.sizeColumnsToFit(n);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle rectangle = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public TreeTableCellRenderer getTree() {
        return this.tree;
    }

    public void expandNode(JDefaultMutableTreeNode jDefaultMutableTreeNode, boolean bl) {
        if (jDefaultMutableTreeNode != null) {
            int n = jDefaultMutableTreeNode.getRow();
            this.tree.expandNode(n, bl);
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JTreeTable.this.tree.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        public void reshape(int n, int n2, int n3, int n4) {
            int n5 = Math.max(n, this.offset);
            super.reshape(n5, n2, n3 - (n5 - n), n4);
        }
    }

    public class TreeTableDefaultCellEditor
    extends DefaultCellEditor {
        public TreeTableDefaultCellEditor() {
            super(new TreeTableTextField());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            TreeTableCellRenderer treeTableCellRenderer = JTreeTable.this.getTree();
            boolean bl2 = treeTableCellRenderer.isRootVisible();
            int n3 = bl2 ? n : n - 1;
            Rectangle rectangle = treeTableCellRenderer.getRowBounds(n3);
            int n4 = rectangle.x;
            TreeCellRenderer treeCellRenderer = treeTableCellRenderer.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                Object object2 = treeTableCellRenderer.getPathForRow(n3).getLastPathComponent();
                Icon icon = null;
                if (icon != null) {
                    n4 += ((DefaultTreeCellRenderer)treeCellRenderer).getIconTextGap() + icon.getIconWidth();
                }
            }
            ((TreeTableTextField)this.getComponent()).offset = n4;
            return component;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                if (mouseEvent.getModifiers() == 0 || mouseEvent.getModifiers() == 16) {
                    for (int i = JTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                        if (JTreeTable.this.getColumnClass(i) != TreeTableModel.class) continue;
                        MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                        break;
                    }
                }
                return false;
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected Border highlightBorder;

        public TreeTableCellRenderer() {
        }

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.putClientProperty("JTree.lineStyle", "Angled");
            this.setExpandsSelectedPaths(true);
            this.setScrollsOnExpand(true);
        }

        public void addMouseListener(MouseListener mouseListener) {
            super.addMouseListener(mouseListener);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, graphics, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            this.putClientProperty("JTree.lineStyle", "Angled");
            if (bl) {
                color2 = jTable.getSelectionBackground();
                color = jTable.getSelectionForeground();
            } else {
                color2 = jTable.getBackground();
                color = jTable.getForeground();
            }
            this.highlightBorder = null;
            if (JTreeTable.this.realEditingRow() == n && JTreeTable.this.getEditingColumn() == n2) {
                color2 = UIManager.getColor("Table.focusCellBackground");
                color = UIManager.getColor("Table.focusCellForeground");
            } else if (bl2) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
                if (JTreeTable.this.isCellEditable(n, n2)) {
                    color2 = UIManager.getColor("Table.focusCellBackground");
                    color = UIManager.getColor("Table.focusCellForeground");
                }
            }
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                TreePath treePath;
                Object object2;
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setLeafIcon(null);
                defaultTreeCellRenderer.setOpenIcon(null);
                defaultTreeCellRenderer.setClosedIcon(null);
                if (bl) {
                    defaultTreeCellRenderer.setTextSelectionColor(color);
                    defaultTreeCellRenderer.setBackgroundSelectionColor(color2);
                } else {
                    defaultTreeCellRenderer.setTextNonSelectionColor(color);
                    defaultTreeCellRenderer.setBackgroundNonSelectionColor(color2);
                }
                if (n2 == 1 && (object2 = (treePath = this.getPathForRow(n)).getLastPathComponent()) != null && object2 instanceof JDefaultMutableTreeNode) {
                    boolean bl3;
                    Object object3;
                    IPropertyElement iPropertyElement;
                    JDefaultMutableTreeNode jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object2;
                    Object object4 = jDefaultMutableTreeNode.getUserObject();
                    if (object4 != null && object4 instanceof IPropertyElement && (iPropertyElement = (IPropertyElement)object4) != null) {
                        object3 = iPropertyElement.getPropertyDefinition();
                        long l = object3.getMultiplicity();
                        if (l > 1L) {
                            Font font = defaultTreeCellRenderer.getFont();
                            this.setFont(font.deriveFont(1));
                        } else {
                            Font font = defaultTreeCellRenderer.getFont();
                            this.setFont(font.deriveFont(0));
                        }
                    }
                    if (bl3 = jDefaultMutableTreeNode.isRoot()) {
                        object3 = new Color(192, 192, 192);
                        this.setBackground((Color)object3);
                        defaultTreeCellRenderer.setBackgroundNonSelectionColor((Color)object3);
                        defaultTreeCellRenderer.setBackgroundSelectionColor((Color)object3);
                    } else {
                        this.setBackground(Color.WHITE);
                    }
                }
            }
            this.visibleRow = n;
            return this;
        }

        public void expandNode(int n, boolean bl) {
            TreePath treePath = this.getPathForRow(n);
            this.setExpandedState(treePath, bl);
        }
    }
}

