/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.app;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.impl.application.ApplicationProxy;
import org.netbeans.modules.j2ee.ddloaders.app.DDChangeEvent;
import org.netbeans.modules.j2ee.ddloaders.app.DDChangeListener;
import org.netbeans.modules.j2ee.ddloaders.app.DDChangesPanel;
import org.netbeans.modules.j2ee.ddloaders.app.EarDDUtils;
import org.netbeans.modules.j2ee.ddloaders.app.EarDataLoader;
import org.netbeans.modules.j2ee.ddloaders.app.EarDataNode;
import org.netbeans.modules.j2ee.ddloaders.common.DD2beansDataObject;
import org.netbeans.modules.j2ee.ddloaders.common.xmlutils.SAXParseError;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class EarDataObject
extends DD2beansDataObject
implements DDChangeListener,
ApplicationProxy.OutputProvider,
FileChangeListener,
ChangeListener {
    private Application ejbJar;
    private FileObject[] srcRoots;
    protected static final RequestProcessor RP = new RequestProcessor("XML Parsing");
    private static final long serialVersionUID = 8857563089355069362L;
    public static final String PROP_DOCUMENT_DTD = "documentDTD";
    private boolean unparsable = true;
    private Vector updates;
    private RequestProcessor.Task updateTask;
    private FileObjectObserver fileListener;
    private static final int HOME = 10;
    private static final int REMOTE = 20;
    private static final int LOCAL_HOME = 30;
    private static final int LOCAL = 40;
    private RequestProcessor.Task elementTask;
    private List deletedEjbNames;
    private List newFileNames;

    public EarDataObject(FileObject fileObject, EarDataLoader earDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)earDataLoader);
        this.init(fileObject, earDataLoader);
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public boolean isUnparsable() {
        return this.unparsable;
    }

    private void init(FileObject fileObject, EarDataLoader earDataLoader) {
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)validateXMLSupport);
        this.fileListener = new FileObjectObserver(fileObject);
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.addChangeListener((ChangeListener)this);
        }
        this.refreshSourceFolders();
    }

    private void refreshSourceFolders() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.addChangeListener((ChangeListener)this);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                EjbJar ejbJar = EjbJar.getEjbJar((FileObject)sourceGroupArray[i].getRootFolder());
                if (ejbJar == null || ejbJar.getDeploymentDescriptor() == null) continue;
                try {
                    FileObject fileObject = sourceGroupArray[i].getRootFolder();
                    arrayList.add(sourceGroupArray[i].getRootFolder());
                    FileSystem fileSystem = fileObject.getFileSystem();
                    fileSystem.removeFileChangeListener((FileChangeListener)this);
                    fileSystem.addFileChangeListener((FileChangeListener)this);
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
        }
        this.srcRoots = arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private String getPackageName(FileObject fileObject) {
        for (int i = 0; i < this.srcRoots.length; ++i) {
            String string = FileUtil.getRelativePath((FileObject)this.srcRoots[i], (FileObject)fileObject);
            if (string == null) continue;
            if (fileObject.getExt().length() > 0) {
                string = string.substring(0, string.length() - fileObject.getExt().length() - 1);
            }
            return string.replace('/', '.');
        }
        return null;
    }

    public Application getApplication() {
        if (this.ejbJar == null) {
            this.parsingDocument();
        }
        return this.ejbJar;
    }

    public Application getOriginalApplication() throws IOException {
        return DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
    }

    protected Node createNodeDelegate() {
        return new EarDataNode(this);
    }

    protected String getIconBaseForValidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/ejb/DDDataIcon.gif";
    }

    protected String getIconBaseForInvalidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/ejb/DDDataIcon1.gif";
    }

    public String getStringForValidDocument() {
        return NbBundle.getMessage(EarDataObject.class, (String)"LAB_deploymentDescriptor");
    }

    public String getStringForInvalidDocument(SAXParseError sAXParseError) {
        return NbBundle.getMessage(EarDataObject.class, (String)"TXT_errorOnLine", (Object)new Integer(sAXParseError.getErrorLine()));
    }

    protected String generateDocument() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.ejbJar.write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString("UTF8");
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        catch (IllegalStateException illegalStateException) {
            Logger.getLogger("global").log(Level.INFO, null, illegalStateException);
        }
        return byteArrayOutputStream.toString();
    }

    protected String updateDocument(Document document) {
        return null;
    }

    public void write(Application application) throws IOException {
        Application application2 = this.getApplication();
        if (application2 != null) {
            application2.merge((RootInterface)application, 2);
        }
        this.setNodeDirty(true);
    }

    public FileObject getTarget() {
        return this.getPrimaryFile();
    }

    protected SAXParseError updateNode(InputSource inputSource) throws IOException {
        if (this.ejbJar == null) {
            try {
                this.ejbJar = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
                this.firePropertyChange("propertySets", null, null);
                if (this.unparsable) {
                    this.unparsable = false;
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                if (!this.unparsable) {
                    this.unparsable = true;
                }
                return new SAXParseError(new SAXParseException(runtimeException.getMessage(), new LocatorImpl()));
            }
        }
        Application application = null;
        try {
            application = EarDDUtils.createApplication(inputSource);
            if (!this.ejbJar.getVersion().equals(application.getVersion())) {
                ((ApplicationProxy)this.ejbJar).setOriginal(application);
            }
            this.unparsable = false;
            if (application.getError() != null) {
                System.out.println(application.getError().getMessage());
            }
        }
        catch (SAXParseException sAXParseException) {
            if (!this.unparsable) {
                this.unparsable = true;
            }
            return new SAXParseError(sAXParseException);
        }
        catch (SAXException sAXException) {
            if (!this.unparsable) {
                this.unparsable = true;
            }
            throw new IOException();
        }
        if (application != null) {
            this.ejbJar.merge((RootInterface)application, 3);
        }
        return null;
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        DataObject dataObject = super.handleCopy(dataFolder);
        try {
            dataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        EarDataObject earDataObject = this;
        synchronized (earDataObject) {
            this.updates = null;
            if (this.updateTask != null) {
                this.updateTask.cancel();
            }
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploymentChange(DDChangeEvent dDChangeEvent) {
        EarDataObject earDataObject = this;
        synchronized (earDataObject) {
            if (this.updates == null) {
                this.updates = new Vector();
            }
            this.updates.addElement(dDChangeEvent);
        }
        if (this.updateTask == null) {
            this.updateTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Vector vector = null;
                    EarDataObject earDataObject = EarDataObject.this;
                    synchronized (earDataObject) {
                        if (!EarDataObject.this.isValid()) {
                            return;
                        }
                        if (EarDataObject.this.updates != null) {
                            vector = EarDataObject.this.updates;
                            EarDataObject.this.updates = null;
                        }
                    }
                    if (vector != null) {
                        EarDataObject.this.showDDChangesDialog(vector);
                    }
                }
            }, 2000, 1);
        } else {
            this.updateTask.schedule(2000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDDChangesDialog(List list) {
        String string;
        final Dialog[] dialogArray = new Dialog[]{null};
        final JButton jButton = new JButton(NbBundle.getMessage(EarDataObject.class, (String)"LAB_processButton"));
        jButton.setMnemonic(NbBundle.getMessage(EarDataObject.class, (String)"LAB_processButton_Mnemonic").charAt(0));
        jButton.setToolTipText(NbBundle.getMessage(EarDataObject.class, (String)"ACS_processButtonA11yDesc"));
        JButton jButton2 = new JButton(NbBundle.getMessage(EarDataObject.class, (String)"LAB_processAllButton"));
        jButton2.setMnemonic(NbBundle.getMessage(EarDataObject.class, (String)"LAB_processAllButton_Mnemonic").charAt(0));
        jButton2.setToolTipText(NbBundle.getMessage(EarDataObject.class, (String)"ACS_processAllButtonA11yDesc"));
        JButton jButton3 = new JButton(NbBundle.getMessage(EarDataObject.class, (String)"LAB_closeButton"));
        jButton3.setMnemonic(NbBundle.getMessage(EarDataObject.class, (String)"LAB_closeButton_Mnemonic").charAt(0));
        jButton3.setToolTipText(NbBundle.getMessage(EarDataObject.class, (String)"ACS_closeButtonA11yDesc"));
        final Object[] objectArray = new Object[]{jButton, jButton2};
        final Object[] objectArray2 = new Object[]{jButton3};
        String string2 = "";
        Project project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        if (project != null) {
            string = null;
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            if (projectInformation != null) {
                string2 = projectInformation.getName();
            }
        }
        string = NbBundle.getMessage(EarDataObject.class, (String)"MSG_SynchronizeCaption", (Object)string2);
        final DDChangesPanel dDChangesPanel = new DDChangesPanel(string, jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)dDChangesPanel, NbBundle.getMessage(EarDataObject.class, (String)"LAB_ConfirmDialog"), true, objectArray, (Object)jButton, 1, HelpCtx.DEFAULT_HELP, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (actionEvent.getSource() instanceof Component && !((Component)(object = SwingUtilities.getRoot((Component)actionEvent.getSource()))).isDisplayable()) {
                    return;
                }
                if (objectArray[0].equals(actionEvent.getSource())) {
                    int n;
                    int n2 = dDChangesPanel.changesList.getMinSelectionIndex();
                    for (int i = n = dDChangesPanel.changesList.getMaxSelectionIndex(); i >= n2; --i) {
                        if (!dDChangesPanel.changesList.isSelectedIndex(i)) continue;
                        DDChangeEvent dDChangeEvent = (DDChangeEvent)dDChangesPanel.listModel.getElementAt(i);
                        EarDataObject.this.processDDChangeEvent(dDChangeEvent);
                        dDChangesPanel.listModel.removeElementAt(i);
                    }
                    if (dDChangesPanel.listModel.isEmpty()) {
                        dialogArray[0].setVisible(false);
                    } else {
                        jButton.setEnabled(false);
                    }
                } else if (objectArray[1].equals(actionEvent.getSource())) {
                    object = dDChangesPanel.listModel.elements();
                    while (object.hasMoreElements()) {
                        EarDataObject.this.processDDChangeEvent((DDChangeEvent)object.nextElement());
                    }
                    dialogArray[0].setVisible(false);
                    dDChangesPanel.setChanges(null);
                } else if (objectArray2[0].equals(actionEvent.getSource())) {
                    dialogArray[0].setVisible(false);
                    dDChangesPanel.setChanges(null);
                }
            }
        });
        dialogDescriptor.setAdditionalOptions(objectArray2);
        jButton.setEnabled(false);
        jButton2.requestFocus();
        dDChangesPanel.setChanges(list);
        try {
            dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialogArray[0].setVisible(true);
        }
        finally {
            dialogArray[0].dispose();
        }
    }

    private void processDDChangeEvent(DDChangeEvent dDChangeEvent) {
        if (!this.isValid()) {
            return;
        }
        if (dDChangeEvent.getType() == 1) {
            String string = dDChangeEvent.getNewValue();
            String string2 = "/servlet/" + string;
        } else {
            this.updateDD(dDChangeEvent.getOldValue(), dDChangeEvent.getNewValue(), dDChangeEvent.getType());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(EarDataObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void elementCreated(String string) {
        EarDataObject earDataObject = this;
        synchronized (earDataObject) {
            if (this.newFileNames == null) {
                this.newFileNames = new ArrayList();
            }
            this.newFileNames.add(string);
        }
        if (this.elementTask == null) {
            this.elementTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    EarDataObject earDataObject;
                    if (EarDataObject.this.deletedEjbNames != null) {
                        for (int i = 0; i < EarDataObject.this.deletedEjbNames.size(); ++i) {
                            String string;
                            String string2 = string = (String)EarDataObject.this.deletedEjbNames.get(i);
                            int n = string.lastIndexOf(".");
                            if (n > 0) {
                                string2 = string.substring(n + 1);
                            }
                            boolean bl = false;
                            for (int j = 0; j < EarDataObject.this.newFileNames.size(); ++j) {
                                String string3;
                                String string4 = string3 = (String)EarDataObject.this.newFileNames.get(j);
                                int n2 = string3.lastIndexOf(".");
                                if (n2 > 0) {
                                    string4 = string3.substring(n2 + 1);
                                }
                                if (!string2.equals(string4)) continue;
                                bl = true;
                                DDChangeEvent dDChangeEvent = new DDChangeEvent(EarDataObject.this, EarDataObject.this, string, string3, 2);
                                EarDataObject.this.deploymentChange(dDChangeEvent);
                                EarDataObject earDataObject2 = EarDataObject.this;
                                synchronized (earDataObject2) {
                                    EarDataObject.this.newFileNames.remove(string3);
                                    break;
                                }
                            }
                            if (bl) continue;
                            DDChangeEvent dDChangeEvent = new DDChangeEvent(EarDataObject.this, EarDataObject.this, null, string, 3);
                            EarDataObject.this.deploymentChange(dDChangeEvent);
                        }
                        earDataObject = EarDataObject.this;
                        synchronized (earDataObject) {
                            EarDataObject.this.deletedEjbNames = null;
                        }
                    }
                    earDataObject = EarDataObject.this;
                    synchronized (earDataObject) {
                        EarDataObject.this.newFileNames = null;
                    }
                }
            }, 1500, 1);
        } else {
            this.elementTask.schedule(1500);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        String string = this.getPackageName(fileObject);
        if (string != null) {
            int n = string.lastIndexOf(".");
            String string2 = fileRenameEvent.getName();
            String string3 = (n >= 0 ? string.substring(0, n + 1) : "") + string2;
            Application application = this.getApplication();
            if (application.getStatus() == 0) {
                this.fireEvent(string3, string, 2);
            }
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        String string = this.getPackageName(fileObject);
        if (string != null) {
            boolean bl = false;
            if (this.newFileNames == null) {
                bl = this.fireEvent(null, string, 3);
            } else if (bl) {
                return;
            }
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        String string = this.getPackageName(fileObject);
        if (string != null) {
            this.elementCreated(string);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshSourceFolders();
    }

    private int getSpecificEvent(int n, int n2) {
        if (n == 2) {
            switch (n2) {
                case 10: {
                    return 5;
                }
                case 20: {
                    return 6;
                }
                case 30: {
                    return 7;
                }
                case 40: {
                    return 8;
                }
            }
        }
        if (n == 3) {
            switch (n2) {
                case 10: {
                    return 9;
                }
                case 20: {
                    return 10;
                }
                case 30: {
                    return 11;
                }
                case 40: {
                    return 12;
                }
            }
        }
        return -1;
    }

    private boolean fireEvent(String string, String string2, int n) {
        boolean bl = false;
        String string3 = null;
        int n2 = -1;
        string3 = n == 2 ? string : string2;
        if (bl) {
            assert (n2 > 0);
            DDChangeEvent dDChangeEvent = new DDChangeEvent(this, this, string, string2, n2);
            this.deploymentChange(dDChangeEvent);
        }
        return bl;
    }

    private void updateDD(String string, String string2, int n) {
        boolean bl = false;
        switch (n) {
            case 13: {
                if (string != null) break;
                return;
            }
            case 14: {
                if (string2 != null) break;
                return;
            }
            case 5: {
                if (string != null) break;
                return;
            }
            case 6: {
                if (string != null) break;
                return;
            }
            case 7: {
                if (string != null) break;
                return;
            }
            case 8: {
                if (string != null) break;
                return;
            }
            case 9: {
                if (string2 != null) break;
                return;
            }
            case 10: {
                if (string2 != null) break;
                return;
            }
            case 11: {
                if (string2 != null) break;
                return;
            }
            case 12: {
                if (string2 != null) break;
                return;
            }
        }
        if (bl) {
            this.setNodeDirty(true);
        }
    }

    private class FileObjectObserver
    implements FileChangeListener {
        FileObjectObserver(FileObject fileObject) {
            fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)fileObject));
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            ApplicationProxy applicationProxy = (ApplicationProxy)EarDataObject.this.getApplication();
            boolean bl = true;
            if (applicationProxy != null && applicationProxy.isWriting()) {
                applicationProxy.setWriting(false);
                bl = false;
            }
            if (EarDataObject.this.isSavingDocument()) {
                EarDataObject.this.setSavingDocument(false);
                bl = false;
            }
            if (bl) {
                EarDataObject.this.getEditorSupport().restartTimer();
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }
    }
}

