/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.mobility.antext.preprocessor.PreprocessorException;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JavaDocument;
import org.netbeans.modules.mobility.editor.hints.DisableHint;
import org.netbeans.modules.mobility.editor.hints.InlineIncludeHint;
import org.netbeans.modules.mobility.editor.hints.ReplaceOldSyntaxHint;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.preprocessor.PPDocumentSource;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2MEEditorDocument
extends JavaDocument {
    public static final String PREPROCESSOR_LINE_LIST = "preprocessor.line.list";
    static final long serialVersionUID = 4863325941230276217L;
    static final Pattern BLOCK_HEADER_PATTERN = Pattern.compile("^\\s*/((/#)|(\\*[\\$#]))\\S");
    static Coloring BLOCK_HEADER_COLORING = new Coloring(Font.decode("Monospaced bold"), 2, new Color(0, 112, 0), null);
    static Coloring ACTIVE_BLOCK_COLORING = new Coloring(null, null, new Color(250, 225, 240));
    static Coloring INACTIVE_BLOCK_COLORING = new Coloring(null, null, new Color(235, 225, 250));
    static LookupListener LL = null;
    static Lookup.Result LR = null;
    protected ArrayList<PPLine> lineList = new ArrayList();
    DocumentListener dl;
    Timer timer;
    transient ConfigurationBlocksLayer cbl = null;
    transient ConfigurationHeadersLayer chl = null;

    private static synchronized void initColoring() {
        if (LL != null) {
            return;
        }
        LR = MimeLookup.getMimeLookup((String)"text/x-java-preprocessor").lookup(new Lookup.Template(FontColorSettings.class));
        LL = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                FontColorSettings fontColorSettings = (FontColorSettings)LR.allInstances().iterator().next();
                BLOCK_HEADER_COLORING = J2MEEditorDocument.toColoring(fontColorSettings.getTokenFontColors("pp-command"), BLOCK_HEADER_COLORING);
                ACTIVE_BLOCK_COLORING = J2MEEditorDocument.toColoring(fontColorSettings.getTokenFontColors("pp-active-block"), ACTIVE_BLOCK_COLORING);
                INACTIVE_BLOCK_COLORING = J2MEEditorDocument.toColoring(fontColorSettings.getTokenFontColors("pp-inactive-block"), INACTIVE_BLOCK_COLORING);
            }
        };
        LR.addLookupListener(LL);
        LL.resultChanged(null);
    }

    public J2MEEditorDocument(Class clazz) {
        super(clazz);
        if (LL == null) {
            J2MEEditorDocument.initColoring();
        }
        this.cbl = new ConfigurationBlocksLayer();
        this.addLayer((DrawLayer)this.cbl, 1200);
        this.chl = new ConfigurationHeadersLayer();
        this.addLayer((DrawLayer)this.chl, 1300);
        J2MEEditorDocument.updateBlockChain((Document)((Object)this));
        this.dl = new DL();
        this.addDocumentListener(this.dl);
        this.getDocumentProperties().put("TEXT_SWITCH_SUPPORT", new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                J2MEEditorDocument.updateBlockChain((Document)((Object)J2MEEditorDocument.this));
            }
        });
    }

    final void setLineList(ArrayList<PPLine> arrayList) {
        this.lineList = arrayList;
        this.putProperty(PREPROCESSOR_LINE_LIST, arrayList);
        this.processAnnotations();
    }

    void restartTimer() {
        if (this.timer == null) {
            this.timer = new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    J2MEEditorDocument.updateBlockChain((Document)((Object)J2MEEditorDocument.this));
                }
            });
            this.timer.setRepeats(false);
        }
        this.timer.restart();
    }

    public static final void updateBlockChain(Document document) {
        Project project;
        if (document instanceof J2MEEditorDocument && (project = J2MEProjectUtils.getProjectForDocument((Document)document)) != null) {
            ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
            if (projectConfigurationsHelper == null || !projectConfigurationsHelper.isPreprocessorOn()) {
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(projectConfigurationsHelper.getActiveAbilities());
            hashMap.put(projectConfigurationsHelper.getActiveConfiguration().getDisplayName(), null);
            try {
                CommentingPreProcessor commentingPreProcessor = new CommentingPreProcessor((CommentingPreProcessor.Source)new PPDocumentSource(document), null, hashMap);
                commentingPreProcessor.run();
                ((J2MEEditorDocument)((Object)document)).setLineList(commentingPreProcessor.getLines());
            }
            catch (PreprocessorException preprocessorException) {
                ErrorManager.getDefault().notify((Throwable)preprocessorException);
            }
            J2MEEditorDocument.repaintDocument(document);
        }
    }

    public static void repaintDocument(Document document) {
        JEditorPane[] jEditorPaneArray;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null) {
            for (int i = 0; i < jEditorPaneArray.length; ++i) {
                try {
                    if (jEditorPaneArray[0] == null) continue;
                    jEditorPaneArray[i].getUI().damageRange(jEditorPaneArray[i], 0, document.getLength() + 1);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    static String prefixPropertyName(String string, String string2) {
        return "configs." + string + '.' + string2;
    }

    void processAnnotations() {
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)((Object)this));
        FileObject fileObject = dataObject == null ? null : dataObject.getPrimaryFile();
        for (PPLine pPLine : this.lineList) {
            PPToken pPToken;
            for (PPLine.Error error : pPLine.getErrors()) {
                pPToken = error.token;
                int n = pPToken.getType() == 257 || pPToken.getType() == 258 || pPToken.getType() == 300 ? Math.max(1, pPToken.getPadding().length()) : 0;
                int n2 = NbDocument.findLineOffset((StyledDocument)((Object)this), (int)(pPLine.getLineNumber() - 1));
                arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)(error.warning ? Severity.WARNING : Severity.ERROR), (String)error.message, (FileObject)fileObject, (int)(n2 + pPToken.getColumn() - n), (int)(n2 + pPToken.getColumn() + pPToken.getText().length())));
            }
            ArrayList arrayList2 = new ArrayList();
            int n = Utilities.getRowStartFromLineOffset((BaseDocument)this, (int)(pPLine.getLineNumber() - 1));
            if (pPLine.getTokens().size() > 1 && "//#include".equals(((PPToken)pPLine.getTokens().get(0)).getText())) {
                arrayList2.add(new InlineIncludeHint((BaseDocument)this, n, ((PPToken)pPLine.getTokens().get(1)).getText()));
            } else if (pPLine.getType() == 13 || pPLine.getType() == 14) {
                for (pPToken = pPLine.getBlock(); pPToken != null && pPToken.getType() != 13; pPToken = pPToken.getParent()) {
                }
                if (pPToken != null) {
                    arrayList2.add(new ReplaceOldSyntaxHint((Document)((Object)this), this.lineList, (PPBlockInfo)pPToken));
                }
            }
            if (pPLine.getType() == -1) {
                arrayList2.add(new DisableHint((BaseDocument)this, n));
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)NbBundle.getMessage(J2MEEditorDocument.class, (String)"LBL_PreprocessorHint"), (List)arrayList2, (Document)((Object)this), (int)pPLine.getLineNumber()));
        }
        HintsController.setErrors((Document)((Object)this), (String)"preprocessor-errors", arrayList);
    }

    protected static Coloring toColoring(AttributeSet attributeSet, Coloring coloring) {
        if (attributeSet == null) {
            return coloring;
        }
        Color color = (Color)attributeSet.getAttribute(StyleConstants.Background);
        Color color2 = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        Color color3 = (Color)attributeSet.getAttribute(StyleConstants.Underline);
        Color color4 = (Color)attributeSet.getAttribute(StyleConstants.StrikeThrough);
        Color color5 = (Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor);
        Font font = J2MEEditorDocument.toFont(attributeSet);
        return new Coloring(font, 7, color2, color, color3, color4, color5);
    }

    static Font toFont(AttributeSet attributeSet) {
        if (attributeSet.getAttribute(StyleConstants.FontFamily) == null) {
            return null;
        }
        int n = 0;
        if (attributeSet.getAttribute(StyleConstants.Bold) != null && attributeSet.getAttribute(StyleConstants.Bold).equals(Boolean.TRUE)) {
            ++n;
        }
        if (attributeSet.getAttribute(StyleConstants.Italic) != null && attributeSet.getAttribute(StyleConstants.Italic).equals(Boolean.TRUE)) {
            n += 2;
        }
        return new Font((String)attributeSet.getAttribute(StyleConstants.FontFamily), n, (Integer)attributeSet.getAttribute(StyleConstants.FontSize));
    }

    class ConfigurationHeadersLayer
    extends DrawLayer.AbstractLayer {
        static final String CONFIG_HEADERS_LAYER_NAME = "CONFIG_HEADERS_LAYER";

        public ConfigurationHeadersLayer() {
            super(CONFIG_HEADERS_LAYER_NAME);
        }

        public boolean extendsEmptyLine() {
            return false;
        }

        public boolean extendsEOL() {
            return false;
        }

        protected Coloring getColoring(DrawContext drawContext) {
            return BLOCK_HEADER_COLORING;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            int n = drawContext.getStartOffset();
            return BLOCK_HEADER_PATTERN.matcher(new String(drawContext.getBuffer(), n - drawContext.getBufferStartOffset(), drawContext.getEndOffset() - n)).find();
        }

        public void updateContext(DrawContext drawContext) {
            BLOCK_HEADER_COLORING.apply(drawContext);
        }
    }

    class ConfigurationBlocksLayer
    extends DrawLayer.AbstractLayer {
        static final String CONFIG_BLOCKS_LAYER_NAME = "CONFIG_BLOCKS_LAYER";
        J2MEEditorDocument doc;
        Coloring currentColoring;

        public ConfigurationBlocksLayer() {
            super(CONFIG_BLOCKS_LAYER_NAME);
            this.currentColoring = INACTIVE_BLOCK_COLORING;
        }

        public void init(DrawContext drawContext) {
            super.init(drawContext);
            this.doc = (J2MEEditorDocument)drawContext.getEditorUI().getDocument();
        }

        public boolean extendsEmptyLine() {
            return true;
        }

        public boolean extendsEOL() {
            return true;
        }

        protected Coloring getColoring(DrawContext drawContext) {
            return this.currentColoring;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            int n = NbDocument.findLineNumber((StyledDocument)((Object)this.doc), (int)drawContext.getStartOffset()) + 1;
            if (n >= J2MEEditorDocument.this.lineList.size()) {
                return false;
            }
            PPBlockInfo pPBlockInfo = J2MEEditorDocument.this.lineList.get(n - 1).getBlock();
            if (pPBlockInfo == null) {
                return false;
            }
            this.currentColoring = pPBlockInfo.isActive() ? ACTIVE_BLOCK_COLORING : INACTIVE_BLOCK_COLORING;
            return pPBlockInfo.isToBeCommented();
        }

        public void updateContext(DrawContext drawContext) {
            this.currentColoring.apply(drawContext);
        }
    }

    class DL
    implements DocumentListener {
        DL() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            J2MEEditorDocument.this.restartTimer();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            J2MEEditorDocument.this.restartTimer();
        }
    }
}

