/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.mobility.editor.J2MEEditorDocument;
import org.netbeans.modules.mobility.editor.actions.AddElifBlockAction;
import org.netbeans.modules.mobility.editor.actions.AddProjectConfigurationAction;
import org.netbeans.modules.mobility.editor.actions.CreateDebugBlockAction;
import org.netbeans.modules.mobility.editor.actions.CreateIfElseBlockAction;
import org.netbeans.modules.mobility.editor.actions.PreprocessorEditorContextAction;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2MEKit
extends JavaKit {
    static final long serialVersionUID = -5445285962533684922L;
    public static final String generatePreprocessorPopupAction = "generate-preprocessor-popup";
    public static final String PROJECT_CLIENT_PROPERTY = "projoject-client-property";

    protected Action[] createActions() {
        return TextAction.augmentList(super.createActions(), new Action[]{new GeneratePreprocessorPopupAction(), new AddProjectConfigurationAction(), new CreateIfElseBlockAction(), new AddElifBlockAction(), new CreateDebugBlockAction(), new RecommentAction()});
    }

    public Document createDefaultDocument() {
        J2MEEditorDocument j2MEEditorDocument = new J2MEEditorDocument(((Object)((Object)this)).getClass());
        Object object = j2MEEditorDocument.getProperty("mimeType");
        if (object == null) {
            j2MEEditorDocument.putProperty("mimeType", this.getContentType());
        }
        return j2MEEditorDocument;
    }

    protected static JMenu createMenu(JMenu jMenu, JTextComponent jTextComponent) {
        String string = NbBundle.getMessage(J2MEKit.class, (String)"Menu/Edit/PreprocessorBlocks");
        if (jMenu == null) {
            jMenu = new JMenu();
        } else {
            jMenu.removeAll();
        }
        Mnemonics.setLocalizedText((AbstractButton)jMenu, (String)string);
        BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
        if (baseKit == null) {
            return jMenu;
        }
        ProjectConfigurationsHelper projectConfigurationsHelper = null;
        ArrayList arrayList = null;
        if (jTextComponent != null && jTextComponent.getDocument() != null) {
            projectConfigurationsHelper = J2MEProjectUtils.getCfgHelperForDoc((Document)jTextComponent.getDocument());
            arrayList = (ArrayList)jTextComponent.getDocument().getProperty("preprocessor.line.list");
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        J2MEKit.addAction(baseKit, projectConfigurationsHelper, arrayList, jTextComponent, jMenu, "add-project-configuration-action");
        jMenu.addSeparator();
        J2MEKit.addAction(baseKit, projectConfigurationsHelper, arrayList, jTextComponent, jMenu, "create-if-else-block-action");
        J2MEKit.addAction(baseKit, projectConfigurationsHelper, arrayList, jTextComponent, jMenu, "add-elif-block-action");
        J2MEKit.addAction(baseKit, projectConfigurationsHelper, arrayList, jTextComponent, jMenu, "create-debug-block-action");
        jMenu.addSeparator();
        J2MEKit.addAction(baseKit, projectConfigurationsHelper, arrayList, jTextComponent, jMenu, RecommentAction.NAME);
        return jMenu;
    }

    private static void addAction(BaseKit baseKit, ProjectConfigurationsHelper projectConfigurationsHelper, ArrayList<PPLine> arrayList, JTextComponent jTextComponent, JMenu jMenu, String string) {
        String string2;
        Action action = baseKit.getActionByName(string);
        if (action != null && action instanceof PreprocessorEditorContextAction && (string2 = ((PreprocessorEditorContextAction)((Object)action)).getPopupMenuText(projectConfigurationsHelper, arrayList, jTextComponent)) != null) {
            Object object;
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.addActionListener(action);
            MultiKeymap multiKeymap = baseKit.getKeymap();
            if (multiKeymap != null) {
                KeyStroke keyStroke;
                object = multiKeymap.getKeyStrokesForAction(action);
                if (object != null && ((KeyStroke[])object).length > 0) {
                    jMenuItem.setAccelerator(object[0]);
                } else if (action != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                    jMenuItem.setAccelerator(keyStroke);
                }
            }
            jMenuItem.setEnabled(((PreprocessorEditorContextAction)((Object)action)).isEnabled(projectConfigurationsHelper, arrayList, jTextComponent));
            object = action.getValue("helpID");
            if (object != null && object instanceof String) {
                jMenuItem.putClientProperty("HelpID", object);
            }
            jMenu.add(jMenuItem);
        }
    }

    public static class PreprocessorMenuAction
    extends MainMenuAction {
        private JMenu PREPROCESSOR_MENU;

        public static void addAccelerators(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
            MainMenuAction.addAccelerators((Action)action, (JMenuItem)jMenuItem, (JTextComponent)jTextComponent);
        }

        public PreprocessorMenuAction() {
            super(false, null);
            this.setMenu();
        }

        protected synchronized void setMenu() {
            this.PREPROCESSOR_MENU = J2MEKit.createMenu(this.PREPROCESSOR_MENU, Utilities.getFocusedComponent());
            ActionMap actionMap = this.getContextActionMap();
            Action action = null;
            JMenuItem jMenuItem = this.getMenuPresenter();
            if (actionMap != null) {
                action = actionMap.get(this.getActionName());
                Action action2 = jMenuItem.getAction();
                if (action2 == null) {
                    if (action != null) {
                        jMenuItem.setAction(action);
                        this.menuInitialized = false;
                    }
                } else if (action != null && !action.equals(action2)) {
                    jMenuItem.setAction(action);
                    this.menuInitialized = false;
                } else if (action == null) {
                    jMenuItem.setEnabled(false);
                }
            }
            if (!this.menuInitialized) {
                Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)this.getMenuItemText());
                this.menuInitialized = true;
            }
            jMenuItem.setEnabled(action != null);
        }

        protected String getMenuItemText() {
            return NbBundle.getMessage(J2MEKit.class, (String)"Menu/Edit/PreprocessorBlocks");
        }

        public JMenuItem getMenuPresenter() {
            return this.PREPROCESSOR_MENU;
        }

        protected String getActionName() {
            return J2MEKit.generatePreprocessorPopupAction;
        }
    }

    public static class GeneratePreprocessorPopupAction
    extends BaseAction {
        public GeneratePreprocessorPopupAction() {
            super(J2MEKit.generatePreprocessorPopupAction);
            this.putValue("ShortDescription", NbBundle.getMessage(J2MEKit.class, (String)J2MEKit.generatePreprocessorPopupAction));
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            return J2MEKit.createMenu(null, jTextComponent);
        }
    }
}

