/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

import antlr.CharFormatter;
import antlr.collections.impl.IntRange;
import antlr.collections.impl.Vector;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int NIBBLE = 4;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    public void add(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] | BitSet.bitMask(el);
    }

    public BitSet and(BitSet a) {
        BitSet s = (BitSet)this.clone();
        s.andInPlace(a);
        return s;
    }

    public void andInPlace(BitSet a) {
        int i;
        int min = Math.min(this.bits.length, a.bits.length);
        for (i = min - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] & a.bits[i];
        }
        for (i = min; i < this.bits.length; ++i) {
            this.bits[i] = 0L;
        }
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public void clear() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            this.bits[i] = 0L;
        }
    }

    public void clear(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet s;
        try {
            s = (BitSet)super.clone();
            s.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return s;
    }

    public int degree() {
        int deg = 0;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            long word = this.bits[i];
            if (word == 0L) continue;
            for (int bit = 63; bit >= 0; --bit) {
                if ((word & 1L << bit) == 0L) continue;
                ++deg;
            }
        }
        return deg;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BitSet) {
            int n;
            BitSet set = (BitSet)obj;
            int i = n = Math.min(this.bits.length, set.bits.length);
            while (i-- > 0) {
                if (this.bits[i] == set.bits[i]) continue;
                return false;
            }
            if (this.bits.length > n) {
                i = this.bits.length;
                while (i-- > n) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
            } else if (set.bits.length > n) {
                i = set.bits.length;
                while (i-- > n) {
                    if (set.bits[i] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Vector getRanges(int[] elems) {
        if (elems.length == 0) {
            return null;
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        if (elems.length <= 2) {
            return null;
        }
        Vector ranges = new Vector(5);
        for (int i = 0; i < elems.length - 2; ++i) {
            int lastInRange = elems.length - 1;
            for (int j = i + 1; j < elems.length; ++j) {
                if (elems[j] == elems[j - 1] + 1) continue;
                lastInRange = j - 1;
                break;
            }
            if (lastInRange - i <= 2) continue;
            ranges.appendElement(new IntRange(elems[i], elems[lastInRange]));
        }
        return ranges;
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public boolean member(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            return false;
        }
        return (this.bits[n] & BitSet.bitMask(el)) != 0L;
    }

    public boolean nil() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public BitSet not() {
        BitSet s = (BitSet)this.clone();
        s.notInPlace();
        return s;
    }

    public void notInPlace() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void notInPlace(int maxBit) {
        this.notInPlace(0, maxBit);
    }

    public void notInPlace(int minBit, int maxBit) {
        this.growToInclude(maxBit);
        for (int i = minBit; i <= maxBit; ++i) {
            int n;
            int n2 = n = BitSet.wordNumber(i);
            this.bits[n2] = this.bits[n2] ^ BitSet.bitMask(i);
        }
    }

    private final int numWordsToHold(int el) {
        return (el >> 6) + 1;
    }

    public static BitSet of(int el) {
        BitSet s = new BitSet(el + 1);
        s.add(el);
        return s;
    }

    public BitSet or(BitSet a) {
        BitSet s = (BitSet)this.clone();
        s.orInPlace(a);
        return s;
    }

    public void orInPlace(BitSet a) {
        if (a.bits.length > this.bits.length) {
            this.setSize(a.bits.length);
        }
        int min = Math.min(this.bits.length, a.bits.length);
        for (int i = min - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] | a.bits[i];
        }
    }

    public void remove(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n);
        this.bits = newbits;
    }

    public int size() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet a) {
        if (a == null || !(a instanceof BitSet)) {
            return false;
        }
        return this.and(a).equals(this);
    }

    public void subtractInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        for (int i = 0; i < this.bits.length && i < a.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (a.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int[] toArray() {
        int[] elems = new int[this.degree()];
        int en = 0;
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            elems[en++] = i;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String separator) {
        String str = "";
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (str.length() > 0) {
                str = str + separator;
            }
            str = str + i;
        }
        return str;
    }

    public String toString(String separator, CharFormatter formatter) {
        String str = "";
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (str.length() > 0) {
                str = str + separator;
            }
            str = str + formatter.literalChar(i);
        }
        return str;
    }

    public String toString(String separator, Vector vocabulary) {
        if (vocabulary == null) {
            return this.toString(separator);
        }
        String str = "";
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (str.length() > 0) {
                str = str + separator;
            }
            str = i >= vocabulary.size() ? str + "<bad element " + i + ">" : (vocabulary.elementAt(i) == null ? str + "<" + i + ">" : str + (String)vocabulary.elementAt(i));
        }
        return str;
    }

    public String toStringOfHalfWords() {
        String s = new String();
        for (int i = 0; i < this.bits.length; ++i) {
            if (i != 0) {
                s = s + ", ";
            }
            long tmp = this.bits[i];
            s = s + (tmp &= 0xFFFFFFFFL) + "UL";
            s = s + ", ";
            tmp = this.bits[i] >>> 32;
            s = s + (tmp &= 0xFFFFFFFFL) + "UL";
        }
        return s;
    }

    public String toStringOfWords() {
        String s = new String();
        for (int i = 0; i < this.bits.length; ++i) {
            if (i != 0) {
                s = s + ", ";
            }
            s = s + this.bits[i] + "L";
        }
        return s;
    }

    public String toStringWithRanges(String separator, CharFormatter formatter) {
        String str = "";
        int[] elems = this.toArray();
        if (elems.length == 0) {
            return "";
        }
        for (int i = 0; i < elems.length; ++i) {
            int lastInRange = 0;
            int j = i + 1;
            while (j < elems.length && elems[j] == elems[j - 1] + 1) {
                lastInRange = j++;
            }
            if (str.length() > 0) {
                str = str + separator;
            }
            if (lastInRange - i >= 2) {
                str = str + formatter.literalChar(elems[i]);
                str = str + "..";
                str = str + formatter.literalChar(elems[lastInRange]);
                i = lastInRange;
                continue;
            }
            str = str + formatter.literalChar(elems[i]);
        }
        return str;
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }
}

