/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.settings;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiKeyBinding {
    private List<KeyStroke> keyStrokeList;
    private String actionName;

    public MultiKeyBinding(KeyStroke[] keyStrokeArray, String string) {
        if (keyStrokeArray == null) {
            throw new NullPointerException("keyStrokes cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("actionName cannot be null");
        }
        this.keyStrokeList = new UnmodifiableArrayList<KeyStroke>(keyStrokeArray);
        this.actionName = string;
    }

    public MultiKeyBinding(KeyStroke keyStroke, String string) {
        this(new KeyStroke[]{keyStroke}, string);
        if (keyStroke == null) {
            throw new NullPointerException("keyStroke cannot be null");
        }
    }

    public KeyStroke getKeyStroke(int n) {
        return this.keyStrokeList.get(n);
    }

    public int getKeyStrokeCount() {
        return this.keyStrokeList.size();
    }

    public List<KeyStroke> getKeyStrokeList() {
        return this.keyStrokeList;
    }

    public String getActionName() {
        return this.actionName;
    }

    public boolean equals(Object object) {
        if (object instanceof MultiKeyBinding) {
            MultiKeyBinding multiKeyBinding = (MultiKeyBinding)object;
            if (this.actionName == null ? multiKeyBinding.actionName != null : !this.actionName.equals(multiKeyBinding.actionName)) {
                return false;
            }
            return ((Object)this.keyStrokeList).equals(multiKeyBinding.keyStrokeList);
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        for (int i = 0; i < this.getKeyStrokeCount(); ++i) {
            n = 37 * n + this.getKeyStroke(i).hashCode();
        }
        if (this.actionName != null) {
            n = 37 * n + this.actionName.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("keys(");
        for (KeyStroke keyStroke : this.keyStrokeList) {
            stringBuffer.append(keyStroke);
        }
        stringBuffer.append("), actionName=");
        stringBuffer.append(this.actionName);
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableArrayList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        private E[] array;

        UnmodifiableArrayList(E[] EArray) {
            if (EArray == null) {
                throw new NullPointerException();
            }
            this.array = EArray;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.array.clone();
        }

        @Override
        public E get(int n) {
            return this.array[n];
        }

        @Override
        public int indexOf(Object object) {
            if (object == null) {
                for (int i = 0; i < this.array.length; ++i) {
                    if (this.array[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.array.length; ++i) {
                    if (!object.equals(this.array[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof UnmodifiableArrayList ? Arrays.equals(this.array, ((UnmodifiableArrayList)object).array) : super.equals(object);
        }
    }
}

