/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.extension.openide.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.netbeans.modules.visualweb.extension.openide.util.Trace;

public class TraceUI
extends Trace {
    private static ColorWheel colorWheel;
    private static int debugRectInc;
    private static boolean debugRectHashLeft;

    public static void debugRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            return;
        }
        graphics.setClip(n, n2, n3, n4);
        Color color = graphics.getColor();
        if (colorWheel == null) {
            colorWheel = new ColorWheel();
        }
        graphics.setColor(colorWheel.next());
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        if (debugRectHashLeft) {
            for (int i = 0; i < n + n3 + n4; i += debugRectInc) {
                graphics.drawLine(n, n2 + i, n + i, n2);
            }
        } else {
            for (int i = 0; i < n + n3 + n4; i += debugRectInc) {
                graphics.drawLine(n + n3, n2 + i, n + n3 - i, n2);
            }
        }
        boolean bl = debugRectHashLeft = !debugRectHashLeft;
        debugRectInc = debugRectInc > 15 ? 5 : (debugRectInc += 2);
        graphics.setColor(color);
        if (rectangle != null) {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    static {
        debugRectInc = 10;
        debugRectHashLeft = true;
    }

    private static class ColorWheel {
        public static final int RED_TO_YELLOW = 1;
        public static final int YELLOW_TO_GREEN = 2;
        public static final int GREEN_TO_CYAN = 3;
        public static final int CYAN_TO_BLUE = 4;
        public static final int BLUE_TO_MAGENTA = 5;
        public static final int MAGENTA_TO_RED = 6;
        private int increment = 50;
        private int cycle = 1;
        private Color current = Color.red;

        public ColorWheel() {
        }

        public ColorWheel(Color color) {
            this.current = color;
        }

        public ColorWheel(Color color, int n) {
            this.current = color;
            this.cycle = n;
        }

        public ColorWheel(Color color, int n, int n2) {
            this.current = color;
            this.cycle = n;
            this.increment = n2;
        }

        public int getIncrement() {
            return this.increment;
        }

        public void setIncrement(int n) {
            if (n < 1 || n > 255) {
                throw new IllegalArgumentException("ColorWheel increment must be in range (1-255)");
            }
            this.increment = n;
        }

        public int getCycle() {
            return this.cycle;
        }

        public void setCycle(int n) {
            if (n < 1 || n > 6) {
                throw new IllegalArgumentException("Invalid ColorWheel cycle: " + n);
            }
            this.cycle = n;
        }

        public Color getColor() {
            return this.current;
        }

        public void setColor(Color color) {
            if (color != null) {
                this.current = color;
            }
        }

        public Color next() {
            return this.next(this.current);
        }

        public Color next(Color color) {
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            switch (this.cycle) {
                case 1: {
                    if ((n2 += this.increment) <= 255) break;
                    n2 = 255;
                    this.cycle = 2;
                    break;
                }
                case 2: {
                    if ((n -= this.increment) >= 0) break;
                    n = 0;
                    this.cycle = 3;
                    break;
                }
                case 3: {
                    if ((n3 += this.increment) <= 255) break;
                    n3 = 255;
                    this.cycle = 4;
                    break;
                }
                case 4: {
                    if ((n2 -= this.increment) >= 0) break;
                    n2 = 0;
                    this.cycle = 5;
                    break;
                }
                case 5: {
                    if ((n += this.increment) <= 255) break;
                    n = 255;
                    this.cycle = 6;
                    break;
                }
                case 6: {
                    if ((n3 -= this.increment) >= 0) break;
                    n3 = 0;
                    this.cycle = 1;
                    break;
                }
                default: {
                    this.cycle = 1;
                }
            }
            this.current = new Color(n, n2, n3);
            return this.current;
        }
    }
}

