/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.wsdl.wsdl2java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.e2e.api.schema.Element;
import org.netbeans.modules.e2e.api.schema.RepeatableSchemaConstruct;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;
import org.netbeans.modules.e2e.api.schema.Type;
import org.netbeans.modules.e2e.api.wsdl.Binding;
import org.netbeans.modules.e2e.api.wsdl.BindingOperation;
import org.netbeans.modules.e2e.api.wsdl.Definition;
import org.netbeans.modules.e2e.api.wsdl.Input;
import org.netbeans.modules.e2e.api.wsdl.Message;
import org.netbeans.modules.e2e.api.wsdl.Operation;
import org.netbeans.modules.e2e.api.wsdl.Output;
import org.netbeans.modules.e2e.api.wsdl.Part;
import org.netbeans.modules.e2e.api.wsdl.Port;
import org.netbeans.modules.e2e.api.wsdl.PortType;
import org.netbeans.modules.e2e.api.wsdl.Service;
import org.netbeans.modules.e2e.api.wsdl.extensions.ExtensibilityElement;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPAddress;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPBinding;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPBody;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPOperation;
import org.netbeans.modules.e2e.api.wsdl.wsdl2java.WSDL2Java;
import org.netbeans.modules.e2e.schema.SchemaConstants;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPConstants;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WSDLValidator {
    private Definition definition;
    private List<WSDL2Java.ValidationResult> result;
    private Service service;
    private boolean flagNoSoapBinding;

    public WSDLValidator(List<WSDL2Java.ValidationResult> list, Definition definition) {
        this.definition = definition;
        this.result = new ArrayList<WSDL2Java.ValidationResult>();
        this.result.addAll(list);
    }

    public List<WSDL2Java.ValidationResult> validate() {
        this.checkDefinition(this.definition);
        this.printMessages();
        return this.result;
    }

    private void checkDefinition(Definition definition) {
        for (Service service : definition.getServices().values()) {
            this.checkService(service);
        }
    }

    private void checkService(Service service) {
        this.service = service;
        for (Port port : service.getPorts()) {
            this.checkPort(port);
        }
    }

    private void checkPort(Port port) {
        for (ExtensibilityElement extensibilityElement : port.getExtensibilityElements()) {
            if (!SOAPConstants.ADDRESS.equals(extensibilityElement.getElementType())) continue;
            SOAPAddress sOAPAddress = (SOAPAddress)extensibilityElement;
            Binding binding = port.getBinding();
            this.checkBinding(binding);
        }
    }

    private void checkBinding(Binding binding) {
        for (ExtensibilityElement extensibilityElement : binding.getExtensibilityElements()) {
            if (!SOAPConstants.BINDING.equals(extensibilityElement.getElementType())) continue;
            SOAPBinding sOAPBinding = (SOAPBinding)extensibilityElement;
            for (BindingOperation bindingOperation : binding.getBindingOperations()) {
                this.checkBindingOperation(bindingOperation);
            }
            PortType portType = binding.getPortType();
            for (Operation operation : portType.getOperations()) {
                this.checkOperation(operation);
            }
        }
    }

    private void checkBindingOperation(BindingOperation bindingOperation) {
        Object object;
        SOAPOperation sOAPOperation = null;
        Object object2 = bindingOperation.getExtensibilityElements().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!SOAPConstants.OPERATION.equals(object.getElementType())) continue;
            if (sOAPOperation == null) {
                sOAPOperation = (SOAPOperation)object;
                continue;
            }
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0011", bindingOperation.getName());
        }
        if (sOAPOperation != null && !"document".equals(sOAPOperation.getStyle())) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0001", bindingOperation.getName());
        }
        if ((object2 = bindingOperation.getBindingInput()) != null) {
            for (ExtensibilityElement object3 : object2.getExtensibilityElements()) {
                ExtensibilityElement extensibilityElement;
                if (!SOAPConstants.BODY.equals(object3.getElementType()) || "literal".equals((extensibilityElement = (SOAPBody)object3).getUse())) continue;
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0002", bindingOperation.getName(), "input");
            }
        } else {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0012", bindingOperation.getName());
        }
        object = bindingOperation.getBindingOutput();
        if (object != null) {
            for (ExtensibilityElement extensibilityElement : object.getExtensibilityElements()) {
                SOAPBody sOAPBody;
                if (!SOAPConstants.BODY.equals(extensibilityElement.getElementType()) || "literal".equals((sOAPBody = (SOAPBody)extensibilityElement).getUse())) continue;
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0002", bindingOperation.getName(), "output");
            }
        } else {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0013", bindingOperation.getName());
        }
    }

    private void checkOperation(Operation operation) {
        RepeatableSchemaConstruct repeatableSchemaConstruct;
        Object object;
        QName qName;
        Output output = operation.getOutput();
        if (output == null) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0007", operation.getName());
            return;
        }
        Message message = output.getMessage();
        if (message.getParts().size() == 0) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0014", message.getName());
        } else if (message.getParts().size() > 1) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0006", operation.getName());
        }
        for (Part object2 : message.getParts()) {
            QName qName2 = object2.getElementName();
            qName = object2.getTypeName();
            object = null;
            repeatableSchemaConstruct = null;
            if (qName2 != null) {
                object = this.definition.getSchemaHolder().getSchemaElement(qName2);
                repeatableSchemaConstruct = ((Element)object).getType();
                this.checkType((Element)object, new HashSet<Element>());
                continue;
            }
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0008", operation.getName());
        }
        Input input = operation.getInput();
        if (input == null) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0009", operation.getName());
            return;
        }
        message = input.getMessage();
        if (message.getParts().size() == 0) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0014", message.getName());
        } else if (message.getParts().size() > 1) {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0006", operation.getName());
        }
        for (Part part : message.getParts()) {
            qName = part.getElementName();
            object = part.getTypeName();
            repeatableSchemaConstruct = null;
            Type type = null;
            if (qName != null) {
                repeatableSchemaConstruct = this.definition.getSchemaHolder().getSchemaElement(qName);
                type = ((Element)repeatableSchemaConstruct).getType();
                this.checkType((Element)repeatableSchemaConstruct, new HashSet<Element>());
                continue;
            }
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0008", operation.getName());
        }
    }

    private void checkType(Element element, Set<Element> set) {
        Type type = element.getType();
        if (3 == type.getFlavor()) {
            QName qName = type.getName();
            if (!(SchemaConstants.TYPE_INT.equals(qName) || SchemaConstants.TYPE_BOOLEAN.equals(qName) || SchemaConstants.TYPE_BYTE.equals(qName) || SchemaConstants.TYPE_DOUBLE.equals(qName) || SchemaConstants.TYPE_FLOAT.equals(qName) || SchemaConstants.TYPE_LONG.equals(qName) || SchemaConstants.TYPE_SHORT.equals(qName) || SchemaConstants.TYPE_BASE64_BINARY.equals(qName) || SchemaConstants.TYPE_HEX_BINARY.equals(qName) || SchemaConstants.TYPE_STRING.equals(qName))) {
                if (SchemaConstants.TYPE_QNAME.equals(qName)) {
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.WARNING, "0015");
                } else {
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0003", qName.toString());
                }
            }
        } else if (1 == type.getFlavor()) {
            set.add(element);
            if (type.getSubconstructs().size() == 0) {
                return;
            }
            for (SchemaConstruct schemaConstruct : type.getSubconstructs()) {
                if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)schemaConstruct.getConstructType())) {
                    Element element2 = (Element)schemaConstruct;
                    if (!set.contains(element2)) {
                        this.checkType(element2, set);
                        continue;
                    }
                    this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0010");
                    continue;
                }
                this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0005", element.getName().toString());
            }
        } else {
            this.addMessage(WSDL2Java.ValidationResult.ErrorLevel.FATAL, "0004", element.getName().toString());
        }
    }

    private void printMessages() {
    }

    private void addMessage(WSDL2Java.ValidationResult.ErrorLevel errorLevel, String string) {
        this.result.add(new WSDL2Java.ValidationResult(errorLevel, NbBundle.getMessage(WSDLValidator.class, (String)string)));
    }

    private void addMessage(WSDL2Java.ValidationResult.ErrorLevel errorLevel, String string, String string2) {
        this.result.add(new WSDL2Java.ValidationResult(errorLevel, NbBundle.getMessage(WSDLValidator.class, (String)string, (Object)string2)));
    }

    private void addMessage(WSDL2Java.ValidationResult.ErrorLevel errorLevel, String string, String string2, String string3) {
        this.result.add(new WSDL2Java.ValidationResult(errorLevel, NbBundle.getMessage(WSDLValidator.class, (String)string, (Object)string2, (Object)string3)));
    }

    private void addMessage(WSDL2Java.ValidationResult.ErrorLevel errorLevel, String string, String[] stringArray) {
        this.result.add(new WSDL2Java.ValidationResult(errorLevel, NbBundle.getMessage(WSDLValidator.class, (String)string, (Object[])stringArray)));
    }
}

