/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.FreeIOHandler;
import org.netbeans.modules.ruby.platform.execution.InputForwarder;
import org.netbeans.modules.ruby.platform.execution.OutputForwarder;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.RerunAction;
import org.netbeans.modules.ruby.platform.execution.StopAction;
import org.netbeans.modules.ruby.platform.spi.RubyDebuggerImplementation;
import org.openide.ErrorManager;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionService {
    public static final Logger LOGGER = Logger.getLogger(ExecutionService.class.getName());
    private static final Set<String> ACTIVE_DISPLAY_NAMES;
    private static final Set<ExecutionService> RUNNING_PROCESSES;
    private InputOutput io;
    private StopAction stopAction;
    private RerunAction rerunAction;
    protected ExecutionDescriptor descriptor;
    private String displayName;
    private boolean rerun;

    public ExecutionService(ExecutionDescriptor executionDescriptor) {
        this.descriptor = executionDescriptor;
    }

    public static void setupProcessEnvironment(Map<String, String> map, String string, boolean bl) {
        String string2;
        Object object;
        String string3 = string;
        if (!Utilities.isWindows()) {
            string3 = string3.replace(" ", "\\ ");
        }
        String string4 = "PATH";
        if (Utilities.isWindows()) {
            string4 = "Path";
            object = map.keySet().iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                if (!"PATH".equals(string2.toUpperCase())) continue;
                string4 = string2;
                break;
            }
        }
        if ((object = map.get(string4)) == null) {
            object = "";
        }
        object = string3 + File.pathSeparator + (String)object;
        if (bl) {
            string2 = System.getProperty("jruby.java.home");
            if (string2 == null) {
                string2 = System.getProperty("jdk.home");
            }
            String string5 = string2 + File.separator + "bin";
            if (!Utilities.isWindows()) {
                string5 = string5.replace(" ", "\\ ");
            }
            object = (String)object + File.pathSeparator + string5;
        }
        map.put(string4, (String)object);
    }

    public void setupProcessEnvironment(Map<String, String> map) {
        ExecutionService.setupProcessEnvironment(map, this.descriptor.getCmd().getParent(), this.descriptor.getAppendJdkToPath());
    }

    public void kill() {
        LOGGER.log(Level.FINE, "Killing " + this.displayName + " " + this);
        if (this.stopAction != null) {
            LOGGER.log(Level.FINE, "StopAction: " + this.stopAction);
            this.stopAction.actionPerformed(null);
            if (this.stopAction.process != null) {
                LOGGER.log(Level.FINE, "Destroying process: " + this.stopAction.process);
                this.stopAction.process.destroy();
            }
        }
    }

    public static void killAll() {
        for (ExecutionService executionService : RUNNING_PROCESSES) {
            executionService.kill();
        }
    }

    public Task rerun() {
        try {
            this.io.getOut().reset();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.rerun = true;
        return this.run();
    }

    protected List<? extends String> buildArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.descriptor.cmd;
        assert (file != null);
        if (this.descriptor.getInitialArgs() != null) {
            arrayList.addAll(Arrays.asList(this.descriptor.getInitialArgs()));
        }
        if (this.descriptor.getScriptPrefix() != null) {
            arrayList.add(this.descriptor.getScriptPrefix());
        }
        if (this.descriptor.script != null) {
            arrayList.add(this.descriptor.script);
        }
        if (this.descriptor.getAdditionalArgs() != null) {
            arrayList.addAll(Arrays.asList(this.descriptor.getAdditionalArgs()));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task run() {
        FreeIOHandler freeIOHandler;
        Object object;
        if (this.descriptor.debug) {
            object = (RubyDebuggerImplementation)Lookup.getDefault().lookup(RubyDebuggerImplementation.class);
            object.describeProcess(this.descriptor);
            if (object == null || !object.canDebug()) {
                return null;
            }
        }
        if (!this.rerun) {
            object = this;
            synchronized (object) {
                if (this.io == null && (freeIOHandler = FreeIOHandler.findFreeIO(this.descriptor.getDisplayName())) != null) {
                    this.io = freeIOHandler.getIO();
                    this.displayName = freeIOHandler.getDisplayName();
                    this.stopAction = freeIOHandler.getStopAction();
                    this.rerunAction = freeIOHandler.getRerunAction();
                    if (this.descriptor.frontWindow) {
                        this.io.select();
                    }
                }
            }
            if (this.io == null) {
                this.displayName = ExecutionService.getNonActiveDisplayName(this.descriptor.getDisplayName());
                this.stopAction = new StopAction();
                this.rerunAction = new RerunAction(this, this.descriptor.getFileObject());
                this.io = IOProvider.getDefault().getIO(this.displayName, new Action[]{this.rerunAction, this.stopAction});
                try {
                    this.io.getOut().reset();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                this.io.setErrSeparated(false);
                if (this.descriptor.frontWindow) {
                    this.io.select();
                }
            }
        }
        ACTIVE_DISPLAY_NAMES.add(this.displayName);
        this.io.setInputVisible(this.descriptor.inputVisible);
        object = new Runnable(){

            public void run() {
                File file = ExecutionService.this.descriptor.cmd;
                try {
                    Object object;
                    Process process = null;
                    if (ExecutionService.this.descriptor.debug) {
                        object = (RubyDebuggerImplementation)Lookup.getDefault().lookup(RubyDebuggerImplementation.class);
                        object.describeProcess(ExecutionService.this.descriptor);
                        if (object != null && object.canDebug()) {
                            process = object.debug();
                        }
                        if (process == null) {
                            return;
                        }
                    } else {
                        object = new ArrayList();
                        if (!file.getName().startsWith("jruby") || RubyExecution.LAUNCH_JRUBY_SCRIPT) {
                            object.add(file.getPath());
                        }
                        List<? extends String> list = ExecutionService.this.buildArgs();
                        object.addAll(list);
                        String[] stringArray = object.toArray(new String[object.size()]);
                        if (stringArray != null && Utilities.isWindows()) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (stringArray[i] == null || stringArray[i].indexOf(32) == -1 || stringArray[i].indexOf(34) != -1) continue;
                                stringArray[i] = '\"' + stringArray[i] + '\"';
                            }
                        }
                        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                        processBuilder.directory(ExecutionService.this.descriptor.pwd);
                        Map<String, String> map = processBuilder.environment();
                        Map<String, String> map2 = ExecutionService.this.descriptor.getAdditionalEnvironment();
                        if (map2 != null) {
                            map.putAll(map2);
                        }
                        if (ExecutionService.this.descriptor.addBinPath) {
                            ExecutionService.this.setupProcessEnvironment(map);
                        }
                        Util.adjustProxy(processBuilder);
                        ExecutionService.logProcess(processBuilder);
                        process = processBuilder.start();
                    }
                    RUNNING_PROCESSES.add(ExecutionService.this);
                    ((ExecutionService)ExecutionService.this).stopAction.process = process;
                    if (ExecutionService.this.descriptor.debug && (object = (RubyDebuggerImplementation)Lookup.getDefault().lookup(RubyDebuggerImplementation.class)) != null) {
                        ExecutionService.this.stopAction.setFinishAction(object.getFinishAction());
                    }
                    ExecutionService.runIO(ExecutionService.this.stopAction, process, ExecutionService.this.io, ExecutionService.this.descriptor.getFileLocator(), ExecutionService.this.descriptor.outputRecognizers, ExecutionService.this.descriptor.getEncoding());
                    process.waitFor();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                catch (InterruptedException interruptedException) {
                    ErrorManager.getDefault().notify((Throwable)interruptedException);
                }
            }
        };
        if (this.descriptor.showProgress || this.descriptor.showSuspended) {
            freeIOHandler = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    ExecutionService.this.stopAction.actionPerformed(null);
                    return true;
                }
            }, (Action)new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExecutionService.this.io.select();
                }
            });
            freeIOHandler.start();
            freeIOHandler.switchToIndeterminate();
            if (this.descriptor.showSuspended) {
                freeIOHandler.suspend(NbBundle.getMessage(ExecutionService.class, (String)"Running"));
            }
        } else {
            freeIOHandler = null;
        }
        this.stopAction.setEnabled(true);
        this.rerunAction.setEnabled(false);
        ExecutorTask executorTask = ExecutionEngine.getDefault().execute(null, (Runnable)object, InputOutput.NULL);
        executorTask.addTaskListener(new TaskListener((ProgressHandle)freeIOHandler){
            final /* synthetic */ ProgressHandle val$handle;
            {
                this.val$handle = progressHandle;
            }

            public void taskFinished(Task task) {
                RUNNING_PROCESSES.remove(ExecutionService.this);
                if (ExecutionService.this.io != null) {
                    FreeIOHandler.addFreeIO(ExecutionService.this.io, ExecutionService.this.displayName, ExecutionService.this.stopAction, ExecutionService.this.rerunAction);
                }
                ACTIVE_DISPLAY_NAMES.remove(ExecutionService.this.displayName);
                if (ExecutionService.this.descriptor.postBuildAction != null) {
                    ExecutionService.this.descriptor.postBuildAction.run();
                }
                if (this.val$handle != null) {
                    this.val$handle.finish();
                }
                ExecutionService.this.stopAction.setEnabled(false);
                ExecutionService.this.rerunAction.setEnabled(true);
                if (((ExecutionService)ExecutionService.this).stopAction.process != null) {
                    ((ExecutionService)ExecutionService.this).stopAction.process.destroy();
                    ((ExecutionService)ExecutionService.this).stopAction.process = null;
                }
            }
        });
        return executorTask;
    }

    private static void runIO(final StopAction stopAction, Process process, InputOutput inputOutput, FileLocator fileLocator, List<OutputRecognizer> list, String string) {
        try {
            InputForwarder inputForwarder = new InputForwarder(process.getOutputStream(), inputOutput.getIn());
            OutputForwarder outputForwarder = new OutputForwarder(process.getInputStream(), inputOutput.getOut(), fileLocator, list, stopAction, string);
            OutputForwarder outputForwarder2 = new OutputForwarder(process.getErrorStream(), inputOutput.getErr(), fileLocator, list, stopAction, string);
            RequestProcessor requestProcessor = new RequestProcessor("Process Execution Stream Handler", 3, true);
            TaskListener taskListener = new TaskListener(){

                public void taskFinished(Task task) {
                    stopAction.notifyDone((RequestProcessor.Task)task);
                }
            };
            RequestProcessor.Task task = requestProcessor.post((Runnable)outputForwarder);
            RequestProcessor.Task task2 = requestProcessor.post((Runnable)outputForwarder2);
            RequestProcessor.Task task3 = requestProcessor.post((Runnable)inputForwarder);
            task.addTaskListener(taskListener);
            task2.addTaskListener(taskListener);
            task3.addTaskListener(taskListener);
            stopAction.addTask(task);
            stopAction.addTask(task2);
            stopAction.addTask(task3);
            process.waitFor();
            stopAction.process = null;
            inputForwarder.cancel();
            task.waitFinished();
            task2.waitFinished();
            task3.waitFinished();
            requestProcessor.stop();
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify(1, (Throwable)interruptedException);
        }
    }

    static boolean isAppropriateName(String string, String string2) {
        if (!string2.startsWith(string)) {
            return false;
        }
        return string2.substring(string.length()).matches("^(\\ #[0-9]+)?$");
    }

    private static String getNonActiveDisplayName(String string) {
        String string2 = string;
        if (ACTIVE_DISPLAY_NAMES.contains(string2)) {
            String string3;
            int n = 2;
            while (ACTIVE_DISPLAY_NAMES.contains(string3 = NbBundle.getMessage(ExecutionService.class, (String)"Uniquified", (Object)string2, (Object)n++))) {
            }
            string2 = string3;
        }
        assert (!ACTIVE_DISPLAY_NAMES.contains(string2));
        return string2;
    }

    public static void logProcess(ProcessBuilder processBuilder) {
        if (LOGGER.isLoggable(Level.FINE)) {
            File file = processBuilder.directory();
            String string = file == null ? "" : "(basedir: " + file.getAbsolutePath() + ") ";
            LOGGER.fine("Running: " + string + '\"' + ExecutionService.getProcessAsString(processBuilder.command()) + '\"');
            LOGGER.fine("Environment: " + processBuilder.environment());
        }
    }

    private static String getProcessAsString(List<? extends String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString().trim();
    }

    static {
        Thread thread = new Thread(){

            public void run() {
                ExecutionService.killAll();
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
        ACTIVE_DISPLAY_NAMES = new HashSet<String>();
        RUNNING_PROCESSES = new HashSet<ExecutionService>();
    }
}

