/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputProcessor;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.execution.StopAction;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OutputForwarder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(OutputForwarder.class.getName());
    static final Pattern RANGE_ERROR_RE = Pattern.compile("#<RangeError: 0x[0-9a-f]+ is recycled object>");
    private StopAction stopAction;
    private InputStream str;
    private OutputWriter writer;
    private FileLocator fileLocator;
    private List<OutputRecognizer> recognizers;
    private String encoding;

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction) {
        this(inputStream, outputWriter, fileLocator, list, stopAction, null);
    }

    OutputForwarder(InputStream inputStream, OutputWriter outputWriter, FileLocator fileLocator, List<OutputRecognizer> list, StopAction stopAction, String string) {
        this.str = inputStream;
        this.writer = outputWriter;
        this.fileLocator = fileLocator;
        this.recognizers = list;
        this.stopAction = stopAction;
        this.encoding = string;
    }

    void processLine(String string) throws IOException {
        if (RANGE_ERROR_RE.matcher(string).matches()) {
            LOGGER.log(Level.FINE, "Filtering line from Output Window (issue #110763): " + string);
            return;
        }
        if (Util.containsAnsiColors(string)) {
            string = Util.stripAnsiColors(string);
        }
        OutputRecognizer.FileLocation fileLocation = null;
        boolean bl = false;
        for (OutputRecognizer outputRecognizer : this.recognizers) {
            String[] stringArray;
            OutputRecognizer.RecognizedOutput recognizedOutput = outputRecognizer.processLine(string);
            if (recognizedOutput instanceof OutputRecognizer.FileLocation) {
                fileLocation = (OutputRecognizer.FileLocation)recognizedOutput;
                continue;
            }
            if (recognizedOutput instanceof OutputRecognizer.ActionText) {
                Object object;
                int n;
                int n2;
                Object[] objectArray;
                stringArray = (String[])recognizedOutput;
                String[] stringArray2 = stringArray.getPlainLinesPre();
                if (stringArray2 != null) {
                    objectArray = stringArray2;
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        object = objectArray[n];
                        this.writer.println((String)object);
                    }
                }
                if ((stringArray2 = stringArray.getActionLines()) != null) {
                    objectArray = stringArray.getActions();
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        String string2 = stringArray2[n2];
                        this.writer.println(string2, (OutputListener)new ActionHandler((Runnable)objectArray[n2]));
                    }
                }
                if ((stringArray2 = stringArray.getPlainLinesPost()) != null) {
                    objectArray = stringArray2;
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        object = objectArray[n];
                        this.writer.println((String)object);
                    }
                }
                bl = true;
                continue;
            }
            if (!(recognizedOutput instanceof OutputRecognizer.FilteredOutput)) continue;
            stringArray = ((OutputRecognizer.FilteredOutput)recognizedOutput).getLinesToPrint();
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    this.writer.println(string3);
                }
            }
            bl = true;
        }
        if (!bl) {
            if (fileLocation != null) {
                this.writer.println(string, (OutputListener)new OutputProcessor(fileLocation.file, fileLocation.line, this.fileLocator));
            } else {
                this.writer.println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        for (OutputRecognizer var2_2 : this.recognizers) {
            var2_2.start();
        }
        var1_1 = null;
        try {
            var2_3 = this.encoding == null ? new InputStreamReader(this.str) : new InputStreamReader(this.str, this.encoding);
            var1_1 = new BufferedReader(var2_3, 1200);
        }
        catch (UnsupportedEncodingException var2_4) {
            Exceptions.printStackTrace((Throwable)var2_4);
            return;
        }
        var2_5 = new StringBuilder();
        try {
            block133: {
                block132: {
                    block131: {
                        block118: {
                            block130: {
                                block129: {
                                    block128: {
                                        block117: {
                                            block127: {
                                                block126: {
                                                    block125: {
                                                        block113: {
                                                            try {
                                                                while (true) {
                                                                    if (!var1_1.ready()) {
                                                                        if (this.stopAction.process == null) {
                                                                            var8_13 = null;
                                                                            break block113;
                                                                        }
                                                                        for (var5_10 = 0; !var1_1.ready() && var5_10 < 1000; var5_10 += 50) {
                                                                            try {
                                                                                Thread.sleep(50L);
                                                                                continue;
                                                                            }
                                                                            catch (InterruptedException var6_12) {
                                                                                var8_14 = null;
                                                                                try {
                                                                                    try {
                                                                                        if (Thread.interrupted()) {
                                                                                            // empty if block
                                                                                        }
                                                                                        if (this.stopAction.process == null) {
                                                                                            var9_22 = false;
                                                                                        } else {
                                                                                            try {
                                                                                                this.stopAction.process.exitValue();
                                                                                                var9_22 = false;
                                                                                            }
                                                                                            catch (IllegalThreadStateException var10_35) {
                                                                                                var9_22 = true;
                                                                                            }
                                                                                        }
                                                                                        if (var9_22) {
                                                                                            if (this.str.available() > 0) {
                                                                                                var10_35 = var1_1.readLine();
                                                                                                var2_5.append((String)var10_35);
                                                                                            }
                                                                                            if (var2_5.length() > 0) {
                                                                                                this.processLine(var2_5.toString());
                                                                                            }
                                                                                        } else {
                                                                                            while ((var10_35 = var1_1.readLine()) != null) {
                                                                                                var2_5.append((String)var10_35);
                                                                                                this.processLine(var2_5.toString());
                                                                                                var2_5.setLength(0);
                                                                                            }
                                                                                        }
                                                                                        v0 = null;
                                                                                    }
                                                                                    catch (IOException var9_23) {
                                                                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var9_23.getMessage(), var9_23);
                                                                                        v0 = null;
                                                                                    }
                                                                                }
                                                                                catch (Throwable var11_42) {
                                                                                    v0 = null;
                                                                                }
                                                                                var12_49 = v0;
                                                                                try {
                                                                                    var1_1.close();
                                                                                }
                                                                                catch (IOException var13_56) {
                                                                                    OutputForwarder.LOGGER.log(Level.WARNING, var13_56.getMessage(), (Throwable)var13_56);
                                                                                }
                                                                                this.writer.flush();
                                                                                this.writer.close();
                                                                                var13_56 = this.recognizers.iterator();
                                                                                while (true) {
                                                                                    if (!var13_56.hasNext()) {
                                                                                        return;
                                                                                    }
                                                                                    var14_63 = (OutputRecognizer)var13_56.next();
                                                                                    var14_63.finish();
                                                                                }
                                                                            }
                                                                        }
                                                                        if (var1_1.ready() || var2_5.length() <= 0) continue;
                                                                        var6_11 = var2_5.toString();
                                                                        var2_5.setLength(0);
                                                                        OutputForwarder.LOGGER.log(Level.INFO, "Process seems to be stalling, emitting chars read so far: " + var6_11);
                                                                        this.writer.print(var6_11);
                                                                        continue;
                                                                    }
                                                                    while (var1_1.ready()) {
                                                                        var3_6 = -1;
                                                                        var3_6 = var1_1.read();
                                                                        if (var3_6 == -1) {
                                                                            var4_9 = var2_5.toString();
                                                                            var2_5.setLength(0);
                                                                            this.processLine(var4_9);
                                                                            break block117;
                                                                        }
                                                                        var2_5.append((char)var3_6);
                                                                    }
                                                                    if (Thread.interrupted()) break;
                                                                }
                                                                break block118;
                                                            }
                                                            catch (IOException var3_7) {
                                                                block121: {
                                                                    block120: {
                                                                        block119: {
                                                                            OutputForwarder.LOGGER.log(Level.INFO, var3_7.getMessage(), var3_7);
                                                                            var8_17 = null;
                                                                            ** try [egrp 4[TRYBLOCK] [19 : 365->540)] { 
lbl109:
                                                                            // 1 sources

                                                                            ** try [egrp 5[TRYBLOCK] [18 : 365->492)] { 
lbl110:
                                                                            // 1 sources

                                                                            if (Thread.interrupted()) {
                                                                                // empty if block
                                                                            }
                                                                            if (this.stopAction.process == null) {
                                                                                var9_28 = false;
                                                                            } else {
                                                                                ** try [egrp 6[TRYBLOCK] [17 : 387->404)] { 
lbl116:
                                                                                // 1 sources

                                                                                this.stopAction.process.exitValue();
                                                                                var9_28 = false;
                                                                            }
                                                                            break block119;
lbl120:
                                                                            // 1 sources

                                                                            catch (IllegalThreadStateException var10_38) {
                                                                                var9_28 = true;
                                                                            }
                                                                        }
                                                                        if (var9_28) {
                                                                            if (this.str.available() > 0) {
                                                                                var10_38 = var1_1.readLine();
                                                                                var2_5.append((String)var10_38);
                                                                            }
                                                                            if (var2_5.length() > 0) {
                                                                                this.processLine(var2_5.toString());
                                                                            }
                                                                        } else {
                                                                            while ((var10_38 = var1_1.readLine()) != null) {
                                                                                var2_5.append((String)var10_38);
                                                                                this.processLine(var2_5.toString());
                                                                                var2_5.setLength(0);
                                                                            }
                                                                        }
                                                                        v1 = null;
lbl139:
                                                                        // 1 sources

                                                                        catch (IOException var9_29) {
                                                                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var9_29.getMessage(), var9_29);
                                                                            v1 = null;
                                                                        }
                                                                        break block120;
lbl143:
                                                                        // 1 sources

                                                                        catch (Throwable var11_45) {
                                                                            v1 = null;
                                                                        }
                                                                    }
                                                                    var12_52 = v1;
                                                                    ** try [egrp 7[TRYBLOCK] [22 : 550->557)] { 
lbl148:
                                                                    // 1 sources

                                                                    var1_1.close();
                                                                    break block121;
lbl150:
                                                                    // 1 sources

                                                                    catch (IOException var13_59) {
                                                                        OutputForwarder.LOGGER.log(Level.WARNING, var13_59.getMessage(), (Throwable)var13_59);
                                                                    }
                                                                }
                                                                this.writer.flush();
                                                                this.writer.close();
                                                                for (OutputRecognizer var14_66 : this.recognizers) {
                                                                    var14_66.finish();
                                                                }
                                                                return;
                                                            }
                                                            catch (Throwable var3_8) {
                                                                block124: {
                                                                    block123: {
                                                                        block122: {
                                                                            OutputForwarder.LOGGER.log(Level.INFO, var3_8.getMessage(), var3_8);
                                                                            var8_18 = null;
                                                                            ** try [egrp 4[TRYBLOCK] [19 : 365->540)] { 
lbl164:
                                                                            // 1 sources

                                                                            ** try [egrp 5[TRYBLOCK] [18 : 365->492)] { 
lbl165:
                                                                            // 1 sources

                                                                            if (Thread.interrupted()) {
                                                                                // empty if block
                                                                            }
                                                                            if (this.stopAction.process == null) {
                                                                                var9_30 = false;
                                                                            } else {
                                                                                ** try [egrp 6[TRYBLOCK] [17 : 387->404)] { 
lbl171:
                                                                                // 1 sources

                                                                                this.stopAction.process.exitValue();
                                                                                var9_30 = false;
                                                                            }
                                                                            break block122;
lbl175:
                                                                            // 1 sources

                                                                            catch (IllegalThreadStateException var10_39) {
                                                                                var9_30 = true;
                                                                            }
                                                                        }
                                                                        if (var9_30) {
                                                                            if (this.str.available() > 0) {
                                                                                var10_39 = var1_1.readLine();
                                                                                var2_5.append((String)var10_39);
                                                                            }
                                                                            if (var2_5.length() > 0) {
                                                                                this.processLine(var2_5.toString());
                                                                            }
                                                                        } else {
                                                                            while ((var10_39 = var1_1.readLine()) != null) {
                                                                                var2_5.append((String)var10_39);
                                                                                this.processLine(var2_5.toString());
                                                                                var2_5.setLength(0);
                                                                            }
                                                                        }
                                                                        v2 = null;
lbl194:
                                                                        // 1 sources

                                                                        catch (IOException var9_31) {
                                                                            OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var9_31.getMessage(), var9_31);
                                                                            v2 = null;
                                                                        }
                                                                        break block123;
lbl198:
                                                                        // 1 sources

                                                                        catch (Throwable var11_46) {
                                                                            v2 = null;
                                                                        }
                                                                    }
                                                                    var12_53 = v2;
                                                                    ** try [egrp 7[TRYBLOCK] [22 : 550->557)] { 
lbl203:
                                                                    // 1 sources

                                                                    var1_1.close();
                                                                    break block124;
lbl205:
                                                                    // 1 sources

                                                                    catch (IOException var13_60) {
                                                                        OutputForwarder.LOGGER.log(Level.WARNING, var13_60.getMessage(), (Throwable)var13_60);
                                                                    }
                                                                }
                                                                this.writer.flush();
                                                                this.writer.close();
                                                                for (OutputRecognizer var14_67 : this.recognizers) {
                                                                    var14_67.finish();
                                                                }
                                                                return;
                                                            }
                                                        }
                                                        ** try [egrp 4[TRYBLOCK] [19 : 365->540)] { 
lbl216:
                                                        // 1 sources

                                                        ** try [egrp 5[TRYBLOCK] [18 : 365->492)] { 
lbl217:
                                                        // 1 sources

                                                        if (Thread.interrupted()) {
                                                            // empty if block
                                                        }
                                                        if (this.stopAction.process == null) {
                                                            var9_20 = false;
                                                        } else {
                                                            ** try [egrp 6[TRYBLOCK] [17 : 387->404)] { 
lbl223:
                                                            // 1 sources

                                                            this.stopAction.process.exitValue();
                                                            var9_20 = false;
                                                        }
                                                        break block125;
lbl227:
                                                        // 1 sources

                                                        catch (IllegalThreadStateException var10_34) {
                                                            var9_20 = true;
                                                        }
                                                    }
                                                    if (var9_20) {
                                                        if (this.str.available() > 0) {
                                                            var10_34 = var1_1.readLine();
                                                            var2_5.append((String)var10_34);
                                                        }
                                                        if (var2_5.length() > 0) {
                                                            this.processLine(var2_5.toString());
                                                        }
                                                    } else {
                                                        while ((var10_34 = var1_1.readLine()) != null) {
                                                            var2_5.append((String)var10_34);
                                                            this.processLine(var2_5.toString());
                                                            var2_5.setLength(0);
                                                        }
                                                    }
                                                    v3 = null;
lbl246:
                                                    // 1 sources

                                                    catch (IOException var9_21) {
                                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var9_21.getMessage(), var9_21);
                                                        v3 = null;
                                                    }
                                                    break block126;
lbl250:
                                                    // 1 sources

                                                    catch (Throwable var11_41) {
                                                        v3 = null;
                                                    }
                                                }
                                                var12_48 = v3;
                                                ** try [egrp 7[TRYBLOCK] [22 : 550->557)] { 
lbl255:
                                                // 1 sources

                                                var1_1.close();
                                                break block127;
lbl257:
                                                // 1 sources

                                                catch (IOException var13_55) {
                                                    OutputForwarder.LOGGER.log(Level.WARNING, var13_55.getMessage(), (Throwable)var13_55);
                                                }
                                            }
                                            this.writer.flush();
                                            this.writer.close();
                                            for (OutputRecognizer var14_62 : this.recognizers) {
                                                var14_62.finish();
                                            }
                                            return;
                                        }
                                        var8_15 = null;
                                        ** try [egrp 4[TRYBLOCK] [19 : 365->540)] { 
lbl269:
                                        // 1 sources

                                        ** try [egrp 5[TRYBLOCK] [18 : 365->492)] { 
lbl270:
                                        // 1 sources

                                        if (Thread.interrupted()) {
                                            // empty if block
                                        }
                                        if (this.stopAction.process == null) {
                                            var9_24 = false;
                                        } else {
                                            ** try [egrp 6[TRYBLOCK] [17 : 387->404)] { 
lbl276:
                                            // 1 sources

                                            this.stopAction.process.exitValue();
                                            var9_24 = false;
                                        }
                                        break block128;
lbl280:
                                        // 1 sources

                                        catch (IllegalThreadStateException var10_36) {
                                            var9_24 = true;
                                        }
                                    }
                                    if (var9_24) {
                                        if (this.str.available() > 0) {
                                            var10_36 = var1_1.readLine();
                                            var2_5.append((String)var10_36);
                                        }
                                        if (var2_5.length() > 0) {
                                            this.processLine(var2_5.toString());
                                        }
                                    } else {
                                        while ((var10_36 = var1_1.readLine()) != null) {
                                            var2_5.append((String)var10_36);
                                            this.processLine(var2_5.toString());
                                            var2_5.setLength(0);
                                        }
                                    }
                                    v4 = null;
lbl299:
                                    // 1 sources

                                    catch (IOException var9_25) {
                                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var9_25.getMessage(), var9_25);
                                        v4 = null;
                                    }
                                    break block129;
lbl303:
                                    // 1 sources

                                    catch (Throwable var11_43) {
                                        v4 = null;
                                    }
                                }
                                var12_50 = v4;
                                ** try [egrp 7[TRYBLOCK] [22 : 550->557)] { 
lbl308:
                                // 1 sources

                                var1_1.close();
                                break block130;
lbl310:
                                // 1 sources

                                catch (IOException var13_57) {
                                    OutputForwarder.LOGGER.log(Level.WARNING, var13_57.getMessage(), (Throwable)var13_57);
                                }
                            }
                            this.writer.flush();
                            this.writer.close();
                            for (OutputRecognizer var14_64 : this.recognizers) {
                                var14_64.finish();
                            }
                            return;
                        }
                        var8_16 = null;
                        ** try [egrp 4[TRYBLOCK] [19 : 365->540)] { 
lbl322:
                        // 1 sources

                        ** try [egrp 5[TRYBLOCK] [18 : 365->492)] { 
lbl323:
                        // 1 sources

                        if (Thread.interrupted()) {
                            // empty if block
                        }
                        if (this.stopAction.process == null) {
                            var9_26 = false;
                        } else {
                            ** try [egrp 6[TRYBLOCK] [17 : 387->404)] { 
lbl329:
                            // 1 sources

                            this.stopAction.process.exitValue();
                            var9_26 = false;
                        }
                        break block131;
lbl333:
                        // 1 sources

                        catch (IllegalThreadStateException var10_37) {
                            var9_26 = true;
                        }
                    }
                    if (var9_26) {
                        if (this.str.available() > 0) {
                            var10_37 = var1_1.readLine();
                            var2_5.append((String)var10_37);
                        }
                        if (var2_5.length() > 0) {
                            this.processLine(var2_5.toString());
                        }
                    } else {
                        while ((var10_37 = var1_1.readLine()) != null) {
                            var2_5.append((String)var10_37);
                            this.processLine(var2_5.toString());
                            var2_5.setLength(0);
                        }
                    }
                    v5 = null;
lbl352:
                    // 1 sources

                    catch (IOException var9_27) {
                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var9_27.getMessage(), var9_27);
                        v5 = null;
                    }
                    break block132;
lbl356:
                    // 1 sources

                    catch (Throwable var11_44) {
                        v5 = null;
                    }
                }
                var12_51 = v5;
                ** try [egrp 7[TRYBLOCK] [22 : 550->557)] { 
lbl361:
                // 1 sources

                var1_1.close();
                break block133;
lbl363:
                // 1 sources

                catch (IOException var13_58) {
                    OutputForwarder.LOGGER.log(Level.WARNING, var13_58.getMessage(), (Throwable)var13_58);
                }
            }
            this.writer.flush();
            this.writer.close();
            for (OutputRecognizer var14_65 : this.recognizers) {
                var14_65.finish();
            }
            return;
        }
        catch (Throwable var7_69) {
            block136: {
                block135: {
                    block134: {
                        var8_19 = null;
                        ** try [egrp 4[TRYBLOCK] [19 : 365->540)] { 
lbl376:
                        // 1 sources

                        ** try [egrp 5[TRYBLOCK] [18 : 365->492)] { 
lbl377:
                        // 1 sources

                        if (Thread.interrupted()) {
                            // empty if block
                        }
                        if (this.stopAction.process == null) {
                            var9_32 = false;
                        } else {
                            ** try [egrp 6[TRYBLOCK] [17 : 387->404)] { 
lbl383:
                            // 1 sources

                            this.stopAction.process.exitValue();
                            var9_32 = false;
                        }
                        break block134;
lbl387:
                        // 1 sources

                        catch (IllegalThreadStateException var10_40) {
                            var9_32 = true;
                        }
                    }
                    if (var9_32) {
                        if (this.str.available() > 0) {
                            var10_40 = var1_1.readLine();
                            var2_5.append((String)var10_40);
                        }
                        if (var2_5.length() > 0) {
                            this.processLine(var2_5.toString());
                        }
                    } else {
                        while ((var10_40 = var1_1.readLine()) != null) {
                            var2_5.append((String)var10_40);
                            this.processLine(var2_5.toString());
                            var2_5.setLength(0);
                        }
                    }
                    v6 = null;
lbl406:
                    // 1 sources

                    catch (IOException var9_33) {
                        OutputForwarder.LOGGER.log(Level.INFO, "Process finished unexpectedly: " + var9_33.getMessage(), var9_33);
                        v6 = null;
                    }
                    break block135;
lbl410:
                    // 1 sources

                    catch (Throwable var11_47) {
                        v6 = null;
                    }
                }
                var12_54 = v6;
                ** try [egrp 7[TRYBLOCK] [22 : 550->557)] { 
lbl415:
                // 1 sources

                var1_1.close();
                break block136;
lbl417:
                // 1 sources

                catch (IOException var13_61) {
                    OutputForwarder.LOGGER.log(Level.WARNING, var13_61.getMessage(), (Throwable)var13_61);
                }
            }
            this.writer.flush();
            this.writer.close();
            var13_61 = this.recognizers.iterator();
            while (true) {
                if (!var13_61.hasNext()) {
                    throw var7_69;
                }
                var14_68 = (OutputRecognizer)var13_61.next();
                var14_68.finish();
            }
        }
    }

    private class ActionHandler
    implements OutputListener {
        private final Runnable runnable;

        private ActionHandler(Runnable runnable) {
            this.runnable = runnable;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.runnable.run();
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

