/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.netbeans.modules.xslt.project.CommandlineXsltProjectXmlCatalogProvider;
import org.netbeans.modules.xslt.project.anttasks.JBIGenerator;

public class GenerateJBIDescriptor
extends Task {
    private String mSourceDirectory = null;
    private String mBuildDirectory = null;
    private String mProjectClassPath = null;
    private Reference m_ref = null;
    private Logger logger = Logger.getLogger(GenerateJBIDescriptor.class.getName());

    public void setClasspathRef(Reference ref) {
        this.m_ref = ref;
    }

    public void setBuildDirectory(String buildDir) {
        this.mBuildDirectory = buildDir;
    }

    public String getBuildDirectory() {
        return this.mBuildDirectory;
    }

    public void setSourceDirectory(String srcDir) {
        this.mSourceDirectory = srcDir;
    }

    public String getSourceDirectory() {
        return this.mSourceDirectory;
    }

    public void setProjectClassPath(String projectClassPath) {
        this.mProjectClassPath = projectClassPath;
    }

    public void execute() throws BuildException {
        if (this.mSourceDirectory == null) {
            throw new BuildException("No directory is set for source files.");
        }
        File sourceDirectory = new File(this.mSourceDirectory);
        File buildDirectory = new File(this.mBuildDirectory);
        ArrayList<File> projectDirs = new ArrayList<File>();
        if (this.mProjectClassPath != null && !this.mProjectClassPath.trim().equals("") && !this.mProjectClassPath.trim().equals("${javac.classpath}")) {
            StringTokenizer st = new StringTokenizer(this.mProjectClassPath, ";");
            while (st.hasMoreTokens()) {
                String spath = st.nextToken();
                try {
                    File sFile = new File(sourceDirectory.getParentFile().getCanonicalPath() + File.separator + spath);
                    File srcFolder = new File(sFile.getParentFile().getParentFile().getCanonicalFile(), "src");
                    projectDirs.add(srcFolder);
                }
                catch (Exception ex) {
                    throw new BuildException("Failed to create File object for dependent project path " + spath);
                }
            }
        }
        if (sourceDirectory != null) {
            ArrayList<File> srcList = new ArrayList<File>();
            srcList.add(sourceDirectory);
            if (buildDirectory != null) {
                srcList.add(buildDirectory);
            }
            CommandlineXsltProjectXmlCatalogProvider.getInstance().setSourceDirectory(this.mSourceDirectory);
            JBIGenerator generator = new JBIGenerator(projectDirs, srcList, this.mSourceDirectory, this.mBuildDirectory);
            generator.generate();
        }
    }

    public static void main(String[] args) {
        GenerateJBIDescriptor dd = new GenerateJBIDescriptor();
    }
}

