/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.anttasks;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Util {
    private static final String XML_FILE_EXTENSION = "xml";
    private static final String XSL_FILE_EXTENSION = "xsl";
    private static final String XSLT_FILE_EXTENSION = "xslt";

    private Util() {
    }

    public static String getRelativePath(File home, File f) {
        return Util.matchPathLists(Util.getPathList(home), Util.getPathList(f));
    }

    private static List getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List r, List f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        s = s + f.get(j);
        return s;
    }

    public static class XsltFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            String fileName = pathname.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String fileExtension = null;
            if (dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex + 1);
            }
            if (fileExtension == null) {
                return false;
            }
            if (fileExtension.equalsIgnoreCase(Util.XSL_FILE_EXTENSION)) {
                return true;
            }
            if (fileExtension.equalsIgnoreCase(Util.XSLT_FILE_EXTENSION)) {
                return true;
            }
            return fileExtension.equalsIgnoreCase(Util.XML_FILE_EXTENSION);
        }
    }
}

