/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.editor;

import java.io.StringReader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.modules.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.asm.core.editor.AsmLanguageHierarchy;
import org.netbeans.modules.asm.core.editor.AsmModelAccessorImpl;
import org.netbeans.modules.asm.core.editor.EditorSyntax;
import org.netbeans.modules.asm.model.AsmModel;
import org.netbeans.modules.asm.model.AsmModelAccessor;
import org.netbeans.modules.asm.model.AsmModelProvider;
import org.netbeans.modules.asm.model.AsmSyntax;
import org.netbeans.modules.asm.model.AsmSyntaxProvider;
import org.netbeans.modules.asm.model.AsmTypesProvider;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.util.Lookup;

public class AsmEditorKit
extends NbEditorKit {
    public static final String MIME_TYPE = "text/x-asm";

    public Syntax createSyntax(Document document) {
        AsmModelAccessor asmModelAccessor = (AsmModelAccessor)document.getProperty(AsmModelAccessor.class);
        if (asmModelAccessor == null) {
            Object object2;
            AsmModelProvider asmModelProvider = null;
            AsmSyntaxProvider asmSyntaxProvider = null;
            Collection collection = Lookup.getDefault().lookup(new Lookup.Template(AsmTypesProvider.class)).allInstances();
            AsmTypesProvider.ResolverResult resolverResult = null;
            String string = AsmObjectUtilities.getText(NbEditorUtilities.getFileObject((Document)document));
            for (Object object2 : collection) {
                resolverResult = object2.resolve(new StringReader(string.toString()));
                if (resolverResult == null) continue;
                asmModelProvider = resolverResult.getModelProvider();
                asmSyntaxProvider = resolverResult.getSyntaxProvider();
                Logger.getLogger(AsmEditorKit.class.getName()).log(Level.FINE, "Asm Regognized " + asmModelProvider + " " + asmSyntaxProvider);
            }
            if (resolverResult == null || asmModelProvider == null || asmSyntaxProvider == null) {
                return new EditorSyntax();
            }
            AsmModel asmModel = asmModelProvider.getModel();
            object2 = asmSyntaxProvider.getSyntax(asmModel);
            asmModelAccessor = new AsmModelAccessorImpl(asmModel, (AsmSyntax)object2, document);
            document.putProperty(AsmModelAccessor.class, asmModelAccessor);
            document.putProperty(AsmModel.class, asmModel);
            document.putProperty(Language.class, new AsmLanguageHierarchy((AsmSyntax)object2).language());
        }
        return new EditorSyntax();
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return super.createSyntaxSupport(baseDocument);
    }
}

