/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.ui.top;

import java.util.Formatter;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.asm.model.lang.instruction.Instruction;
import org.netbeans.modules.asm.model.lang.instruction.InstructionArgs;

public class InstructionInfoPanel
extends JPanel {
    private String infoTemplate = "%s  -  %s\n";
    private JScrollPane jInfoScrollPanel;
    private JTextArea jInfoTextArea;

    public InstructionInfoPanel() {
        this.initComponents();
    }

    public void setInstruction(Instruction instruction) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new Formatter().format(this.infoTemplate, instruction.getName(), instruction.getDescription()));
        for (InstructionArgs instructionArgs : instruction.getArguments()) {
            stringBuilder.append("\n").append(instruction.getName());
            for (String string : instructionArgs.getParamMnemonic()) {
                stringBuilder.append(" ").append(string);
            }
            stringBuilder.append(" - ").append(instructionArgs.getDescription());
        }
        this.jInfoTextArea.setText(stringBuilder.toString());
    }

    private void initComponents() {
        this.jInfoScrollPanel = new JScrollPane();
        this.jInfoTextArea = new JTextArea();
        this.setLayout(new BoxLayout(this, 1));
        this.jInfoTextArea.setColumns(50);
        this.jInfoTextArea.setRows(5);
        this.jInfoScrollPanel.setViewportView(this.jInfoTextArea);
        this.add(this.jInfoScrollPanel);
    }
}

