/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.ui.top;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import org.netbeans.modules.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.asm.model.AsmState;
import org.netbeans.modules.asm.model.lang.AsmElement;
import org.netbeans.modules.asm.model.lang.AsmOffsetable;
import org.netbeans.modules.asm.model.lang.syntax.FunctionBoundsResolver;
import org.netbeans.modules.asm.model.util.DefaultOffsetable;
import org.netbeans.modules.asm.model.util.IntervalSet;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NavigatorUI
extends JPanel
implements ExplorerManager.Provider {
    private static Logger LOGGER = Logger.getLogger(NavigatorUI.class.getName());
    private ListView navigatorPane;
    private ExplorerManager explorerManager;

    public NavigatorUI() {
        this.initComponents();
        this.explorerManager = new ExplorerManager();
        this.navigatorPane = new ListView();
        this.navigatorPane.setDropTarget(false);
        this.navigatorPane.setDragSource(false);
        this.add((Component)this.navigatorPane, "Center");
        this.setEmpty();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void updateCursor(int n) {
        Node[] nodeArray;
        Node node = this.explorerManager.getRootContext();
        for (Node node2 : nodeArray = node.getChildren().getNodes()) {
            AsmFunctionNode asmFunctionNode;
            if (!(node2 instanceof AsmFunctionNode) || !(asmFunctionNode = (AsmFunctionNode)node2).isActive(n)) continue;
            try {
                this.explorerManager.setSelectedNodes(new Node[]{node2});
            }
            catch (PropertyVetoException propertyVetoException) {
                LOGGER.info("PropertyVetoException exception");
            }
            return;
        }
    }

    public void update(DataObject dataObject, AsmState asmState) {
        this.setFunctions(dataObject, asmState);
    }

    private void setEmpty() {
        Children.Array array = new Children.Array();
        AbstractNode abstractNode = new AbstractNode((Children)array);
        this.explorerManager.setRootContext((Node)abstractNode);
    }

    private void setFunctions(DataObject dataObject, AsmState asmState) {
        FunctionBoundsResolver.Entry entry2;
        FunctionBoundsResolver functionBoundsResolver = (FunctionBoundsResolver)asmState.getServices().lookup(FunctionBoundsResolver.class);
        if (functionBoundsResolver == null) {
            this.setEmpty();
            return;
        }
        IntervalSet<FunctionBoundsResolver.Entry> intervalSet = functionBoundsResolver.getFunctions();
        Node[] nodeArray = new Node[intervalSet.getList().size()];
        int n = 0;
        for (FunctionBoundsResolver.Entry entry2 : intervalSet) {
            List<AsmElement> list = asmState.getElements().getCompounds();
            int n2 = list.get(entry2.getStartOffset()).getStartOffset();
            int n3 = list.get(entry2.getEndOffset()).getEndOffset();
            AsmOffsetable asmOffsetable = DefaultOffsetable.create(n2, n3);
            nodeArray[n++] = new AsmFunctionNode(dataObject, entry2.getName(), asmOffsetable);
        }
        Children.Array array = new Children.Array();
        array.add(nodeArray);
        entry2 = new AbstractNode((Children)array);
        this.explorerManager.setRootContext((Node)entry2);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private static class AsmFunctionNode
    extends AbstractNode {
        private static final String FUNC_ICON = "org/netbeans/modules/asm/core/resources/function.png";
        private final AsmOffsetable off;
        private final DataObject dob;

        public AsmFunctionNode(DataObject dataObject, String string, AsmOffsetable asmOffsetable) {
            super(Children.LEAF, null);
            this.dob = dataObject;
            this.setName(string);
            this.off = asmOffsetable;
        }

        public boolean isActive(int n) {
            return n >= this.off.getStartOffset() && n < this.off.getEndOffset();
        }

        public Image getIcon(int n) {
            return Utilities.loadImage((String)FUNC_ICON);
        }

        public Action getPreferredAction() {
            return new GoToFunctionAction();
        }

        class GoToFunctionAction
        extends AbstractAction {
            public GoToFunctionAction() {
                this.putValue("Name", NbBundle.getMessage(GoToFunctionAction.class, (String)"LBL_GoToFunctionAction"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AsmObjectUtilities.goToSource(AsmFunctionNode.this.dob, AsmFunctionNode.this.off.getStartOffset());
            }
        }
    }
}

