/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.samples;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.metro.samples.PanelConfigureProject;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PanelOptionsVisual
extends JPanel {
    private PanelConfigureProject panel;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;

    public PanelOptionsVisual(PanelConfigureProject panelConfigureProject) {
        this.panel = panelConfigureProject;
        this.initComponents();
        this.initServers();
    }

    private void initComponents() {
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.serverInstanceLabel.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_Server"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.serverInstanceLabel).add(18, 18, 18).add((Component)this.serverInstanceComboBox, -2, 221, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serverInstanceLabel).add((Component)this.serverInstanceComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initServers() {
        String[] stringArray;
        this.serverInstanceComboBox.removeAllItems();
        ServerWrapper serverWrapper = null;
        for (String string : stringArray = Deployment.getDefault().getServerInstanceIDs(new Object[]{J2eeModule.WAR}, "1.5", new String[]{"jsr109"})) {
            String string2;
            String string3 = Deployment.getDefault().getServerInstanceDisplayName(string);
            if (string3 == null) continue;
            ServerWrapper serverWrapper2 = new ServerWrapper(string, string3);
            this.serverInstanceComboBox.addItem(serverWrapper2);
            if (serverWrapper == null || !"J2EE".equals(string2 = Deployment.getDefault().getServerID(string))) continue;
            serverWrapper = serverWrapper2;
        }
        if (serverWrapper != null) {
            this.serverInstanceComboBox.setSelectedItem(serverWrapper);
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return this.serverInstanceComboBox.getItemCount() > 0;
    }

    void store(WizardDescriptor wizardDescriptor) {
        ServerWrapper serverWrapper = (ServerWrapper)this.serverInstanceComboBox.getSelectedItem();
        if (serverWrapper != null) {
            wizardDescriptor.putProperty("server", (Object)serverWrapper.getServerID());
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    private class ServerWrapper {
        private String serverID;
        private String displayName;

        ServerWrapper(String string, String string2) {
            this.serverID = string;
            this.displayName = string2;
        }

        public String getServerID() {
            return this.serverID;
        }

        public void setServerID(String string) {
            this.serverID = string;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String string) {
            this.displayName = string;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

