/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.structure.formatting.JoinedTokenSequence;
import org.netbeans.modules.editor.structure.formatting.TagBasedLexerFormatter;
import org.netbeans.modules.xml.text.folding.TokenElement;
import org.netbeans.modules.xml.text.syntax.XMLKit;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.DefaultElementIdentity;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLexerFormatter
extends TagBasedLexerFormatter {
    private static final String TAG_OPENING_PREFIX = "<";
    private static final String TAG_CLOSING_PREFIX = "</";
    private final LanguagePath languagePath;
    private int spacesPerTab = 4;

    public XMLLexerFormatter(LanguagePath languagePath) {
        this.languagePath = languagePath;
    }

    protected boolean isOpeningTag(JoinedTokenSequence joinedTokenSequence, int n) {
        Token token = this.getTokenAtOffset(joinedTokenSequence, n);
        return token != null && token.id() == XMLTokenId.TAG && ((Object)token.text()).toString().startsWith(TAG_OPENING_PREFIX) && !((Object)token.text()).toString().startsWith(TAG_CLOSING_PREFIX);
    }

    protected boolean isClosingTag(JoinedTokenSequence joinedTokenSequence, int n) {
        Token token = this.getTokenAtOffset(joinedTokenSequence, n);
        return token != null && token.id() == XMLTokenId.TAG && ((Object)token.text()).toString().startsWith(TAG_CLOSING_PREFIX);
    }

    protected boolean areTagNamesEqual(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    protected boolean isClosingTagRequired(BaseDocument baseDocument, String string) {
        return true;
    }

    protected boolean isUnformattableToken(JoinedTokenSequence joinedTokenSequence, int n) {
        Token token = this.getTokenAtOffset(joinedTokenSequence, n);
        return token.id() == XMLTokenId.BLOCK_COMMENT || token.id() == XMLTokenId.CDATA_SECTION;
    }

    protected boolean isUnformattableTag(String string) {
        return false;
    }

    protected boolean isTopLevelLanguage(BaseDocument baseDocument) {
        return true;
    }

    protected LanguagePath supportedLanguagePath() {
        return this.languagePath;
    }

    protected String extractTagName(JoinedTokenSequence joinedTokenSequence, int n) {
        Token token = this.getTokenAtOffset(joinedTokenSequence, n);
        String string = ((Object)token.text()).toString();
        int n2 = -1;
        if (this.isOpeningTag(joinedTokenSequence, n)) {
            n2 = TAG_OPENING_PREFIX.length();
        } else if (this.isClosingTag(joinedTokenSequence, n)) {
            n2 = TAG_CLOSING_PREFIX.length();
        }
        if (n2 >= 0) {
            String string2 = string.substring(n2);
            return string2;
        }
        return null;
    }

    protected int getTagEndingAtPosition(JoinedTokenSequence joinedTokenSequence, int n) throws BadLocationException {
        if (n >= 0) {
            int n2 = joinedTokenSequence.offset();
            joinedTokenSequence.move(n);
            joinedTokenSequence.moveNext();
            Token token = joinedTokenSequence.token();
            if (token.id() == XMLTokenId.TAG && !((Object)token.text()).toString().endsWith("/>")) {
                while (joinedTokenSequence.movePrevious()) {
                    int n3 = joinedTokenSequence.offset();
                    if (!this.isOpeningTag(joinedTokenSequence, n3) && !this.isClosingTag(joinedTokenSequence, n3)) continue;
                    int n4 = joinedTokenSequence.offset();
                    joinedTokenSequence.move(n2);
                    joinedTokenSequence.moveNext();
                    return n4;
                }
            }
            joinedTokenSequence.move(n2);
            joinedTokenSequence.moveNext();
        }
        return -1;
    }

    protected int getTagEndOffset(JoinedTokenSequence joinedTokenSequence, int n) {
        boolean bl;
        int n2 = joinedTokenSequence.offset();
        joinedTokenSequence.move(n);
        joinedTokenSequence.moveNext();
        joinedTokenSequence.moveNext();
        for (bl = true; bl && joinedTokenSequence.token().id() != XMLTokenId.TAG; bl &= joinedTokenSequence.moveNext()) {
        }
        int n3 = joinedTokenSequence.offset() + joinedTokenSequence.token().length();
        joinedTokenSequence.move(n2);
        joinedTokenSequence.moveNext();
        return bl ? n3 : -1;
    }

    protected int getOpeningSymbolOffset(JoinedTokenSequence joinedTokenSequence, int n) {
        int n2 = joinedTokenSequence.offset();
        joinedTokenSequence.move(n);
        boolean bl = true;
        while ((bl = joinedTokenSequence.movePrevious()) && joinedTokenSequence.token().id() != XMLTokenId.TAG) {
        }
        if (bl) {
            int n3 = joinedTokenSequence.offset();
            joinedTokenSequence.move(n2);
            joinedTokenSequence.moveNext();
            return n3;
        }
        joinedTokenSequence.move(n2);
        joinedTokenSequence.moveNext();
        return -1;
    }

    public void reformat(Context context, int n, int n2) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)context.document();
        baseDocument = this.doReformat(baseDocument, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDocument doReformat(BaseDocument baseDocument, int n, int n2) {
        BaseDocument baseDocument2 = new BaseDocument(XMLKit.class, false);
        this.spacesPerTab = IndentUtils.indentLevelSize((Document)baseDocument);
        baseDocument.atomicLock();
        try {
            baseDocument2.insertString(0, baseDocument.getText(0, baseDocument.getLength()), null);
            List<TokenElement> list = this.getTags(baseDocument, n, n2);
            for (int i = list.size() - 1; i >= 0; --i) {
                TokenElement tokenElement = list.get(i);
                int n3 = tokenElement.getStartOffset();
                int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3);
                String string = tokenElement.getName();
                if (string.startsWith(TAG_CLOSING_PREFIX)) {
                    Element element = baseDocument.getDefaultRootElement().getElement(n4);
                    String string2 = baseDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    int n5 = string2.lastIndexOf(string);
                    if (n5 == -1) continue;
                    int n6 = (string2 = string2.substring(0, n5)).lastIndexOf(TAG_OPENING_PREFIX + string.substring(2));
                    if (n6 == -1) {
                        this.changePrettyText(baseDocument2, tokenElement, n3);
                        continue;
                    }
                    if ((n6 = (string2 = string2.substring(n6 + 1)).indexOf(TAG_OPENING_PREFIX)) == -1) continue;
                    this.changePrettyText(baseDocument2, tokenElement, n3);
                    continue;
                }
                this.changePrettyText(baseDocument2, tokenElement, n3);
            }
            this.compareAndMerge((Document)baseDocument, (Document)baseDocument2);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (IOException iOException) {
        }
        finally {
            baseDocument.atomicUnlock();
        }
        return baseDocument;
    }

    private void changePrettyText(BaseDocument baseDocument, TokenElement tokenElement, int n) throws BadLocationException {
        Formatter formatter = Formatter.getFormatter(XMLKit.class);
        formatter.setExpandTabs(false);
        String string = IndentUtils.createIndentString((Document)baseDocument, (int)(tokenElement.getIndentLevel() * this.spacesPerTab));
        int n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n) + 1;
        String string2 = baseDocument.getText(n2, n - n2);
        if (string2.indexOf("\n") != -1) {
            int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            baseDocument.insertString(n, string, null);
            baseDocument.remove(n4, n3 - n4);
        } else {
            baseDocument.insertString(n, "\n" + string, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TokenElement> getTags(BaseDocument baseDocument, int n, int n2) throws BadLocationException, IOException {
        ArrayList<TokenElement> arrayList = new ArrayList<TokenElement>();
        baseDocument.readLock();
        int n3 = 0;
        try {
            TokenHierarchy tokenHierarchy;
            TokenSequence tokenSequence;
            Token token;
            int n4;
            int n5 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
            if (n5 > 0) {
                int n6 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n);
                int n7 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n6);
                int n8 = 0;
                n8 = n7 != n5 ? Utilities.getRowIndent((BaseDocument)baseDocument, (int)n6) : Utilities.getRowIndent((BaseDocument)baseDocument, (int)n);
                if (n8 < this.spacesPerTab) {
                    n3 = 1;
                } else if (n8 > this.spacesPerTab || n8 == this.spacesPerTab) {
                    n4 = n8 / this.spacesPerTab;
                    n3 = n4 + 1;
                }
            }
            if ((token = (tokenSequence = (tokenHierarchy = TokenHierarchy.get((Document)baseDocument)).tokenSequence()).token()) != null && token.id() == XMLTokenId.TEXT && tokenSequence.moveNext()) {
                token = tokenSequence.token();
            }
            n4 = 0;
            Stack<TokenElement> stack = new Stack<TokenElement>();
            String string = null;
            while (tokenSequence.moveNext()) {
                token = tokenSequence.token();
                XMLTokenId xMLTokenId = (XMLTokenId)token.id();
                String string2 = ((Object)token.text()).toString();
                if (tokenSequence.offset() < n || tokenSequence.offset() >= n2) {
                    n4 += string2.length();
                    continue;
                }
                TokenElement.TokenType tokenType = TokenElement.TokenType.TOKEN_WHITESPACE;
                switch (xMLTokenId) {
                    case TAG: {
                        TokenElement tokenElement;
                        int n9;
                        int n10;
                        int n11;
                        String string3;
                        int n12 = string2.length();
                        if (string2.charAt(n12 - 1) == '>') {
                            if (n12 != 2 || stack.empty()) break;
                            stack.pop();
                            break;
                        }
                        tokenType = TokenElement.TokenType.TOKEN_ELEMENT_START_TAG;
                        if (string2.startsWith(TAG_CLOSING_PREFIX)) {
                            string = string3 = string2.substring(2);
                            n11 = n4;
                            n10 = n11 + string2.length();
                            n9 = n3;
                            if (!stack.empty()) {
                                stack.pop();
                                n9 = stack.size() + n3;
                            }
                            tokenElement = new TokenElement(tokenType, string2, n11, n10, n9);
                            arrayList.add(tokenElement);
                            break;
                        }
                        string3 = string2.substring(1);
                        n11 = n4;
                        n10 = n11 + string2.length();
                        n9 = stack.size() + n3;
                        tokenElement = new TokenElement(tokenType, string3, n11, n10, n9);
                        arrayList.add(tokenElement);
                        stack.push(tokenElement);
                        break;
                    }
                    case BLOCK_COMMENT: 
                    case CDATA_SECTION: 
                    case PI_START: 
                    case PI_TARGET: 
                    case PI_CONTENT: 
                    case PI_END: 
                    case ARGUMENT: 
                    case VALUE: 
                    case TEXT: 
                    case CHARACTER: 
                    case WS: 
                    case OPERATOR: 
                    case DECLARATION: {
                        break;
                    }
                    default: {
                        throw new IOException("Invalid token found in document: Please use the text editor to resolve the issues...");
                    }
                }
                n4 += string2.length();
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return arrayList;
    }

    public boolean isOneLiner(int n, int n2, BaseDocument baseDocument) {
        try {
            return Utilities.getLineOffset((BaseDocument)baseDocument, (int)n) == Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void compareAndMerge(Document document, Document document2) throws IOException {
        Lookup lookup = Lookups.singleton((Object)document);
        ModelSource modelSource = new ModelSource(lookup, true);
        XDMModel xDMModel = new XDMModel(modelSource);
        xDMModel.sync();
        lookup = Lookups.singleton((Object)document2);
        modelSource = new ModelSource(lookup, true);
        XDMModel xDMModel2 = new XDMModel(modelSource);
        xDMModel2.sync();
        DefaultElementIdentity defaultElementIdentity = new DefaultElementIdentity();
        DiffFinder diffFinder = new DiffFinder((ElementIdentity)defaultElementIdentity);
        List list = diffFinder.findDiff(xDMModel.getDocument(), xDMModel2.getDocument());
        xDMModel.mergeDiff(list);
        xDMModel.flush();
    }
}

