/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.IntrospectionHelperProxy;
import org.openide.util.ChangeSupport;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectedInfo {
    private static final Logger LOG = Logger.getLogger(IntrospectedInfo.class.getName());
    private static IntrospectedInfo defaults = null;
    private static boolean defaultsInited = false;
    private static boolean defaultsEverInited = false;
    private Map<String, IntrospectedClass> clazzes = Collections.synchronizedMap(new TreeMap());
    private Map<String, Map<String, String>> namedefs = new TreeMap<String, Map<String, String>>();
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private ChangeListener antBridgeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            IntrospectedInfo.this.clearDefs();
            IntrospectedInfo.this.fireStateChanged();
        }
    };
    private ChangeListener holder;
    private static IntrospectedInfo merged;

    public static synchronized IntrospectedInfo getDefaults() {
        if (defaults == null) {
            defaults = new IntrospectedInfo();
        }
        return defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Class<IntrospectedInfo> clazz = IntrospectedInfo.class;
        synchronized (IntrospectedInfo.class) {
            if (!defaultsInited && this == defaults) {
                AntModule.err.log("IntrospectedInfo.getDefaults: loading...");
                defaultsInited = true;
                this.loadDefaults(!defaultsEverInited);
                defaultsEverInited = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void clearDefs() {
        this.clazzes.clear();
        this.namedefs.clear();
        defaultsInited = false;
    }

    private void loadDefaults(boolean bl) {
        ClassLoader classLoader = AntBridge.getMainClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/apache/tools/ant/taskdefs/defaults.properties");
        if (inputStream != null) {
            try {
                defaults.load(inputStream, "task", classLoader);
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not load default taskdefs");
                AntModule.err.notify((Throwable)iOException);
            }
        } else {
            AntModule.err.log("Could not open default taskdefs");
        }
        InputStream inputStream2 = classLoader.getResourceAsStream("org/apache/tools/ant/types/defaults.properties");
        if (inputStream2 != null) {
            try {
                defaults.load(inputStream2, "type", classLoader);
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not load default typedefs");
                AntModule.err.notify((Throwable)iOException);
            }
        } else {
            AntModule.err.log("Could not open default typedefs");
        }
        defaults.loadNetBeansSpecificDefinitions();
        if (bl) {
            AntBridge.addChangeListener(WeakListeners.change((ChangeListener)this.antBridgeListener, AntBridge.class));
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.defaults=" + defaults);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    private void fireStateChanged() {
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.fireStateChanged");
        }
        RequestProcessor.getDefault().post((Runnable)new ChangeTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefs(String string) {
        this.init();
        Map<String, Map<String, String>> map = this.namedefs;
        synchronized (map) {
            Map<String, String> map2 = this.namedefs.get(string);
            if (map2 != null) {
                return Collections.unmodifiableMap(map2);
            }
            return Collections.emptyMap();
        }
    }

    private IntrospectedClass getData(String string) throws IllegalArgumentException {
        IntrospectedClass introspectedClass = this.clazzes.get(string);
        if (introspectedClass == null) {
            throw new IllegalArgumentException("Unknown class: " + string);
        }
        return introspectedClass;
    }

    public boolean isKnown(String string) {
        this.init();
        return this.clazzes.get(string) != null;
    }

    public boolean supportsText(String string) throws IllegalArgumentException {
        this.init();
        return this.getData((String)string).supportsText;
    }

    public Map<String, String> getAttributes(String string) throws IllegalArgumentException {
        this.init();
        Map<String, String> map = this.getData((String)string).attrs;
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, String> getElements(String string) throws IllegalArgumentException {
        this.init();
        Map<String, String> map = this.getData((String)string).subs;
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public String[] getTags(String string) throws IllegalArgumentException {
        this.init();
        return this.getData((String)string).enumTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream inputStream, String string, ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        for (Map.Entry entry : NbCollections.checkedMapByFilter((Map)properties, String.class, String.class, (boolean)true).entrySet()) {
            String string2 = (String)entry.getKey();
            if (string.equals("type") && string2.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            String string3 = (String)entry.getValue();
            try {
                Class<?> clazz = classLoader.loadClass(string3);
                this.register(string2, clazz, string, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AntModule.err.log("IntrospectedInfo: skipping " + string3 + ": " + classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                AntModule.err.log("IntrospectedInfo: skipping " + string3 + ": " + noClassDefFoundError);
            }
            catch (LinkageError linkageError) {
                throw (IOException)new IOException("Could not load class " + string3 + ": " + linkageError).initCause(linkageError);
            }
            catch (RuntimeException runtimeException) {
                throw (IOException)new IOException("Could not load class " + string3 + ": " + runtimeException).initCause(runtimeException);
            }
        }
    }

    private void loadNetBeansSpecificDefinitions() {
        this.loadNetBeansSpecificDefinitions0(AntBridge.getCustomDefsNoNamespace());
        if (AntBridge.getInterface().isAnt16()) {
            this.loadNetBeansSpecificDefinitions0(AntBridge.getCustomDefsWithNamespace());
        }
    }

    private void loadNetBeansSpecificDefinitions0(Map<String, Map<String, Class>> map) {
        for (Map.Entry<String, Map<String, Class>> entry : map.entrySet()) {
            for (Map.Entry<String, Class> entry2 : entry.getValue().entrySet()) {
                this.register(entry2.getKey(), entry2.getValue(), entry.getKey());
            }
        }
    }

    public synchronized void register(String string, Class clazz, String string2) {
        this.register(string, clazz, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(String string, Class clazz, String string2, boolean bl) {
        this.init();
        Map<String, Map<String, String>> map = this.namedefs;
        synchronized (map) {
            Map<String, String> map2 = this.namedefs.get(string2);
            if (map2 == null) {
                map2 = new TreeMap<String, String>();
                this.namedefs.put(string2, map2);
            }
            map2.put(string, clazz.getName());
        }
        boolean bl2 = this.analyze(clazz, null, false);
        if (bl2 && bl) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(String string, String string2) {
        this.init();
        Map<String, Map<String, String>> map = this.namedefs;
        synchronized (map) {
            Map<String, String> map2 = this.namedefs.get(string2);
            if (map2 != null) {
                map2.remove(string);
            }
        }
        this.fireStateChanged();
    }

    private boolean analyze(Class clazz, Set<Class> set, boolean bl) {
        Iterator iterator;
        Object object;
        Object object2;
        String string = clazz.getName();
        if (IntrospectedInfo.getDefaults().isKnown(string)) {
            return false;
        }
        if ((set == null || !set.add(clazz)) && this.isKnown(string)) {
            return false;
        }
        IntrospectedClass introspectedClass = new IntrospectedClass();
        if (bl) {
            String[] stringArray = AntBridge.getInterface().getEnumeratedValues(clazz);
            if (stringArray != null) {
                introspectedClass.enumTags = stringArray;
                return !introspectedClass.equals(this.clazzes.put(clazz.getName(), introspectedClass));
            }
            return this.clazzes.remove(clazz.getName()) != null;
        }
        IntrospectionHelperProxy introspectionHelperProxy = AntBridge.getInterface().getIntrospectionHelper(clazz);
        introspectedClass.supportsText = introspectionHelperProxy.supportsCharacters();
        Enumeration<String> enumeration = introspectionHelperProxy.getAttributes();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                try {
                    object = introspectionHelperProxy.getAttributeType((String)object2);
                    iterator = ((Class)object).getName();
                    if (IntrospectedInfo.hasSuperclass(clazz, "org.apache.tools.ant.Task") && (((String)object2).equals("location") && ((String)((Object)iterator)).equals("org.apache.tools.ant.Location") || ((String)object2).equals("taskname") && ((String)((Object)iterator)).equals("java.lang.String") || ((String)object2).equals("description") && ((String)((Object)iterator)).equals("java.lang.String"))) continue;
                    if (introspectedClass.attrs == null) {
                        introspectedClass.attrs = new TreeMap<String, String>();
                    }
                    introspectedClass.attrs.put((String)object2, (String)((Object)iterator));
                    hashSet.add(object);
                }
                catch (RuntimeException runtimeException) {
                    AntModule.err.notify(1, (Throwable)runtimeException);
                }
            }
        } else {
            introspectedClass.attrs = null;
        }
        object2 = new HashSet();
        enumeration = introspectionHelperProxy.getNestedElements();
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                try {
                    iterator = introspectionHelperProxy.getElementType((String)object);
                    if (introspectedClass.subs == null) {
                        introspectedClass.subs = new TreeMap<String, String>();
                    }
                    introspectedClass.subs.put((String)object, ((Class)((Object)iterator)).getName());
                    object2.add(iterator);
                }
                catch (RuntimeException runtimeException) {
                    AntModule.err.notify(1, (Throwable)runtimeException);
                }
            }
        } else {
            introspectedClass.subs = null;
        }
        boolean bl2 = !introspectedClass.equals(this.clazzes.put(clazz.getName(), introspectedClass));
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            bl2 |= this.analyze(clazz2, set, false);
        }
        for (Class clazz2 : hashSet) {
            bl2 |= this.analyze(clazz2, set, true);
        }
        return bl2;
    }

    private static boolean hasSuperclass(Class clazz, String string) {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!clazz2.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void scanProject(Map<String, Map<String, Class>> map) {
        this.init();
        HashSet<Class> hashSet = new HashSet<Class>();
        boolean bl = false;
        for (Map.Entry<String, Map<String, Class>> entry : map.entrySet()) {
            bl |= this.scanMap(entry.getValue(), entry.getKey(), hashSet);
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.scanProject: " + this);
        }
        if (bl) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanMap(Map<String, Class> map, String string, Set<Class> set) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        for (Map.Entry<String, Class> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (string.equals("type") && string2.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            Class clazz = entry.getValue();
            if (clazz.getName().equals("org.apache.tools.ant.taskdefs.MacroInstance")) continue;
            Map<String, String> map2 = this.namedefs.get(string);
            if (map2 == null) {
                map2 = new TreeMap<String, String>();
                this.namedefs.put(string, map2);
            }
            IntrospectedInfo introspectedInfo = this;
            synchronized (introspectedInfo) {
                if (IntrospectedInfo.getDefaults().getDefs(string).get(string2) == null) {
                    bl |= !clazz.getName().equals(map2.put(string2, clazz.getName()));
                }
                if (!IntrospectedInfo.getDefaults().isKnown(clazz.getName())) {
                    try {
                        bl |= this.analyze(clazz, set, false);
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        AntModule.err.log("Skipping " + clazz.getName() + ": " + noClassDefFoundError);
                    }
                    catch (LinkageError linkageError) {
                        AntModule.err.annotate((Throwable)linkageError, 1, "Cannot scan class " + clazz.getName(), null, null, null);
                        AntModule.err.notify(1, (Throwable)linkageError);
                    }
                }
            }
        }
        return bl;
    }

    public String toString() {
        return "IntrospectedInfo[namedefs=" + this.namedefs + ",clazzes=" + this.clazzes + "]";
    }

    private static IntrospectedInfo merge(IntrospectedInfo[] introspectedInfoArray) {
        ChangeListener changeListener;
        final IntrospectedInfo introspectedInfo = new IntrospectedInfo();
        introspectedInfo.holder = changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                IntrospectedInfo introspectedInfo2 = (IntrospectedInfo)changeEvent.getSource();
                introspectedInfo2.init();
                introspectedInfo.clazzes.putAll(introspectedInfo2.clazzes);
                for (Map.Entry entry : introspectedInfo2.namedefs.entrySet()) {
                    String string = (String)entry.getKey();
                    Map map = (Map)entry.getValue();
                    if (introspectedInfo.namedefs.containsKey(string)) {
                        ((Map)introspectedInfo.namedefs.get(string)).putAll(map);
                        continue;
                    }
                    introspectedInfo.namedefs.put(string, new TreeMap(map));
                }
                introspectedInfo.fireStateChanged();
            }
        };
        for (IntrospectedInfo introspectedInfo2 : introspectedInfoArray) {
            introspectedInfo2.addChangeListener(WeakListeners.change((ChangeListener)changeListener, (Object)introspectedInfo2));
            changeListener.stateChanged(new ChangeEvent(introspectedInfo2));
        }
        return introspectedInfo;
    }

    public static synchronized IntrospectedInfo getKnownInfo() {
        if (merged == null) {
            merged = IntrospectedInfo.merge(new IntrospectedInfo[]{IntrospectedInfo.getDefaults(), AntSettings.getCustomDefs()});
        }
        return merged;
    }

    static {
        AntSettings.IntrospectedInfoSerializer.instance = new AntSettings.IntrospectedInfoSerializer(){
            Pattern p = Pattern.compile("(.+)\\.(supportsText|attrs\\.(.+)|subs\\.(.+)|enumTags)");

            public IntrospectedInfo load(Preferences preferences) {
                IntrospectedInfo introspectedInfo = new IntrospectedInfo();
                try {
                    for (String string : preferences.keys()) {
                        Object object;
                        String string2 = preferences.get(string, null);
                        assert (string2 != null) : string;
                        String[] stringArray = string.split("\\.", 2);
                        if (stringArray.length != 2) {
                            LOG.log(Level.WARNING, "malformed key: {0}", string);
                            continue;
                        }
                        if (stringArray[0].equals("class")) {
                            object = this.p.matcher(stringArray[1]);
                            boolean bl = ((Matcher)object).matches();
                            if (!bl) {
                                LOG.log(Level.WARNING, "malformed key: {0}", string);
                                continue;
                            }
                            String string3 = ((Matcher)object).group(1);
                            IntrospectedClass introspectedClass = this.assureDefined(introspectedInfo, string3);
                            String string4 = ((Matcher)object).group(2);
                            if (string4.equals("supportsText")) {
                                assert (string2.equals("true")) : string;
                                introspectedClass.supportsText = true;
                                continue;
                            }
                            if (string4.equals("enumTags")) {
                                introspectedClass.enumTags = string2.split(",");
                                continue;
                            }
                            if (((Matcher)object).group(3) != null) {
                                if (introspectedClass.attrs == null) {
                                    introspectedClass.attrs = new TreeMap<String, String>();
                                }
                                introspectedClass.attrs.put(((Matcher)object).group(3), string2);
                                continue;
                            }
                            assert (((Matcher)object).group(4) != null) : string;
                            if (introspectedClass.subs == null) {
                                introspectedClass.subs = new TreeMap<String, String>();
                            }
                            introspectedClass.subs.put(((Matcher)object).group(4), string2);
                            continue;
                        }
                        object = (Map)introspectedInfo.namedefs.get(stringArray[0]);
                        if (object == null) {
                            object = new TreeMap<String, String>();
                            introspectedInfo.namedefs.put(stringArray[0], object);
                        }
                        object.put(stringArray[1], string2);
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    LOG.log(Level.WARNING, null, backingStoreException);
                }
                for (String string : new String[]{"task", "type"}) {
                    if (introspectedInfo.namedefs.containsKey(string)) continue;
                    introspectedInfo.namedefs.put(string, new TreeMap());
                }
                return introspectedInfo;
            }

            private IntrospectedClass assureDefined(IntrospectedInfo introspectedInfo, String string) {
                IntrospectedClass introspectedClass = (IntrospectedClass)introspectedInfo.clazzes.get(string);
                if (introspectedClass == null) {
                    introspectedClass = new IntrospectedClass();
                    introspectedInfo.clazzes.put(string, introspectedClass);
                }
                return introspectedClass;
            }

            public void store(Preferences preferences, IntrospectedInfo introspectedInfo) {
                try {
                    preferences.clear();
                }
                catch (BackingStoreException backingStoreException) {
                    LOG.log(Level.WARNING, null, backingStoreException);
                    return;
                }
                for (Map.Entry entry : introspectedInfo.namedefs.entrySet()) {
                    for (Map.Entry object : ((Map)entry.getValue()).entrySet()) {
                        preferences.put((String)entry.getKey() + "." + (String)object.getKey(), (String)object.getValue());
                    }
                }
                for (Map.Entry entry : introspectedInfo.clazzes.entrySet()) {
                    String string = "class." + (String)entry.getKey();
                    IntrospectedClass introspectedClass = (IntrospectedClass)entry.getValue();
                    if (introspectedClass.supportsText) {
                        preferences.putBoolean((String)string + ".supportsText", true);
                    }
                    if (introspectedClass.attrs != null) {
                        for (Map.Entry<String, String> entry2 : introspectedClass.attrs.entrySet()) {
                            preferences.put((String)string + ".attrs." + entry2.getKey(), entry2.getValue());
                        }
                    }
                    if (introspectedClass.subs != null) {
                        for (Map.Entry entry3 : introspectedClass.subs.entrySet()) {
                            preferences.put((String)string + ".subs." + (String)entry3.getKey(), (String)entry3.getValue());
                        }
                    }
                    if (introspectedClass.enumTags == null) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string2 : introspectedClass.enumTags) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(string2);
                    }
                    preferences.put((String)string + ".enumTags", stringBuilder.toString());
                }
            }

            private boolean equiv(IntrospectedInfo introspectedInfo, IntrospectedInfo introspectedInfo2) {
                return ((Object)introspectedInfo.clazzes).equals(introspectedInfo2.clazzes) && ((Object)introspectedInfo.namedefs).equals(introspectedInfo2.namedefs);
            }
        };
    }

    private static final class IntrospectedClass {
        public boolean supportsText;
        public Map<String, String> attrs;
        public Map<String, String> subs;
        public String[] enumTags;

        private IntrospectedClass() {
        }

        public String toString() {
            return "IntrospectedClass[text=" + this.supportsText + ",attrs=" + this.attrs + ",subs=" + this.subs + ",enumTags=" + Arrays.toString(this.enumTags) + "]";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IntrospectedClass)) {
                return false;
            }
            IntrospectedClass introspectedClass = (IntrospectedClass)object;
            return this.supportsText == introspectedClass.supportsText && Utilities.compareObjects(this.attrs, introspectedClass.attrs) && Utilities.compareObjects(this.subs, introspectedClass.subs) && Utilities.compareObjects((Object)this.enumTags, (Object)introspectedClass.enumTags);
        }
    }

    private class ChangeTask
    implements Runnable {
        private ChangeTask() {
        }

        public void run() {
            IntrospectedInfo.this.cs.fireChange();
        }
    }
}

