/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AuxClassLoader;
import org.apache.tools.ant.module.bridge.BridgeInterface;
import org.apache.tools.ant.module.bridge.DummyBridgeImpl;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.io.NullOutputStream;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AntBridge {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance(AntBridge.class.getName());
    private static Reference<AntInstance> antInstance = null;
    private static final ChangeSupport cs = new ChangeSupport(AntBridge.class);
    private static MiscListener miscListener = new MiscListener();
    private static Lookup.Result<ModuleInfo> modulesResult = Lookup.getDefault().lookupResult(ModuleInfo.class);
    private static String originalJavaClassPath;
    private static int delegating;
    private static InputStream origIn;
    private static PrintStream origOut;
    private static PrintStream origErr;
    private static Map<ThreadGroup, InputStream> delegateIns;
    private static Map<ThreadGroup, PrintStream> delegateOuts;
    private static Map<ThreadGroup, PrintStream> delegateErrs;
    private static List<Thread> suspendedDelegationTasks;
    private static int fakingJavaClassPath;

    private AntBridge() {
    }

    public static synchronized void addChangeListener(ChangeListener changeListener) {
        cs.addChangeListener(changeListener);
    }

    public static synchronized void removeChangeListener(ChangeListener changeListener) {
        cs.removeChangeListener(changeListener);
    }

    private static void fireChange() {
        antInstance = null;
        cs.fireChange();
    }

    public static ClassLoader getMainClassLoader() {
        return AntBridge.getAntInstance().mainClassLoader;
    }

    public static Map<String, Map<String, Class>> getCustomDefsWithNamespace() {
        return AntBridge.getAntInstance().customDefs;
    }

    public static Map<String, Map<String, Class>> getCustomDefsNoNamespace() {
        HashMap<String, Map<String, Class>> hashMap = new HashMap<String, Map<String, Class>>();
        for (Map.Entry<String, Map<String, Class>> entry : AntBridge.getCustomDefsWithNamespace().entrySet()) {
            String string = entry.getKey();
            Map<String, Class> map = entry.getValue();
            HashMap<String, Class> hashMap2 = new HashMap<String, Class>();
            for (Map.Entry<String, Class> entry2 : map.entrySet()) {
                String string2 = entry2.getKey();
                Class clazz = entry2.getValue();
                int n = string2.lastIndexOf(58);
                String string3 = n != -1 ? string2.substring(n + 1) : string2;
                hashMap2.put(string3, clazz);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    public static Map<String, ClassLoader> getCustomDefClassLoaders() throws IOException {
        return AntBridge.getAntInstance().customDefClassLoaders;
    }

    public static BridgeInterface getInterface() {
        return AntBridge.getAntInstance().bridge;
    }

    private static synchronized AntInstance getAntInstance() {
        AntInstance antInstance = AntBridge.antInstance != null ? AntBridge.antInstance.get() : null;
        if (antInstance == null) {
            antInstance = AntBridge.createAntInstance();
            AntBridge.antInstance = new SoftReference<AntInstance>(antInstance);
        }
        return antInstance;
    }

    private static AntInstance createAntInstance() {
        err.log("AntBridge.createAntInstance - loading Ant installation...");
        try {
            Object object;
            List<File> list = AntBridge.createMainClassPath();
            err.log("mainClassPath=" + list);
            ClassLoader classLoader = AntBridge.createMainClassLoader(list);
            ClassLoader classLoader2 = AntBridge.createBridgeClassLoader(classLoader);
            Class<?> clazz = Class.forName("org.apache.tools.ant.input.InputHandler", false, classLoader2);
            Class<BridgeInterface> clazz2 = classLoader2.loadClass("org.apache.tools.ant.module.bridge.impl.BridgeImpl").asSubclass(BridgeInterface.class);
            if (AntSettings.getAntHome() != null) {
                object = clazz.getClassLoader();
                if (object != classLoader) {
                    throw new IllegalStateException("Wrong class loader is finding Ant: " + object);
                }
                Class<?> clazz3 = Class.forName("org.apache.tools.ant.input.InputHandler", false, classLoader);
                if (clazz3 != clazz) {
                    throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + clazz3.getClassLoader());
                }
                try {
                    Class<?> clazz4 = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, classLoader2);
                    if (clazz4.getClassLoader() != classLoader) {
                        throw new IllegalStateException("Bridge loader is loading stuff from elsewhere: " + clazz4.getClassLoader());
                    }
                    Class<?> clazz5 = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, classLoader);
                    if (clazz5 != clazz4) {
                        throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + clazz5.getClassLoader());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz2.getClassLoader() != classLoader2) {
                    throw new IllegalStateException("Wrong class loader is finding bridge impl: " + clazz2.getClassLoader());
                }
            }
            object = AntBridge.createCustomDefClassLoaders(classLoader);
            return new AntInstance(AntBridge.classPathToString(list), classLoader, classLoader2, clazz2.newInstance(), AntBridge.createCustomDefs((Map<String, ClassLoader>)object), (Map<String, ClassLoader>)object);
        }
        catch (Exception exception) {
            return AntBridge.fallback(exception);
        }
        catch (LinkageError linkageError) {
            return AntBridge.fallback(linkageError);
        }
    }

    private static AntInstance fallback(Throwable throwable) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        HashMap<String, Map<String, Class>> hashMap = new HashMap<String, Map<String, Class>>();
        hashMap.put("task", new HashMap());
        hashMap.put("type", new HashMap());
        return new AntInstance("", classLoader, classLoader, new DummyBridgeImpl(throwable), hashMap, Collections.<String, ClassLoader>emptyMap());
    }

    private static String classPathToString(List<File> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().getAbsolutePath());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }

    public static String getMainClassPath() {
        return AntBridge.getAntInstance().mainClassPath + File.pathSeparatorChar + originalJavaClassPath;
    }

    private static List<File> createMainClassPath() throws Exception {
        Object object;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        File file = AntSettings.getAntHome();
        if (file != null) {
            File[] fileArray;
            object = new File(file, "lib");
            if (!object.isDirectory()) {
                throw new IOException("No such Ant library dir: " + object);
            }
            err.log("Creating main class loader from " + object);
            File[] fileArray2 = new File(object.getParentFile(), "patches").listFiles(new JarFilter());
            if (fileArray2 != null) {
                linkedHashSet.addAll(Arrays.asList(fileArray2));
            }
            if ((fileArray = object.listFiles(new JarFilter())) == null) {
                throw new IOException("Listing: " + object);
            }
            linkedHashSet.addAll(Arrays.asList(fileArray));
        } else {
            object = new File(new File(new File(System.getProperty("java.home")).getParentFile(), "lib"), "tools.jar");
            if (object.isFile()) {
                linkedHashSet.add(object);
            }
        }
        object = new File(new File(System.getProperty("user.home"), ".ant"), "lib").listFiles(new JarFilter());
        if (object != null) {
            linkedHashSet.addAll(Arrays.asList(object));
        }
        linkedHashSet.addAll(AntSettings.getExtraClasspath());
        linkedHashSet.addAll(AntSettings.getAutomaticExtraClasspath());
        return new ArrayList<File>(linkedHashSet);
    }

    private static ClassLoader createMainClassLoader(List<File> list) throws Exception {
        URL[] uRLArray = new URL[list.size()];
        Iterator<File> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            uRLArray[n++] = iterator.next().toURI().toURL();
        }
        if (AntSettings.getAntHome() != null) {
            ClassLoader classLoader = Lookup.class.getClassLoader();
            if (err.isLoggable(1)) {
                List<URL> list2 = classLoader instanceof URLClassLoader ? Arrays.asList(((URLClassLoader)classLoader).getURLs()) : null;
                err.log("AntBridge.createMainClassLoader: cp=" + Arrays.asList(uRLArray) + " parent.urls=" + list2);
            }
            return new MaskedClassLoader(uRLArray, classLoader);
        }
        ClassLoader classLoader = AntBridge.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            try {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                for (URL uRL : uRLArray) {
                    method.invoke((Object)classLoader, uRL);
                }
                return classLoader;
            }
            catch (Exception exception) {
                err.notify(16, (Throwable)exception);
            }
        }
        return new AllPermissionURLClassLoader(uRLArray, classLoader);
    }

    private static ClassLoader createBridgeClassLoader(ClassLoader classLoader) throws Exception {
        File file = InstalledFileLocator.getDefault().locate("ant/nblib/bridge.jar", "org.apache.tools.ant.module", false);
        if (file == null) {
            return classLoader;
        }
        return AntBridge.createAuxClassLoader(file, classLoader, AntBridge.class.getClassLoader());
    }

    private static ClassLoader createAuxClassLoader(File file, ClassLoader classLoader, ClassLoader classLoader2) throws IOException {
        return new AuxClassLoader(classLoader2, classLoader, file.toURI().toURL());
    }

    private static Map<String, ClassLoader> createCustomDefClassLoaders(ClassLoader classLoader) throws IOException {
        HashMap<String, ClassLoader> hashMap = new HashMap<String, ClassLoader>();
        ModuleInfo[] moduleInfoArray = miscListener.getEnabledModules();
        InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
        for (ModuleInfo moduleInfo : moduleInfoArray) {
            String string = moduleInfo.getCodeNameBase();
            String string2 = string.replace('.', '-');
            File file = installedFileLocator.locate("ant/nblib/" + string2 + ".jar", string, false);
            if (file == null) {
                if (classLoader.getResource(string.replace('.', '/') + "/antlib.xml") == null) continue;
                hashMap.put(string, classLoader);
                continue;
            }
            ClassLoader classLoader2 = AntBridge.createAuxClassLoader(file, classLoader, moduleInfo.getClassLoader());
            hashMap.put(string, classLoader2);
        }
        return hashMap;
    }

    private static Map<String, Map<String, Class>> createCustomDefs(Map<String, ClassLoader> map) throws IOException {
        HashMap<String, Map<String, Class>> hashMap = new HashMap<String, Map<String, Class>>();
        HashMap<String, Class> hashMap2 = new HashMap<String, Class>();
        HashMap<String, Class> hashMap3 = new HashMap<String, Class>();
        hashMap.put("task", hashMap2);
        hashMap.put("type", hashMap3);
        for (Map.Entry<String, ClassLoader> entry : map.entrySet()) {
            Document document;
            String string;
            String string2 = entry.getKey();
            ClassLoader classLoader = entry.getValue();
            URL uRL = classLoader.getResource(string = string2.replace('.', '/') + "/antlib.xml");
            if (uRL == null) {
                throw new IOException("Could not find " + string + " in ant/nblib/" + string2.replace('.', '-') + ".jar");
            }
            try {
                document = XMLUtil.parse((InputSource)new InputSource(uRL.toExternalForm()), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException(sAXException.toString()).initCause(sAXException);
            }
            Element element = document.getDocumentElement();
            if (!element.getLocalName().equals("antlib")) {
                throw new IOException("Bad root element for " + uRL + ": " + element);
            }
            NodeList nodeList = element.getChildNodes();
            HashMap<String, String> hashMap4 = new HashMap<String, String>();
            HashMap<String, String> hashMap5 = new HashMap<String, String>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean bl;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                if (element2.getNodeName().equals("taskdef")) {
                    bl = false;
                } else if (element2.getNodeName().equals("typedef")) {
                    bl = true;
                } else {
                    err.log(16, "Warning: unrecognized definition " + element2 + " in " + uRL);
                    continue;
                }
                String string3 = element2.getAttribute("name");
                if (string3 == null) {
                    err.log(16, "Warning: skipping definition " + element2 + " with no 'name' in " + uRL);
                    continue;
                }
                String string4 = element2.getAttribute("classname");
                if (string4 == null) {
                    throw new IOException("No 'classname' attr on def of " + string3 + " in " + uRL);
                }
                String string5 = "antlib:" + string2 + ":" + string3;
                (bl ? hashMap5 : hashMap4).put(string5, string4);
            }
            AntBridge.loadDefs(hashMap4, hashMap2, classLoader);
            AntBridge.loadDefs(hashMap5, hashMap3, classLoader);
        }
        return hashMap;
    }

    private static void loadDefs(Map<String, String> map, Map<String, Class> map2, ClassLoader classLoader) throws IOException {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            try {
                Class<?> clazz = classLoader.loadClass(string2);
                map2.put(string, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (IOException)new IOException("Could not load class " + string2 + ": " + classNotFoundException).initCause(classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                err.log("AntBridge.loadDefs: skipping " + string2 + ": " + noClassDefFoundError);
            }
            catch (LinkageError linkageError) {
                throw (IOException)new IOException("Could not load class " + string2 + ": " + linkageError).initCause(linkageError);
            }
        }
    }

    private static boolean masked(String string) {
        return string.startsWith("org.apache.tools.") || string.startsWith("org.netbeans.") || string.startsWith("org.openide.") || string.startsWith("org.openidex.");
    }

    public static synchronized void pushSystemInOutErr(InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        if (delegating++ == 0) {
            origIn = System.in;
            origOut = System.out;
            origErr = System.err;
            System.setIn(new MultiplexInputStream());
            System.setOut(new MultiplexPrintStream(false));
            System.setErr(new MultiplexPrintStream(true));
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        delegateIns.put(threadGroup, inputStream);
        delegateOuts.put(threadGroup, printStream);
        delegateErrs.put(threadGroup, printStream2);
    }

    public static synchronized void restoreSystemInOutErr() {
        assert (delegating > 0);
        if (--delegating == 0) {
            System.setIn(origIn);
            System.setOut(origOut);
            System.setErr(origErr);
            origIn = null;
            origOut = null;
            origErr = null;
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        delegateIns.remove(threadGroup);
        delegateOuts.remove(threadGroup);
        delegateErrs.remove(threadGroup);
    }

    public static synchronized void suspendDelegation() {
        Thread thread = Thread.currentThread();
        suspendedDelegationTasks.add(thread);
    }

    public static synchronized void resumeDelegation() {
        Thread thread = Thread.currentThread();
        assert (suspendedDelegationTasks.contains(thread)) : "Have not suspended delegation in " + thread;
        suspendedDelegationTasks.remove(thread);
    }

    public static synchronized InputStream delegateInputStream() {
        ThreadGroup threadGroup;
        Thread thread = Thread.currentThread();
        for (threadGroup = thread.getThreadGroup(); threadGroup != null && !delegateIns.containsKey(threadGroup); threadGroup = threadGroup.getParent()) {
        }
        InputStream inputStream = delegateIns.get(threadGroup);
        return inputStream != null ? inputStream : origIn;
    }

    public static synchronized PrintStream delegateOutputStream(boolean bl) {
        ThreadGroup threadGroup;
        Thread thread = Thread.currentThread();
        for (threadGroup = thread.getThreadGroup(); threadGroup != null && !delegateIns.containsKey(threadGroup); threadGroup = threadGroup.getParent()) {
        }
        PrintStream printStream = (bl ? delegateErrs : delegateOuts).get(threadGroup);
        return printStream != null ? printStream : (bl ? origErr : origOut);
    }

    public static synchronized void fakeJavaClassPath() {
        if (fakingJavaClassPath++ == 0) {
            String string = AntBridge.getMainClassPath();
            err.log("Faking java.class.path=" + string);
            System.setProperty("java.class.path", string);
        }
    }

    public static synchronized void unfakeJavaClassPath() {
        if (--fakingJavaClassPath == 0) {
            err.log("Restoring java.class.path=" + originalJavaClassPath);
            System.setProperty("java.class.path", originalJavaClassPath);
        }
    }

    static {
        AntSettings.addPropertyChangeListener(miscListener);
        modulesResult.addLookupListener((LookupListener)miscListener);
        originalJavaClassPath = System.getProperty("java.class.path");
        delegating = 0;
        delegateIns = new HashMap<ThreadGroup, InputStream>();
        delegateOuts = new HashMap<ThreadGroup, PrintStream>();
        delegateErrs = new HashMap<ThreadGroup, PrintStream>();
        suspendedDelegationTasks = new ArrayList<Thread>();
        fakingJavaClassPath = 0;
    }

    private static final class MultiplexPrintStream
    extends PrintStream {
        private final boolean err;

        public MultiplexPrintStream(boolean bl) {
            this(new NullOutputStream(), bl);
        }

        private MultiplexPrintStream(NullOutputStream nullOutputStream, boolean bl) {
            super((OutputStream)nullOutputStream);
            nullOutputStream.throwException = true;
            this.err = bl;
        }

        private PrintStream delegate() {
            PrintStream printStream;
            ThreadGroup threadGroup;
            Map map;
            Thread thread = Thread.currentThread();
            Map map2 = map = this.err ? delegateErrs : delegateOuts;
            for (threadGroup = thread.getThreadGroup(); threadGroup != null && !map.containsKey(threadGroup); threadGroup = threadGroup.getParent()) {
            }
            PrintStream printStream2 = (PrintStream)map.get(threadGroup);
            if (printStream2 != null && !suspendedDelegationTasks.contains(thread)) {
                assert (!(printStream2 instanceof MultiplexPrintStream));
                return printStream2;
            }
            if (delegating > 0) {
                PrintStream printStream3;
                PrintStream printStream4 = printStream3 = this.err ? origErr : origOut;
                assert (printStream3 != null);
                assert (!(printStream3 instanceof MultiplexPrintStream));
                return printStream3;
            }
            PrintStream printStream5 = printStream = this.err ? System.err : System.out;
            assert (!(printStream instanceof MultiplexPrintStream));
            return printStream;
        }

        public boolean checkError() {
            return this.delegate().checkError();
        }

        public void close() {
            this.delegate().close();
        }

        public void flush() {
            this.delegate().flush();
        }

        public void print(long l) {
            this.delegate().print(l);
        }

        public void print(char[] cArray) {
            this.delegate().print(cArray);
        }

        public void print(int n) {
            this.delegate().print(n);
        }

        public void print(boolean bl) {
            this.delegate().print(bl);
        }

        public void print(char c) {
            this.delegate().print(c);
        }

        public void print(float f) {
            this.delegate().print(f);
        }

        public void print(double d) {
            this.delegate().print(d);
        }

        public void print(Object object) {
            this.delegate().print(object);
        }

        public void print(String string) {
            this.delegate().print(string);
        }

        public void println(double d) {
            this.delegate().println(d);
        }

        public void println(Object object) {
            this.delegate().println(object);
        }

        public void println(float f) {
            this.delegate().println(f);
        }

        public void println(int n) {
            this.delegate().println(n);
        }

        public void println(char c) {
            this.delegate().println(c);
        }

        public void println(boolean bl) {
            this.delegate().println(bl);
        }

        public void println(String string) {
            this.delegate().println(string);
        }

        public void println(char[] cArray) {
            this.delegate().println(cArray);
        }

        public void println() {
            this.delegate().println();
        }

        public void println(long l) {
            this.delegate().println(l);
        }

        public void write(int n) {
            this.delegate().write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.delegate().write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) {
            this.delegate().write(byArray, n, n2);
        }
    }

    private static final class MultiplexInputStream
    extends InputStream {
        private InputStream delegate() {
            ThreadGroup threadGroup;
            Thread thread = Thread.currentThread();
            for (threadGroup = thread.getThreadGroup(); threadGroup != null && !delegateIns.containsKey(threadGroup); threadGroup = threadGroup.getParent()) {
            }
            InputStream inputStream = (InputStream)delegateIns.get(threadGroup);
            if (inputStream != null && !suspendedDelegationTasks.contains(thread)) {
                return inputStream;
            }
            if (delegating > 0) {
                assert (origIn != null);
                return origIn;
            }
            return System.in;
        }

        public int read() throws IOException {
            return this.delegate().read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.delegate().read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.delegate().read(byArray, n, n2);
        }

        public int available() throws IOException {
            return this.delegate().available();
        }

        public boolean markSupported() {
            return this.delegate().markSupported();
        }

        public void mark(int n) {
            this.delegate().mark(n);
        }

        public void close() throws IOException {
            this.delegate().close();
        }

        public long skip(long l) throws IOException {
            return this.delegate().skip(l);
        }

        public void reset() throws IOException {
            this.delegate().reset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MaskedClassLoader
    extends AllPermissionURLClassLoader {
        public MaskedClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        @Override
        protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (AntBridge.masked(string)) {
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz == null) {
                    clazz = this.findClass(string);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return super.loadClass(string, bl);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            if (string.equals("META-INF/services/javax.xml.stream.XMLInputFactory")) {
                return super.getResourceAsStream(string);
            }
            if (string.startsWith("META-INF/services/javax.xml.")) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return super.getResourceAsStream(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AllPermissionURLClassLoader
    extends URLClassLoader {
        private static PermissionCollection allPermission;

        private static synchronized PermissionCollection getAllPermissions() {
            if (allPermission == null) {
                allPermission = new Permissions();
                allPermission.add(new AllPermission());
            }
            return allPermission;
        }

        public AllPermissionURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        @Override
        protected final PermissionCollection getPermissions(CodeSource codeSource) {
            return AllPermissionURLClassLoader.getAllPermissions();
        }

        public String toString() {
            return super.toString() + "[parent=" + this.getParent() + ",urls=" + Arrays.asList(this.getURLs()) + "]";
        }

        @Override
        public URL getResource(String string) {
            URL uRL = super.getResource(string);
            if (err.isLoggable(1)) {
                err.log("APURLCL.gR: " + string + " -> " + uRL + " [" + this + "]");
            }
            return uRL;
        }

        @Override
        public Enumeration<URL> findResources(String string) throws IOException {
            try {
                Enumeration<URL> enumeration = super.findResources(string);
                if (err.isLoggable(1)) {
                    ArrayList<URL> arrayList = Collections.list(enumeration);
                    enumeration = Collections.enumeration(arrayList);
                    err.log("APURLCL.fRs: " + string + " -> " + arrayList + " [" + this + "]");
                }
                return enumeration;
            }
            catch (IOException iOException) {
                if (err.isLoggable(1)) {
                    err.notify(1, (Throwable)iOException);
                }
                throw iOException;
            }
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase(Locale.US).endsWith(".jar");
        }
    }

    private static final class MiscListener
    implements PropertyChangeListener,
    LookupListener {
        private ModuleInfo[] modules = null;

        MiscListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("antHome".equals(string) || "extraClasspath".equals(string) || "automaticExtraClasspath".equals(string)) {
                err.log("AntBridge got settings change in " + string);
                AntBridge.fireChange();
            } else if ("enabled".equals(string)) {
                err.log("AntBridge got module enablement change on " + propertyChangeEvent.getSource());
                AntBridge.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            err.log("AntModule got ModuleInfo change");
            MiscListener miscListener = this;
            synchronized (miscListener) {
                if (this.modules != null) {
                    for (ModuleInfo moduleInfo : this.modules) {
                        moduleInfo.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.modules = null;
                }
            }
            AntBridge.fireChange();
        }

        public synchronized ModuleInfo[] getEnabledModules() {
            ArrayList<ModuleInfo> arrayList;
            if (this.modules == null) {
                arrayList = modulesResult.allInstances();
                for (ModuleInfo moduleInfo : this.modules = arrayList.toArray(new ModuleInfo[arrayList.size()])) {
                    moduleInfo.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            arrayList = new ArrayList<ModuleInfo>(this.modules.length);
            for (ModuleInfo moduleInfo : this.modules) {
                if (!moduleInfo.isEnabled()) continue;
                arrayList.add(moduleInfo);
            }
            return arrayList.toArray(new ModuleInfo[arrayList.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AntInstance {
        public final String mainClassPath;
        public final ClassLoader mainClassLoader;
        public final ClassLoader bridgeClassLoader;
        public final BridgeInterface bridge;
        public final Map<String, Map<String, Class>> customDefs;
        public final Map<String, ClassLoader> customDefClassLoaders;

        public AntInstance(String string, ClassLoader classLoader, ClassLoader classLoader2, BridgeInterface bridgeInterface, Map<String, Map<String, Class>> map, Map<String, ClassLoader> map2) {
            this.mainClassPath = string;
            this.mainClassLoader = classLoader;
            this.bridgeClassLoader = classLoader2;
            this.bridge = bridgeInterface;
            this.customDefs = map;
            this.customDefClassLoaders = map2;
        }
    }
}

