/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.openide.ErrorManager;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;

public class SyntaxErrorHighlighter
implements ParserManagerListener {
    private NbEditorDocument doc;
    private ParserManagerImpl parserManager;
    private List<LanguagesAnnotation> annotations = new ArrayList<LanguagesAnnotation>();

    public SyntaxErrorHighlighter(Document document) {
        this.doc = (NbEditorDocument)document;
        this.parserManager = ParserManagerImpl.getImpl(document);
        this.parserManager.addListener(this);
    }

    public void parsed(ParserManager.State state, ASTNode aSTNode) {
        final ArrayList<SyntaxError> arrayList = new ArrayList<SyntaxError>(this.parserManager.getSyntaxErrors());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ArrayList<LanguagesAnnotation> arrayList2 = new ArrayList<LanguagesAnnotation>();
                    Iterator iterator = SyntaxErrorHighlighter.this.annotations.iterator();
                    LanguagesAnnotation languagesAnnotation = iterator.hasNext() ? (LanguagesAnnotation)((Object)iterator.next()) : null;
                    Iterator iterator2 = arrayList.iterator();
                    int n = -1;
                    int n2 = 0;
                    while (iterator2.hasNext() && n2 < 100) {
                        int n3;
                        SyntaxError syntaxError = (SyntaxError)iterator2.next();
                        ASTItem aSTItem = syntaxError.getItem();
                        String string = syntaxError.getMessage();
                        while (languagesAnnotation != null && languagesAnnotation.getPosition().getOffset() < aSTItem.getOffset()) {
                            SyntaxErrorHighlighter.this.doc.removeAnnotation((Annotation)languagesAnnotation);
                            languagesAnnotation = iterator.hasNext() ? (LanguagesAnnotation)((Object)iterator.next()) : null;
                        }
                        ++n2;
                        if (languagesAnnotation != null && languagesAnnotation.getPosition().getOffset() == aSTItem.getOffset() && languagesAnnotation.getShortDescription().equals(string)) {
                            n3 = NbDocument.findLineNumber((StyledDocument)SyntaxErrorHighlighter.this.doc, (int)languagesAnnotation.getPosition().getOffset());
                            if (n3 > n) {
                                arrayList2.add(languagesAnnotation);
                            } else {
                                SyntaxErrorHighlighter.this.doc.removeAnnotation((Annotation)languagesAnnotation);
                            }
                            n = n3;
                            languagesAnnotation = iterator.hasNext() ? (LanguagesAnnotation)((Object)iterator.next()) : null;
                            continue;
                        }
                        n3 = NbDocument.findLineNumber((StyledDocument)SyntaxErrorHighlighter.this.doc, (int)aSTItem.getOffset());
                        if (n3 == n) continue;
                        LanguagesAnnotation languagesAnnotation2 = new LanguagesAnnotation("SyntaxError", string);
                        Position position = SyntaxErrorHighlighter.this.doc.createPosition(aSTItem.getOffset());
                        languagesAnnotation2.setPosition(position);
                        SyntaxErrorHighlighter.this.doc.addAnnotation(position, aSTItem.getLength(), (Annotation)languagesAnnotation2);
                        arrayList2.add(languagesAnnotation2);
                        n = n3;
                    }
                    if (languagesAnnotation != null) {
                        SyntaxErrorHighlighter.this.doc.removeAnnotation((Annotation)languagesAnnotation);
                    }
                    while (iterator.hasNext()) {
                        SyntaxErrorHighlighter.this.doc.removeAnnotation((Annotation)iterator.next());
                    }
                    SyntaxErrorHighlighter.this.annotations = arrayList2;
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        });
    }

    static class LanguagesAnnotation
    extends Annotation {
        private String type;
        private String description;
        private Position position;

        LanguagesAnnotation(String string, String string2) {
            this.type = string;
            this.description = string2;
        }

        public String getAnnotationType() {
            return this.type;
        }

        public String getShortDescription() {
            return this.description;
        }

        void setPosition(Position position) {
            this.position = position;
        }

        Position getPosition() {
            return this.position;
        }
    }
}

