/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.dirchooser.DirectoryCellEditor;
import org.netbeans.swing.dirchooser.DirectoryNode;
import org.netbeans.swing.dirchooser.FileCompletionPopup;
import org.netbeans.swing.dirchooser.InputBlocker;
import org.openide.awt.HtmlRenderer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryChooserUI
extends BasicFileChooserUI {
    private static final Dimension horizontalStrut1 = new Dimension(25, 1);
    private static final Dimension verticalStrut1 = new Dimension(1, 4);
    private static final Dimension verticalStrut2 = new Dimension(1, 6);
    private static final Dimension verticalStrut3 = new Dimension(1, 8);
    private static Dimension PREF_SIZE = new Dimension(425, 245);
    private static Dimension MIN_SIZE = new Dimension(425, 245);
    private static Dimension TREE_PREF_SIZE = new Dimension(380, 230);
    private static final int ACCESSORY_WIDTH = 250;
    private static final Logger LOG = Logger.getLogger(DirectoryChooserUI.class.getName());
    private JPanel centerPanel;
    private JLabel lookInComboBoxLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private ActionListener directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterTypeComboBoxModel filterTypeComboBoxModel;
    private JTextField filenameTextField;
    private JComponent placesBar;
    private boolean placesBarFailed = false;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterTypeComboBox;
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String homeFolderTooltipText = null;
    private Action newFolderAction = new NewDirectoryAction();
    private BasicFileChooserUI.BasicFileView fileView = new DirectoryChooserFileView();
    private static JTree tree;
    private DirectoryTreeModel model;
    private DirectoryNode newFolderNode;
    private JComponent treeViewPanel;
    private InputBlocker blocker;
    private static JFileChooser fileChooser;
    private boolean changeDirectory = true;
    private boolean showPopupCompletion = false;
    private boolean addNewDirectory = false;
    private JPopupMenu popupMenu;
    private FileCompletionPopup completionPopup;
    private RequestProcessor.Task updateWorker;
    private boolean useShellFolder = false;
    private JButton upFolderButton;
    private JButton newFolderButton;
    private JComponent topCombo;
    private JComponent topComboWrapper;
    private JComponent topToolbar;

    public static ComponentUI createUI(JComponent jComponent) {
        return new DirectoryChooserUI((JFileChooser)jComponent);
    }

    public DirectoryChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
        super.uninstallComponents(jFileChooser);
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        fileChooser = jFileChooser;
        jFileChooser.setFocusCycleRoot(true);
        jFileChooser.setBorder(new EmptyBorder(4, 10, 10, 10));
        jFileChooser.setLayout(new BorderLayout(8, 8));
        this.updateUseShellFolder();
        this.createCenterPanel(jFileChooser);
        jFileChooser.add((Component)this.centerPanel, "Center");
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.getStringOfFileNames(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.getStringOfFileName(jFileChooser.getSelectedFile()));
        }
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        this.createPopup();
    }

    private void updateUseShellFolder() {
        Boolean bl = (Boolean)fileChooser.getClientProperty("FileChooser.useShellFolder");
        if (bl != null) {
            this.useShellFolder = bl;
        } else {
            File[] fileArray;
            this.useShellFolder = false;
            File[] fileArray2 = fileChooser.getFileSystemView().getRoots();
            if (fileArray2 != null && fileArray2.length == 1 && (fileArray = this.getShellFolderRoots()) != null && fileArray.length > 0 && fileArray2[0] == fileArray[0]) {
                this.useShellFolder = true;
            }
        }
        if (Utilities.isWindows()) {
            if (this.useShellFolder) {
                if (this.placesBar == null) {
                    this.placesBar = this.getPlacesBar();
                }
                if (this.placesBar != null) {
                    fileChooser.add((Component)this.placesBar, "Before");
                    if (this.placesBar instanceof PropertyChangeListener) {
                        fileChooser.addPropertyChangeListener((PropertyChangeListener)((Object)this.placesBar));
                    }
                }
            } else if (this.placesBar != null) {
                fileChooser.remove(this.placesBar);
                if (this.placesBar instanceof PropertyChangeListener) {
                    fileChooser.removePropertyChangeListener((PropertyChangeListener)((Object)this.placesBar));
                }
                this.placesBar = null;
            }
        }
    }

    private JComponent getPlacesBar() {
        if (this.placesBarFailed) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("sun.swing.WindowsPlacesBar");
            Class[] classArray = new Class[]{JFileChooser.class, Boolean.TYPE};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (JComponent)constructor.newInstance(fileChooser, this.isXPStyle());
        }
        catch (Exception exception) {
            Logger.getLogger(DirectoryChooserUI.class.getName()).log(Level.FINE, "WindowsPlacesBar class can't be instantiated.", exception);
            this.placesBarFailed = true;
            return null;
        }
    }

    private File getShellFolderForFile(File file) {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            return (File)clazz.getMethod("getShellFolder", File.class).invoke(null, file);
        }
        catch (Exception exception) {
            Logger.getLogger(DirectoryChooserUI.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exception);
            return null;
        }
    }

    private File getShellFolderForFileLinkLoc(File file) {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            Object object = clazz.getMethod("getShellFolder", File.class).invoke(null, file);
            return (File)clazz.getMethod("getLinkLocation", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            Logger.getLogger(DirectoryChooserUI.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exception);
            return null;
        }
    }

    private File[] getShellFolderRoots() {
        try {
            Class<?> clazz = Class.forName("sun.awt.shell.ShellFolder");
            return (File[])clazz.getMethod("get", String.class).invoke(null, "fileChooserComboBoxFolders");
        }
        catch (Exception exception) {
            Logger.getLogger(DirectoryChooserUI.class.getName()).log(Level.FINE, "ShellFolder can't be used.", exception);
            return null;
        }
    }

    private void createBottomPanel(JFileChooser jFileChooser) {
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 2));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(Box.createRigidArea(verticalStrut1));
        JLabel jLabel = new JLabel(this.fileNameLabelText);
        jLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jLabel.setAlignmentY(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(1, 12)));
        JLabel jLabel2 = new JLabel(this.filesOfTypeLabelText);
        jLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel.add(jLabel2);
        this.bottomPanel.add(jPanel);
        this.bottomPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(Box.createRigidArea(verticalStrut3));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.filenameTextField = new JTextField(24){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.filenameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                DirectoryChooserUI.this.updateCompletions();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DirectoryChooserUI.this.updateCompletions();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.filenameTextField.addKeyListener(new TextFieldKeyListener());
        jLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!DirectoryChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    tree.clearSelection();
                }
            }
        });
        Set<AWTKeyStroke> set = this.filenameTextField.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
        hashSet.remove(AWTKeyStroke.getAWTKeyStroke(9, 0));
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        this.filenameTextField.setFocusTraversalKeys(0, hashSet);
        jPanel2.add(this.filenameTextField);
        jPanel2.add(Box.createRigidArea(verticalStrut3));
        this.filterTypeComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterTypeComboBoxModel);
        this.filterTypeComboBox = new JComboBox(this.filterTypeComboBoxModel);
        jLabel2.setLabelFor(this.filterTypeComboBox);
        this.filterTypeComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel2.add(this.filterTypeComboBox);
        this.bottomPanel.add(jPanel2);
        this.bottomPanel.add(Box.createRigidArea(horizontalStrut1));
        this.createButtonsPanel(jFileChooser);
    }

    private void createButtonsPanel(JFileChooser jFileChooser) {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser)){

            public Dimension getMaximumSize() {
                return ((DirectoryChooserUI)DirectoryChooserUI.this).approveButton.getPreferredSize().width > ((DirectoryChooserUI)DirectoryChooserUI.this).cancelButton.getPreferredSize().width ? DirectoryChooserUI.this.approveButton.getPreferredSize() : DirectoryChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        }
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.buttonPanel.add(Box.createRigidArea(verticalStrut1));
        this.buttonPanel.add(this.approveButton);
        this.buttonPanel.add(Box.createRigidArea(verticalStrut2));
        this.cancelButton = new JButton(this.cancelButtonText){

            public Dimension getMaximumSize() {
                return ((DirectoryChooserUI)DirectoryChooserUI.this).approveButton.getPreferredSize().width > ((DirectoryChooserUI)DirectoryChooserUI.this).cancelButton.getPreferredSize().width ? DirectoryChooserUI.this.approveButton.getPreferredSize() : DirectoryChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        if (!Utilities.isMac()) {
            this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        }
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.buttonPanel.add(this.cancelButton);
    }

    private void createCenterPanel(final JFileChooser jFileChooser) {
        this.centerPanel = new JPanel(new BorderLayout());
        this.treeViewPanel = this.createTree();
        this.treeViewPanel.setPreferredSize(TREE_PREF_SIZE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JComponent jComponent = jFileChooser.getAccessory();
        this.topToolbar = this.createTopToolbar();
        this.topCombo = this.createTopCombo(jFileChooser);
        this.topComboWrapper = new JPanel(new BorderLayout());
        this.topComboWrapper.add((Component)this.topCombo, "Center");
        if (jComponent == null) {
            this.topComboWrapper.add((Component)this.topToolbar, "East");
        }
        jPanel.add((Component)this.topComboWrapper, "North");
        jPanel.add((Component)this.treeViewPanel, "Center");
        this.centerPanel.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(){
            private Dimension prefSize = new Dimension(250, 0);
            private Dimension minSize = new Dimension(250, 0);

            public Dimension getMinimumSize() {
                if (jFileChooser.getAccessory() != null) {
                    this.minSize.height = DirectoryChooserUI.this.getAccessoryPanel().getMinimumSize().height;
                    return this.minSize;
                }
                return super.getMinimumSize();
            }

            public Dimension getPreferredSize() {
                if (jFileChooser.getAccessory() != null) {
                    Dimension dimension = DirectoryChooserUI.this.getAccessoryPanel().getPreferredSize();
                    LOG.fine("AccessoryWrapper.getPreferredSize: orig pref size: " + dimension);
                    this.prefSize.height = dimension.height;
                    this.prefSize.width = Math.max(this.prefSize.width, dimension.width);
                    int n = DirectoryChooserUI.this.centerPanel.getWidth();
                    if (n != 0 && this.prefSize.width > n / 2) {
                        this.prefSize.width = n / 2;
                    }
                    LOG.fine("AccessoryWrapper.getPreferredSize: resulting pref size: " + this.prefSize);
                    return this.prefSize;
                }
                return super.getPreferredSize();
            }
        };
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = this.getAccessoryPanel();
        if (jComponent != null) {
            jPanel3.add((Component)this.topToolbar, "North");
            jPanel3.add((Component)jComponent, "Center");
        }
        jPanel2.add((Component)jPanel3, "Center");
        this.centerPanel.add((Component)jPanel2, "East");
        this.createBottomPanel(jFileChooser);
        this.centerPanel.add((Component)this.bottomPanel, "South");
    }

    private JComponent createTopCombo(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel();
        if (jFileChooser.getAccessory() != null) {
            jPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
        } else {
            jPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 10, 0));
        }
        jPanel.setLayout(new BorderLayout());
        Box box = Box.createHorizontalBox();
        this.lookInComboBoxLabel = new JLabel(this.lookInLabelText);
        this.lookInComboBoxLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.lookInComboBoxLabel.setAlignmentX(0.0f);
        this.lookInComboBoxLabel.setAlignmentY(0.5f);
        box.add(this.lookInComboBoxLabel);
        box.add(Box.createRigidArea(new Dimension(9, 0)));
        this.directoryComboBox = new JComboBox(){

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 60;
                return dimension;
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = 24;
                dimension.width = 150;
                return dimension;
            }
        };
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInComboBoxLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel.add((Component)box, "West");
        jPanel.add((Component)this.directoryComboBox, "Center");
        return jPanel;
    }

    private JComponent createTopToolbar() {
        Object object;
        Object object2;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        if (Utilities.isWindows()) {
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        this.upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        this.upFolderButton.setText(null);
        boolean bl = Utilities.isMac();
        Icon icon = null;
        if (!bl) {
            icon = UIManager.getIcon("FileChooser.upFolderIcon");
        }
        if (bl || icon == null) {
            icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/swing/dirchooser/resources/upFolderIcon.gif"));
        }
        this.upFolderButton.setIcon(icon);
        this.upFolderButton.setToolTipText(this.upFolderToolTipText);
        this.upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        this.upFolderButton.setAlignmentX(1.0f);
        this.upFolderButton.setAlignmentY(0.5f);
        if (this.useShellFolder) {
            this.upFolderButton.setFocusPainted(false);
        }
        jToolBar.add(this.upFolderButton);
        jToolBar.add(Box.createRigidArea(new Dimension(2, 0)));
        if (!Utilities.isWindows()) {
            object2 = new JButton(this.getGoHomeAction());
            object = null;
            if (!bl) {
                object = UIManager.getIcon("FileChooser.homeFolderIcon");
            }
            if (bl || object == null) {
                object = new ImageIcon(Utilities.loadImage((String)"org/netbeans/swing/dirchooser/resources/homeIcon.gif"));
            }
            ((AbstractButton)object2).setIcon((Icon)object);
            ((AbstractButton)object2).setText(null);
            String string = ((JComponent)object2).getToolTipText();
            if (string == null) {
                string = this.homeFolderTooltipText;
                if (string == null) {
                    string = NbBundle.getMessage(DirectoryChooserUI.class, (String)"TLTP_HomeFolder");
                }
                ((JComponent)object2).setToolTipText(string);
            }
            jToolBar.add((Component)object2);
        }
        this.newFolderButton = new JButton(this.newFolderAction);
        this.newFolderButton.setText(null);
        object2 = null;
        if (!bl) {
            object2 = UIManager.getIcon("FileChooser.newFolderIcon");
        }
        if (bl || object2 == null) {
            object2 = new ImageIcon(Utilities.loadImage((String)"org/netbeans/swing/dirchooser/resources/newFolderIcon.gif"));
        }
        this.newFolderButton.setIcon((Icon)object2);
        this.newFolderButton.setToolTipText(this.newFolderToolTipText);
        this.newFolderButton.setAlignmentX(1.0f);
        this.newFolderButton.setAlignmentY(0.5f);
        if (this.useShellFolder) {
            this.newFolderButton.setFocusPainted(false);
        }
        jToolBar.add(this.newFolderButton);
        jToolBar.add(Box.createRigidArea(new Dimension(2, 0)));
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(4, 9, 8, 0));
        ((Container)object).add((Component)jToolBar, "Center");
        return object;
    }

    private JComponent createTree() {
        final DirectoryHandler directoryHandler = this.createDirectoryHandler(fileChooser);
        tree = new JTree(new Object[0]){
            private boolean firstPaint;
            {
                super(objectArray);
                this.firstPaint = true;
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                directoryHandler.preprocessMouseEvent(mouseEvent);
                super.processMouseEvent(mouseEvent);
            }

            public boolean isLargeModel() {
                return true;
            }

            public void setFont(Font font) {
                this.firstPaint = true;
                super.setFont(font);
            }

            public void paint(Graphics graphics) {
                if (this.firstPaint) {
                    graphics.setFont(this.getFont());
                    this.setRowHeight(Math.max(17, graphics.getFontMetrics().getHeight()));
                    this.firstPaint = false;
                    return;
                }
                super.paint(graphics);
            }
        };
        File file = fileChooser.getCurrentDirectory();
        if (file == null) {
            file = fileChooser.getFileSystemView().getRoots()[0];
        }
        this.updateTree(file);
        tree.setFocusable(true);
        tree.setOpaque(true);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setToggleClickCount(0);
        tree.addTreeExpansionListener(new TreeExpansionHandler());
        TreeKeyHandler treeKeyHandler = new TreeKeyHandler();
        tree.addKeyListener(treeKeyHandler);
        tree.addFocusListener(treeKeyHandler);
        tree.addMouseListener(directoryHandler);
        tree.addFocusListener(directoryHandler);
        tree.addTreeSelectionListener(directoryHandler);
        if (fileChooser.isMultiSelectionEnabled()) {
            tree.getSelectionModel().setSelectionMode(4);
        } else {
            tree.getSelectionModel().setSelectionMode(1);
        }
        DirectoryCellEditor directoryCellEditor = new DirectoryCellEditor(tree, fileChooser, new JTextField());
        tree.setCellEditor(directoryCellEditor);
        directoryCellEditor.addCellEditorListener(directoryHandler);
        tree.setCellRenderer(new DirectoryTreeRenderer());
        JScrollPane jScrollPane = new JScrollPane(tree);
        jScrollPane.setViewportView(tree);
        tree.setInvokesStopCellEditing(true);
        return jScrollPane;
    }

    private List<TreePath> getVisiblePaths() {
        int n = tree.getRowCount();
        Object var2_2 = null;
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(tree.getPathForRow(i));
        }
        return arrayList;
    }

    private void createPopup() {
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(DirectoryChooserUI.getBundle().getString("LBL_NewFolder"));
        jMenuItem.addActionListener(this.newFolderAction);
        JMenuItem jMenuItem2 = new JMenuItem(DirectoryChooserUI.getBundle().getString("LBL_Rename"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryNode directoryNode = (DirectoryNode)tree.getLastSelectedPathComponent();
                DirectoryChooserUI.this.applyEdit(directoryNode);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(DirectoryChooserUI.getBundle().getString("LBL_Delete"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryChooserUI.this.deleteAction();
            }
        });
        this.popupMenu.add(jMenuItem);
        this.popupMenu.add(jMenuItem2);
        this.popupMenu.add(jMenuItem3);
    }

    private void deleteAction() {
        final TreePath[] treePathArray = tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        String string = "";
        if (treePathArray.length == 1) {
            File file = ((DirectoryNode)treePathArray[0].getLastPathComponent()).getFile();
            if (!DirectoryChooserUI.canWrite(file)) {
                return;
            }
            string = MessageFormat.format(DirectoryChooserUI.getBundle().getString("MSG_Delete"), file.getName());
        } else {
            string = MessageFormat.format(DirectoryChooserUI.getBundle().getString("MSG_Delete_Multiple"), treePathArray.length);
        }
        int n = JOptionPane.showConfirmDialog(fileChooser, string, DirectoryChooserUI.getBundle().getString("MSG_Confirm"), 0);
        if (n == 0) {
            RequestProcessor.getDefault().post(new Runnable(){
                DirectoryNode node;
                ArrayList<File> list = new ArrayList();
                int cannotDelete;

                public void run() {
                    if (!EventQueue.isDispatchThread()) {
                        DirectoryChooserUI.this.setCursor(fileChooser, 3);
                        this.cannotDelete = 0;
                        for (int i = 0; i < treePathArray.length; ++i) {
                            DirectoryNode directoryNode = (DirectoryNode)treePathArray[i].getLastPathComponent();
                            try {
                                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)tree.getModel();
                                FileObject fileObject = FileUtil.toFileObject((File)directoryNode.getFile());
                                fileObject.delete();
                                defaultTreeModel.removeNodeFromParent(directoryNode);
                                continue;
                            }
                            catch (IOException iOException) {
                                ++this.cannotDelete;
                                if (!DirectoryChooserUI.canWrite(directoryNode.getFile())) continue;
                                this.list.add(directoryNode.getFile());
                            }
                        }
                        EventQueue.invokeLater(this);
                    } else {
                        DirectoryChooserUI.this.setCursor(fileChooser, 0);
                        if (this.cannotDelete > 0) {
                            String string = "";
                            string = this.cannotDelete == 1 ? this.cannotDelete + " " + DirectoryChooserUI.getBundle().getString("MSG_Sing_Delete") : this.cannotDelete + " " + DirectoryChooserUI.getBundle().getString("MSG_Plur_Delete");
                            DirectoryChooserUI.this.setSelected(this.list.toArray(new File[this.list.size()]));
                            JOptionPane.showConfirmDialog(fileChooser, string, DirectoryChooserUI.getBundle().getString("MSG_Confirm"), 0);
                        } else {
                            DirectoryChooserUI.this.setSelected(new File[]{null});
                            DirectoryChooserUI.this.setFileName("");
                        }
                    }
                }
            });
        }
    }

    private void updateCompletions() {
        File[] fileArray;
        String string;
        File file;
        String string2 = DirectoryChooserUI.normalizeFile(this.getFileName());
        boolean bl = true;
        int n = string2.lastIndexOf(File.separatorChar);
        if (n != -1 && (file = new File(string = string2.substring(0, n + 1))).isDirectory() && (fileArray = file.listFiles()) != null) {
            Vector<File> vector = this.buildList(string2, fileArray);
            if (this.completionPopup == null) {
                bl = true;
            }
            if (this.completionPopup != null && this.completionPopup.isVisible()) {
                bl = false;
            }
            if (bl) {
                this.completionPopup = new FileCompletionPopup(fileChooser, this.filenameTextField, vector);
                if (this.showPopupCompletion && fileChooser.isShowing()) {
                    Point point = this.filenameTextField.getLocation();
                    int n2 = point.x;
                    int n3 = point.y + this.filenameTextField.getHeight() - 6;
                    this.completionPopup.showPopup(this.filenameTextField, n2, n3);
                }
            } else {
                this.completionPopup.setDataList(vector);
            }
        }
    }

    public Vector<File> buildList(String string, File[] fileArray) {
        Vector<File> vector = new Vector<File>(fileArray.length);
        for (int i = fileArray.length - 1; i >= 0; --i) {
            String string2;
            File file = fileArray[i];
            if (!fileChooser.accept(file) || !(string2 = file.getAbsolutePath()).regionMatches(true, 0, string, 0, string.length())) continue;
            if (fileChooser.getFileSelectionMode() == 1) {
                if (!file.isDirectory()) continue;
                vector.add(file);
                continue;
            }
            if (fileChooser.getFileSelectionMode() == 0) {
                if (!file.isFile()) continue;
                vector.add(file);
                continue;
            }
            if (fileChooser.getFileSelectionMode() != 2) continue;
            vector.add(file);
        }
        Collections.sort(vector, DirectoryNode.FILE_NAME_COMPARATOR);
        return vector;
    }

    private static String normalizeFile(String string) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("(^|[^\\\\])\\$([a-zA-Z_0-9.]+)");
        while ((matcher = pattern.matcher(string)).find()) {
            String string2 = System.getenv(matcher.group(2));
            if (string2 == null) {
                string2 = System.getProperty(matcher.group(2), "");
            }
            string = string.substring(0, matcher.end(1)) + string2 + string.substring(matcher.end(2));
        }
        if (string.equals("~")) {
            return System.getProperty("user.home");
        }
        if (string.startsWith("~" + File.separatorChar)) {
            return System.getProperty("user.home") + string.substring(1);
        }
        int n = string.lastIndexOf("//");
        if (n != -1) {
            return string.substring(n + 1);
        }
        n = string.lastIndexOf(File.separatorChar + "~" + File.separatorChar);
        if (n != -1) {
            return System.getProperty("user.home") + string.substring(n + 2);
        }
        return string;
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle(DirectoryChooserUI.class);
    }

    private void updateTree(final File file) {
        if (this.updateWorker != null) {
            if (!this.updateWorker.isFinished()) {
                this.updateWorker.cancel();
            }
            this.updateWorker.waitFinished();
        }
        this.updateWorker = RequestProcessor.getDefault().post(new Runnable(){
            DirectoryNode node;

            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    DirectoryChooserUI.this.setCursor(fileChooser, 3);
                    this.node = new DirectoryNode(file);
                    this.node.loadChildren(fileChooser, true);
                    EventQueue.invokeLater(this);
                } else {
                    DirectoryChooserUI.this.model = new DirectoryTreeModel(this.node);
                    tree.setModel(DirectoryChooserUI.this.model);
                    tree.repaint();
                    DirectoryChooserUI.this.setCursor(fileChooser, 0);
                }
            }
        });
    }

    private Boolean isXPStyle() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Boolean bl = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        if (bl.booleanValue() && System.getProperty("swing.noxp") == null) {
            bl = Boolean.TRUE;
        }
        return bl;
    }

    @Override
    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale);
        this.homeFolderTooltipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale);
    }

    @Override
    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryChooserUI.this.getFileChooser().cancelSelection();
            }

            public boolean isEnabled() {
                return DirectoryChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMapUIResource;
    }

    @Override
    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterTypeComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n = DirectoryChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n ? n : dimension.width, dimension.height < DirectoryChooserUI.PREF_SIZE.height ? DirectoryChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n, DirectoryChooserUI.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String getStringOfFileName(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            if (jFileChooser.getFileSystemView().isDrive(file)) {
                return file.getPath();
            }
            return file.getPath();
        }
        return file.getName();
    }

    private String getStringOfFileNames(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.getStringOfFileName(fileArray[i]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    private void fireSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.getStringOfFileName(file));
        }
    }

    private void fireSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.getStringOfFileNames(fileArray));
        }
    }

    private void fireDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.showPopupCompletion = false;
        this.setFileName("");
        this.clearIconCache();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            this.newFolderAction.setEnabled(file.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fileSystemView.isRoot(file));
            this.updateTree(file);
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(this.getStringOfFileName(file));
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void fireFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.clearIconCache();
    }

    private void fireFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.clearIconCache();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void fireMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            tree.getSelectionModel().setSelectionMode(4);
        } else {
            tree.getSelectionModel().setSelectionMode(1);
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void fireAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getOldValue();
            JComponent jComponent2 = (JComponent)propertyChangeEvent.getNewValue();
            JPanel jPanel = this.getAccessoryPanel();
            if (jComponent != null) {
                jPanel.remove(jComponent);
            }
            if (jComponent != null && jComponent2 == null) {
                jPanel.remove(this.topToolbar);
                this.topComboWrapper.add((Component)this.topToolbar, "East");
                this.topCombo.setBorder(BorderFactory.createEmptyBorder(6, 0, 10, 0));
                this.topCombo.revalidate();
            }
            if (jComponent2 != null) {
                this.getAccessoryPanel().add((Component)jComponent2, "Center");
            }
            if (jComponent == null && jComponent2 != null) {
                this.topComboWrapper.remove(this.topToolbar);
                this.topCombo.setBorder(BorderFactory.createEmptyBorder(4, 0, 8, 0));
                jPanel.add((Component)this.topToolbar, "North");
            }
        }
    }

    private void fireApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        }
    }

    private void fireDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        }
        if (jFileChooser.getDialogType() == 1) {
            this.lookInComboBoxLabel.setText(this.saveInLabelText);
        } else {
            this.lookInComboBoxLabel.setText(this.lookInLabelText);
        }
    }

    private void fireApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
        if (!Utilities.isMac()) {
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
        }
    }

    private void fireControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    DirectoryChooserUI.this.fireSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    DirectoryChooserUI.this.fireSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged") && DirectoryChooserUI.this.changeDirectory) {
                    DirectoryChooserUI.this.fireDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    DirectoryChooserUI.this.fireFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    DirectoryChooserUI.this.fireFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    DirectoryChooserUI.this.fireMultiSelectionChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    DirectoryChooserUI.this.fireAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    DirectoryChooserUI.this.fireApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    DirectoryChooserUI.this.fireDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    DirectoryChooserUI.this.fireApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    DirectoryChooserUI.this.fireControlButtonsChanged(propertyChangeEvent);
                } else if (string.equals("FileChooser.useShellFolder")) {
                    DirectoryChooserUI.this.updateUseShellFolder();
                    DirectoryChooserUI.this.fireDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                } else if (string.equals("ancestor") && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                    DirectoryChooserUI.this.filenameTextField.selectAll();
                    DirectoryChooserUI.this.filenameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.bottomPanel.remove(this.buttonPanel);
    }

    protected void addControlButtons() {
        this.bottomPanel.add(this.buttonPanel);
    }

    @Override
    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    private DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterTypeComboBoxModel createFilterComboBoxModel() {
        return new FilterTypeComboBoxModel();
    }

    @Override
    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    @Override
    public FileView getFileView(JFileChooser jFileChooser) {
        if (Utilities.isWindows()) {
            if (this.useShellFolder) {
                this.fileView = new DirectoryChooserFileView();
            }
        } else {
            this.fileView = (BasicFileChooserUI.BasicFileView)super.getFileView(fileChooser);
        }
        return this.fileView;
    }

    private void setSelected(File[] fileArray) {
        this.changeDirectory = false;
        fileChooser.setSelectedFiles(fileArray);
        this.changeDirectory = true;
    }

    private DirectoryHandler createDirectoryHandler(JFileChooser jFileChooser) {
        return new DirectoryHandler(jFileChooser);
    }

    private void addNewDirectory(final TreePath treePath) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DirectoryNode directoryNode = (DirectoryNode)treePath.getLastPathComponent();
                        if (directoryNode == null || !DirectoryChooserUI.canWrite(directoryNode.getFile())) {
                            return;
                        }
                        try {
                            DirectoryChooserUI.this.newFolderNode = new DirectoryNode(fileChooser.getFileSystemView().createNewFolder(directoryNode.getFile()));
                            DirectoryChooserUI.this.model.insertNodeInto(DirectoryChooserUI.this.newFolderNode, directoryNode, directoryNode.getChildCount());
                            DirectoryChooserUI.this.applyEdit(DirectoryChooserUI.this.newFolderNode);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    private void applyEdit(DirectoryNode directoryNode) {
        Object[] objectArray = this.model.getPathToRoot(directoryNode);
        TreePath treePath = new TreePath(objectArray);
        tree.setEditable(true);
        tree.makeVisible(treePath);
        tree.scrollPathToVisible(treePath);
        tree.setSelectionPath(treePath);
        tree.startEditingAtPath(treePath);
        JTextField jTextField = DirectoryCellEditor.getTextField();
        jTextField.setCursor(Cursor.getPredefinedCursor(2));
        jTextField.setRequestFocusEnabled(true);
        jTextField.requestFocus();
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    private static boolean canWrite(File file) {
        boolean bl = false;
        if (file != null) {
            try {
                bl = file.canWrite();
            }
            catch (AccessControlException accessControlException) {
                bl = false;
            }
        }
        return bl;
    }

    private void expandNode(final JFileChooser jFileChooser, final TreePath treePath) {
        RequestProcessor.getDefault().post(new Runnable(){
            DirectoryNode node;

            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    DirectoryChooserUI.this.setCursor(jFileChooser, 3);
                    this.node = (DirectoryNode)treePath.getLastPathComponent();
                    this.node.loadChildren(jFileChooser, true);
                    EventQueue.invokeLater(this);
                } else {
                    ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(this.node);
                    if (DirectoryChooserUI.this.addNewDirectory) {
                        DirectoryChooserUI.this.addNewDirectory(treePath);
                        DirectoryChooserUI.this.addNewDirectory = false;
                    }
                    DirectoryChooserUI.this.setCursor(jFileChooser, 0);
                }
            }
        });
    }

    private void setCursor(JComponent jComponent, int n) {
        Serializable serializable;
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        if (window != null) {
            serializable = Cursor.getPredefinedCursor(n);
            window.setCursor((Cursor)serializable);
            window.setFocusable(true);
        }
        serializable = fileChooser.getRootPane();
        this.blocker = new InputBlocker();
        if (serializable != null) {
            ((JRootPane)serializable).setGlassPane(this.blocker);
        }
        if (n == 3) {
            this.blocker.block();
        } else if (n == 0) {
            this.blocker.unBlock();
        }
    }

    private class DirectoryTreeModel
    extends DefaultTreeModel {
        public DirectoryTreeModel(TreeNode treeNode) {
            super(treeNode);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            File file;
            boolean bl = false;
            DirectoryNode directoryNode = (DirectoryNode)treePath.getLastPathComponent();
            File file2 = directoryNode.getFile();
            if (file2.renameTo(file = new File(file2.getParentFile(), (String)object))) {
                if (tree.isExpanded(treePath)) {
                    tree.collapsePath(treePath);
                    bl = true;
                }
                directoryNode.setFile(file);
                directoryNode.removeAllChildren();
                ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(directoryNode);
                if (bl) {
                    tree.expandPath(treePath);
                }
            }
        }
    }

    private class DirectoryTreeRenderer
    implements TreeCellRenderer {
        HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();

        private DirectoryTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Serializable serializable;
            Component component = this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DirectoryNode) {
                jTree.setShowsRootHandles(true);
                serializable = (DirectoryNode)object;
                ((JLabel)component).setIcon(this.getNodeIcon((DirectoryNode)serializable));
                ((JLabel)component).setText(this.getNodeText(((DirectoryNode)serializable).getFile()));
            }
            serializable = component.getFont();
            component.setPreferredSize(new Dimension(component.getPreferredSize().width, 30));
            ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            component.setSize(component.getPreferredSize());
            return component;
        }

        private Icon getNodeIcon(DirectoryNode directoryNode) {
            File file = directoryNode.getFile();
            if (file.exists()) {
                return fileChooser.getIcon(file);
            }
            return null;
        }

        private String getNodeText(File file) {
            if (file.exists()) {
                return "<html>" + fileChooser.getName(file) + "</html>";
            }
            return "<html></html>";
        }
    }

    private class NewDirectoryAction
    extends AbstractAction {
        private NewDirectoryAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = tree.getSelectionPath();
            if (treePath == null) {
                DirectoryChooserUI.this.addNewDirectory(new TreePath(DirectoryChooserUI.this.model.getPathToRoot((DirectoryNode)tree.getModel().getRoot())));
            }
            if (treePath != null) {
                if (tree.isExpanded(treePath)) {
                    DirectoryChooserUI.this.addNewDirectory(treePath);
                } else {
                    DirectoryChooserUI.this.addNewDirectory = true;
                    tree.expandPath(treePath);
                }
            }
        }
    }

    private class TreeExpansionHandler
    implements TreeExpansionListener {
        private TreeExpansionHandler() {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            DirectoryNode directoryNode = (DirectoryNode)treePath.getLastPathComponent();
            if (!directoryNode.isLoaded()) {
                DirectoryChooserUI.this.expandNode(fileChooser, treePath);
            } else if (DirectoryChooserUI.this.addNewDirectory) {
                DirectoryChooserUI.this.addNewDirectory(treePath);
                DirectoryChooserUI.this.addNewDirectory = false;
            }
            this.refreshNode(treePath, directoryNode);
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        private void refreshNode(TreePath treePath, DirectoryNode directoryNode) {
            HashSet hashSet;
            Object object;
            Object object2;
            File[] fileArray;
            File file = directoryNode.getFile();
            if (!file.exists()) {
                TreePath treePath2 = treePath.getParentPath();
                boolean bl = false;
                if (tree.isExpanded(treePath)) {
                    tree.collapsePath(treePath);
                    bl = true;
                }
                DirectoryChooserUI.this.model.removeNodeFromParent(directoryNode);
                if (bl) {
                    tree.expandPath(treePath2);
                }
            }
            int n = directoryNode.getChildCount();
            HashMap<String, DirectoryNode> hashMap = new HashMap<String, DirectoryNode>();
            for (int i = 0; i < n; ++i) {
                fileArray = directoryNode.getChildAt(i);
                if (!(fileArray instanceof DirectoryNode)) continue;
                object2 = ((DirectoryNode)fileArray).getFile();
                hashMap.put(((File)object2).getName(), (DirectoryNode)fileArray);
            }
            HashSet<String> hashSet2 = new HashSet<String>();
            fileArray = file.listFiles();
            fileArray = fileArray == null ? new File[]{} : fileArray;
            for (File object3 : fileArray) {
                if (!object3.isDirectory()) continue;
                object = object3.getName();
                hashSet2.add((String)object);
            }
            object2 = new HashSet(hashSet2);
            if (object2.removeAll(hashMap.keySet())) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    DirectoryNode directoryNode2 = new DirectoryNode(new File(file, string));
                    DirectoryChooserUI.this.model.insertNodeInto(directoryNode2, directoryNode, directoryNode.getChildCount());
                }
            }
            if ((hashSet = new HashSet(hashMap.keySet())).removeAll(hashSet2)) {
                for (String string : hashSet) {
                    object = (DirectoryNode)hashMap.get(string);
                    DirectoryChooserUI.this.model.removeNodeFromParent((MutableTreeNode)object);
                }
            }
        }
    }

    private class DirectoryHandler
    extends MouseAdapter
    implements TreeSelectionListener,
    CellEditorListener,
    ActionListener,
    FocusListener,
    Runnable {
        private JFileChooser fileChooser;
        private WeakReference<TreePath> curSelPath;
        private Timer renameTimer;
        private TreePath pathToRename;

        public DirectoryHandler(JFileChooser jFileChooser) {
            this.fileChooser = jFileChooser;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DirectoryNode directoryNode;
            File file;
            DirectoryChooserUI.this.showPopupCompletion = false;
            FileSystemView fileSystemView = this.fileChooser.getFileSystemView();
            JTree jTree = (JTree)treeSelectionEvent.getSource();
            TreePath treePath = jTree.getSelectionPath();
            TreePath treePath2 = treeSelectionEvent.getNewLeadSelectionPath();
            WeakReference<TreePath> weakReference = this.curSelPath = treePath2 != null ? new WeakReference<TreePath>(treePath2) : null;
            if (treePath != null && (file = (directoryNode = (DirectoryNode)treePath.getLastPathComponent()).getFile()) != null) {
                DirectoryChooserUI.this.setSelected(this.getSelectedNodes(jTree.getSelectionPaths()));
                DirectoryChooserUI.this.newFolderAction.setEnabled(DirectoryChooserUI.canWrite(file) && file.isDirectory());
                if (file.isDirectory()) {
                    DirectoryChooserUI.this.setDirectorySelected(true);
                }
            }
        }

        private File[] getSelectedNodes(TreePath[] treePathArray) {
            Vector<File> vector = new Vector<File>();
            for (int i = 0; i < treePathArray.length; ++i) {
                File file = ((DirectoryNode)treePathArray[i].getLastPathComponent()).getFile();
                if (file.isDirectory() && this.fileChooser.isTraversable(file) && !this.fileChooser.getFileSystemView().isFileSystem(file)) continue;
                vector.add(file);
            }
            return vector.toArray(new File[vector.size()]);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTree jTree = (JTree)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n2 = mouseEvent.getX();
            int n3 = jTree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = jTree.getPathForRow(n3);
            if (treePath != null) {
                DirectoryNode directoryNode = (DirectoryNode)treePath.getLastPathComponent();
                DirectoryChooserUI.this.newFolderAction.setEnabled(DirectoryChooserUI.canWrite(directoryNode.getFile()));
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    this.cancelRename();
                    if (directoryNode.isNetBeansProject()) {
                        this.fileChooser.approveSelection();
                    } else if (directoryNode.getFile().isFile() && !directoryNode.getFile().getPath().endsWith(".lnk")) {
                        this.fileChooser.approveSelection();
                    } else {
                        this.changeTreeDirectory(directoryNode.getFile());
                    }
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 && this.pathToRename != null) {
                    if (this.renameTimer != null) {
                        this.renameTimer.stop();
                    }
                    this.renameTimer = new Timer(800, this);
                    this.renameTimer.setRepeats(false);
                    this.renameTimer.start();
                }
                ((DirectoryTreeModel)jTree.getModel()).nodeChanged(directoryNode);
                if (n3 == 0) {
                    jTree.revalidate();
                    jTree.repaint();
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.handlePopupMenu(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handlePopupMenu(mouseEvent);
        }

        private void handlePopupMenu(MouseEvent mouseEvent) {
            int n;
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            JTree jTree = (JTree)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n2 = mouseEvent.getX();
            int n3 = jTree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = jTree.getPathForRow(n3);
            if (treePath != null) {
                DirectoryNode directoryNode = (DirectoryNode)treePath.getLastPathComponent();
                ((DirectoryTreeModel)jTree.getModel()).nodeChanged(directoryNode);
                if (!this.fileChooser.getFileSystemView().isFileSystem(directoryNode.getFile())) {
                    return;
                }
                jTree.setSelectionPath(treePath);
                DirectoryChooserUI.this.popupMenu.show(jTree, n2, n);
            }
        }

        private void changeTreeDirectory(File file) {
            if (File.separatorChar == '\\' && file.getPath().endsWith(".lnk")) {
                File file2 = DirectoryChooserUI.this.getShellFolderForFileLinkLoc(file);
                if (file2 != null && this.fileChooser.isTraversable(file2)) {
                    file = file2;
                } else {
                    return;
                }
            }
            this.fileChooser.setCurrentDirectory(file);
        }

        public void editingStopped(ChangeEvent changeEvent) {
            DirectoryNode directoryNode = (DirectoryNode)tree.getLastSelectedPathComponent();
            if (directoryNode != null) {
                DirectoryChooserUI.this.setFileName(DirectoryChooserUI.this.getStringOfFileName(directoryNode.getFile()));
            }
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryNode directoryNode;
            if (tree.isFocusOwner() && this.isSelectionKept(this.pathToRename) && (directoryNode = (DirectoryNode)tree.getLastSelectedPathComponent()) != null) {
                DirectoryChooserUI.this.applyEdit(directoryNode);
            }
            this.cancelRename();
        }

        void preprocessMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() != 501 || mouseEvent.getButton() != 1) {
                return;
            }
            TreePath treePath = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && this.isSelectionKept(treePath)) {
                this.pathToRename = treePath;
            }
        }

        private boolean isSelectionKept(TreePath treePath) {
            TreePath treePath2;
            return this.curSelPath != null && (treePath2 = (TreePath)this.curSelPath.get()) != null && treePath2.equals(treePath);
        }

        private void cancelRename() {
            if (this.renameTimer != null) {
                this.renameTimer.stop();
                this.renameTimer = null;
            }
            this.pathToRename = null;
        }

        public void focusGained(FocusEvent focusEvent) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.cancelRename();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.cancelRename();
        }
    }

    private class TextFieldKeyListener
    extends KeyAdapter {
        private TextFieldKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            DirectoryChooserUI.this.showPopupCompletion = true;
            int n = keyEvent.getKeyCode();
            if (DirectoryChooserUI.this.completionPopup != null && !DirectoryChooserUI.this.completionPopup.isVisible()) {
                File file;
                if (n == 10 && (file = new File(DirectoryChooserUI.this.filenameTextField.getText())).exists() && file.isDirectory()) {
                    DirectoryChooserUI.this.setSelected(new File[]{file});
                    fileChooser.approveSelection();
                }
                if (n == 9 || n == 40 || n == 39 && DirectoryChooserUI.this.filenameTextField.getCaretPosition() >= DirectoryChooserUI.this.filenameTextField.getDocument().getLength() - 1) {
                    DirectoryChooserUI.this.updateCompletions();
                }
            }
            if (DirectoryChooserUI.this.filenameTextField.isFocusOwner() && (DirectoryChooserUI.this.completionPopup == null || !DirectoryChooserUI.this.completionPopup.isVisible()) && n == 27) {
                fileChooser.cancelSelection();
            }
        }
    }

    private class DirectoryChooserFileView
    extends BasicFileChooserUI.BasicFileView {
        private DirectoryChooserFileView() {
            super(DirectoryChooserUI.this);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                icon = fileChooser.getFileSystemView().getSystemIcon(file);
            }
            if (icon == null) {
                icon = super.getIcon(file);
            }
            this.cacheIcon(file, icon);
            return icon;
        }
    }

    private class DirectoryComboBoxAction
    implements ActionListener {
        private DirectoryComboBoxAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)DirectoryChooserUI.this.directoryComboBox.getSelectedItem();
            DirectoryChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class FilterTypeComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterTypeComboBoxModel() {
            this.filters = DirectoryChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                DirectoryChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                DirectoryChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = DirectoryChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != fileFilter) continue;
                    bl = true;
                }
                if (!bl) {
                    DirectoryChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return DirectoryChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return DirectoryChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    private class FilterComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public FilterComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = DirectoryChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = DirectoryChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            File file2;
            File file3;
            if (file == null) {
                return;
            }
            this.directories.clear();
            if (DirectoryChooserUI.this.useShellFolder) {
                this.directories.addAll(Arrays.asList(DirectoryChooserUI.this.getShellFolderRoots()));
            } else {
                this.directories.addAll(Arrays.asList(fileChooser.getFileSystemView().getRoots()));
            }
            File file4 = null;
            try {
                file4 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file4 = file;
            }
            Vector<File> vector = new Vector<File>(10);
            for (file3 = file2 = DirectoryChooserUI.this.getShellFolderForFile(file4); file3 != null; file3 = file3.getParentFile()) {
                vector.addElement(file3);
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                file3 = (File)vector.get(i);
                if (!this.directories.contains(file3)) continue;
                int n2 = this.directories.indexOf(file3);
                for (int j = i - 1; j >= 0; --j) {
                    this.directories.insertElementAt((File)vector.get(j), n2 + i - j);
                }
                break;
            }
            this.calculateDepths();
            this.setSelectedItem(file2);
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File file = this.directories.get(i);
                File file2 = file.getParentFile();
                this.depths[i] = 0;
                if (file2 == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!file2.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int n) {
            return this.depths != null && n >= 0 && n < this.depths.length ? this.depths[n] : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    private class DirectoryComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        IconIndenter indenter;

        public DirectoryComboBoxRenderer() {
            this.indenter = new IconIndenter();
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            this.setName("ComboBox.listRenderer");
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(DirectoryChooserUI.this.getFileChooser().getName(file));
            this.indenter.icon = icon = DirectoryChooserUI.this.getFileChooser().getIcon(file);
            this.indenter.depth = DirectoryChooserUI.this.directoryComboBoxModel.getDepth(n);
            this.setIcon(this.indenter);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private class IconIndenter
    implements Icon {
        static final int space = 10;
        Icon icon = null;
        int depth = 0;

        private IconIndenter() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.icon == null) {
                return;
            }
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
            } else {
                this.icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.icon != null ? Integer.valueOf(this.icon.getIconWidth() + this.depth * 10) : null;
        }

        public int getIconHeight() {
            return this.icon != null ? Integer.valueOf(this.icon.getIconHeight()) : null;
        }
    }

    class TreeKeyHandler
    extends KeyAdapter
    implements FocusListener {
        StringBuffer searchBuf = new StringBuffer();
        List<TreePath> paths;

        TreeKeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n;
            Serializable serializable;
            if (keyEvent.getKeyCode() == 127) {
                DirectoryChooserUI.this.deleteAction();
            }
            if (keyEvent.getKeyCode() == 113 && (serializable = (DirectoryNode)tree.getLastSelectedPathComponent()) != null) {
                DirectoryChooserUI.this.applyEdit((DirectoryNode)serializable);
            }
            if (this.isCharForSearch(keyEvent)) {
                keyEvent.consume();
            } else {
                this.resetBuffer();
            }
            if (keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown() && !DirectoryChooserUI.this.popupMenu.isShowing() && (n = ((JTree)(serializable = (JTree)keyEvent.getSource())).getLeadSelectionRow()) >= 0) {
                Rectangle rectangle = ((JTree)serializable).getRowBounds(n);
                DirectoryChooserUI.this.popupMenu.show((Component)serializable, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height * 3 / 5);
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (this.isCharForSearch(keyEvent)) {
                if (this.paths == null) {
                    this.paths = DirectoryChooserUI.this.getVisiblePaths();
                }
                this.searchBuf.append(c);
                String string = this.searchBuf.toString().toLowerCase();
                String string2 = null;
                for (TreePath treePath : this.paths) {
                    string2 = fileChooser.getName(((DirectoryNode)treePath.getLastPathComponent()).getFile());
                    if (string2 == null || !string2.toLowerCase().startsWith(string)) continue;
                    tree.makeVisible(treePath);
                    tree.scrollPathToVisible(treePath);
                    tree.setSelectionPath(treePath);
                    break;
                }
            } else {
                this.resetBuffer();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.resetBuffer();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.resetBuffer();
        }

        private boolean isCharForSearch(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\b') {
                return false;
            }
            if (keyEvent.getModifiers() != 0) {
                return false;
            }
            return Character.isJavaIdentifierPart(c) && !Character.isIdentifierIgnorable(c) || Character.isSpaceChar(c);
        }

        private void resetBuffer() {
            this.searchBuf.delete(0, this.searchBuf.length());
            this.paths = null;
        }
    }
}

