/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.core;

import java.util.Collection;
import java.util.List;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.CreateInstanceActivity;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitor;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.soa.validation.core.Validator;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SequenceDefinition;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;

public abstract class BpelValidator
extends Validator {
    protected abstract SimpleBpelModelVisitor getVisitor();

    public synchronized ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        if (!(model instanceof BpelModel)) {
            return null;
        }
        BpelModel bpelModel = (BpelModel)model;
        if (bpelModel.getState() == Model.State.NOT_WELL_FORMED) {
            return null;
        }
        final Process process = bpelModel.getProcess();
        if (process == null) {
            return null;
        }
        this.init(validation, validationType);
        Runnable runnable = new Runnable(){

            public void run() {
                UI.startTime();
                process.accept(BpelValidator.this.getVisitor());
                UI.endTime((Object)BpelValidator.this.getDisplayName());
            }
        };
        bpelModel.invoke(runnable);
        return this.createValidationResult((Model)bpelModel);
    }

    protected final boolean isCreateInstanceYes(CreateInstanceActivity createInstanceActivity) {
        return createInstanceActivity != null && createInstanceActivity.getCreateInstance() == TBoolean.YES;
    }

    protected final CreateInstanceActivity getCreateInstanceActivity(Component component) {
        if (component instanceof CreateInstanceActivity) {
            return (CreateInstanceActivity)component;
        }
        if (component.getParent() instanceof CreateInstanceActivity) {
            return (CreateInstanceActivity)component.getParent();
        }
        return null;
    }

    protected final Component getVariableType(Variable variable) {
        Collection collection;
        Component component = this.getVariableDeclarationType((VariableDeclaration)variable);
        if (component instanceof Message && (collection = ((Message)component).getParts()) != null && collection.size() == 1) {
            component = this.getType((Part)collection.iterator().next());
        }
        return ValidationUtil.getBasedSimpleType((Component)this.checkComplexType(this.getTypeOfElement(this.checkElement(component))));
    }

    private Component checkElement(Component component) {
        if (component == null) {
            return null;
        }
        List list = component.getChildren();
        if (list == null || list.size() != 1) {
            return component;
        }
        Object e = list.get(0);
        if (!(e instanceof Component)) {
            return component;
        }
        Component component2 = this.getComplexType((Component)e);
        if (component2 == null) {
            return component;
        }
        return component2;
    }

    private Component checkComplexType(Component component) {
        Component component2 = this.getComplexType(component);
        if (component2 == null) {
            return component;
        }
        return component2;
    }

    private Component getComplexType(Component component) {
        if (!(component instanceof ComplexType)) {
            return null;
        }
        List list = component.getChildren();
        if (list == null || list.size() != 1) {
            return null;
        }
        Object e = list.get(0);
        if (!(e instanceof Sequence)) {
            return null;
        }
        Component component2 = this.getSequenceType((Sequence)e);
        if (component2 == null) {
            return null;
        }
        return component2;
    }

    private Component getSequenceType(Sequence sequence) {
        List list = sequence.getContent();
        if (list == null || list.size() == 0) {
            return null;
        }
        Component component = null;
        for (SequenceDefinition sequenceDefinition : list) {
            component = this.getTypeOfElement((Component)sequenceDefinition);
            if (component instanceof GlobalSimpleType) continue;
            return null;
        }
        return component;
    }

    protected final Component getVariableDeclarationType(VariableDeclaration variableDeclaration) {
        GlobalType globalType;
        SchemaReference schemaReference;
        SchemaReference schemaReference2;
        if (variableDeclaration == null) {
            return null;
        }
        WSDLReference wSDLReference = variableDeclaration.getMessageType();
        if (wSDLReference != null && (schemaReference2 = (Message)wSDLReference.get()) != null) {
            return schemaReference2;
        }
        schemaReference2 = variableDeclaration.getElement();
        if (schemaReference2 != null && (schemaReference = (GlobalElement)schemaReference2.get()) != null) {
            return schemaReference;
        }
        schemaReference = variableDeclaration.getType();
        if (schemaReference != null && (globalType = (GlobalType)schemaReference.get()) != null) {
            return globalType;
        }
        return null;
    }
}

