/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.runtime;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CatchAll;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.CorrelationsHolder;
import org.netbeans.modules.bpel.model.api.CreateInstanceActivity;
import org.netbeans.modules.bpel.model.api.Documentation;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.ExtensibleAssign;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.LinkContainer;
import org.netbeans.modules.bpel.model.api.MessageExchangeContainer;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.SourceContainer;
import org.netbeans.modules.bpel.model.api.TargetContainer;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.Validate;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.api.support.Initiate;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitor;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitorAdaptor;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.bpel.validation.core.BpelValidator;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Validator
extends BpelValidator {
    protected SimpleBpelModelVisitor getVisitor() {
        return new SimpleBpelModelVisitorAdaptor(){
            private static final String TO_PARTS = "<toParts>";
            private static final String FROM_PARTS = "<fromParts>";

            public void visit(ElseIf elseIf) {
                this.checkCondition((Component)elseIf.getCondition());
            }

            public void visit(If if_) {
                this.checkCondition((Component)if_.getCondition());
            }

            public void visit(RepeatUntil repeatUntil) {
                this.checkCondition((Component)repeatUntil.getCondition());
            }

            public void visit(While while_) {
                this.checkCondition((Component)while_.getCondition());
            }

            private void checkCondition(Component component) {
                if (!(component instanceof ContentElement)) {
                    return;
                }
                String string = ((ContentElement)component).getContent();
                if (string == null) {
                    return;
                }
                if (!this.containsDuration(string)) {
                    return;
                }
                if (string.contains("<") || string.contains(">") || string.contains("<=") || string.contains(">=") || string.contains("=") || string.contains("!=")) {
                    Validator.this.addWarning("FIX_Compare_Time", component);
                }
            }

            private boolean containsDuration(String string) {
                for (int i = 0; i <= 9; ++i) {
                    if (!string.contains("'P" + i)) continue;
                    return true;
                }
                return false;
            }

            public void visit(Process process) {
                TBoolean tBoolean;
                String string;
                String string2 = process.getQueryLanguage();
                if (string2 != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)process, "queryLanguage");
                }
                if ((string = process.getExpressionLanguage()) != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)process, "expressionLanguage");
                }
                if ((tBoolean = process.getSuppressJoinFailure()) != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)process, "suppressJoinFailure");
                }
                if ((tBoolean = process.getExitOnStandardFault()) != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)process, "exitOnStandardFault");
                }
                this.checkValidURI((BpelEntity)process, "queryLanguage", process.getQueryLanguage());
                this.checkValidURI((BpelEntity)process, "expressionLanguage", process.getExpressionLanguage());
            }

            private void processCorrelationsHolder(CorrelationsHolder correlationsHolder) {
                CorrelationSet correlationSet;
                if (correlationsHolder instanceof Reply) {
                    return;
                }
                CreateInstanceActivity createInstanceActivity = Validator.this.getCreateInstanceActivity((Component)correlationsHolder);
                CorrelationContainer correlationContainer = correlationsHolder.getCorrelationContainer();
                if (correlationContainer == null && !Validator.this.isCreateInstanceYes(createInstanceActivity)) {
                    Validator.this.addWarning("FIX_Empty_Correlations", (Component)correlationsHolder);
                    return;
                }
                if (correlationContainer == null) {
                    return;
                }
                Correlation[] correlationArray = correlationContainer.getCorrelations();
                if (!(correlationArray != null && correlationArray.length != 0 || Validator.this.isCreateInstanceYes(createInstanceActivity))) {
                    Validator.this.addWarning("FIX_Empty_Correlations", (Component)correlationContainer);
                    return;
                }
                ArrayList<CorrelationSet> arrayList = new ArrayList<CorrelationSet>();
                for (Correlation correlation : correlationArray) {
                    if (correlation.getInitiate() != Initiate.YES) continue;
                    correlationSet = (CorrelationSet)correlation.getSet().get();
                    if (arrayList.contains(correlationSet)) {
                        Validator.this.addError("FIX_Repeated_Corelation_Sets", (Component)correlationContainer);
                        return;
                    }
                    arrayList.add(correlationSet);
                }
                if (createInstanceActivity != null && createInstanceActivity.getCreateInstance() == TBoolean.YES) {
                    return;
                }
                for (Correlation correlation : correlationArray) {
                    correlationSet = correlation.getInitiate();
                    if (correlationSet != null && correlationSet != Initiate.NO) continue;
                    return;
                }
                Validator.this.addWarning("FIX_Correlating_Activity", (Component)correlationContainer);
            }

            public void visit(Validate validate) {
                this.addElementError((BpelEntity)validate);
            }

            public void visit(PartnerLink partnerLink) {
                if (partnerLink.getInitializePartnerRole() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)partnerLink, "initializePartnerRole");
                }
            }

            public void visit(Variable variable) {
                From from = variable.getFrom();
                if (from != null) {
                    this.addElementsInParentError((BpelContainer)variable, new BpelEntity[]{from});
                }
            }

            public void visit(TargetContainer targetContainer) {
                this.addElementError((BpelEntity)targetContainer);
            }

            public void visit(SourceContainer sourceContainer) {
                this.addElementError((BpelEntity)sourceContainer);
            }

            public void visit(Invoke invoke) {
                CatchAll catchAll;
                super.visit(invoke);
                Catch[] catchArray = invoke.getCatches();
                if (catchArray != null && catchArray.length > 0) {
                    this.addElementsInParentError((BpelContainer)invoke, (BpelEntity[])catchArray);
                }
                if ((catchAll = invoke.getCatchAll()) != null) {
                    this.addElementsInParentError((BpelContainer)invoke, new BpelEntity[]{catchAll});
                }
                if (invoke.getFromPartContaner() != null) {
                    this.addElementsInParentError((BpelContainer)invoke, FROM_PARTS);
                }
                if (invoke.getToPartContaner() != null) {
                    this.addElementsInParentError((BpelContainer)invoke, TO_PARTS);
                }
            }

            public void visit(ExtensibleAssign extensibleAssign) {
                this.addElementError((BpelEntity)extensibleAssign);
            }

            public void visit(Assign assign) {
                super.visit(assign);
                if (assign.getValidate() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)assign, "validate");
                }
            }

            public void visit(From from) {
                Documentation[] documentationArray = from.getDocumentations();
                if (documentationArray != null && documentationArray.length > 0) {
                    this.addElementsInParentError((BpelContainer)from, (BpelEntity[])documentationArray);
                }
                if (from.getExpressionLanguage() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)from, "expressionLanguage");
                }
                if (from.getProperty() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)from, "property");
                }
                this.checkAbsenceExtensions((ExtensibleElements)from);
            }

            public void visit(To to) {
                Documentation[] documentationArray = to.getDocumentations();
                if (documentationArray != null && documentationArray.length > 0) {
                    this.addElementsInParentError((BpelContainer)to, (BpelEntity[])documentationArray);
                }
                if (to.getProperty() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)to, "property");
                }
                this.checkAbsenceExtensions((ExtensibleElements)to);
            }

            public void visit(Flow flow) {
                super.visit(flow);
                LinkContainer linkContainer = flow.getLinkContainer();
                if (linkContainer != null) {
                    this.addElementError((BpelEntity)linkContainer);
                }
            }

            public void visit(Scope scope) {
                CorrelationSetContainer correlationSetContainer;
                super.visit(scope);
                PartnerLinkContainer partnerLinkContainer = scope.getPartnerLinkContainer();
                if (partnerLinkContainer != null) {
                    this.addElementsInParentError((BpelContainer)scope, new BpelEntity[]{partnerLinkContainer});
                }
                if ((correlationSetContainer = scope.getCorrelationSetContainer()) != null) {
                    this.addElementsInParentError((BpelContainer)scope, new BpelEntity[]{correlationSetContainer});
                }
                if (scope.getIsolated() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)scope, "isolated");
                }
                if (scope.getExitOnStandardFault() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)scope, "exitOnStandardFault");
                }
            }

            public void visit(ForEach forEach) {
                super.visit(forEach);
                if (TBoolean.YES.equals((Object)forEach.getParallel())) {
                    Validator.this.addWarning("FIX_Attribute", (Component)forEach, "parallel");
                }
            }

            protected void visit(Activity activity) {
                if (activity.getSuppressJoinFailure() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)activity, "suppressJoinFailure");
                }
            }

            public void visit(Import import_) {
                if (!this.isAttributeValueSpecified(import_.getLocation())) {
                    this.addAttributeNeededForRuntime("location", (Component)import_);
                }
                if (!this.isAttributeValueSpecified(import_.getNamespace())) {
                    this.addAttributeNeededForRuntime("namespace", (Component)import_);
                }
            }

            public void visit(Receive receive) {
                super.visit(receive);
                if (receive.getFromPartContaner() != null) {
                    this.addElementsInParentError((BpelContainer)receive, FROM_PARTS);
                }
                if (receive.getMessageExchange() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)receive, "messageExchange");
                }
                this.processCorrelationsHolder((CorrelationsHolder)receive);
            }

            public void visit(Reply reply) {
                super.visit(reply);
                if (reply.getToPartContaner() != null) {
                    this.addElementsInParentError((BpelContainer)reply, TO_PARTS);
                }
                if (reply.getMessageExchange() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)reply, "messageExchange");
                }
                this.processCorrelationsHolder((CorrelationsHolder)reply);
            }

            public void visit(OnEvent onEvent) {
                if (onEvent.getFromPartContaner() != null) {
                    this.addElementsInParentError((BpelContainer)onEvent, FROM_PARTS);
                }
                if (onEvent.getMessageExchange() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)onEvent, "messageExchange");
                }
                this.processCorrelationsHolder((CorrelationsHolder)onEvent);
            }

            public void visit(OnMessage onMessage) {
                if (onMessage.getFromPartContaner() != null) {
                    this.addElementsInParentError((BpelContainer)onMessage, FROM_PARTS);
                }
                if (onMessage.getMessageExchange() != null) {
                    Validator.this.addWarning("FIX_Attribute", (Component)onMessage, "messageExchange");
                }
                this.processCorrelationsHolder((CorrelationsHolder)onMessage);
            }

            public void visit(MessageExchangeContainer messageExchangeContainer) {
                this.addElementError((BpelEntity)messageExchangeContainer);
            }

            private void checkAbsenceExtensions(ExtensibleElements extensibleElements) {
                if (extensibleElements instanceof AbstractDocumentComponent) {
                    Object object;
                    AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)extensibleElements;
                    Map map = abstractDocumentComponent.getAttributeMap();
                    for (Object k : map.keySet()) {
                        object = (QName)k;
                        if (((QName)object).getNamespaceURI() == null || ((QName)object).getNamespaceURI().length() <= 0) continue;
                        Validator.this.addWarning("FIX_Attribute", (Component)extensibleElements, ((QName)object).toString());
                    }
                    NodeList nodeList = abstractDocumentComponent.getPeer().getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element;
                        object = nodeList.item(i);
                        if (!(object instanceof Element) || "http://docs.oasis-open.org/wsbpel/2.0/process/executable".equals((element = (Element)object).getNamespaceURI())) continue;
                        this.addElementsInParentError((BpelContainer)extensibleElements, element.getLocalName());
                    }
                }
            }

            private void addElementError(BpelEntity bpelEntity) {
                Validator.this.addError("FIX_Element", (Component)bpelEntity, bpelEntity.getPeer().getLocalName());
            }

            private void addElementsInParentError(BpelContainer bpelContainer, BpelEntity ... bpelEntityArray) {
                Validator.this.addError("FIX_ElementInParent", (Component)bpelEntityArray[0], bpelEntityArray[0].getPeer().getLocalName(), bpelContainer.getPeer().getLocalName());
            }

            private void addElementsInParentError(BpelContainer bpelContainer, String string) {
                Validator.this.addError("FIX_ElementInParent", (Component)bpelContainer, string, bpelContainer.getPeer().getLocalName());
            }

            private void addAttributeNeededForRuntime(String string, Component component) {
                Validator.this.addWarning("FIX_Attribute_Required_by_SE", component, string);
            }

            private boolean isAttributeValueSpecified(String string) {
                return string != null && !string.trim().equals("");
            }

            private void checkValidURI(BpelEntity bpelEntity, String string, String string2) {
                if (string2 != null) {
                    try {
                        new URI(string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Validator.this.addError("FIX_Invalid_URI", (Component)bpelEntity, string);
                    }
                }
            }

            private BpelContainer hasParent(BpelEntity bpelEntity, Class<? extends BpelContainer> ... classArray) {
                for (BpelContainer bpelContainer = bpelEntity.getParent(); bpelContainer != null; bpelContainer = bpelContainer.getParent()) {
                    for (Class<? extends BpelContainer> clazz : classArray) {
                        if (!clazz.isInstance(bpelContainer)) continue;
                        return bpelContainer;
                    }
                }
                return null;
            }
        };
    }
}

