/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.schema;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.netbeans.modules.bpel.model.api.AnotherVersionBpelProcess;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.ConditionHolder;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.resources.ResourcePackageMarker;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.spi.XsdBasedValidator;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validator
extends XsdBasedValidator {
    private static Schema ourBPEL11Schema;
    private static Schema ourBPEL20Schema;
    private static final String BPEL_XSD_URL;
    private static final String BPEL_1_1_XSD_URL;
    private static final String XML_XSD_URL;
    private static final String TRACE_2_0_XSD_URL;
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_WSDL_URL = "nbres:/org/netbeans/modules/xml/wsdl/validator/resources/wsdl-2004-08-24.xsd";
    private static final String XML_XSD_SYSTEMID = "http://www.w3.org/2001/xml.xsd";
    private static final String XML_WSDL_SYSTEMID = "http://schemas.xmlsoap.org/wsdl/";

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        if (!(model instanceof BpelModel)) {
            return null;
        }
        UI.startTime();
        ValidationResult validationResult = Validator.super.validate((Model)((BpelModel)model), validation, validationType);
        UI.endTime((Object)("Validator " + this.getName() + "    "));
        Iterator iterator = validationResult.getValidationResult().iterator();
        LinkedList<Validator.ResultItem> linkedList = new LinkedList<Validator.ResultItem>();
        LinkedList<Validator.ResultItem> linkedList2 = new LinkedList<Validator.ResultItem>();
        while (iterator.hasNext()) {
            this.fixDescription((Validator.ResultItem)iterator.next(), linkedList, linkedList2);
        }
        return this.updateResult(validationResult, linkedList, linkedList2);
    }

    private void patch(Validator.ResultItem resultItem, List<Validator.ResultItem> list, List<Validator.ResultItem> list2) {
        if (this.patchCondition(resultItem, list, list2)) {
            return;
        }
        if (this.patchForEach(resultItem, list, list2)) {
            return;
        }
    }

    private boolean patchCondition(Validator.ResultItem resultItem, List<Validator.ResultItem> list, List<Validator.ResultItem> list2) {
        Component component = resultItem.getComponents();
        Component component2 = this.getParent(component);
        if (!(component2 instanceof ConditionHolder)) {
            return false;
        }
        ConditionHolder conditionHolder = (ConditionHolder)component2;
        if (conditionHolder.getCondition() != null) {
            return false;
        }
        list2.add(resultItem);
        list.add(this.createItem(resultItem, (Component)conditionHolder));
        return true;
    }

    private boolean patchForEach(Validator.ResultItem resultItem, List<Validator.ResultItem> list, List<Validator.ResultItem> list2) {
        Component component = resultItem.getComponents();
        Component component2 = this.getParent(component);
        if (!(component2 instanceof ForEach)) {
            return false;
        }
        ForEach forEach = (ForEach)component2;
        if (forEach.getStartCounterValue() != null && forEach.getFinalCounterValue() != null && forEach.getCompletionCondition() != null) {
            return false;
        }
        list2.add(resultItem);
        list.add(this.createItem(resultItem, (Component)forEach));
        return true;
    }

    private Validator.ResultItem createItem(Validator.ResultItem resultItem, Component component) {
        return new Validator.ResultItem((org.netbeans.modules.xml.xam.spi.Validator)this, resultItem.getType(), component, resultItem.getDescription());
    }

    private Component getParent(Component component) {
        Component component2;
        while (true) {
            if (component == null) {
                return null;
            }
            component2 = component.getParent();
            if (!(component2 instanceof Scope)) break;
            component = component2.getParent();
        }
        return component2;
    }

    private ValidationResult updateResult(ValidationResult validationResult, List<Validator.ResultItem> list, List<Validator.ResultItem> list2) {
        Iterator iterator = validationResult.getValidationResult().iterator();
        LinkedList<Validator.ResultItem> linkedList = new LinkedList<Validator.ResultItem>();
        while (iterator.hasNext()) {
            Validator.ResultItem resultItem = (Validator.ResultItem)iterator.next();
            if (list2.contains(resultItem)) continue;
            linkedList.add(resultItem);
        }
        for (Validator.ResultItem resultItem : list) {
            linkedList.add(resultItem);
        }
        return new ValidationResult(linkedList, validationResult.getValidatedModels());
    }

    private void fixDescription(Validator.ResultItem resultItem, List<Validator.ResultItem> list, List<Validator.ResultItem> list2) {
        String string = resultItem.getDescription();
        if (!string.startsWith("cvc-complex-type")) {
            return;
        }
        int n = string.indexOf(": ");
        if (n != -1) {
            string = string.substring(n + 2);
        }
        string = UI.replace((String)string, (String)"'{", (String)"");
        string = UI.replace((String)string, (String)"}'", (String)"");
        string = UI.replace((String)string, (String)"\"http://docs.oasis-open.org/wsbpel/2.0/process/executable\":", (String)"");
        string = UI.replace((String)string, (String)"WC[##other:\"http://docs.oasis-open.org/wsbpel/2.0/process/executable\"], ", (String)"");
        resultItem.setDescription(this.adjustDescription(string));
        this.patch(resultItem, list, list2);
    }

    private String adjustDescription(String string) {
        int n = this.getCommaCount(string);
        if (n < 6) {
            return string;
        }
        int n2 = string.indexOf("One of ");
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2) + "The element must contain at least one child activity.";
    }

    private int getCommaCount(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        return n;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected Schema getSchema(Model model) {
        String string;
        if (!(model instanceof BpelModel)) {
            return null;
        }
        AnotherVersionBpelProcess anotherVersionBpelProcess = ((BpelModel)model).getAnotherVersionProcess();
        if (anotherVersionBpelProcess != null && "http://schemas.xmlsoap.org/ws/2003/03/business-process/".equals(string = anotherVersionBpelProcess.getNamespaceUri())) {
            return this.getBpel11Schema();
        }
        return this.getBpel20Schema();
    }

    private Schema getBpel20Schema() {
        if (ourBPEL20Schema == null) {
            ourBPEL20Schema = this.getCompiledSchema(new InputStream[]{Validator.class.getResourceAsStream(BPEL_XSD_URL)}, new BPELEntityResolver());
        }
        return ourBPEL20Schema;
    }

    private Schema getBpel11Schema() {
        if (ourBPEL11Schema == null) {
            ourBPEL11Schema = this.getCompiledSchema(new InputStream[]{Validator.class.getResourceAsStream(BPEL_1_1_XSD_URL)}, new BPELEntityResolver());
        }
        return ourBPEL11Schema;
    }

    static {
        BPEL_XSD_URL = "/" + ResourcePackageMarker.getPackage() + "/" + "wsbpel_2_0.xsd";
        BPEL_1_1_XSD_URL = "/" + ResourcePackageMarker.getPackage() + "/" + "bpel4ws_1_1.xsd";
        XML_XSD_URL = "/" + ResourcePackageMarker.getPackage() + "/" + "xml.xsd";
        TRACE_2_0_XSD_URL = "/" + ResourcePackageMarker.getPackage() + "/" + "trace.xsd";
    }

    private class BPELEntityResolver
    implements LSResourceResolver {
        private BPELEntityResolver() {
        }

        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            InputStream inputStream = null;
            if (string4.equals(Validator.XML_XSD_SYSTEMID)) {
                inputStream = Validator.class.getResourceAsStream(XML_XSD_URL);
            } else if (string4.equals(Validator.XML_WSDL_SYSTEMID)) {
                inputStream = Validator.class.getResourceAsStream(Validator.XML_WSDL_URL);
            } else if (string4.equals("http://www.sun.com/wsbpel/2.0/process/executable/SUNExtension/Trace")) {
                inputStream = Validator.class.getResourceAsStream(TRACE_2_0_XSD_URL);
            }
            if (inputStream != null) {
                DOMImplementation dOMImplementation = null;
                try {
                    dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    return null;
                }
                DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
                LSInput lSInput = dOMImplementationLS.createLSInput();
                lSInput.setByteStream(inputStream);
                return lSInput;
            }
            return null;
        }
    }
}

