/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.OperationReference;
import org.netbeans.modules.bpel.model.api.PartReference;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkReference;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableReference;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.ExpressionUpdater;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitor;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitorAdaptor;
import org.netbeans.modules.bpel.validation.core.BpelValidator;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public final class Validator
extends BpelValidator {
    protected SimpleBpelModelVisitor getVisitor() {
        return new SimpleBpelModelVisitorAdaptor(){

            public void visit(VariableContainer variableContainer) {
                Object object;
                VariableInfo variableInfo;
                Variable[] variableArray = variableContainer.getVariables();
                if (variableArray == null) {
                    return;
                }
                LinkedList<VariableInfo> linkedList = new LinkedList<VariableInfo>();
                for (Variable object2 : variableArray) {
                    variableInfo = new VariableInfo(object2);
                    object = Validator.this.getVariableType(object2);
                    if (object instanceof GlobalSimpleType) {
                        variableInfo.setInitialized();
                    }
                    linkedList.add(variableInfo);
                }
                this.findVariables((BpelEntity)variableContainer.getParent(), linkedList);
                for (VariableInfo variableInfo2 : linkedList) {
                    boolean bl = variableInfo2.isInitialized();
                    int n = variableInfo2.isUsed() ? 1 : 0;
                    variableInfo = variableInfo2.getVariable();
                    object = variableInfo.getName();
                    if (!bl && n == 0) {
                        Validator.this.addWarning("FIX_not_initialized_and_not_used", (Component)variableInfo, (String)object);
                        continue;
                    }
                    if (!bl && n != 0) {
                        Validator.this.addError("FIX_not_initialized_but_used", (Component)variableInfo, (String)object);
                        continue;
                    }
                    if (!bl || n != 0) continue;
                    Validator.this.addWarning("FIX_initialized_and_not_used", (Component)variableInfo, (String)object);
                }
            }

            private void findVariables(BpelEntity bpelEntity, List<VariableInfo> list) {
                this.checkInitialization(bpelEntity, list);
                this.checkUsages(bpelEntity, list);
                List list2 = bpelEntity.getChildren();
                for (BpelEntity bpelEntity2 : list2) {
                    this.findVariables(bpelEntity2, list);
                }
            }

            private void checkInitialization(BpelEntity bpelEntity, List<VariableInfo> list) {
                if (bpelEntity instanceof To || bpelEntity instanceof Receive || bpelEntity instanceof OnMessage) {
                    this.checkInitializationVariableReference((VariableReference)bpelEntity, list);
                }
                if (bpelEntity instanceof ContentElement && bpelEntity instanceof To) {
                    this.checkInitializationContent((ContentElement)bpelEntity, list);
                }
                if (bpelEntity instanceof Invoke) {
                    this.checkInfoVariableDeclaration((BpelReference<VariableDeclaration>)((Invoke)bpelEntity).getOutputVariable(), list, false);
                }
                if (bpelEntity instanceof OnEvent) {
                    this.checkInfoVariable(((OnEvent)bpelEntity).getVariableName(), list, false);
                }
                if (bpelEntity instanceof Catch) {
                    this.checkInfoVariable(((Catch)bpelEntity).getFaultVariable(), list, false);
                }
            }

            private void checkUsages(BpelEntity bpelEntity, List<VariableInfo> list) {
                if (bpelEntity instanceof From || bpelEntity instanceof Reply) {
                    this.checkUsagesVariableReference((VariableReference)bpelEntity, list);
                }
                if (bpelEntity instanceof ContentElement && !(bpelEntity instanceof To)) {
                    this.checkUsagesContent((ContentElement)bpelEntity, list);
                }
                if (bpelEntity instanceof Invoke) {
                    this.checkInfoVariableDeclaration((BpelReference<VariableDeclaration>)((Invoke)bpelEntity).getInputVariable(), list, true);
                }
                if (bpelEntity instanceof Throw) {
                    this.checkInfoVariableDeclaration((BpelReference<VariableDeclaration>)((Throw)bpelEntity).getFaultVariable(), list, true);
                }
            }

            private void checkInitializationContent(ContentElement contentElement, List<VariableInfo> list) {
                this.checkInfoContent(contentElement, list, false);
            }

            private void checkUsagesContent(ContentElement contentElement, List<VariableInfo> list) {
                this.checkInfoContent(contentElement, list, true);
            }

            private void checkInfoContent(ContentElement contentElement, List<VariableInfo> list, boolean bl) {
                String string = contentElement.getContent();
                Collection collection = ExpressionUpdater.getInstance().getUsedVariables(string);
                if (collection == null) {
                    return;
                }
                for (String string2 : collection) {
                    for (VariableInfo variableInfo : list) {
                        if (!variableInfo.getVariable().getName().equals(string2)) continue;
                        if (bl) {
                            variableInfo.setUsed();
                            continue;
                        }
                        variableInfo.setInitialized();
                    }
                }
            }

            private void checkInitializationVariableReference(VariableReference variableReference, List<VariableInfo> list) {
                this.checkInfoVariableReference(variableReference, list, false);
            }

            private void checkUsagesVariableReference(VariableReference variableReference, List<VariableInfo> list) {
                this.checkInfoVariableReference(variableReference, list, true);
            }

            private void checkInfoVariableReference(VariableReference variableReference, List<VariableInfo> list, boolean bl) {
                this.checkInfoVariableDeclaration((BpelReference<VariableDeclaration>)variableReference.getVariable(), list, bl);
            }

            private void checkInfoVariableDeclaration(BpelReference<VariableDeclaration> bpelReference, List<VariableInfo> list, boolean bl) {
                if (bpelReference == null) {
                    return;
                }
                VariableDeclaration variableDeclaration = (VariableDeclaration)bpelReference.get();
                if (variableDeclaration == null) {
                    return;
                }
                this.checkInfoVariable(variableDeclaration.getVariableName(), list, bl);
            }

            private void checkInfoVariable(String string, List<VariableInfo> list, boolean bl) {
                if (string == null) {
                    return;
                }
                for (VariableInfo variableInfo : list) {
                    if (!variableInfo.getVariable().getName().equals(string)) continue;
                    if (bl) {
                        variableInfo.setUsed();
                        continue;
                    }
                    variableInfo.setInitialized();
                }
            }

            public void visit(Flow flow) {
                Object object;
                ArrayList<LinkedList<VariablePart>> arrayList = new ArrayList<LinkedList<VariablePart>>();
                List list = flow.getChildren();
                for (BpelEntity bpelEntity : list) {
                    object = new LinkedList<VariablePart>();
                    this.findVariableParts(bpelEntity, (List<VariablePart>)object);
                    if (object.isEmpty()) continue;
                    arrayList.add((LinkedList<VariablePart>)object);
                }
                block1: for (int i = 0; i < arrayList.size(); ++i) {
                    for (int j = i + 1; j < arrayList.size(); ++j) {
                        object = this.getCommonVariable((List)arrayList.get(i), (List)arrayList.get(j));
                        if (object == null) continue;
                        Validator.this.addWarning("FIX_Variable_in_Flow", (Component)flow, flow.getName(), ((VariablePart)object).toString());
                        continue block1;
                    }
                }
            }

            private VariablePart getCommonVariable(List<VariablePart> list, List<VariablePart> list2) {
                for (VariablePart variablePart : list) {
                    if (!list2.contains(variablePart)) continue;
                    return variablePart;
                }
                return null;
            }

            private void findVariableParts(BpelEntity bpelEntity, List<VariablePart> list) {
                if (bpelEntity instanceof Scope) {
                    return;
                }
                if (bpelEntity instanceof Pick) {
                    return;
                }
                if (bpelEntity instanceof Assign) {
                    this.findVariablePartsInAssign((Assign)bpelEntity, list);
                }
                List list2 = bpelEntity.getChildren();
                for (BpelEntity bpelEntity2 : list2) {
                    this.findVariableParts(bpelEntity2, list);
                }
            }

            private void findVariablePartsInAssign(Assign assign, List<VariablePart> list) {
                List list2 = assign.getChildren(Copy.class);
                for (Copy copy : list2) {
                    VariableDeclaration variableDeclaration;
                    To to = copy.getTo();
                    BpelReference bpelReference = to.getVariable();
                    if (bpelReference == null || (variableDeclaration = (VariableDeclaration)bpelReference.get()) == null) continue;
                    list.add(new VariablePart(variableDeclaration, this.getPart(to)));
                }
            }

            private Part getPart(To to) {
                WSDLReference wSDLReference = to.getPart();
                if (wSDLReference == null) {
                    return null;
                }
                return (Part)wSDLReference.get();
            }

            public void visit(Assign assign) {
                List<Copy> list = this.list(assign.getChildren(Copy.class));
                for (int i = 0; i < list.size(); ++i) {
                    for (int j = i + 1; j < list.size(); ++j) {
                        this.checkCopies(list.get(i), list.get(j));
                    }
                }
            }

            private void checkCopies(Copy copy, Copy copy2) {
                if (this.checkTo(copy.getTo(), copy2.getTo()) && this.checkFrom(copy.getFrom(), copy2.getFrom())) {
                    Validator.this.addError("FIX_duplicate_copies", (Component)copy);
                    Validator.this.addError("FIX_duplicate_copies", (Component)copy2);
                }
            }

            private boolean checkTo(To to, To to2) {
                if (this.checkContent((ContentElement)to, (ContentElement)to2)) {
                    return true;
                }
                if (this.checkVariable((VariableReference)to, (PartReference)to, (VariableReference)to2, (PartReference)to2)) {
                    return true;
                }
                return this.checkPartnerLink((PartnerLinkReference)to, (PartnerLinkReference)to2);
            }

            private boolean checkPartnerLink(PartnerLinkReference partnerLinkReference, PartnerLinkReference partnerLinkReference2) {
                BpelReference bpelReference = partnerLinkReference.getPartnerLink();
                if (bpelReference == null) {
                    return false;
                }
                PartnerLink partnerLink = (PartnerLink)bpelReference.get();
                if (partnerLink == null) {
                    return false;
                }
                BpelReference bpelReference2 = partnerLinkReference2.getPartnerLink();
                if (bpelReference2 == null) {
                    return false;
                }
                PartnerLink partnerLink2 = (PartnerLink)bpelReference2.get();
                if (partnerLink2 == null) {
                    return false;
                }
                return partnerLink.equals(partnerLink2);
            }

            private boolean checkVariable(VariableReference variableReference, PartReference partReference, VariableReference variableReference2, PartReference partReference2) {
                BpelReference bpelReference = variableReference.getVariable();
                if (bpelReference == null) {
                    return false;
                }
                VariableDeclaration variableDeclaration = (VariableDeclaration)bpelReference.get();
                if (variableDeclaration == null) {
                    return false;
                }
                WSDLReference wSDLReference = partReference.getPart();
                if (wSDLReference == null) {
                    return false;
                }
                Part part = (Part)wSDLReference.get();
                if (part == null) {
                    return false;
                }
                BpelReference bpelReference2 = variableReference2.getVariable();
                if (bpelReference2 == null) {
                    return false;
                }
                VariableDeclaration variableDeclaration2 = (VariableDeclaration)bpelReference2.get();
                if (variableDeclaration2 == null) {
                    return false;
                }
                WSDLReference wSDLReference2 = partReference2.getPart();
                if (wSDLReference2 == null) {
                    return false;
                }
                Part part2 = (Part)wSDLReference2.get();
                if (part2 == null) {
                    return false;
                }
                return variableDeclaration.equals(variableDeclaration2) && part.equals(part2);
            }

            private boolean checkContent(ContentElement contentElement, ContentElement contentElement2) {
                String string = contentElement.getContent();
                if (string == null || string.length() == 0) {
                    return false;
                }
                String string2 = contentElement2.getContent();
                if (string2 == null || string2.length() == 0) {
                    return false;
                }
                return string.equals(string2);
            }

            private boolean checkFrom(From from, From from2) {
                if (this.checkContent((ContentElement)from, (ContentElement)from2)) {
                    return true;
                }
                if (this.checkVariable((VariableReference)from, (PartReference)from, (VariableReference)from2, (PartReference)from2)) {
                    return true;
                }
                return this.checkPartnerLink((PartnerLinkReference)from, (PartnerLinkReference)from2);
            }

            private List<Copy> list(Collection<Copy> collection) {
                ArrayList<Copy> arrayList = new ArrayList<Copy>();
                if (collection == null) {
                    return arrayList;
                }
                for (Copy copy : collection) {
                    arrayList.add(copy);
                }
                return arrayList;
            }

            public void visit(OnMessage onMessage) {
                this.checkVariable((VariableReference)onMessage, (OperationReference)onMessage, true);
            }

            public void visit(Receive receive) {
                this.checkVariable((VariableReference)receive, (OperationReference)receive, true);
            }

            public void visit(Reply reply) {
                this.checkVariable((VariableReference)reply, (OperationReference)reply, false);
            }

            private void checkVariable(VariableReference variableReference, OperationReference operationReference, boolean bl) {
                BpelReference bpelReference = variableReference.getVariable();
                if (bpelReference != null && bpelReference.get() != null) {
                    return;
                }
                WSDLReference wSDLReference = operationReference.getOperation();
                if (wSDLReference == null) {
                    return;
                }
                Operation operation = (Operation)wSDLReference.get();
                if (operation == null) {
                    return;
                }
                Object object = bl ? operation.getInput() : operation.getOutput();
                if (object == null) {
                    return;
                }
                NamedComponentReference namedComponentReference = object.getMessage();
                if (namedComponentReference == null) {
                    return;
                }
                Message message = (Message)namedComponentReference.get();
                if (message == null) {
                    return;
                }
                Collection collection = message.getParts();
                if (collection == null) {
                    return;
                }
                if (collection.size() != 0) {
                    Validator.this.addError("FIX_SA00047", (Component)variableReference);
                }
            }
        };
    }

    private class VariableInfo {
        private boolean myIsUsed;
        private boolean myIsInitialized;
        private Variable myVariable;

        VariableInfo(Variable variable) {
            this.myVariable = variable;
            this.myIsUsed = false;
            this.myIsInitialized = false;
        }

        public Variable getVariable() {
            return this.myVariable;
        }

        public void setUsed() {
            this.myIsUsed = true;
        }

        public boolean isUsed() {
            return this.myIsUsed;
        }

        public void setInitialized() {
            this.myIsInitialized = true;
        }

        public boolean isInitialized() {
            return this.myIsInitialized;
        }

        public String toString() {
            return this.myVariable.getName() + "\t " + this.myIsInitialized + "\t " + this.myIsUsed;
        }
    }

    private class VariablePart {
        private Part myPart;
        private VariableDeclaration myVariable;

        VariablePart(VariableDeclaration variableDeclaration, Part part) {
            this.myVariable = variableDeclaration;
            this.myPart = part;
        }

        public boolean equals(Object object) {
            if (!(object instanceof VariablePart)) {
                return false;
            }
            VariablePart variablePart = (VariablePart)object;
            return variablePart.myVariable == this.myVariable && variablePart.myPart == this.myPart;
        }

        public int hashCode() {
            if (this.myPart == null) {
                return this.myVariable.hashCode();
            }
            return this.myVariable.hashCode() * this.myPart.hashCode();
        }

        public String toString() {
            if (this.myPart == null) {
                return Validator.this.getName(this.myVariable);
            }
            return Validator.this.getName(this.myVariable) + "." + this.myPart.getName();
        }
    }
}

