/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.bpel.validation.core.WsdlValidator;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;
import org.netbeans.modules.xml.wsdl.model.visitor.DefaultVisitor;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public final class Validator
extends WsdlValidator {
    protected WSDLVisitor getVisitor() {
        return new DefaultVisitor(){

            public void visit(Definitions definitions) {
                ArrayList<PropertyAlias> arrayList = new ArrayList<PropertyAlias>();
                this.collectPropertyAliases((WSDLComponent)definitions, arrayList);
                for (int i = 0; i < arrayList.size(); ++i) {
                    for (int j = i + 1; j < arrayList.size(); ++j) {
                        if (!this.theSame((PropertyAlias)arrayList.get(i), (PropertyAlias)arrayList.get(j))) continue;
                        Validator.this.addError("FIX_Identical_Property_Aliases", (Component)arrayList.get(i));
                        Validator.this.addError("FIX_Identical_Property_Aliases", (Component)arrayList.get(j));
                    }
                }
                this.visitChildren(definitions);
            }

            private void visitChildren(Definitions definitions) {
                List list = definitions.getChildren(ExtensibilityElement.class);
                for (ExtensibilityElement extensibilityElement : list) {
                    this.visitExtensibility(extensibilityElement);
                }
            }

            private boolean theSame(PropertyAlias propertyAlias, PropertyAlias propertyAlias2) {
                if (propertyAlias == null || propertyAlias2 == null) {
                    return false;
                }
                return this.getProperty(propertyAlias) == this.getProperty(propertyAlias2) && this.getMessage(propertyAlias) == this.getMessage(propertyAlias2) && propertyAlias.getPart() == propertyAlias2.getPart() && propertyAlias.getQuery() == propertyAlias2.getQuery() && this.getGlobalType(propertyAlias) == this.getGlobalType(propertyAlias2) && this.getGlobalElement(propertyAlias) == this.getGlobalElement(propertyAlias2);
            }

            private CorrelationProperty getProperty(PropertyAlias propertyAlias) {
                NamedComponentReference namedComponentReference = propertyAlias.getPropertyName();
                if (namedComponentReference == null) {
                    return null;
                }
                return (CorrelationProperty)namedComponentReference.get();
            }

            private Message getMessage(PropertyAlias propertyAlias) {
                NamedComponentReference namedComponentReference = propertyAlias.getMessageType();
                if (namedComponentReference == null) {
                    return null;
                }
                return (Message)namedComponentReference.get();
            }

            private GlobalType getGlobalType(PropertyAlias propertyAlias) {
                NamedComponentReference namedComponentReference = propertyAlias.getType();
                if (namedComponentReference == null) {
                    return null;
                }
                return (GlobalType)namedComponentReference.get();
            }

            private GlobalElement getGlobalElement(PropertyAlias propertyAlias) {
                NamedComponentReference namedComponentReference = propertyAlias.getElement();
                if (namedComponentReference == null) {
                    return null;
                }
                return (GlobalElement)namedComponentReference.get();
            }

            private void collectPropertyAliases(WSDLComponent wSDLComponent, List<PropertyAlias> list) {
                if (wSDLComponent instanceof PropertyAlias) {
                    list.add((PropertyAlias)wSDLComponent);
                }
                List list2 = wSDLComponent.getChildren();
                for (WSDLComponent wSDLComponent2 : list2) {
                    this.collectPropertyAliases(wSDLComponent2, list);
                }
            }

            private void visitExtensibility(ExtensibilityElement extensibilityElement) {
                if (!(extensibilityElement instanceof PropertyAlias)) {
                    return;
                }
                PropertyAlias propertyAlias = (PropertyAlias)extensibilityElement;
                if (propertyAlias.getQuery() != null) {
                    return;
                }
                DocumentComponent documentComponent = Validator.this.getWrongQuery(propertyAlias);
                if (documentComponent != null) {
                    Validator.this.addError("FIX_QUERY_PREFIX", (Component)propertyAlias);
                    return;
                }
                NamedComponentReference namedComponentReference = propertyAlias.getPropertyName();
                if (namedComponentReference == null) {
                    return;
                }
                CorrelationProperty correlationProperty = (CorrelationProperty)namedComponentReference.get();
                if (correlationProperty == null) {
                    return;
                }
                Component component = Validator.this.getType(correlationProperty);
                if (component == null) {
                    return;
                }
                NamedComponentReference namedComponentReference2 = propertyAlias.getMessageType();
                if (namedComponentReference2 == null) {
                    return;
                }
                Message message = (Message)namedComponentReference2.get();
                if (message == null) {
                    return;
                }
                String string = propertyAlias.getPart();
                if (string == null) {
                    return;
                }
                Collection collection = message.getParts();
                if (collection == null) {
                    return;
                }
                Part part = null;
                for (Part part2 : collection) {
                    if (!string.equals(part2.getName())) continue;
                    part = part2;
                    break;
                }
                if (part == null) {
                    return;
                }
                Component component2 = Validator.this.getType(part);
                if (component2 == null) {
                    return;
                }
                if (ValidationUtil.getBasedSimpleType((Component)component2) != ValidationUtil.getBasedSimpleType((Component)component)) {
                    Validator.this.addWarning("FIX_TYPE_IN_PROPERTY_ALIAS", (Component)propertyAlias, Validator.this.getTypeName(component), Validator.this.getTypeName(component2));
                }
            }
        };
    }

    private Component getType(CorrelationProperty correlationProperty) {
        GlobalElement globalElement;
        NamedComponentReference namedComponentReference;
        NamedComponentReference namedComponentReference2 = correlationProperty.getType();
        if (namedComponentReference2 != null && (namedComponentReference = (GlobalType)namedComponentReference2.get()) != null) {
            return this.getTypeOfElement((Component)namedComponentReference);
        }
        namedComponentReference = correlationProperty.getElement();
        if (namedComponentReference != null && (globalElement = (GlobalElement)namedComponentReference.get()) != null) {
            return this.getTypeOfElement((Component)globalElement);
        }
        return null;
    }

    private DocumentComponent getWrongQuery(PropertyAlias propertyAlias) {
        List list = propertyAlias.getChildren();
        for (WSDLComponent wSDLComponent : list) {
            WSDLComponent wSDLComponent2;
            String string;
            if (!(wSDLComponent instanceof DocumentComponent) || !(string = (wSDLComponent2 = wSDLComponent).getPeer().getTagName()).endsWith("query")) continue;
            return wSDLComponent2;
        }
        return null;
    }
}

